package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics resource performance entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "averageSpikeTimeScore", 
    "cpuSpikeTimePercentage", 
    "cpuSpikeTimePercentageThreshold", 
    "cpuSpikeTimeScore", 
    "deviceCount", 
    "deviceId", 
    "deviceName", 
    "deviceResourcePerformanceScore", 
    "manufacturer", 
    "model", 
    "ramSpikeTimePercentage", 
    "ramSpikeTimePercentageThreshold", 
    "ramSpikeTimeScore"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsResourcePerformance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsResourcePerformance";
    }

    @JsonProperty("averageSpikeTimeScore")
    protected Integer averageSpikeTimeScore;

    @JsonProperty("cpuSpikeTimePercentage")
    protected Double cpuSpikeTimePercentage;

    @JsonProperty("cpuSpikeTimePercentageThreshold")
    protected Double cpuSpikeTimePercentageThreshold;

    @JsonProperty("cpuSpikeTimeScore")
    protected Integer cpuSpikeTimeScore;

    @JsonProperty("deviceCount")
    protected Long deviceCount;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("deviceResourcePerformanceScore")
    protected Integer deviceResourcePerformanceScore;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("ramSpikeTimePercentage")
    protected Double ramSpikeTimePercentage;

    @JsonProperty("ramSpikeTimePercentageThreshold")
    protected Double ramSpikeTimePercentageThreshold;

    @JsonProperty("ramSpikeTimeScore")
    protected Integer ramSpikeTimeScore;

    protected UserExperienceAnalyticsResourcePerformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsResourcePerformance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer averageSpikeTimeScore;
        private Double cpuSpikeTimePercentage;
        private Double cpuSpikeTimePercentageThreshold;
        private Integer cpuSpikeTimeScore;
        private Long deviceCount;
        private String deviceId;
        private String deviceName;
        private Integer deviceResourcePerformanceScore;
        private String manufacturer;
        private String model;
        private Double ramSpikeTimePercentage;
        private Double ramSpikeTimePercentageThreshold;
        private Integer ramSpikeTimeScore;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“AverageSpikeTimeScore of a device or a model type. Valid values 0 to 100”</i>
         * 
         * @param averageSpikeTimeScore
         *            value of {@code averageSpikeTimeScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder averageSpikeTimeScore(Integer averageSpikeTimeScore) {
            this.averageSpikeTimeScore = averageSpikeTimeScore;
            this.changedFields = changedFields.add("averageSpikeTimeScore");
            return this;
        }

        /**
         * <i>“CPU spike time in percentage. Valid values 0 to 100”</i>
         * 
         * @param cpuSpikeTimePercentage
         *            value of {@code cpuSpikeTimePercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cpuSpikeTimePercentage(Double cpuSpikeTimePercentage) {
            this.cpuSpikeTimePercentage = cpuSpikeTimePercentage;
            this.changedFields = changedFields.add("cpuSpikeTimePercentage");
            return this;
        }

        /**
         * <i>“Threshold of cpuSpikeTimeScore. Valid values 0 to 100”</i>
         * 
         * @param cpuSpikeTimePercentageThreshold
         *            value of {@code cpuSpikeTimePercentageThreshold} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cpuSpikeTimePercentageThreshold(Double cpuSpikeTimePercentageThreshold) {
            this.cpuSpikeTimePercentageThreshold = cpuSpikeTimePercentageThreshold;
            this.changedFields = changedFields.add("cpuSpikeTimePercentageThreshold");
            return this;
        }

        /**
         * <i>“The user experience analytics device CPU spike time score. Valid values 0 to 100”</i>
         * 
         * @param cpuSpikeTimeScore
         *            value of {@code cpuSpikeTimeScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cpuSpikeTimeScore(Integer cpuSpikeTimeScore) {
            this.cpuSpikeTimeScore = cpuSpikeTimeScore;
            this.changedFields = changedFields.add("cpuSpikeTimeScore");
            return this;
        }

        /**
         * <i>“User experience analytics summarized device count.”</i>
         * 
         * @param deviceCount
         *            value of {@code deviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCount(Long deviceCount) {
            this.deviceCount = deviceCount;
            this.changedFields = changedFields.add("deviceCount");
            return this;
        }

        /**
         * <i>“The id of the device.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The name of the device.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Resource performance score of a specific device. Valid values 0 to 100”</i>
         * 
         * @param deviceResourcePerformanceScore
         *            value of {@code deviceResourcePerformanceScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceResourcePerformanceScore(Integer deviceResourcePerformanceScore) {
            this.deviceResourcePerformanceScore = deviceResourcePerformanceScore;
            this.changedFields = changedFields.add("deviceResourcePerformanceScore");
            return this;
        }

        /**
         * <i>“The user experience analytics device manufacturer.”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“The user experience analytics device model.”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“RAM spike time in percentage. Valid values 0 to 100”</i>
         * 
         * @param ramSpikeTimePercentage
         *            value of {@code ramSpikeTimePercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ramSpikeTimePercentage(Double ramSpikeTimePercentage) {
            this.ramSpikeTimePercentage = ramSpikeTimePercentage;
            this.changedFields = changedFields.add("ramSpikeTimePercentage");
            return this;
        }

        /**
         * <i>“Threshold of ramSpikeTimeScore. Valid values 0 to 100”</i>
         * 
         * @param ramSpikeTimePercentageThreshold
         *            value of {@code ramSpikeTimePercentageThreshold} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ramSpikeTimePercentageThreshold(Double ramSpikeTimePercentageThreshold) {
            this.ramSpikeTimePercentageThreshold = ramSpikeTimePercentageThreshold;
            this.changedFields = changedFields.add("ramSpikeTimePercentageThreshold");
            return this;
        }

        /**
         * <i>“The user experience analytics device RAM spike time score. Valid values 0 to 100”</i>
         * 
         * @param ramSpikeTimeScore
         *            value of {@code ramSpikeTimeScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ramSpikeTimeScore(Integer ramSpikeTimeScore) {
            this.ramSpikeTimeScore = ramSpikeTimeScore;
            this.changedFields = changedFields.add("ramSpikeTimeScore");
            return this;
        }

        public UserExperienceAnalyticsResourcePerformance build() {
            UserExperienceAnalyticsResourcePerformance _x = new UserExperienceAnalyticsResourcePerformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsResourcePerformance";
            _x.id = id;
            _x.averageSpikeTimeScore = averageSpikeTimeScore;
            _x.cpuSpikeTimePercentage = cpuSpikeTimePercentage;
            _x.cpuSpikeTimePercentageThreshold = cpuSpikeTimePercentageThreshold;
            _x.cpuSpikeTimeScore = cpuSpikeTimeScore;
            _x.deviceCount = deviceCount;
            _x.deviceId = deviceId;
            _x.deviceName = deviceName;
            _x.deviceResourcePerformanceScore = deviceResourcePerformanceScore;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.ramSpikeTimePercentage = ramSpikeTimePercentage;
            _x.ramSpikeTimePercentageThreshold = ramSpikeTimePercentageThreshold;
            _x.ramSpikeTimeScore = ramSpikeTimeScore;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“AverageSpikeTimeScore of a device or a model type. Valid values 0 to 100”</i>
     * 
     * @return property averageSpikeTimeScore
     */
    @Property(name="averageSpikeTimeScore")
    @JsonIgnore
    public Optional<Integer> getAverageSpikeTimeScore() {
        return Optional.ofNullable(averageSpikeTimeScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * averageSpikeTimeScore} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“AverageSpikeTimeScore of a device or a model type. Valid values 0 to 100”</i>
     * 
     * @param averageSpikeTimeScore
     *            new value of {@code averageSpikeTimeScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code averageSpikeTimeScore} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withAverageSpikeTimeScore(Integer averageSpikeTimeScore) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("averageSpikeTimeScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.averageSpikeTimeScore = averageSpikeTimeScore;
        return _x;
    }

    /**
     * <i>“CPU spike time in percentage. Valid values 0 to 100”</i>
     * 
     * @return property cpuSpikeTimePercentage
     */
    @Property(name="cpuSpikeTimePercentage")
    @JsonIgnore
    public Optional<Double> getCpuSpikeTimePercentage() {
        return Optional.ofNullable(cpuSpikeTimePercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cpuSpikeTimePercentage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“CPU spike time in percentage. Valid values 0 to 100”</i>
     * 
     * @param cpuSpikeTimePercentage
     *            new value of {@code cpuSpikeTimePercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cpuSpikeTimePercentage} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withCpuSpikeTimePercentage(Double cpuSpikeTimePercentage) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("cpuSpikeTimePercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.cpuSpikeTimePercentage = cpuSpikeTimePercentage;
        return _x;
    }

    /**
     * <i>“Threshold of cpuSpikeTimeScore. Valid values 0 to 100”</i>
     * 
     * @return property cpuSpikeTimePercentageThreshold
     */
    @Property(name="cpuSpikeTimePercentageThreshold")
    @JsonIgnore
    public Optional<Double> getCpuSpikeTimePercentageThreshold() {
        return Optional.ofNullable(cpuSpikeTimePercentageThreshold);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cpuSpikeTimePercentageThreshold} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Threshold of cpuSpikeTimeScore. Valid values 0 to 100”</i>
     * 
     * @param cpuSpikeTimePercentageThreshold
     *            new value of {@code cpuSpikeTimePercentageThreshold} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cpuSpikeTimePercentageThreshold} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withCpuSpikeTimePercentageThreshold(Double cpuSpikeTimePercentageThreshold) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("cpuSpikeTimePercentageThreshold");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.cpuSpikeTimePercentageThreshold = cpuSpikeTimePercentageThreshold;
        return _x;
    }

    /**
     * <i>“The user experience analytics device CPU spike time score. Valid values 0 to 100”</i>
     * 
     * @return property cpuSpikeTimeScore
     */
    @Property(name="cpuSpikeTimeScore")
    @JsonIgnore
    public Optional<Integer> getCpuSpikeTimeScore() {
        return Optional.ofNullable(cpuSpikeTimeScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cpuSpikeTimeScore
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device CPU spike time score. Valid values 0 to 100”</i>
     * 
     * @param cpuSpikeTimeScore
     *            new value of {@code cpuSpikeTimeScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cpuSpikeTimeScore} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withCpuSpikeTimeScore(Integer cpuSpikeTimeScore) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("cpuSpikeTimeScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.cpuSpikeTimeScore = cpuSpikeTimeScore;
        return _x;
    }

    /**
     * <i>“User experience analytics summarized device count.”</i>
     * 
     * @return property deviceCount
     */
    @Property(name="deviceCount")
    @JsonIgnore
    public Optional<Long> getDeviceCount() {
        return Optional.ofNullable(deviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics summarized device count.”</i>
     * 
     * @param deviceCount
     *            new value of {@code deviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCount} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withDeviceCount(Long deviceCount) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.deviceCount = deviceCount;
        return _x;
    }

    /**
     * <i>“The id of the device.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The id of the device.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withDeviceId(String deviceId) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The name of the device.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the device.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withDeviceName(String deviceName) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Resource performance score of a specific device. Valid values 0 to 100”</i>
     * 
     * @return property deviceResourcePerformanceScore
     */
    @Property(name="deviceResourcePerformanceScore")
    @JsonIgnore
    public Optional<Integer> getDeviceResourcePerformanceScore() {
        return Optional.ofNullable(deviceResourcePerformanceScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceResourcePerformanceScore} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Resource performance score of a specific device. Valid values 0 to 100”</i>
     * 
     * @param deviceResourcePerformanceScore
     *            new value of {@code deviceResourcePerformanceScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceResourcePerformanceScore} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withDeviceResourcePerformanceScore(Integer deviceResourcePerformanceScore) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceResourcePerformanceScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.deviceResourcePerformanceScore = deviceResourcePerformanceScore;
        return _x;
    }

    /**
     * <i>“The user experience analytics device manufacturer.”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device manufacturer.”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withManufacturer(String manufacturer) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“The user experience analytics device model.”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience analytics device model.”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withModel(String model) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“RAM spike time in percentage. Valid values 0 to 100”</i>
     * 
     * @return property ramSpikeTimePercentage
     */
    @Property(name="ramSpikeTimePercentage")
    @JsonIgnore
    public Optional<Double> getRamSpikeTimePercentage() {
        return Optional.ofNullable(ramSpikeTimePercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ramSpikeTimePercentage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“RAM spike time in percentage. Valid values 0 to 100”</i>
     * 
     * @param ramSpikeTimePercentage
     *            new value of {@code ramSpikeTimePercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ramSpikeTimePercentage} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withRamSpikeTimePercentage(Double ramSpikeTimePercentage) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("ramSpikeTimePercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.ramSpikeTimePercentage = ramSpikeTimePercentage;
        return _x;
    }

    /**
     * <i>“Threshold of ramSpikeTimeScore. Valid values 0 to 100”</i>
     * 
     * @return property ramSpikeTimePercentageThreshold
     */
    @Property(name="ramSpikeTimePercentageThreshold")
    @JsonIgnore
    public Optional<Double> getRamSpikeTimePercentageThreshold() {
        return Optional.ofNullable(ramSpikeTimePercentageThreshold);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ramSpikeTimePercentageThreshold} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Threshold of ramSpikeTimeScore. Valid values 0 to 100”</i>
     * 
     * @param ramSpikeTimePercentageThreshold
     *            new value of {@code ramSpikeTimePercentageThreshold} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ramSpikeTimePercentageThreshold} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withRamSpikeTimePercentageThreshold(Double ramSpikeTimePercentageThreshold) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("ramSpikeTimePercentageThreshold");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.ramSpikeTimePercentageThreshold = ramSpikeTimePercentageThreshold;
        return _x;
    }

    /**
     * <i>“The user experience analytics device RAM spike time score. Valid values 0 to 100”</i>
     * 
     * @return property ramSpikeTimeScore
     */
    @Property(name="ramSpikeTimeScore")
    @JsonIgnore
    public Optional<Integer> getRamSpikeTimeScore() {
        return Optional.ofNullable(ramSpikeTimeScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ramSpikeTimeScore
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device RAM spike time score. Valid values 0 to 100”</i>
     * 
     * @param ramSpikeTimeScore
     *            new value of {@code ramSpikeTimeScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ramSpikeTimeScore} field changed
     */
    public UserExperienceAnalyticsResourcePerformance withRamSpikeTimeScore(Integer ramSpikeTimeScore) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = changedFields.add("ramSpikeTimeScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsResourcePerformance");
        _x.ramSpikeTimeScore = ramSpikeTimeScore;
        return _x;
    }

    public UserExperienceAnalyticsResourcePerformance withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsResourcePerformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsResourcePerformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsResourcePerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsResourcePerformance _copy() {
        UserExperienceAnalyticsResourcePerformance _x = new UserExperienceAnalyticsResourcePerformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.averageSpikeTimeScore = averageSpikeTimeScore;
        _x.cpuSpikeTimePercentage = cpuSpikeTimePercentage;
        _x.cpuSpikeTimePercentageThreshold = cpuSpikeTimePercentageThreshold;
        _x.cpuSpikeTimeScore = cpuSpikeTimeScore;
        _x.deviceCount = deviceCount;
        _x.deviceId = deviceId;
        _x.deviceName = deviceName;
        _x.deviceResourcePerformanceScore = deviceResourcePerformanceScore;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.ramSpikeTimePercentage = ramSpikeTimePercentage;
        _x.ramSpikeTimePercentageThreshold = ramSpikeTimePercentageThreshold;
        _x.ramSpikeTimeScore = ramSpikeTimeScore;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsResourcePerformance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("averageSpikeTimeScore=");
        b.append(this.averageSpikeTimeScore);
        b.append(", ");
        b.append("cpuSpikeTimePercentage=");
        b.append(this.cpuSpikeTimePercentage);
        b.append(", ");
        b.append("cpuSpikeTimePercentageThreshold=");
        b.append(this.cpuSpikeTimePercentageThreshold);
        b.append(", ");
        b.append("cpuSpikeTimeScore=");
        b.append(this.cpuSpikeTimeScore);
        b.append(", ");
        b.append("deviceCount=");
        b.append(this.deviceCount);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("deviceResourcePerformanceScore=");
        b.append(this.deviceResourcePerformanceScore);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("ramSpikeTimePercentage=");
        b.append(this.ramSpikeTimePercentage);
        b.append(", ");
        b.append("ramSpikeTimePercentageThreshold=");
        b.append(this.ramSpikeTimePercentageThreshold);
        b.append(", ");
        b.append("ramSpikeTimeScore=");
        b.append(this.ramSpikeTimeScore);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
