package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics metric contains the score and units of a metric of
 * a user experience anlaytics category.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "unit", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsMetric extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsMetric";
    }

    @JsonProperty("unit")
    protected String unit;

    @JsonProperty("value")
    protected Double value;

    protected UserExperienceAnalyticsMetric() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsMetric() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String unit;
        private Double value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The unit of the user experience analytics metric.”</i>
         * 
         * @param unit
         *            value of {@code unit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unit(String unit) {
            this.unit = unit;
            this.changedFields = changedFields.add("unit");
            return this;
        }

        /**
         * <i>“The value of the user experience analytics metric.”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(Double value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public UserExperienceAnalyticsMetric build() {
            UserExperienceAnalyticsMetric _x = new UserExperienceAnalyticsMetric();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsMetric";
            _x.id = id;
            _x.unit = unit;
            _x.value = value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The unit of the user experience analytics metric.”</i>
     * 
     * @return property unit
     */
    @Property(name="unit")
    @JsonIgnore
    public Optional<String> getUnit() {
        return Optional.ofNullable(unit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code unit} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The unit of the user experience analytics metric.”</i>
     * 
     * @param unit
     *            new value of {@code unit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unit} field changed
     */
    public UserExperienceAnalyticsMetric withUnit(String unit) {
        UserExperienceAnalyticsMetric _x = _copy();
        _x.changedFields = changedFields.add("unit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsMetric");
        _x.unit = unit;
        return _x;
    }

    /**
     * <i>“The value of the user experience analytics metric.”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<Double> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value of the user experience analytics metric.”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public UserExperienceAnalyticsMetric withValue(Double value) {
        UserExperienceAnalyticsMetric _x = _copy();
        _x.changedFields = changedFields.add("value");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsMetric");
        _x.value = value;
        return _x;
    }

    public UserExperienceAnalyticsMetric withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsMetric _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsMetric patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsMetric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsMetric put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsMetric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsMetric _copy() {
        UserExperienceAnalyticsMetric _x = new UserExperienceAnalyticsMetric();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.unit = unit;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsMetric[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("unit=");
        b.append(this.unit);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
