package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics top impacting process entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "category", 
    "description", 
    "deviceId", 
    "impactValue", 
    "processName", 
    "publisher"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsImpactingProcess extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsImpactingProcess";
    }

    @JsonProperty("category")
    protected String category;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("impactValue")
    protected Double impactValue;

    @JsonProperty("processName")
    protected String processName;

    @JsonProperty("publisher")
    protected String publisher;

    protected UserExperienceAnalyticsImpactingProcess() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsImpactingProcess() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String category;
        private String description;
        private String deviceId;
        private Double impactValue;
        private String processName;
        private String publisher;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The category of impacting process.”</i>
         * 
         * @param category
         *            value of {@code category} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        /**
         * <i>“The description of process.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The unique identifier of the impacted device.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The impact value of the process. Valid values 0 to 1.79769313486232E+308”</i>
         * 
         * @param impactValue
         *            value of {@code impactValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder impactValue(Double impactValue) {
            this.impactValue = impactValue;
            this.changedFields = changedFields.add("impactValue");
            return this;
        }

        /**
         * <i>“The process name.”</i>
         * 
         * @param processName
         *            value of {@code processName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processName(String processName) {
            this.processName = processName;
            this.changedFields = changedFields.add("processName");
            return this;
        }

        /**
         * <i>“The publisher of the process.”</i>
         * 
         * @param publisher
         *            value of {@code publisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public UserExperienceAnalyticsImpactingProcess build() {
            UserExperienceAnalyticsImpactingProcess _x = new UserExperienceAnalyticsImpactingProcess();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsImpactingProcess";
            _x.id = id;
            _x.category = category;
            _x.description = description;
            _x.deviceId = deviceId;
            _x.impactValue = impactValue;
            _x.processName = processName;
            _x.publisher = publisher;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The category of impacting process.”</i>
     * 
     * @return property category
     */
    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code category} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The category of impacting process.”</i>
     * 
     * @param category
     *            new value of {@code category} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code category} field changed
     */
    public UserExperienceAnalyticsImpactingProcess withCategory(String category) {
        UserExperienceAnalyticsImpactingProcess _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsImpactingProcess");
        _x.category = category;
        return _x;
    }

    /**
     * <i>“The description of process.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of process.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public UserExperienceAnalyticsImpactingProcess withDescription(String description) {
        UserExperienceAnalyticsImpactingProcess _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsImpactingProcess");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The unique identifier of the impacted device.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The unique identifier of the impacted device.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public UserExperienceAnalyticsImpactingProcess withDeviceId(String deviceId) {
        UserExperienceAnalyticsImpactingProcess _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsImpactingProcess");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The impact value of the process. Valid values 0 to 1.79769313486232E+308”</i>
     * 
     * @return property impactValue
     */
    @Property(name="impactValue")
    @JsonIgnore
    public Optional<Double> getImpactValue() {
        return Optional.ofNullable(impactValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code impactValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The impact value of the process. Valid values 0 to 1.79769313486232E+308”</i>
     * 
     * @param impactValue
     *            new value of {@code impactValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code impactValue} field changed
     */
    public UserExperienceAnalyticsImpactingProcess withImpactValue(Double impactValue) {
        UserExperienceAnalyticsImpactingProcess _x = _copy();
        _x.changedFields = changedFields.add("impactValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsImpactingProcess");
        _x.impactValue = impactValue;
        return _x;
    }

    /**
     * <i>“The process name.”</i>
     * 
     * @return property processName
     */
    @Property(name="processName")
    @JsonIgnore
    public Optional<String> getProcessName() {
        return Optional.ofNullable(processName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code processName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The process name.”</i>
     * 
     * @param processName
     *            new value of {@code processName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processName} field changed
     */
    public UserExperienceAnalyticsImpactingProcess withProcessName(String processName) {
        UserExperienceAnalyticsImpactingProcess _x = _copy();
        _x.changedFields = changedFields.add("processName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsImpactingProcess");
        _x.processName = processName;
        return _x;
    }

    /**
     * <i>“The publisher of the process.”</i>
     * 
     * @return property publisher
     */
    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The publisher of the process.”</i>
     * 
     * @param publisher
     *            new value of {@code publisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisher} field changed
     */
    public UserExperienceAnalyticsImpactingProcess withPublisher(String publisher) {
        UserExperienceAnalyticsImpactingProcess _x = _copy();
        _x.changedFields = changedFields.add("publisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsImpactingProcess");
        _x.publisher = publisher;
        return _x;
    }

    public UserExperienceAnalyticsImpactingProcess withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsImpactingProcess _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsImpactingProcess patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsImpactingProcess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsImpactingProcess put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsImpactingProcess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsImpactingProcess _copy() {
        UserExperienceAnalyticsImpactingProcess _x = new UserExperienceAnalyticsImpactingProcess();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.category = category;
        _x.description = description;
        _x.deviceId = deviceId;
        _x.impactValue = impactValue;
        _x.processName = processName;
        _x.publisher = publisher;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsImpactingProcess[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("impactValue=");
        b.append(this.impactValue);
        b.append(", ");
        b.append("processName=");
        b.append(this.processName);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
