package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics Device without Cloud Identity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "azureAdDeviceId", 
    "deviceName"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsDeviceWithoutCloudIdentity extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsDeviceWithoutCloudIdentity";
    }

    @JsonProperty("azureAdDeviceId")
    protected String azureAdDeviceId;

    @JsonProperty("deviceName")
    protected String deviceName;

    protected UserExperienceAnalyticsDeviceWithoutCloudIdentity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsDeviceWithoutCloudIdentity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String azureAdDeviceId;
        private String deviceName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Azure Active Directory Device Id”</i>
         * 
         * @param azureAdDeviceId
         *            value of {@code azureAdDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureAdDeviceId(String azureAdDeviceId) {
            this.azureAdDeviceId = azureAdDeviceId;
            this.changedFields = changedFields.add("azureAdDeviceId");
            return this;
        }

        /**
         * <i>“The tenant attach device's name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        public UserExperienceAnalyticsDeviceWithoutCloudIdentity build() {
            UserExperienceAnalyticsDeviceWithoutCloudIdentity _x = new UserExperienceAnalyticsDeviceWithoutCloudIdentity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsDeviceWithoutCloudIdentity";
            _x.id = id;
            _x.azureAdDeviceId = azureAdDeviceId;
            _x.deviceName = deviceName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Azure Active Directory Device Id”</i>
     * 
     * @return property azureAdDeviceId
     */
    @Property(name="azureAdDeviceId")
    @JsonIgnore
    public Optional<String> getAzureAdDeviceId() {
        return Optional.ofNullable(azureAdDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureAdDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Azure Active Directory Device Id”</i>
     * 
     * @param azureAdDeviceId
     *            new value of {@code azureAdDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureAdDeviceId} field changed
     */
    public UserExperienceAnalyticsDeviceWithoutCloudIdentity withAzureAdDeviceId(String azureAdDeviceId) {
        UserExperienceAnalyticsDeviceWithoutCloudIdentity _x = _copy();
        _x.changedFields = changedFields.add("azureAdDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceWithoutCloudIdentity");
        _x.azureAdDeviceId = azureAdDeviceId;
        return _x;
    }

    /**
     * <i>“The tenant attach device's name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The tenant attach device's name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public UserExperienceAnalyticsDeviceWithoutCloudIdentity withDeviceName(String deviceName) {
        UserExperienceAnalyticsDeviceWithoutCloudIdentity _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceWithoutCloudIdentity");
        _x.deviceName = deviceName;
        return _x;
    }

    public UserExperienceAnalyticsDeviceWithoutCloudIdentity withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsDeviceWithoutCloudIdentity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsDeviceWithoutCloudIdentity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsDeviceWithoutCloudIdentity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsDeviceWithoutCloudIdentity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsDeviceWithoutCloudIdentity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsDeviceWithoutCloudIdentity _copy() {
        UserExperienceAnalyticsDeviceWithoutCloudIdentity _x = new UserExperienceAnalyticsDeviceWithoutCloudIdentity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.azureAdDeviceId = azureAdDeviceId;
        _x.deviceName = deviceName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsDeviceWithoutCloudIdentity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("azureAdDeviceId=");
        b.append(this.azureAdDeviceId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
