package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics device startup process performance.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceCount", 
    "medianImpactInMs", 
    "medianImpactInMs2", 
    "processName", 
    "productName", 
    "publisher", 
    "totalImpactInMs", 
    "totalImpactInMs2"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsDeviceStartupProcessPerformance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsDeviceStartupProcessPerformance";
    }

    @JsonProperty("deviceCount")
    protected Long deviceCount;

    @JsonProperty("medianImpactInMs")
    protected Integer medianImpactInMs;

    @JsonProperty("medianImpactInMs2")
    protected Long medianImpactInMs2;

    @JsonProperty("processName")
    protected String processName;

    @JsonProperty("productName")
    protected String productName;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("totalImpactInMs")
    protected Integer totalImpactInMs;

    @JsonProperty("totalImpactInMs2")
    protected Long totalImpactInMs2;

    protected UserExperienceAnalyticsDeviceStartupProcessPerformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsDeviceStartupProcessPerformance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long deviceCount;
        private Integer medianImpactInMs;
        private Long medianImpactInMs2;
        private String processName;
        private String productName;
        private String publisher;
        private Integer totalImpactInMs;
        private Long totalImpactInMs2;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“User experience analytics device startup process summarized count.”</i>
         * 
         * @param deviceCount
         *            value of {@code deviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCount(Long deviceCount) {
            this.deviceCount = deviceCount;
            this.changedFields = changedFields.add("deviceCount");
            return this;
        }

        /**
         * <i>“User experience analytics device startup process median impact in milliseconds.”</i>
         * 
         * @param medianImpactInMs
         *            value of {@code medianImpactInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder medianImpactInMs(Integer medianImpactInMs) {
            this.medianImpactInMs = medianImpactInMs;
            this.changedFields = changedFields.add("medianImpactInMs");
            return this;
        }

        /**
         * <i>“User experience analytics device startup process median impact in milliseconds.”</i>
         * 
         * @param medianImpactInMs2
         *            value of {@code medianImpactInMs2} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder medianImpactInMs2(Long medianImpactInMs2) {
            this.medianImpactInMs2 = medianImpactInMs2;
            this.changedFields = changedFields.add("medianImpactInMs2");
            return this;
        }

        /**
         * <i>“User experience analytics device startup process name.”</i>
         * 
         * @param processName
         *            value of {@code processName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processName(String processName) {
            this.processName = processName;
            this.changedFields = changedFields.add("processName");
            return this;
        }

        /**
         * <i>“The user experience analytics device startup process product name.”</i>
         * 
         * @param productName
         *            value of {@code productName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productName(String productName) {
            this.productName = productName;
            this.changedFields = changedFields.add("productName");
            return this;
        }

        /**
         * <i>“The User experience analytics device startup process publisher.”</i>
         * 
         * @param publisher
         *            value of {@code publisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        /**
         * <i>“User experience analytics device startup process total impact in milliseconds.”</i>
         * 
         * @param totalImpactInMs
         *            value of {@code totalImpactInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalImpactInMs(Integer totalImpactInMs) {
            this.totalImpactInMs = totalImpactInMs;
            this.changedFields = changedFields.add("totalImpactInMs");
            return this;
        }

        /**
         * <i>“User experience analytics device startup process total impact in milliseconds.”</i>
         * 
         * @param totalImpactInMs2
         *            value of {@code totalImpactInMs2} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalImpactInMs2(Long totalImpactInMs2) {
            this.totalImpactInMs2 = totalImpactInMs2;
            this.changedFields = changedFields.add("totalImpactInMs2");
            return this;
        }

        public UserExperienceAnalyticsDeviceStartupProcessPerformance build() {
            UserExperienceAnalyticsDeviceStartupProcessPerformance _x = new UserExperienceAnalyticsDeviceStartupProcessPerformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsDeviceStartupProcessPerformance";
            _x.id = id;
            _x.deviceCount = deviceCount;
            _x.medianImpactInMs = medianImpactInMs;
            _x.medianImpactInMs2 = medianImpactInMs2;
            _x.processName = processName;
            _x.productName = productName;
            _x.publisher = publisher;
            _x.totalImpactInMs = totalImpactInMs;
            _x.totalImpactInMs2 = totalImpactInMs2;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“User experience analytics device startup process summarized count.”</i>
     * 
     * @return property deviceCount
     */
    @Property(name="deviceCount")
    @JsonIgnore
    public Optional<Long> getDeviceCount() {
        return Optional.ofNullable(deviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics device startup process summarized count.”</i>
     * 
     * @param deviceCount
     *            new value of {@code deviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCount} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformance withDeviceCount(Long deviceCount) {
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcessPerformance");
        _x.deviceCount = deviceCount;
        return _x;
    }

    /**
     * <i>“User experience analytics device startup process median impact in milliseconds.”</i>
     * 
     * @return property medianImpactInMs
     */
    @Property(name="medianImpactInMs")
    @JsonIgnore
    public Optional<Integer> getMedianImpactInMs() {
        return Optional.ofNullable(medianImpactInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code medianImpactInMs}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics device startup process median impact in milliseconds.”</i>
     * 
     * @param medianImpactInMs
     *            new value of {@code medianImpactInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code medianImpactInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformance withMedianImpactInMs(Integer medianImpactInMs) {
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.changedFields = changedFields.add("medianImpactInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcessPerformance");
        _x.medianImpactInMs = medianImpactInMs;
        return _x;
    }

    /**
     * <i>“User experience analytics device startup process median impact in milliseconds.”</i>
     * 
     * @return property medianImpactInMs2
     */
    @Property(name="medianImpactInMs2")
    @JsonIgnore
    public Optional<Long> getMedianImpactInMs2() {
        return Optional.ofNullable(medianImpactInMs2);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code medianImpactInMs2
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics device startup process median impact in milliseconds.”</i>
     * 
     * @param medianImpactInMs2
     *            new value of {@code medianImpactInMs2} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code medianImpactInMs2} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformance withMedianImpactInMs2(Long medianImpactInMs2) {
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.changedFields = changedFields.add("medianImpactInMs2");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcessPerformance");
        _x.medianImpactInMs2 = medianImpactInMs2;
        return _x;
    }

    /**
     * <i>“User experience analytics device startup process name.”</i>
     * 
     * @return property processName
     */
    @Property(name="processName")
    @JsonIgnore
    public Optional<String> getProcessName() {
        return Optional.ofNullable(processName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code processName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics device startup process name.”</i>
     * 
     * @param processName
     *            new value of {@code processName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processName} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformance withProcessName(String processName) {
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.changedFields = changedFields.add("processName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcessPerformance");
        _x.processName = processName;
        return _x;
    }

    /**
     * <i>“The user experience analytics device startup process product name.”</i>
     * 
     * @return property productName
     */
    @Property(name="productName")
    @JsonIgnore
    public Optional<String> getProductName() {
        return Optional.ofNullable(productName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device startup process product name.”</i>
     * 
     * @param productName
     *            new value of {@code productName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productName} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformance withProductName(String productName) {
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.changedFields = changedFields.add("productName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcessPerformance");
        _x.productName = productName;
        return _x;
    }

    /**
     * <i>“The User experience analytics device startup process publisher.”</i>
     * 
     * @return property publisher
     */
    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The User experience analytics device startup process publisher.”</i>
     * 
     * @param publisher
     *            new value of {@code publisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisher} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformance withPublisher(String publisher) {
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.changedFields = changedFields.add("publisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcessPerformance");
        _x.publisher = publisher;
        return _x;
    }

    /**
     * <i>“User experience analytics device startup process total impact in milliseconds.”</i>
     * 
     * @return property totalImpactInMs
     */
    @Property(name="totalImpactInMs")
    @JsonIgnore
    public Optional<Integer> getTotalImpactInMs() {
        return Optional.ofNullable(totalImpactInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalImpactInMs}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics device startup process total impact in milliseconds.”</i>
     * 
     * @param totalImpactInMs
     *            new value of {@code totalImpactInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalImpactInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformance withTotalImpactInMs(Integer totalImpactInMs) {
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.changedFields = changedFields.add("totalImpactInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcessPerformance");
        _x.totalImpactInMs = totalImpactInMs;
        return _x;
    }

    /**
     * <i>“User experience analytics device startup process total impact in milliseconds.”</i>
     * 
     * @return property totalImpactInMs2
     */
    @Property(name="totalImpactInMs2")
    @JsonIgnore
    public Optional<Long> getTotalImpactInMs2() {
        return Optional.ofNullable(totalImpactInMs2);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalImpactInMs2}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics device startup process total impact in milliseconds.”</i>
     * 
     * @param totalImpactInMs2
     *            new value of {@code totalImpactInMs2} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalImpactInMs2} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformance withTotalImpactInMs2(Long totalImpactInMs2) {
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.changedFields = changedFields.add("totalImpactInMs2");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcessPerformance");
        _x.totalImpactInMs2 = totalImpactInMs2;
        return _x;
    }

    public UserExperienceAnalyticsDeviceStartupProcessPerformance withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsDeviceStartupProcessPerformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsDeviceStartupProcessPerformance _copy() {
        UserExperienceAnalyticsDeviceStartupProcessPerformance _x = new UserExperienceAnalyticsDeviceStartupProcessPerformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceCount = deviceCount;
        _x.medianImpactInMs = medianImpactInMs;
        _x.medianImpactInMs2 = medianImpactInMs2;
        _x.processName = processName;
        _x.productName = productName;
        _x.publisher = publisher;
        _x.totalImpactInMs = totalImpactInMs;
        _x.totalImpactInMs2 = totalImpactInMs2;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsDeviceStartupProcessPerformance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceCount=");
        b.append(this.deviceCount);
        b.append(", ");
        b.append("medianImpactInMs=");
        b.append(this.medianImpactInMs);
        b.append(", ");
        b.append("medianImpactInMs2=");
        b.append(this.medianImpactInMs2);
        b.append(", ");
        b.append("processName=");
        b.append(this.processName);
        b.append(", ");
        b.append("productName=");
        b.append(this.productName);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("totalImpactInMs=");
        b.append(this.totalImpactInMs);
        b.append(", ");
        b.append("totalImpactInMs2=");
        b.append(this.totalImpactInMs2);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
