package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics device startup process details.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "managedDeviceId", 
    "processName", 
    "productName", 
    "publisher", 
    "startupImpactInMs"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsDeviceStartupProcess extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsDeviceStartupProcess";
    }

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("processName")
    protected String processName;

    @JsonProperty("productName")
    protected String productName;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("startupImpactInMs")
    protected Integer startupImpactInMs;

    protected UserExperienceAnalyticsDeviceStartupProcess() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsDeviceStartupProcess() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String managedDeviceId;
        private String processName;
        private String productName;
        private String publisher;
        private Integer startupImpactInMs;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The user experience analytics device id.”</i>
         * 
         * @param managedDeviceId
         *            value of {@code managedDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        /**
         * <i>“User experience analytics device startup process name.”</i>
         * 
         * @param processName
         *            value of {@code processName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processName(String processName) {
            this.processName = processName;
            this.changedFields = changedFields.add("processName");
            return this;
        }

        /**
         * <i>“The user experience analytics device startup process product name.”</i>
         * 
         * @param productName
         *            value of {@code productName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productName(String productName) {
            this.productName = productName;
            this.changedFields = changedFields.add("productName");
            return this;
        }

        /**
         * <i>“The User experience analytics device startup process publisher.”</i>
         * 
         * @param publisher
         *            value of {@code publisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        /**
         * <i>“User experience analytics device startup process impact in milliseconds.”</i>
         * 
         * @param startupImpactInMs
         *            value of {@code startupImpactInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startupImpactInMs(Integer startupImpactInMs) {
            this.startupImpactInMs = startupImpactInMs;
            this.changedFields = changedFields.add("startupImpactInMs");
            return this;
        }

        public UserExperienceAnalyticsDeviceStartupProcess build() {
            UserExperienceAnalyticsDeviceStartupProcess _x = new UserExperienceAnalyticsDeviceStartupProcess();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsDeviceStartupProcess";
            _x.id = id;
            _x.managedDeviceId = managedDeviceId;
            _x.processName = processName;
            _x.productName = productName;
            _x.publisher = publisher;
            _x.startupImpactInMs = startupImpactInMs;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The user experience analytics device id.”</i>
     * 
     * @return property managedDeviceId
     */
    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device id.”</i>
     * 
     * @param managedDeviceId
     *            new value of {@code managedDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceId} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcess withManagedDeviceId(String managedDeviceId) {
        UserExperienceAnalyticsDeviceStartupProcess _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcess");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    /**
     * <i>“User experience analytics device startup process name.”</i>
     * 
     * @return property processName
     */
    @Property(name="processName")
    @JsonIgnore
    public Optional<String> getProcessName() {
        return Optional.ofNullable(processName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code processName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics device startup process name.”</i>
     * 
     * @param processName
     *            new value of {@code processName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processName} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcess withProcessName(String processName) {
        UserExperienceAnalyticsDeviceStartupProcess _x = _copy();
        _x.changedFields = changedFields.add("processName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcess");
        _x.processName = processName;
        return _x;
    }

    /**
     * <i>“The user experience analytics device startup process product name.”</i>
     * 
     * @return property productName
     */
    @Property(name="productName")
    @JsonIgnore
    public Optional<String> getProductName() {
        return Optional.ofNullable(productName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device startup process product name.”</i>
     * 
     * @param productName
     *            new value of {@code productName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productName} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcess withProductName(String productName) {
        UserExperienceAnalyticsDeviceStartupProcess _x = _copy();
        _x.changedFields = changedFields.add("productName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcess");
        _x.productName = productName;
        return _x;
    }

    /**
     * <i>“The User experience analytics device startup process publisher.”</i>
     * 
     * @return property publisher
     */
    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The User experience analytics device startup process publisher.”</i>
     * 
     * @param publisher
     *            new value of {@code publisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisher} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcess withPublisher(String publisher) {
        UserExperienceAnalyticsDeviceStartupProcess _x = _copy();
        _x.changedFields = changedFields.add("publisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcess");
        _x.publisher = publisher;
        return _x;
    }

    /**
     * <i>“User experience analytics device startup process impact in milliseconds.”</i>
     * 
     * @return property startupImpactInMs
     */
    @Property(name="startupImpactInMs")
    @JsonIgnore
    public Optional<Integer> getStartupImpactInMs() {
        return Optional.ofNullable(startupImpactInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startupImpactInMs
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics device startup process impact in milliseconds.”</i>
     * 
     * @param startupImpactInMs
     *            new value of {@code startupImpactInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startupImpactInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupProcess withStartupImpactInMs(Integer startupImpactInMs) {
        UserExperienceAnalyticsDeviceStartupProcess _x = _copy();
        _x.changedFields = changedFields.add("startupImpactInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupProcess");
        _x.startupImpactInMs = startupImpactInMs;
        return _x;
    }

    public UserExperienceAnalyticsDeviceStartupProcess withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsDeviceStartupProcess _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsDeviceStartupProcess patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsDeviceStartupProcess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsDeviceStartupProcess put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsDeviceStartupProcess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsDeviceStartupProcess _copy() {
        UserExperienceAnalyticsDeviceStartupProcess _x = new UserExperienceAnalyticsDeviceStartupProcess();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.managedDeviceId = managedDeviceId;
        _x.processName = processName;
        _x.productName = productName;
        _x.publisher = publisher;
        _x.startupImpactInMs = startupImpactInMs;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsDeviceStartupProcess[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("processName=");
        b.append(this.processName);
        b.append(", ");
        b.append("productName=");
        b.append(this.productName);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("startupImpactInMs=");
        b.append(this.startupImpactInMs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
