package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.UserExperienceAnalyticsOperatingSystemRestartCategory;


/**
 * <i>“The user experience analytics device startup history entity contains device boot
 * performance history details.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "coreBootTimeInMs", 
    "coreLoginTimeInMs", 
    "deviceId", 
    "featureUpdateBootTimeInMs", 
    "groupPolicyBootTimeInMs", 
    "groupPolicyLoginTimeInMs", 
    "isFeatureUpdate", 
    "isFirstLogin", 
    "operatingSystemVersion", 
    "responsiveDesktopTimeInMs", 
    "restartCategory", 
    "restartFaultBucket", 
    "restartStopCode", 
    "startTime", 
    "totalBootTimeInMs", 
    "totalLoginTimeInMs"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsDeviceStartupHistory extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory";
    }

    @JsonProperty("coreBootTimeInMs")
    protected Integer coreBootTimeInMs;

    @JsonProperty("coreLoginTimeInMs")
    protected Integer coreLoginTimeInMs;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("featureUpdateBootTimeInMs")
    protected Integer featureUpdateBootTimeInMs;

    @JsonProperty("groupPolicyBootTimeInMs")
    protected Integer groupPolicyBootTimeInMs;

    @JsonProperty("groupPolicyLoginTimeInMs")
    protected Integer groupPolicyLoginTimeInMs;

    @JsonProperty("isFeatureUpdate")
    protected Boolean isFeatureUpdate;

    @JsonProperty("isFirstLogin")
    protected Boolean isFirstLogin;

    @JsonProperty("operatingSystemVersion")
    protected String operatingSystemVersion;

    @JsonProperty("responsiveDesktopTimeInMs")
    protected Integer responsiveDesktopTimeInMs;

    @JsonProperty("restartCategory")
    protected UserExperienceAnalyticsOperatingSystemRestartCategory restartCategory;

    @JsonProperty("restartFaultBucket")
    protected String restartFaultBucket;

    @JsonProperty("restartStopCode")
    protected String restartStopCode;

    @JsonProperty("startTime")
    protected OffsetDateTime startTime;

    @JsonProperty("totalBootTimeInMs")
    protected Integer totalBootTimeInMs;

    @JsonProperty("totalLoginTimeInMs")
    protected Integer totalLoginTimeInMs;

    protected UserExperienceAnalyticsDeviceStartupHistory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsDeviceStartupHistory() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer coreBootTimeInMs;
        private Integer coreLoginTimeInMs;
        private String deviceId;
        private Integer featureUpdateBootTimeInMs;
        private Integer groupPolicyBootTimeInMs;
        private Integer groupPolicyLoginTimeInMs;
        private Boolean isFeatureUpdate;
        private Boolean isFirstLogin;
        private String operatingSystemVersion;
        private Integer responsiveDesktopTimeInMs;
        private UserExperienceAnalyticsOperatingSystemRestartCategory restartCategory;
        private String restartFaultBucket;
        private String restartStopCode;
        private OffsetDateTime startTime;
        private Integer totalBootTimeInMs;
        private Integer totalLoginTimeInMs;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The user experience analytics device core boot time in milliseconds.”</i>
         * 
         * @param coreBootTimeInMs
         *            value of {@code coreBootTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder coreBootTimeInMs(Integer coreBootTimeInMs) {
            this.coreBootTimeInMs = coreBootTimeInMs;
            this.changedFields = changedFields.add("coreBootTimeInMs");
            return this;
        }

        /**
         * <i>“The user experience analytics device core login time in milliseconds.”</i>
         * 
         * @param coreLoginTimeInMs
         *            value of {@code coreLoginTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder coreLoginTimeInMs(Integer coreLoginTimeInMs) {
            this.coreLoginTimeInMs = coreLoginTimeInMs;
            this.changedFields = changedFields.add("coreLoginTimeInMs");
            return this;
        }

        /**
         * <i>“The user experience analytics device id.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The user experience analytics device feature update time in milliseconds.”</i>
         * 
         * @param featureUpdateBootTimeInMs
         *            value of {@code featureUpdateBootTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureUpdateBootTimeInMs(Integer featureUpdateBootTimeInMs) {
            this.featureUpdateBootTimeInMs = featureUpdateBootTimeInMs;
            this.changedFields = changedFields.add("featureUpdateBootTimeInMs");
            return this;
        }

        /**
         * <i>“The User experience analytics Device group policy boot time in milliseconds.”</i>
         * 
         * @param groupPolicyBootTimeInMs
         *            value of {@code groupPolicyBootTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyBootTimeInMs(Integer groupPolicyBootTimeInMs) {
            this.groupPolicyBootTimeInMs = groupPolicyBootTimeInMs;
            this.changedFields = changedFields.add("groupPolicyBootTimeInMs");
            return this;
        }

        /**
         * <i>“The User experience analytics Device group policy login time in milliseconds.”</i>
         * 
         * @param groupPolicyLoginTimeInMs
         *            value of {@code groupPolicyLoginTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyLoginTimeInMs(Integer groupPolicyLoginTimeInMs) {
            this.groupPolicyLoginTimeInMs = groupPolicyLoginTimeInMs;
            this.changedFields = changedFields.add("groupPolicyLoginTimeInMs");
            return this;
        }

        /**
         * <i>“The user experience analytics device boot record is a feature update.”</i>
         * 
         * @param isFeatureUpdate
         *            value of {@code isFeatureUpdate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isFeatureUpdate(Boolean isFeatureUpdate) {
            this.isFeatureUpdate = isFeatureUpdate;
            this.changedFields = changedFields.add("isFeatureUpdate");
            return this;
        }

        /**
         * <i>“The user experience analytics device first login.”</i>
         * 
         * @param isFirstLogin
         *            value of {@code isFirstLogin} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isFirstLogin(Boolean isFirstLogin) {
            this.isFirstLogin = isFirstLogin;
            this.changedFields = changedFields.add("isFirstLogin");
            return this;
        }

        /**
         * <i>“The user experience analytics device boot record's operating system version.”</i>
         * 
         * @param operatingSystemVersion
         *            value of {@code operatingSystemVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            this.changedFields = changedFields.add("operatingSystemVersion");
            return this;
        }

        /**
         * <i>“The user experience analytics responsive desktop time in milliseconds.”</i>
         * 
         * @param responsiveDesktopTimeInMs
         *            value of {@code responsiveDesktopTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder responsiveDesktopTimeInMs(Integer responsiveDesktopTimeInMs) {
            this.responsiveDesktopTimeInMs = responsiveDesktopTimeInMs;
            this.changedFields = changedFields.add("responsiveDesktopTimeInMs");
            return this;
        }

        /**
         * <i>“OS restart category”</i>
         * 
         * @param restartCategory
         *            value of {@code restartCategory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restartCategory(UserExperienceAnalyticsOperatingSystemRestartCategory restartCategory) {
            this.restartCategory = restartCategory;
            this.changedFields = changedFields.add("restartCategory");
            return this;
        }

        /**
         * <i>“OS restart fault bucket. The fault bucket is used to find additional information
         * about a system crash.”</i>
         * 
         * @param restartFaultBucket
         *            value of {@code restartFaultBucket} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restartFaultBucket(String restartFaultBucket) {
            this.restartFaultBucket = restartFaultBucket;
            this.changedFields = changedFields.add("restartFaultBucket");
            return this;
        }

        /**
         * <i>“OS restart stop code. This shows the bug check code which can be used to look up
         * the blue screen reason.”</i>
         * 
         * @param restartStopCode
         *            value of {@code restartStopCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restartStopCode(String restartStopCode) {
            this.restartStopCode = restartStopCode;
            this.changedFields = changedFields.add("restartStopCode");
            return this;
        }

        /**
         * <i>“The user experience analytics device boot start time.”</i>
         * 
         * @param startTime
         *            value of {@code startTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            this.changedFields = changedFields.add("startTime");
            return this;
        }

        /**
         * <i>“The user experience analytics device total boot time in milliseconds.”</i>
         * 
         * @param totalBootTimeInMs
         *            value of {@code totalBootTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalBootTimeInMs(Integer totalBootTimeInMs) {
            this.totalBootTimeInMs = totalBootTimeInMs;
            this.changedFields = changedFields.add("totalBootTimeInMs");
            return this;
        }

        /**
         * <i>“The user experience analytics device total login time in milliseconds.”</i>
         * 
         * @param totalLoginTimeInMs
         *            value of {@code totalLoginTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalLoginTimeInMs(Integer totalLoginTimeInMs) {
            this.totalLoginTimeInMs = totalLoginTimeInMs;
            this.changedFields = changedFields.add("totalLoginTimeInMs");
            return this;
        }

        public UserExperienceAnalyticsDeviceStartupHistory build() {
            UserExperienceAnalyticsDeviceStartupHistory _x = new UserExperienceAnalyticsDeviceStartupHistory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory";
            _x.id = id;
            _x.coreBootTimeInMs = coreBootTimeInMs;
            _x.coreLoginTimeInMs = coreLoginTimeInMs;
            _x.deviceId = deviceId;
            _x.featureUpdateBootTimeInMs = featureUpdateBootTimeInMs;
            _x.groupPolicyBootTimeInMs = groupPolicyBootTimeInMs;
            _x.groupPolicyLoginTimeInMs = groupPolicyLoginTimeInMs;
            _x.isFeatureUpdate = isFeatureUpdate;
            _x.isFirstLogin = isFirstLogin;
            _x.operatingSystemVersion = operatingSystemVersion;
            _x.responsiveDesktopTimeInMs = responsiveDesktopTimeInMs;
            _x.restartCategory = restartCategory;
            _x.restartFaultBucket = restartFaultBucket;
            _x.restartStopCode = restartStopCode;
            _x.startTime = startTime;
            _x.totalBootTimeInMs = totalBootTimeInMs;
            _x.totalLoginTimeInMs = totalLoginTimeInMs;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The user experience analytics device core boot time in milliseconds.”</i>
     * 
     * @return property coreBootTimeInMs
     */
    @Property(name="coreBootTimeInMs")
    @JsonIgnore
    public Optional<Integer> getCoreBootTimeInMs() {
        return Optional.ofNullable(coreBootTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code coreBootTimeInMs}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device core boot time in milliseconds.”</i>
     * 
     * @param coreBootTimeInMs
     *            new value of {@code coreBootTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code coreBootTimeInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withCoreBootTimeInMs(Integer coreBootTimeInMs) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("coreBootTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.coreBootTimeInMs = coreBootTimeInMs;
        return _x;
    }

    /**
     * <i>“The user experience analytics device core login time in milliseconds.”</i>
     * 
     * @return property coreLoginTimeInMs
     */
    @Property(name="coreLoginTimeInMs")
    @JsonIgnore
    public Optional<Integer> getCoreLoginTimeInMs() {
        return Optional.ofNullable(coreLoginTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code coreLoginTimeInMs
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device core login time in milliseconds.”</i>
     * 
     * @param coreLoginTimeInMs
     *            new value of {@code coreLoginTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code coreLoginTimeInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withCoreLoginTimeInMs(Integer coreLoginTimeInMs) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("coreLoginTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.coreLoginTimeInMs = coreLoginTimeInMs;
        return _x;
    }

    /**
     * <i>“The user experience analytics device id.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience analytics device id.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withDeviceId(String deviceId) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The user experience analytics device feature update time in milliseconds.”</i>
     * 
     * @return property featureUpdateBootTimeInMs
     */
    @Property(name="featureUpdateBootTimeInMs")
    @JsonIgnore
    public Optional<Integer> getFeatureUpdateBootTimeInMs() {
        return Optional.ofNullable(featureUpdateBootTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureUpdateBootTimeInMs} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics device feature update time in milliseconds.”</i>
     * 
     * @param featureUpdateBootTimeInMs
     *            new value of {@code featureUpdateBootTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureUpdateBootTimeInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withFeatureUpdateBootTimeInMs(Integer featureUpdateBootTimeInMs) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("featureUpdateBootTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.featureUpdateBootTimeInMs = featureUpdateBootTimeInMs;
        return _x;
    }

    /**
     * <i>“The User experience analytics Device group policy boot time in milliseconds.”</i>
     * 
     * @return property groupPolicyBootTimeInMs
     */
    @Property(name="groupPolicyBootTimeInMs")
    @JsonIgnore
    public Optional<Integer> getGroupPolicyBootTimeInMs() {
        return Optional.ofNullable(groupPolicyBootTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyBootTimeInMs} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The User experience analytics Device group policy boot time in milliseconds.”</i>
     * 
     * @param groupPolicyBootTimeInMs
     *            new value of {@code groupPolicyBootTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyBootTimeInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withGroupPolicyBootTimeInMs(Integer groupPolicyBootTimeInMs) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyBootTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.groupPolicyBootTimeInMs = groupPolicyBootTimeInMs;
        return _x;
    }

    /**
     * <i>“The User experience analytics Device group policy login time in milliseconds.”</i>
     * 
     * @return property groupPolicyLoginTimeInMs
     */
    @Property(name="groupPolicyLoginTimeInMs")
    @JsonIgnore
    public Optional<Integer> getGroupPolicyLoginTimeInMs() {
        return Optional.ofNullable(groupPolicyLoginTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyLoginTimeInMs} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The User experience analytics Device group policy login time in milliseconds.”</i>
     * 
     * @param groupPolicyLoginTimeInMs
     *            new value of {@code groupPolicyLoginTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyLoginTimeInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withGroupPolicyLoginTimeInMs(Integer groupPolicyLoginTimeInMs) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyLoginTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.groupPolicyLoginTimeInMs = groupPolicyLoginTimeInMs;
        return _x;
    }

    /**
     * <i>“The user experience analytics device boot record is a feature update.”</i>
     * 
     * @return property isFeatureUpdate
     */
    @Property(name="isFeatureUpdate")
    @JsonIgnore
    public Optional<Boolean> getIsFeatureUpdate() {
        return Optional.ofNullable(isFeatureUpdate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isFeatureUpdate}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device boot record is a feature update.”</i>
     * 
     * @param isFeatureUpdate
     *            new value of {@code isFeatureUpdate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isFeatureUpdate} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withIsFeatureUpdate(Boolean isFeatureUpdate) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("isFeatureUpdate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.isFeatureUpdate = isFeatureUpdate;
        return _x;
    }

    /**
     * <i>“The user experience analytics device first login.”</i>
     * 
     * @return property isFirstLogin
     */
    @Property(name="isFirstLogin")
    @JsonIgnore
    public Optional<Boolean> getIsFirstLogin() {
        return Optional.ofNullable(isFirstLogin);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isFirstLogin}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device first login.”</i>
     * 
     * @param isFirstLogin
     *            new value of {@code isFirstLogin} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isFirstLogin} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withIsFirstLogin(Boolean isFirstLogin) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("isFirstLogin");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.isFirstLogin = isFirstLogin;
        return _x;
    }

    /**
     * <i>“The user experience analytics device boot record's operating system version.”</i>
     * 
     * @return property operatingSystemVersion
     */
    @Property(name="operatingSystemVersion")
    @JsonIgnore
    public Optional<String> getOperatingSystemVersion() {
        return Optional.ofNullable(operatingSystemVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics device boot record's operating system version.”</i>
     * 
     * @param operatingSystemVersion
     *            new value of {@code operatingSystemVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemVersion} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withOperatingSystemVersion(String operatingSystemVersion) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("operatingSystemVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.operatingSystemVersion = operatingSystemVersion;
        return _x;
    }

    /**
     * <i>“The user experience analytics responsive desktop time in milliseconds.”</i>
     * 
     * @return property responsiveDesktopTimeInMs
     */
    @Property(name="responsiveDesktopTimeInMs")
    @JsonIgnore
    public Optional<Integer> getResponsiveDesktopTimeInMs() {
        return Optional.ofNullable(responsiveDesktopTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * responsiveDesktopTimeInMs} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics responsive desktop time in milliseconds.”</i>
     * 
     * @param responsiveDesktopTimeInMs
     *            new value of {@code responsiveDesktopTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code responsiveDesktopTimeInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withResponsiveDesktopTimeInMs(Integer responsiveDesktopTimeInMs) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("responsiveDesktopTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.responsiveDesktopTimeInMs = responsiveDesktopTimeInMs;
        return _x;
    }

    /**
     * <i>“OS restart category”</i>
     * 
     * @return property restartCategory
     */
    @Property(name="restartCategory")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsOperatingSystemRestartCategory> getRestartCategory() {
        return Optional.ofNullable(restartCategory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code restartCategory}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“OS restart category”</i>
     * 
     * @param restartCategory
     *            new value of {@code restartCategory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restartCategory} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withRestartCategory(UserExperienceAnalyticsOperatingSystemRestartCategory restartCategory) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("restartCategory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.restartCategory = restartCategory;
        return _x;
    }

    /**
     * <i>“OS restart fault bucket. The fault bucket is used to find additional information
     * about a system crash.”</i>
     * 
     * @return property restartFaultBucket
     */
    @Property(name="restartFaultBucket")
    @JsonIgnore
    public Optional<String> getRestartFaultBucket() {
        return Optional.ofNullable(restartFaultBucket);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * restartFaultBucket} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“OS restart fault bucket. The fault bucket is used to find additional information
     * about a system crash.”</i>
     * 
     * @param restartFaultBucket
     *            new value of {@code restartFaultBucket} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restartFaultBucket} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withRestartFaultBucket(String restartFaultBucket) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("restartFaultBucket");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.restartFaultBucket = restartFaultBucket;
        return _x;
    }

    /**
     * <i>“OS restart stop code. This shows the bug check code which can be used to look up
     * the blue screen reason.”</i>
     * 
     * @return property restartStopCode
     */
    @Property(name="restartStopCode")
    @JsonIgnore
    public Optional<String> getRestartStopCode() {
        return Optional.ofNullable(restartStopCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code restartStopCode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“OS restart stop code. This shows the bug check code which can be used to look up
     * the blue screen reason.”</i>
     * 
     * @param restartStopCode
     *            new value of {@code restartStopCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restartStopCode} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withRestartStopCode(String restartStopCode) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("restartStopCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.restartStopCode = restartStopCode;
        return _x;
    }

    /**
     * <i>“The user experience analytics device boot start time.”</i>
     * 
     * @return property startTime
     */
    @Property(name="startTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartTime() {
        return Optional.ofNullable(startTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startTime} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience analytics device boot start time.”</i>
     * 
     * @param startTime
     *            new value of {@code startTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startTime} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withStartTime(OffsetDateTime startTime) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("startTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.startTime = startTime;
        return _x;
    }

    /**
     * <i>“The user experience analytics device total boot time in milliseconds.”</i>
     * 
     * @return property totalBootTimeInMs
     */
    @Property(name="totalBootTimeInMs")
    @JsonIgnore
    public Optional<Integer> getTotalBootTimeInMs() {
        return Optional.ofNullable(totalBootTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalBootTimeInMs
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device total boot time in milliseconds.”</i>
     * 
     * @param totalBootTimeInMs
     *            new value of {@code totalBootTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalBootTimeInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withTotalBootTimeInMs(Integer totalBootTimeInMs) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("totalBootTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.totalBootTimeInMs = totalBootTimeInMs;
        return _x;
    }

    /**
     * <i>“The user experience analytics device total login time in milliseconds.”</i>
     * 
     * @return property totalLoginTimeInMs
     */
    @Property(name="totalLoginTimeInMs")
    @JsonIgnore
    public Optional<Integer> getTotalLoginTimeInMs() {
        return Optional.ofNullable(totalLoginTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * totalLoginTimeInMs} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics device total login time in milliseconds.”</i>
     * 
     * @param totalLoginTimeInMs
     *            new value of {@code totalLoginTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalLoginTimeInMs} field changed
     */
    public UserExperienceAnalyticsDeviceStartupHistory withTotalLoginTimeInMs(Integer totalLoginTimeInMs) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = changedFields.add("totalLoginTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDeviceStartupHistory");
        _x.totalLoginTimeInMs = totalLoginTimeInMs;
        return _x;
    }

    public UserExperienceAnalyticsDeviceStartupHistory withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsDeviceStartupHistory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsDeviceStartupHistory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsDeviceStartupHistory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsDeviceStartupHistory _copy() {
        UserExperienceAnalyticsDeviceStartupHistory _x = new UserExperienceAnalyticsDeviceStartupHistory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.coreBootTimeInMs = coreBootTimeInMs;
        _x.coreLoginTimeInMs = coreLoginTimeInMs;
        _x.deviceId = deviceId;
        _x.featureUpdateBootTimeInMs = featureUpdateBootTimeInMs;
        _x.groupPolicyBootTimeInMs = groupPolicyBootTimeInMs;
        _x.groupPolicyLoginTimeInMs = groupPolicyLoginTimeInMs;
        _x.isFeatureUpdate = isFeatureUpdate;
        _x.isFirstLogin = isFirstLogin;
        _x.operatingSystemVersion = operatingSystemVersion;
        _x.responsiveDesktopTimeInMs = responsiveDesktopTimeInMs;
        _x.restartCategory = restartCategory;
        _x.restartFaultBucket = restartFaultBucket;
        _x.restartStopCode = restartStopCode;
        _x.startTime = startTime;
        _x.totalBootTimeInMs = totalBootTimeInMs;
        _x.totalLoginTimeInMs = totalLoginTimeInMs;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsDeviceStartupHistory[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("coreBootTimeInMs=");
        b.append(this.coreBootTimeInMs);
        b.append(", ");
        b.append("coreLoginTimeInMs=");
        b.append(this.coreLoginTimeInMs);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("featureUpdateBootTimeInMs=");
        b.append(this.featureUpdateBootTimeInMs);
        b.append(", ");
        b.append("groupPolicyBootTimeInMs=");
        b.append(this.groupPolicyBootTimeInMs);
        b.append(", ");
        b.append("groupPolicyLoginTimeInMs=");
        b.append(this.groupPolicyLoginTimeInMs);
        b.append(", ");
        b.append("isFeatureUpdate=");
        b.append(this.isFeatureUpdate);
        b.append(", ");
        b.append("isFirstLogin=");
        b.append(this.isFirstLogin);
        b.append(", ");
        b.append("operatingSystemVersion=");
        b.append(this.operatingSystemVersion);
        b.append(", ");
        b.append("responsiveDesktopTimeInMs=");
        b.append(this.responsiveDesktopTimeInMs);
        b.append(", ");
        b.append("restartCategory=");
        b.append(this.restartCategory);
        b.append(", ");
        b.append("restartFaultBucket=");
        b.append(this.restartFaultBucket);
        b.append(", ");
        b.append("restartStopCode=");
        b.append(this.restartStopCode);
        b.append(", ");
        b.append("startTime=");
        b.append(this.startTime);
        b.append(", ");
        b.append("totalBootTimeInMs=");
        b.append(this.totalBootTimeInMs);
        b.append(", ");
        b.append("totalLoginTimeInMs=");
        b.append(this.totalLoginTimeInMs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
