package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UserExperienceAnalyticsInsight;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsMetricCollectionRequest;


/**
 * <i>“The user experience analytics category entity contains the scores and insights
 * for the various metrics of a category.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "insights", 
    "metricValues"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsCategory extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsCategory";
    }

    @JsonProperty("insights")
    protected List<UserExperienceAnalyticsInsight> insights;

    @JsonProperty("insights@nextLink")
    protected String insightsNextLink;

    @JsonProperty("metricValues")
    protected List<UserExperienceAnalyticsMetric> metricValues;

    protected UserExperienceAnalyticsCategory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsCategory() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<UserExperienceAnalyticsInsight> insights;
        private String insightsNextLink;
        private List<UserExperienceAnalyticsMetric> metricValues;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The insights for the user experience analytics category.”</i>
         * 
         * @param insights
         *            value of {@code insights} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder insights(List<UserExperienceAnalyticsInsight> insights) {
            this.insights = insights;
            this.changedFields = changedFields.add("insights");
            return this;
        }

        /**
         * <i>“The insights for the user experience analytics category.”</i>
         * 
         * @param insights
         *            value of {@code insights} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder insights(UserExperienceAnalyticsInsight... insights) {
            return insights(Arrays.asList(insights));
        }

        /**
         * <i>“The insights for the user experience analytics category.”</i>
         * 
         * @param insightsNextLink
         *            value of {@code insights@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder insightsNextLink(String insightsNextLink) {
            this.insightsNextLink = insightsNextLink;
            this.changedFields = changedFields.add("insights");
            return this;
        }

        /**
         * <i>“The metric values for the user experience analytics category.”</i>
         * 
         * @param metricValues
         *            value of {@code metricValues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder metricValues(List<UserExperienceAnalyticsMetric> metricValues) {
            this.metricValues = metricValues;
            this.changedFields = changedFields.add("metricValues");
            return this;
        }

        /**
         * <i>“The metric values for the user experience analytics category.”</i>
         * 
         * @param metricValues
         *            value of {@code metricValues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder metricValues(UserExperienceAnalyticsMetric... metricValues) {
            return metricValues(Arrays.asList(metricValues));
        }

        public UserExperienceAnalyticsCategory build() {
            UserExperienceAnalyticsCategory _x = new UserExperienceAnalyticsCategory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsCategory";
            _x.id = id;
            _x.insights = insights;
            _x.insightsNextLink = insightsNextLink;
            _x.metricValues = metricValues;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The insights for the user experience analytics category.”</i>
     * 
     * @return property insights
     */
    @Property(name="insights")
    @JsonIgnore
    public CollectionPage<UserExperienceAnalyticsInsight> getInsights() {
        return new CollectionPage<UserExperienceAnalyticsInsight>(contextPath, UserExperienceAnalyticsInsight.class, this.insights, Optional.ofNullable(insightsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code insights} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The insights for the user experience analytics category.”</i>
     * 
     * @param insights
     *            new value of {@code insights} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code insights} field changed
     */
    public UserExperienceAnalyticsCategory withInsights(List<UserExperienceAnalyticsInsight> insights) {
        UserExperienceAnalyticsCategory _x = _copy();
        _x.changedFields = changedFields.add("insights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsCategory");
        _x.insights = insights;
        return _x;
    }

    /**
     * <i>“The insights for the user experience analytics category.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property insights
     */
    @Property(name="insights")
    @JsonIgnore
    public CollectionPage<UserExperienceAnalyticsInsight> getInsights(HttpRequestOptions options) {
        return new CollectionPage<UserExperienceAnalyticsInsight>(contextPath, UserExperienceAnalyticsInsight.class, this.insights, Optional.ofNullable(insightsNextLink), Collections.emptyList(), options);
    }

    public UserExperienceAnalyticsCategory withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsCategory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The metric values for the user experience analytics category.”</i>
     * 
     * @return navigational property metricValues
     */
    @NavigationProperty(name="metricValues")
    @JsonIgnore
    public UserExperienceAnalyticsMetricCollectionRequest getMetricValues() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("metricValues"), Optional.ofNullable(metricValues));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code metricValues}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The metric values for the user experience analytics category.”</i>
     * 
     * @param metricValues
     *            new value of {@code metricValues} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code metricValues} field changed
     */
    public UserExperienceAnalyticsCategory withMetricValues(List<UserExperienceAnalyticsMetric> metricValues) {
        UserExperienceAnalyticsCategory _x = _copy();
        _x.changedFields = changedFields.add("metricValues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsCategory");
        _x.metricValues = metricValues;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsCategory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsCategory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsCategory _copy() {
        UserExperienceAnalyticsCategory _x = new UserExperienceAnalyticsCategory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.insights = insights;
        _x.metricValues = metricValues;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsCategory[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("insights=");
        b.append(this.insights);
        b.append(", ");
        b.append("metricValues=");
        b.append(this.metricValues);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
