package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics battery health device app impact entity contains
 * battery usage related information at an app level for a given device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appDisplayName", 
    "appName", 
    "appPublisher", 
    "batteryUsagePercentage", 
    "deviceId", 
    "isForegroundApp"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsBatteryHealthDeviceAppImpact extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsBatteryHealthDeviceAppImpact";
    }

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("appName")
    protected String appName;

    @JsonProperty("appPublisher")
    protected String appPublisher;

    @JsonProperty("batteryUsagePercentage")
    protected Double batteryUsagePercentage;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("isForegroundApp")
    protected Boolean isForegroundApp;

    protected UserExperienceAnalyticsBatteryHealthDeviceAppImpact() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsBatteryHealthDeviceAppImpact() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appDisplayName;
        private String appName;
        private String appPublisher;
        private Double batteryUsagePercentage;
        private String deviceId;
        private Boolean isForegroundApp;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“User friendly display name for the app. Eg: Outlook”</i>
         * 
         * @param appDisplayName
         *            value of {@code appDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        /**
         * <i>“App name. Eg: oltk.exe”</i>
         * 
         * @param appName
         *            value of {@code appName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appName(String appName) {
            this.appName = appName;
            this.changedFields = changedFields.add("appName");
            return this;
        }

        /**
         * <i>“App publisher. Eg: Microsoft Corporation”</i>
         * 
         * @param appPublisher
         *            value of {@code appPublisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appPublisher(String appPublisher) {
            this.appPublisher = appPublisher;
            this.changedFields = changedFields.add("appPublisher");
            return this;
        }

        /**
         * <i>“The percent of total battery power used by this application when the device was
         * not plugged into AC power, over 14 days. Unit in percentage. Valid values -1.
         * 79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param batteryUsagePercentage
         *            value of {@code batteryUsagePercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batteryUsagePercentage(Double batteryUsagePercentage) {
            this.batteryUsagePercentage = batteryUsagePercentage;
            this.changedFields = changedFields.add("batteryUsagePercentage");
            return this;
        }

        /**
         * <i>“The unique identifier of the device, Intune DeviceID or SCCM device id.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“true if the user had active interaction with the app.”</i>
         * 
         * @param isForegroundApp
         *            value of {@code isForegroundApp} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isForegroundApp(Boolean isForegroundApp) {
            this.isForegroundApp = isForegroundApp;
            this.changedFields = changedFields.add("isForegroundApp");
            return this;
        }

        public UserExperienceAnalyticsBatteryHealthDeviceAppImpact build() {
            UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = new UserExperienceAnalyticsBatteryHealthDeviceAppImpact();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsBatteryHealthDeviceAppImpact";
            _x.id = id;
            _x.appDisplayName = appDisplayName;
            _x.appName = appName;
            _x.appPublisher = appPublisher;
            _x.batteryUsagePercentage = batteryUsagePercentage;
            _x.deviceId = deviceId;
            _x.isForegroundApp = isForegroundApp;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“User friendly display name for the app. Eg: Outlook”</i>
     * 
     * @return property appDisplayName
     */
    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User friendly display name for the app. Eg: Outlook”</i>
     * 
     * @param appDisplayName
     *            new value of {@code appDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appDisplayName} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDeviceAppImpact withAppDisplayName(String appDisplayName) {
        UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDeviceAppImpact");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    /**
     * <i>“App name. Eg: oltk.exe”</i>
     * 
     * @return property appName
     */
    @Property(name="appName")
    @JsonIgnore
    public Optional<String> getAppName() {
        return Optional.ofNullable(appName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“App name. Eg: oltk.exe”</i>
     * 
     * @param appName
     *            new value of {@code appName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appName} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDeviceAppImpact withAppName(String appName) {
        UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = _copy();
        _x.changedFields = changedFields.add("appName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDeviceAppImpact");
        _x.appName = appName;
        return _x;
    }

    /**
     * <i>“App publisher. Eg: Microsoft Corporation”</i>
     * 
     * @return property appPublisher
     */
    @Property(name="appPublisher")
    @JsonIgnore
    public Optional<String> getAppPublisher() {
        return Optional.ofNullable(appPublisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appPublisher}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“App publisher. Eg: Microsoft Corporation”</i>
     * 
     * @param appPublisher
     *            new value of {@code appPublisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appPublisher} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDeviceAppImpact withAppPublisher(String appPublisher) {
        UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = _copy();
        _x.changedFields = changedFields.add("appPublisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDeviceAppImpact");
        _x.appPublisher = appPublisher;
        return _x;
    }

    /**
     * <i>“The percent of total battery power used by this application when the device was
     * not plugged into AC power, over 14 days. Unit in percentage. Valid values -1.
     * 79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property batteryUsagePercentage
     */
    @Property(name="batteryUsagePercentage")
    @JsonIgnore
    public Optional<Double> getBatteryUsagePercentage() {
        return Optional.ofNullable(batteryUsagePercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * batteryUsagePercentage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The percent of total battery power used by this application when the device was
     * not plugged into AC power, over 14 days. Unit in percentage. Valid values -1.
     * 79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param batteryUsagePercentage
     *            new value of {@code batteryUsagePercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batteryUsagePercentage} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDeviceAppImpact withBatteryUsagePercentage(Double batteryUsagePercentage) {
        UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = _copy();
        _x.changedFields = changedFields.add("batteryUsagePercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDeviceAppImpact");
        _x.batteryUsagePercentage = batteryUsagePercentage;
        return _x;
    }

    /**
     * <i>“The unique identifier of the device, Intune DeviceID or SCCM device id.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The unique identifier of the device, Intune DeviceID or SCCM device id.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDeviceAppImpact withDeviceId(String deviceId) {
        UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDeviceAppImpact");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“true if the user had active interaction with the app.”</i>
     * 
     * @return property isForegroundApp
     */
    @Property(name="isForegroundApp")
    @JsonIgnore
    public Optional<Boolean> getIsForegroundApp() {
        return Optional.ofNullable(isForegroundApp);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isForegroundApp}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“true if the user had active interaction with the app.”</i>
     * 
     * @param isForegroundApp
     *            new value of {@code isForegroundApp} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isForegroundApp} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDeviceAppImpact withIsForegroundApp(Boolean isForegroundApp) {
        UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = _copy();
        _x.changedFields = changedFields.add("isForegroundApp");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDeviceAppImpact");
        _x.isForegroundApp = isForegroundApp;
        return _x;
    }

    public UserExperienceAnalyticsBatteryHealthDeviceAppImpact withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBatteryHealthDeviceAppImpact patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBatteryHealthDeviceAppImpact put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsBatteryHealthDeviceAppImpact _copy() {
        UserExperienceAnalyticsBatteryHealthDeviceAppImpact _x = new UserExperienceAnalyticsBatteryHealthDeviceAppImpact();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appDisplayName = appDisplayName;
        _x.appName = appName;
        _x.appPublisher = appPublisher;
        _x.batteryUsagePercentage = batteryUsagePercentage;
        _x.deviceId = deviceId;
        _x.isForegroundApp = isForegroundApp;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsBatteryHealthDeviceAppImpact[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appName=");
        b.append(this.appName);
        b.append(", ");
        b.append("appPublisher=");
        b.append(this.appPublisher);
        b.append(", ");
        b.append("batteryUsagePercentage=");
        b.append(this.batteryUsagePercentage);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("isForegroundApp=");
        b.append(this.isForegroundApp);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
