package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics device OS version performance entity contains OS
 * version performance details.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "activeDeviceCount", 
    "meanTimeToFailureInMinutes", 
    "osBuildNumber", 
    "osVersion", 
    "osVersionAppHealthScore", 
    "osVersionAppHealthStatus"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsAppHealthOSVersionPerformance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsAppHealthOSVersionPerformance";
    }

    @JsonProperty("activeDeviceCount")
    protected Integer activeDeviceCount;

    @JsonProperty("meanTimeToFailureInMinutes")
    protected Integer meanTimeToFailureInMinutes;

    @JsonProperty("osBuildNumber")
    protected String osBuildNumber;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("osVersionAppHealthScore")
    protected Double osVersionAppHealthScore;

    @JsonProperty("osVersionAppHealthStatus")
    protected String osVersionAppHealthStatus;

    protected UserExperienceAnalyticsAppHealthOSVersionPerformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsAppHealthOSVersionPerformance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer activeDeviceCount;
        private Integer meanTimeToFailureInMinutes;
        private String osBuildNumber;
        private String osVersion;
        private Double osVersionAppHealthScore;
        private String osVersionAppHealthStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The number of active devices for the OS version. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param activeDeviceCount
         *            value of {@code activeDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeDeviceCount(Integer activeDeviceCount) {
            this.activeDeviceCount = activeDeviceCount;
            this.changedFields = changedFields.add("activeDeviceCount");
            return this;
        }

        /**
         * <i>“The mean time to failure for the OS version in minutes. Valid values -2147483648
         * to 2147483647”</i>
         * 
         * @param meanTimeToFailureInMinutes
         *            value of {@code meanTimeToFailureInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder meanTimeToFailureInMinutes(Integer meanTimeToFailureInMinutes) {
            this.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
            this.changedFields = changedFields.add("meanTimeToFailureInMinutes");
            return this;
        }

        /**
         * <i>“The OS build number installed on the device.”</i>
         * 
         * @param osBuildNumber
         *            value of {@code osBuildNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osBuildNumber(String osBuildNumber) {
            this.osBuildNumber = osBuildNumber;
            this.changedFields = changedFields.add("osBuildNumber");
            return this;
        }

        /**
         * <i>“The OS version installed on the device.”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        /**
         * <i>“The app health score of the OS version. Valid values -1.79769313486232E+308 to 1
         * .79769313486232E+308”</i>
         * 
         * @param osVersionAppHealthScore
         *            value of {@code osVersionAppHealthScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersionAppHealthScore(Double osVersionAppHealthScore) {
            this.osVersionAppHealthScore = osVersionAppHealthScore;
            this.changedFields = changedFields.add("osVersionAppHealthScore");
            return this;
        }

        /**
         * <i>“The overall app health status of the OS version.”</i>
         * 
         * @param osVersionAppHealthStatus
         *            value of {@code osVersionAppHealthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersionAppHealthStatus(String osVersionAppHealthStatus) {
            this.osVersionAppHealthStatus = osVersionAppHealthStatus;
            this.changedFields = changedFields.add("osVersionAppHealthStatus");
            return this;
        }

        public UserExperienceAnalyticsAppHealthOSVersionPerformance build() {
            UserExperienceAnalyticsAppHealthOSVersionPerformance _x = new UserExperienceAnalyticsAppHealthOSVersionPerformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsAppHealthOSVersionPerformance";
            _x.id = id;
            _x.activeDeviceCount = activeDeviceCount;
            _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
            _x.osBuildNumber = osBuildNumber;
            _x.osVersion = osVersion;
            _x.osVersionAppHealthScore = osVersionAppHealthScore;
            _x.osVersionAppHealthStatus = osVersionAppHealthStatus;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The number of active devices for the OS version. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property activeDeviceCount
     */
    @Property(name="activeDeviceCount")
    @JsonIgnore
    public Optional<Integer> getActiveDeviceCount() {
        return Optional.ofNullable(activeDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of active devices for the OS version. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param activeDeviceCount
     *            new value of {@code activeDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeDeviceCount} field changed
     */
    public UserExperienceAnalyticsAppHealthOSVersionPerformance withActiveDeviceCount(Integer activeDeviceCount) {
        UserExperienceAnalyticsAppHealthOSVersionPerformance _x = _copy();
        _x.changedFields = changedFields.add("activeDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthOSVersionPerformance");
        _x.activeDeviceCount = activeDeviceCount;
        return _x;
    }

    /**
     * <i>“The mean time to failure for the OS version in minutes. Valid values -2147483648
     * to 2147483647”</i>
     * 
     * @return property meanTimeToFailureInMinutes
     */
    @Property(name="meanTimeToFailureInMinutes")
    @JsonIgnore
    public Optional<Integer> getMeanTimeToFailureInMinutes() {
        return Optional.ofNullable(meanTimeToFailureInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * meanTimeToFailureInMinutes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The mean time to failure for the OS version in minutes. Valid values -2147483648
     * to 2147483647”</i>
     * 
     * @param meanTimeToFailureInMinutes
     *            new value of {@code meanTimeToFailureInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code meanTimeToFailureInMinutes} field changed
     */
    public UserExperienceAnalyticsAppHealthOSVersionPerformance withMeanTimeToFailureInMinutes(Integer meanTimeToFailureInMinutes) {
        UserExperienceAnalyticsAppHealthOSVersionPerformance _x = _copy();
        _x.changedFields = changedFields.add("meanTimeToFailureInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthOSVersionPerformance");
        _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
        return _x;
    }

    /**
     * <i>“The OS build number installed on the device.”</i>
     * 
     * @return property osBuildNumber
     */
    @Property(name="osBuildNumber")
    @JsonIgnore
    public Optional<String> getOsBuildNumber() {
        return Optional.ofNullable(osBuildNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osBuildNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The OS build number installed on the device.”</i>
     * 
     * @param osBuildNumber
     *            new value of {@code osBuildNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osBuildNumber} field changed
     */
    public UserExperienceAnalyticsAppHealthOSVersionPerformance withOsBuildNumber(String osBuildNumber) {
        UserExperienceAnalyticsAppHealthOSVersionPerformance _x = _copy();
        _x.changedFields = changedFields.add("osBuildNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthOSVersionPerformance");
        _x.osBuildNumber = osBuildNumber;
        return _x;
    }

    /**
     * <i>“The OS version installed on the device.”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The OS version installed on the device.”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public UserExperienceAnalyticsAppHealthOSVersionPerformance withOsVersion(String osVersion) {
        UserExperienceAnalyticsAppHealthOSVersionPerformance _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthOSVersionPerformance");
        _x.osVersion = osVersion;
        return _x;
    }

    /**
     * <i>“The app health score of the OS version. Valid values -1.79769313486232E+308 to 1
     * .79769313486232E+308”</i>
     * 
     * @return property osVersionAppHealthScore
     */
    @Property(name="osVersionAppHealthScore")
    @JsonIgnore
    public Optional<Double> getOsVersionAppHealthScore() {
        return Optional.ofNullable(osVersionAppHealthScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * osVersionAppHealthScore} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The app health score of the OS version. Valid values -1.79769313486232E+308 to 1
     * .79769313486232E+308”</i>
     * 
     * @param osVersionAppHealthScore
     *            new value of {@code osVersionAppHealthScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersionAppHealthScore} field changed
     */
    public UserExperienceAnalyticsAppHealthOSVersionPerformance withOsVersionAppHealthScore(Double osVersionAppHealthScore) {
        UserExperienceAnalyticsAppHealthOSVersionPerformance _x = _copy();
        _x.changedFields = changedFields.add("osVersionAppHealthScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthOSVersionPerformance");
        _x.osVersionAppHealthScore = osVersionAppHealthScore;
        return _x;
    }

    /**
     * <i>“The overall app health status of the OS version.”</i>
     * 
     * @return property osVersionAppHealthStatus
     */
    @Property(name="osVersionAppHealthStatus")
    @JsonIgnore
    public Optional<String> getOsVersionAppHealthStatus() {
        return Optional.ofNullable(osVersionAppHealthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * osVersionAppHealthStatus} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The overall app health status of the OS version.”</i>
     * 
     * @param osVersionAppHealthStatus
     *            new value of {@code osVersionAppHealthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersionAppHealthStatus} field changed
     */
    public UserExperienceAnalyticsAppHealthOSVersionPerformance withOsVersionAppHealthStatus(String osVersionAppHealthStatus) {
        UserExperienceAnalyticsAppHealthOSVersionPerformance _x = _copy();
        _x.changedFields = changedFields.add("osVersionAppHealthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthOSVersionPerformance");
        _x.osVersionAppHealthStatus = osVersionAppHealthStatus;
        return _x;
    }

    public UserExperienceAnalyticsAppHealthOSVersionPerformance withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsAppHealthOSVersionPerformance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthOSVersionPerformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthOSVersionPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthOSVersionPerformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthOSVersionPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsAppHealthOSVersionPerformance _copy() {
        UserExperienceAnalyticsAppHealthOSVersionPerformance _x = new UserExperienceAnalyticsAppHealthOSVersionPerformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activeDeviceCount = activeDeviceCount;
        _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
        _x.osBuildNumber = osBuildNumber;
        _x.osVersion = osVersion;
        _x.osVersionAppHealthScore = osVersionAppHealthScore;
        _x.osVersionAppHealthStatus = osVersionAppHealthStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsAppHealthOSVersionPerformance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activeDeviceCount=");
        b.append(this.activeDeviceCount);
        b.append(", ");
        b.append("meanTimeToFailureInMinutes=");
        b.append(this.meanTimeToFailureInMinutes);
        b.append(", ");
        b.append("osBuildNumber=");
        b.append(this.osBuildNumber);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("osVersionAppHealthScore=");
        b.append(this.osVersionAppHealthScore);
        b.append(", ");
        b.append("osVersionAppHealthStatus=");
        b.append(this.osVersionAppHealthStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
