package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“The user experience analytics application performance entity contains app
 * performance by app version device id.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appCrashCount", 
    "appDisplayName", 
    "appName", 
    "appPublisher", 
    "appVersion", 
    "deviceDisplayName", 
    "deviceId", 
    "processedDateTime"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId";
    }

    @JsonProperty("appCrashCount")
    protected Integer appCrashCount;

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("appName")
    protected String appName;

    @JsonProperty("appPublisher")
    protected String appPublisher;

    @JsonProperty("appVersion")
    protected String appVersion;

    @JsonProperty("deviceDisplayName")
    protected String deviceDisplayName;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("processedDateTime")
    protected OffsetDateTime processedDateTime;

    protected UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer appCrashCount;
        private String appDisplayName;
        private String appName;
        private String appPublisher;
        private String appVersion;
        private String deviceDisplayName;
        private String deviceId;
        private OffsetDateTime processedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param appCrashCount
         *            value of {@code appCrashCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appCrashCount(Integer appCrashCount) {
            this.appCrashCount = appCrashCount;
            this.changedFields = changedFields.add("appCrashCount");
            return this;
        }

        /**
         * <i>“The friendly name of the application.”</i>
         * 
         * @param appDisplayName
         *            value of {@code appDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        /**
         * <i>“The name of the application.”</i>
         * 
         * @param appName
         *            value of {@code appName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appName(String appName) {
            this.appName = appName;
            this.changedFields = changedFields.add("appName");
            return this;
        }

        /**
         * <i>“The publisher of the application.”</i>
         * 
         * @param appPublisher
         *            value of {@code appPublisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appPublisher(String appPublisher) {
            this.appPublisher = appPublisher;
            this.changedFields = changedFields.add("appPublisher");
            return this;
        }

        /**
         * <i>“The version of the application.”</i>
         * 
         * @param appVersion
         *            value of {@code appVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            this.changedFields = changedFields.add("appVersion");
            return this;
        }

        /**
         * <i>“The name of the device.”</i>
         * 
         * @param deviceDisplayName
         *            value of {@code deviceDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceDisplayName(String deviceDisplayName) {
            this.deviceDisplayName = deviceDisplayName;
            this.changedFields = changedFields.add("deviceDisplayName");
            return this;
        }

        /**
         * <i>“The id of the device.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The date and time when the statistics were last computed.”</i>
         * 
         * @param processedDateTime
         *            value of {@code processedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processedDateTime(OffsetDateTime processedDateTime) {
            this.processedDateTime = processedDateTime;
            this.changedFields = changedFields.add("processedDateTime");
            return this;
        }

        public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId build() {
            UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId";
            _x.id = id;
            _x.appCrashCount = appCrashCount;
            _x.appDisplayName = appDisplayName;
            _x.appName = appName;
            _x.appPublisher = appPublisher;
            _x.appVersion = appVersion;
            _x.deviceDisplayName = deviceDisplayName;
            _x.deviceId = deviceId;
            _x.processedDateTime = processedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property appCrashCount
     */
    @Property(name="appCrashCount")
    @JsonIgnore
    public Optional<Integer> getAppCrashCount() {
        return Optional.ofNullable(appCrashCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appCrashCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param appCrashCount
     *            new value of {@code appCrashCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appCrashCount} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId withAppCrashCount(Integer appCrashCount) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.changedFields = changedFields.add("appCrashCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId");
        _x.appCrashCount = appCrashCount;
        return _x;
    }

    /**
     * <i>“The friendly name of the application.”</i>
     * 
     * @return property appDisplayName
     */
    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The friendly name of the application.”</i>
     * 
     * @param appDisplayName
     *            new value of {@code appDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appDisplayName} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId withAppDisplayName(String appDisplayName) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    /**
     * <i>“The name of the application.”</i>
     * 
     * @return property appName
     */
    @Property(name="appName")
    @JsonIgnore
    public Optional<String> getAppName() {
        return Optional.ofNullable(appName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the application.”</i>
     * 
     * @param appName
     *            new value of {@code appName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appName} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId withAppName(String appName) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.changedFields = changedFields.add("appName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId");
        _x.appName = appName;
        return _x;
    }

    /**
     * <i>“The publisher of the application.”</i>
     * 
     * @return property appPublisher
     */
    @Property(name="appPublisher")
    @JsonIgnore
    public Optional<String> getAppPublisher() {
        return Optional.ofNullable(appPublisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appPublisher}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The publisher of the application.”</i>
     * 
     * @param appPublisher
     *            new value of {@code appPublisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appPublisher} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId withAppPublisher(String appPublisher) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.changedFields = changedFields.add("appPublisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId");
        _x.appPublisher = appPublisher;
        return _x;
    }

    /**
     * <i>“The version of the application.”</i>
     * 
     * @return property appVersion
     */
    @Property(name="appVersion")
    @JsonIgnore
    public Optional<String> getAppVersion() {
        return Optional.ofNullable(appVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The version of the application.”</i>
     * 
     * @param appVersion
     *            new value of {@code appVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appVersion} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId withAppVersion(String appVersion) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.changedFields = changedFields.add("appVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId");
        _x.appVersion = appVersion;
        return _x;
    }

    /**
     * <i>“The name of the device.”</i>
     * 
     * @return property deviceDisplayName
     */
    @Property(name="deviceDisplayName")
    @JsonIgnore
    public Optional<String> getDeviceDisplayName() {
        return Optional.ofNullable(deviceDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceDisplayName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name of the device.”</i>
     * 
     * @param deviceDisplayName
     *            new value of {@code deviceDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceDisplayName} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId withDeviceDisplayName(String deviceDisplayName) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.changedFields = changedFields.add("deviceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId");
        _x.deviceDisplayName = deviceDisplayName;
        return _x;
    }

    /**
     * <i>“The id of the device.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The id of the device.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId withDeviceId(String deviceId) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The date and time when the statistics were last computed.”</i>
     * 
     * @return property processedDateTime
     */
    @Property(name="processedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getProcessedDateTime() {
        return Optional.ofNullable(processedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code processedDateTime
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date and time when the statistics were last computed.”</i>
     * 
     * @param processedDateTime
     *            new value of {@code processedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processedDateTime} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId withProcessedDateTime(OffsetDateTime processedDateTime) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.changedFields = changedFields.add("processedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId");
        _x.processedDateTime = processedDateTime;
        return _x;
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _copy() {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId _x = new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appCrashCount = appCrashCount;
        _x.appDisplayName = appDisplayName;
        _x.appName = appName;
        _x.appPublisher = appPublisher;
        _x.appVersion = appVersion;
        _x.deviceDisplayName = deviceDisplayName;
        _x.deviceId = deviceId;
        _x.processedDateTime = processedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appCrashCount=");
        b.append(this.appCrashCount);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appName=");
        b.append(this.appName);
        b.append(", ");
        b.append("appPublisher=");
        b.append(this.appPublisher);
        b.append(", ");
        b.append("appVersion=");
        b.append(this.appVersion);
        b.append(", ");
        b.append("deviceDisplayName=");
        b.append(this.deviceDisplayName);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("processedDateTime=");
        b.append(this.processedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
