package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.request.ApprovalRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "reason", 
    "approval"})
@JsonInclude(Include.NON_NULL)
public class UserConsentRequest extends Request implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userConsentRequest";
    }

    @JsonProperty("reason")
    protected String reason;

    @JsonProperty("approval")
    protected Approval approval;

    protected UserConsentRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserConsentRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String approvalId;
        private OffsetDateTime completedDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String customData;
        private String status;
        private String reason;
        private Approval approval;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder approvalId(String approvalId) {
            this.approvalId = approvalId;
            this.changedFields = changedFields.add("approvalId");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder customData(String customData) {
            this.customData = customData;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            this.changedFields = changedFields.add("reason");
            return this;
        }

        public Builder approval(Approval approval) {
            this.approval = approval;
            this.changedFields = changedFields.add("approval");
            return this;
        }

        public UserConsentRequest build() {
            UserConsentRequest _x = new UserConsentRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userConsentRequest";
            _x.id = id;
            _x.approvalId = approvalId;
            _x.completedDateTime = completedDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.customData = customData;
            _x.status = status;
            _x.reason = reason;
            _x.approval = approval;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="reason")
    @JsonIgnore
    public Optional<String> getReason() {
        return Optional.ofNullable(reason);
    }

    public UserConsentRequest withReason(String reason) {
        UserConsentRequest _x = _copy();
        _x.changedFields = changedFields.add("reason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userConsentRequest");
        _x.reason = reason;
        return _x;
    }

    public UserConsentRequest withUnmappedField(String name, Object value) {
        UserConsentRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="approval")
    @JsonIgnore
    public ApprovalRequest getApproval() {
        return new ApprovalRequest(contextPath.addSegment("approval"), Optional.ofNullable(approval));
    }

    public UserConsentRequest withApproval(Approval approval) {
        UserConsentRequest _x = _copy();
        _x.changedFields = changedFields.add("approval");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userConsentRequest");
        _x.approval = approval;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserConsentRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserConsentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserConsentRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserConsentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserConsentRequest _copy() {
        UserConsentRequest _x = new UserConsentRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.approvalId = approvalId;
        _x.completedDateTime = completedDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.customData = customData;
        _x.status = status;
        _x.reason = reason;
        _x.approval = approval;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserConsentRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("approvalId=");
        b.append(this.approvalId);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("customData=");
        b.append(this.customData);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("reason=");
        b.append(this.reason);
        b.append(", ");
        b.append("approval=");
        b.append(this.approval);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
