package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.graph.security.entity.Security;
import microsoft.graph.security.entity.request.SecurityEntityRequest;

import odata.msgraph.client.beta.complex.AssignedLicense;
import odata.msgraph.client.beta.complex.AssignedPlan;
import odata.msgraph.client.beta.complex.AttendeeBase;
import odata.msgraph.client.beta.complex.ConvertIdResult;
import odata.msgraph.client.beta.complex.CustomSecurityAttributeValue;
import odata.msgraph.client.beta.complex.DeviceAndAppManagementData;
import odata.msgraph.client.beta.complex.DeviceKey;
import odata.msgraph.client.beta.complex.EmailAddress;
import odata.msgraph.client.beta.complex.EmployeeOrgData;
import odata.msgraph.client.beta.complex.LicenseAssignmentState;
import odata.msgraph.client.beta.complex.LocationConstraint;
import odata.msgraph.client.beta.complex.MailTips;
import odata.msgraph.client.beta.complex.MailboxSettings;
import odata.msgraph.client.beta.complex.ManagedAppDiagnosticStatus;
import odata.msgraph.client.beta.complex.ManagedDeviceSummarizedAppState;
import odata.msgraph.client.beta.complex.MeetingTimeSuggestionsResult;
import odata.msgraph.client.beta.complex.ObjectIdentity;
import odata.msgraph.client.beta.complex.OnPremisesExtensionAttributes;
import odata.msgraph.client.beta.complex.OnPremisesProvisioningError;
import odata.msgraph.client.beta.complex.PasswordProfile;
import odata.msgraph.client.beta.complex.ProvisionedPlan;
import odata.msgraph.client.beta.complex.Reminder;
import odata.msgraph.client.beta.complex.SignInActivity;
import odata.msgraph.client.beta.complex.TimeConstraint;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgreementAcceptanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppConsentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ApprovalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CalendarCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CalendarGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ChatCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceEnrollmentConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LicenseDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MailFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppIntentAndStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NotificationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OAuth2PermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnlineMeetingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProfilePhotoCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ScopedRoleMembershipCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UsageRightCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserActivityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionDeviceRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.request.AuthenticationRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.InferenceClassificationRequest;
import odata.msgraph.client.beta.entity.request.InformationProtectionRequest;
import odata.msgraph.client.beta.entity.request.ItemInsightsRequest;
import odata.msgraph.client.beta.entity.request.OnenoteRequest;
import odata.msgraph.client.beta.entity.request.OutlookUserRequest;
import odata.msgraph.client.beta.entity.request.PlannerUserRequest;
import odata.msgraph.client.beta.entity.request.PresenceRequest;
import odata.msgraph.client.beta.entity.request.ProfilePhotoRequest;
import odata.msgraph.client.beta.entity.request.ProfileRequest;
import odata.msgraph.client.beta.entity.request.TasksRequest;
import odata.msgraph.client.beta.entity.request.TodoRequest;
import odata.msgraph.client.beta.entity.request.UserAnalyticsRequest;
import odata.msgraph.client.beta.entity.request.UserSettingsRequest;
import odata.msgraph.client.beta.entity.request.UserTeamworkRequest;
import odata.msgraph.client.beta.enums.ExchangeIdFormat;
import odata.msgraph.client.beta.enums.MailTipsType;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
 * <p>
 * Supported = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "signInActivity", 
    "accountEnabled", 
    "ageGroup", 
    "assignedLicenses", 
    "assignedPlans", 
    "businessPhones", 
    "city", 
    "companyName", 
    "consentProvidedForMinor", 
    "country", 
    "createdDateTime", 
    "creationType", 
    "customSecurityAttributes", 
    "department", 
    "deviceKeys", 
    "displayName", 
    "employeeHireDate", 
    "employeeId", 
    "employeeOrgData", 
    "employeeType", 
    "externalUserState", 
    "externalUserStateChangeDateTime", 
    "faxNumber", 
    "givenName", 
    "identities", 
    "imAddresses", 
    "infoCatalogs", 
    "isResourceAccount", 
    "jobTitle", 
    "lastPasswordChangeDateTime", 
    "legalAgeGroupClassification", 
    "licenseAssignmentStates", 
    "mail", 
    "mailNickname", 
    "mobilePhone", 
    "officeLocation", 
    "onPremisesDistinguishedName", 
    "onPremisesDomainName", 
    "onPremisesExtensionAttributes", 
    "onPremisesImmutableId", 
    "onPremisesLastSyncDateTime", 
    "onPremisesProvisioningErrors", 
    "onPremisesSamAccountName", 
    "onPremisesSecurityIdentifier", 
    "onPremisesSyncEnabled", 
    "onPremisesUserPrincipalName", 
    "otherMails", 
    "passwordPolicies", 
    "passwordProfile", 
    "postalCode", 
    "preferredDataLocation", 
    "preferredLanguage", 
    "provisionedPlans", 
    "proxyAddresses", 
    "refreshTokensValidFromDateTime", 
    "showInAddressList", 
    "signInSessionsValidFromDateTime", 
    "state", 
    "streetAddress", 
    "surname", 
    "usageLocation", 
    "userPrincipalName", 
    "userType", 
    "mailboxSettings", 
    "deviceEnrollmentLimit", 
    "aboutMe", 
    "birthday", 
    "hireDate", 
    "interests", 
    "mySite", 
    "pastProjects", 
    "preferredName", 
    "responsibilities", 
    "schools", 
    "skills", 
    "analytics", 
    "usageRights", 
    "informationProtection", 
    "appRoleAssignments", 
    "licenseDetails", 
    "scopedRoleMemberOf", 
    "calendar", 
    "calendarGroups", 
    "calendars", 
    "calendarView", 
    "contactFolders", 
    "contacts", 
    "events", 
    "inferenceClassification", 
    "joinedGroups", 
    "mailFolders", 
    "messages", 
    "outlook", 
    "people", 
    "drive", 
    "drives", 
    "extensions", 
    "appConsentRequestsForApproval", 
    "approvals", 
    "pendingAccessReviewInstances", 
    "security", 
    "deviceEnrollmentConfigurations", 
    "managedDevices", 
    "deviceManagementTroubleshootingEvents", 
    "mobileAppIntentAndStates", 
    "mobileAppTroubleshootingEvents", 
    "notifications", 
    "planner", 
    "insights", 
    "settings", 
    "onenote", 
    "photo", 
    "photos", 
    "profile", 
    "activities", 
    "devices", 
    "onlineMeetings", 
    "presence", 
    "authentication", 
    "tasks", 
    "chats", 
    "teamwork", 
    "todo"})
@JsonInclude(Include.NON_NULL)
public class User extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.user";
    }

    @JsonProperty("signInActivity")
    protected SignInActivity signInActivity;

    @JsonProperty("accountEnabled")
    protected Boolean accountEnabled;

    @JsonProperty("ageGroup")
    protected String ageGroup;

    @JsonProperty("assignedLicenses")
    protected List<AssignedLicense> assignedLicenses;

    @JsonProperty("assignedLicenses@nextLink")
    protected String assignedLicensesNextLink;

    @JsonProperty("assignedPlans")
    protected List<AssignedPlan> assignedPlans;

    @JsonProperty("assignedPlans@nextLink")
    protected String assignedPlansNextLink;

    @JsonProperty("businessPhones")
    protected List<String> businessPhones;

    @JsonProperty("businessPhones@nextLink")
    protected String businessPhonesNextLink;

    @JsonProperty("city")
    protected String city;

    @JsonProperty("companyName")
    protected String companyName;

    @JsonProperty("consentProvidedForMinor")
    protected String consentProvidedForMinor;

    @JsonProperty("country")
    protected String country;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("creationType")
    protected String creationType;

    @JsonProperty("customSecurityAttributes")
    protected CustomSecurityAttributeValue customSecurityAttributes;

    @JsonProperty("department")
    protected String department;

    @JsonProperty("deviceKeys")
    protected List<DeviceKey> deviceKeys;

    @JsonProperty("deviceKeys@nextLink")
    protected String deviceKeysNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("employeeHireDate")
    protected OffsetDateTime employeeHireDate;

    @JsonProperty("employeeId")
    protected String employeeId;

    @JsonProperty("employeeOrgData")
    protected EmployeeOrgData employeeOrgData;

    @JsonProperty("employeeType")
    protected String employeeType;

    @JsonProperty("externalUserState")
    protected String externalUserState;

    @JsonProperty("externalUserStateChangeDateTime")
    protected String externalUserStateChangeDateTime;

    @JsonProperty("faxNumber")
    protected String faxNumber;

    @JsonProperty("givenName")
    protected String givenName;

    @JsonProperty("identities")
    protected List<ObjectIdentity> identities;

    @JsonProperty("identities@nextLink")
    protected String identitiesNextLink;

    @JsonProperty("imAddresses")
    protected List<String> imAddresses;

    @JsonProperty("imAddresses@nextLink")
    protected String imAddressesNextLink;

    @JsonProperty("infoCatalogs")
    protected List<String> infoCatalogs;

    @JsonProperty("infoCatalogs@nextLink")
    protected String infoCatalogsNextLink;

    @JsonProperty("isResourceAccount")
    protected Boolean isResourceAccount;

    @JsonProperty("jobTitle")
    protected String jobTitle;

    @JsonProperty("lastPasswordChangeDateTime")
    protected OffsetDateTime lastPasswordChangeDateTime;

    @JsonProperty("legalAgeGroupClassification")
    protected String legalAgeGroupClassification;

    @JsonProperty("licenseAssignmentStates")
    protected List<LicenseAssignmentState> licenseAssignmentStates;

    @JsonProperty("licenseAssignmentStates@nextLink")
    protected String licenseAssignmentStatesNextLink;

    @JsonProperty("mail")
    protected String mail;

    @JsonProperty("mailNickname")
    protected String mailNickname;

    @JsonProperty("mobilePhone")
    protected String mobilePhone;

    @JsonProperty("officeLocation")
    protected String officeLocation;

    @JsonProperty("onPremisesDistinguishedName")
    protected String onPremisesDistinguishedName;

    @JsonProperty("onPremisesDomainName")
    protected String onPremisesDomainName;

    @JsonProperty("onPremisesExtensionAttributes")
    protected OnPremisesExtensionAttributes onPremisesExtensionAttributes;

    @JsonProperty("onPremisesImmutableId")
    protected String onPremisesImmutableId;

    @JsonProperty("onPremisesLastSyncDateTime")
    protected OffsetDateTime onPremisesLastSyncDateTime;

    @JsonProperty("onPremisesProvisioningErrors")
    protected List<OnPremisesProvisioningError> onPremisesProvisioningErrors;

    @JsonProperty("onPremisesProvisioningErrors@nextLink")
    protected String onPremisesProvisioningErrorsNextLink;

    @JsonProperty("onPremisesSamAccountName")
    protected String onPremisesSamAccountName;

    @JsonProperty("onPremisesSecurityIdentifier")
    protected String onPremisesSecurityIdentifier;

    @JsonProperty("onPremisesSyncEnabled")
    protected Boolean onPremisesSyncEnabled;

    @JsonProperty("onPremisesUserPrincipalName")
    protected String onPremisesUserPrincipalName;

    @JsonProperty("otherMails")
    protected List<String> otherMails;

    @JsonProperty("otherMails@nextLink")
    protected String otherMailsNextLink;

    @JsonProperty("passwordPolicies")
    protected String passwordPolicies;

    @JsonProperty("passwordProfile")
    protected PasswordProfile passwordProfile;

    @JsonProperty("postalCode")
    protected String postalCode;

    @JsonProperty("preferredDataLocation")
    protected String preferredDataLocation;

    @JsonProperty("preferredLanguage")
    protected String preferredLanguage;

    @JsonProperty("provisionedPlans")
    protected List<ProvisionedPlan> provisionedPlans;

    @JsonProperty("provisionedPlans@nextLink")
    protected String provisionedPlansNextLink;

    @JsonProperty("proxyAddresses")
    protected List<String> proxyAddresses;

    @JsonProperty("proxyAddresses@nextLink")
    protected String proxyAddressesNextLink;

    @JsonProperty("refreshTokensValidFromDateTime")
    protected OffsetDateTime refreshTokensValidFromDateTime;

    @JsonProperty("showInAddressList")
    protected Boolean showInAddressList;

    @JsonProperty("signInSessionsValidFromDateTime")
    protected OffsetDateTime signInSessionsValidFromDateTime;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("streetAddress")
    protected String streetAddress;

    @JsonProperty("surname")
    protected String surname;

    @JsonProperty("usageLocation")
    protected String usageLocation;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("userType")
    protected String userType;

    @JsonProperty("mailboxSettings")
    protected MailboxSettings mailboxSettings;

    @JsonProperty("deviceEnrollmentLimit")
    protected Integer deviceEnrollmentLimit;

    @JsonProperty("aboutMe")
    protected String aboutMe;

    @JsonProperty("birthday")
    protected OffsetDateTime birthday;

    @JsonProperty("hireDate")
    protected OffsetDateTime hireDate;

    @JsonProperty("interests")
    protected List<String> interests;

    @JsonProperty("interests@nextLink")
    protected String interestsNextLink;

    @JsonProperty("mySite")
    protected String mySite;

    @JsonProperty("pastProjects")
    protected List<String> pastProjects;

    @JsonProperty("pastProjects@nextLink")
    protected String pastProjectsNextLink;

    @JsonProperty("preferredName")
    protected String preferredName;

    @JsonProperty("responsibilities")
    protected List<String> responsibilities;

    @JsonProperty("responsibilities@nextLink")
    protected String responsibilitiesNextLink;

    @JsonProperty("schools")
    protected List<String> schools;

    @JsonProperty("schools@nextLink")
    protected String schoolsNextLink;

    @JsonProperty("skills")
    protected List<String> skills;

    @JsonProperty("skills@nextLink")
    protected String skillsNextLink;

    @JsonProperty("analytics")
    protected UserAnalytics analytics;

    @JsonProperty("usageRights")
    protected List<UsageRight> usageRights;

    @JsonProperty("informationProtection")
    protected InformationProtection informationProtection;

    @JsonProperty("appRoleAssignments")
    protected List<AppRoleAssignment> appRoleAssignments;

    @JsonProperty("licenseDetails")
    protected List<LicenseDetails> licenseDetails;

    @JsonProperty("scopedRoleMemberOf")
    protected List<ScopedRoleMembership> scopedRoleMemberOf;

    @JsonProperty("calendar")
    protected Calendar calendar;

    @JsonProperty("calendarGroups")
    protected List<CalendarGroup> calendarGroups;

    @JsonProperty("calendars")
    protected List<Calendar> calendars;

    @JsonProperty("calendarView")
    protected List<Event> calendarView;

    @JsonProperty("contactFolders")
    protected List<ContactFolder> contactFolders;

    @JsonProperty("contacts")
    protected List<Contact> contacts;

    @JsonProperty("events")
    protected List<Event> events;

    @JsonProperty("inferenceClassification")
    protected InferenceClassification inferenceClassification;

    @JsonProperty("joinedGroups")
    protected List<Group> joinedGroups;

    @JsonProperty("mailFolders")
    protected List<MailFolder> mailFolders;

    @JsonProperty("messages")
    protected List<Message> messages;

    @JsonProperty("outlook")
    protected OutlookUser outlook;

    @JsonProperty("people")
    protected List<Person> people;

    @JsonProperty("drive")
    protected Drive drive;

    @JsonProperty("drives")
    protected List<Drive> drives;

    @JsonProperty("extensions")
    protected List<Extension> extensions;

    @JsonProperty("appConsentRequestsForApproval")
    protected List<AppConsentRequest> appConsentRequestsForApproval;

    @JsonProperty("approvals")
    protected List<Approval> approvals;

    @JsonProperty("pendingAccessReviewInstances")
    protected List<AccessReviewInstance> pendingAccessReviewInstances;

    @JsonProperty("security")
    protected Security security;

    @JsonProperty("deviceEnrollmentConfigurations")
    protected List<DeviceEnrollmentConfiguration> deviceEnrollmentConfigurations;

    @JsonProperty("managedDevices")
    protected List<ManagedDevice> managedDevices;

    @JsonProperty("deviceManagementTroubleshootingEvents")
    protected List<DeviceManagementTroubleshootingEvent> deviceManagementTroubleshootingEvents;

    @JsonProperty("mobileAppIntentAndStates")
    protected List<MobileAppIntentAndState> mobileAppIntentAndStates;

    @JsonProperty("mobileAppTroubleshootingEvents")
    protected List<MobileAppTroubleshootingEvent> mobileAppTroubleshootingEvents;

    @JsonProperty("notifications")
    protected List<Notification> notifications;

    @JsonProperty("planner")
    protected PlannerUser planner;

    @JsonProperty("insights")
    protected ItemInsights insights;

    @JsonProperty("settings")
    protected UserSettings settings;

    @JsonProperty("onenote")
    protected Onenote onenote;

    @JsonProperty("photo")
    protected ProfilePhoto photo;

    @JsonProperty("photos")
    protected List<ProfilePhoto> photos;

    @JsonProperty("profile")
    protected Profile profile;

    @JsonProperty("activities")
    protected List<UserActivity> activities;

    @JsonProperty("devices")
    protected List<Device> devices;

    @JsonProperty("onlineMeetings")
    protected List<OnlineMeeting> onlineMeetings;

    @JsonProperty("presence")
    protected Presence presence;

    @JsonProperty("authentication")
    protected Authentication authentication;

    @JsonProperty("tasks")
    protected Tasks tasks;

    @JsonProperty("chats")
    protected List<Chat> chats;

    @JsonProperty("teamwork")
    protected UserTeamwork teamwork;

    @JsonProperty("todo")
    protected Todo todo;

    protected User() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUser() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private SignInActivity signInActivity;
        private Boolean accountEnabled;
        private String ageGroup;
        private List<AssignedLicense> assignedLicenses;
        private String assignedLicensesNextLink;
        private List<AssignedPlan> assignedPlans;
        private String assignedPlansNextLink;
        private List<String> businessPhones;
        private String businessPhonesNextLink;
        private String city;
        private String companyName;
        private String consentProvidedForMinor;
        private String country;
        private OffsetDateTime createdDateTime;
        private String creationType;
        private CustomSecurityAttributeValue customSecurityAttributes;
        private String department;
        private List<DeviceKey> deviceKeys;
        private String deviceKeysNextLink;
        private String displayName;
        private OffsetDateTime employeeHireDate;
        private String employeeId;
        private EmployeeOrgData employeeOrgData;
        private String employeeType;
        private String externalUserState;
        private String externalUserStateChangeDateTime;
        private String faxNumber;
        private String givenName;
        private List<ObjectIdentity> identities;
        private String identitiesNextLink;
        private List<String> imAddresses;
        private String imAddressesNextLink;
        private List<String> infoCatalogs;
        private String infoCatalogsNextLink;
        private Boolean isResourceAccount;
        private String jobTitle;
        private OffsetDateTime lastPasswordChangeDateTime;
        private String legalAgeGroupClassification;
        private List<LicenseAssignmentState> licenseAssignmentStates;
        private String licenseAssignmentStatesNextLink;
        private String mail;
        private String mailNickname;
        private String mobilePhone;
        private String officeLocation;
        private String onPremisesDistinguishedName;
        private String onPremisesDomainName;
        private OnPremisesExtensionAttributes onPremisesExtensionAttributes;
        private String onPremisesImmutableId;
        private OffsetDateTime onPremisesLastSyncDateTime;
        private List<OnPremisesProvisioningError> onPremisesProvisioningErrors;
        private String onPremisesProvisioningErrorsNextLink;
        private String onPremisesSamAccountName;
        private String onPremisesSecurityIdentifier;
        private Boolean onPremisesSyncEnabled;
        private String onPremisesUserPrincipalName;
        private List<String> otherMails;
        private String otherMailsNextLink;
        private String passwordPolicies;
        private PasswordProfile passwordProfile;
        private String postalCode;
        private String preferredDataLocation;
        private String preferredLanguage;
        private List<ProvisionedPlan> provisionedPlans;
        private String provisionedPlansNextLink;
        private List<String> proxyAddresses;
        private String proxyAddressesNextLink;
        private OffsetDateTime refreshTokensValidFromDateTime;
        private Boolean showInAddressList;
        private OffsetDateTime signInSessionsValidFromDateTime;
        private String state;
        private String streetAddress;
        private String surname;
        private String usageLocation;
        private String userPrincipalName;
        private String userType;
        private MailboxSettings mailboxSettings;
        private Integer deviceEnrollmentLimit;
        private String aboutMe;
        private OffsetDateTime birthday;
        private OffsetDateTime hireDate;
        private List<String> interests;
        private String interestsNextLink;
        private String mySite;
        private List<String> pastProjects;
        private String pastProjectsNextLink;
        private String preferredName;
        private List<String> responsibilities;
        private String responsibilitiesNextLink;
        private List<String> schools;
        private String schoolsNextLink;
        private List<String> skills;
        private String skillsNextLink;
        private UserAnalytics analytics;
        private List<UsageRight> usageRights;
        private InformationProtection informationProtection;
        private List<AppRoleAssignment> appRoleAssignments;
        private List<LicenseDetails> licenseDetails;
        private List<ScopedRoleMembership> scopedRoleMemberOf;
        private Calendar calendar;
        private List<CalendarGroup> calendarGroups;
        private List<Calendar> calendars;
        private List<Event> calendarView;
        private List<ContactFolder> contactFolders;
        private List<Contact> contacts;
        private List<Event> events;
        private InferenceClassification inferenceClassification;
        private List<Group> joinedGroups;
        private List<MailFolder> mailFolders;
        private List<Message> messages;
        private OutlookUser outlook;
        private List<Person> people;
        private Drive drive;
        private List<Drive> drives;
        private List<Extension> extensions;
        private List<AppConsentRequest> appConsentRequestsForApproval;
        private List<Approval> approvals;
        private List<AccessReviewInstance> pendingAccessReviewInstances;
        private Security security;
        private List<DeviceEnrollmentConfiguration> deviceEnrollmentConfigurations;
        private List<ManagedDevice> managedDevices;
        private List<DeviceManagementTroubleshootingEvent> deviceManagementTroubleshootingEvents;
        private List<MobileAppIntentAndState> mobileAppIntentAndStates;
        private List<MobileAppTroubleshootingEvent> mobileAppTroubleshootingEvents;
        private List<Notification> notifications;
        private PlannerUser planner;
        private ItemInsights insights;
        private UserSettings settings;
        private Onenote onenote;
        private ProfilePhoto photo;
        private List<ProfilePhoto> photos;
        private Profile profile;
        private List<UserActivity> activities;
        private List<Device> devices;
        private List<OnlineMeeting> onlineMeetings;
        private Presence presence;
        private Authentication authentication;
        private Tasks tasks;
        private List<Chat> chats;
        private UserTeamwork teamwork;
        private Todo todo;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder signInActivity(SignInActivity signInActivity) {
            this.signInActivity = signInActivity;
            this.changedFields = changedFields.add("signInActivity");
            return this;
        }

        public Builder accountEnabled(Boolean accountEnabled) {
            this.accountEnabled = accountEnabled;
            this.changedFields = changedFields.add("accountEnabled");
            return this;
        }

        public Builder ageGroup(String ageGroup) {
            this.ageGroup = ageGroup;
            this.changedFields = changedFields.add("ageGroup");
            return this;
        }

        public Builder assignedLicenses(List<AssignedLicense> assignedLicenses) {
            this.assignedLicenses = assignedLicenses;
            this.changedFields = changedFields.add("assignedLicenses");
            return this;
        }

        public Builder assignedLicenses(AssignedLicense... assignedLicenses) {
            return assignedLicenses(Arrays.asList(assignedLicenses));
        }

        public Builder assignedLicensesNextLink(String assignedLicensesNextLink) {
            this.assignedLicensesNextLink = assignedLicensesNextLink;
            this.changedFields = changedFields.add("assignedLicenses");
            return this;
        }

        public Builder assignedPlans(List<AssignedPlan> assignedPlans) {
            this.assignedPlans = assignedPlans;
            this.changedFields = changedFields.add("assignedPlans");
            return this;
        }

        public Builder assignedPlans(AssignedPlan... assignedPlans) {
            return assignedPlans(Arrays.asList(assignedPlans));
        }

        public Builder assignedPlansNextLink(String assignedPlansNextLink) {
            this.assignedPlansNextLink = assignedPlansNextLink;
            this.changedFields = changedFields.add("assignedPlans");
            return this;
        }

        public Builder businessPhones(List<String> businessPhones) {
            this.businessPhones = businessPhones;
            this.changedFields = changedFields.add("businessPhones");
            return this;
        }

        public Builder businessPhones(String... businessPhones) {
            return businessPhones(Arrays.asList(businessPhones));
        }

        public Builder businessPhonesNextLink(String businessPhonesNextLink) {
            this.businessPhonesNextLink = businessPhonesNextLink;
            this.changedFields = changedFields.add("businessPhones");
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            this.changedFields = changedFields.add("city");
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = companyName;
            this.changedFields = changedFields.add("companyName");
            return this;
        }

        public Builder consentProvidedForMinor(String consentProvidedForMinor) {
            this.consentProvidedForMinor = consentProvidedForMinor;
            this.changedFields = changedFields.add("consentProvidedForMinor");
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            this.changedFields = changedFields.add("country");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder creationType(String creationType) {
            this.creationType = creationType;
            this.changedFields = changedFields.add("creationType");
            return this;
        }

        public Builder customSecurityAttributes(CustomSecurityAttributeValue customSecurityAttributes) {
            this.customSecurityAttributes = customSecurityAttributes;
            this.changedFields = changedFields.add("customSecurityAttributes");
            return this;
        }

        public Builder department(String department) {
            this.department = department;
            this.changedFields = changedFields.add("department");
            return this;
        }

        public Builder deviceKeys(List<DeviceKey> deviceKeys) {
            this.deviceKeys = deviceKeys;
            this.changedFields = changedFields.add("deviceKeys");
            return this;
        }

        public Builder deviceKeys(DeviceKey... deviceKeys) {
            return deviceKeys(Arrays.asList(deviceKeys));
        }

        public Builder deviceKeysNextLink(String deviceKeysNextLink) {
            this.deviceKeysNextLink = deviceKeysNextLink;
            this.changedFields = changedFields.add("deviceKeys");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder employeeHireDate(OffsetDateTime employeeHireDate) {
            this.employeeHireDate = employeeHireDate;
            this.changedFields = changedFields.add("employeeHireDate");
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = employeeId;
            this.changedFields = changedFields.add("employeeId");
            return this;
        }

        public Builder employeeOrgData(EmployeeOrgData employeeOrgData) {
            this.employeeOrgData = employeeOrgData;
            this.changedFields = changedFields.add("employeeOrgData");
            return this;
        }

        public Builder employeeType(String employeeType) {
            this.employeeType = employeeType;
            this.changedFields = changedFields.add("employeeType");
            return this;
        }

        public Builder externalUserState(String externalUserState) {
            this.externalUserState = externalUserState;
            this.changedFields = changedFields.add("externalUserState");
            return this;
        }

        public Builder externalUserStateChangeDateTime(String externalUserStateChangeDateTime) {
            this.externalUserStateChangeDateTime = externalUserStateChangeDateTime;
            this.changedFields = changedFields.add("externalUserStateChangeDateTime");
            return this;
        }

        public Builder faxNumber(String faxNumber) {
            this.faxNumber = faxNumber;
            this.changedFields = changedFields.add("faxNumber");
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            this.changedFields = changedFields.add("givenName");
            return this;
        }

        public Builder identities(List<ObjectIdentity> identities) {
            this.identities = identities;
            this.changedFields = changedFields.add("identities");
            return this;
        }

        public Builder identities(ObjectIdentity... identities) {
            return identities(Arrays.asList(identities));
        }

        public Builder identitiesNextLink(String identitiesNextLink) {
            this.identitiesNextLink = identitiesNextLink;
            this.changedFields = changedFields.add("identities");
            return this;
        }

        public Builder imAddresses(List<String> imAddresses) {
            this.imAddresses = imAddresses;
            this.changedFields = changedFields.add("imAddresses");
            return this;
        }

        public Builder imAddresses(String... imAddresses) {
            return imAddresses(Arrays.asList(imAddresses));
        }

        public Builder imAddressesNextLink(String imAddressesNextLink) {
            this.imAddressesNextLink = imAddressesNextLink;
            this.changedFields = changedFields.add("imAddresses");
            return this;
        }

        public Builder infoCatalogs(List<String> infoCatalogs) {
            this.infoCatalogs = infoCatalogs;
            this.changedFields = changedFields.add("infoCatalogs");
            return this;
        }

        public Builder infoCatalogs(String... infoCatalogs) {
            return infoCatalogs(Arrays.asList(infoCatalogs));
        }

        public Builder infoCatalogsNextLink(String infoCatalogsNextLink) {
            this.infoCatalogsNextLink = infoCatalogsNextLink;
            this.changedFields = changedFields.add("infoCatalogs");
            return this;
        }

        public Builder isResourceAccount(Boolean isResourceAccount) {
            this.isResourceAccount = isResourceAccount;
            this.changedFields = changedFields.add("isResourceAccount");
            return this;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            this.changedFields = changedFields.add("jobTitle");
            return this;
        }

        public Builder lastPasswordChangeDateTime(OffsetDateTime lastPasswordChangeDateTime) {
            this.lastPasswordChangeDateTime = lastPasswordChangeDateTime;
            this.changedFields = changedFields.add("lastPasswordChangeDateTime");
            return this;
        }

        public Builder legalAgeGroupClassification(String legalAgeGroupClassification) {
            this.legalAgeGroupClassification = legalAgeGroupClassification;
            this.changedFields = changedFields.add("legalAgeGroupClassification");
            return this;
        }

        public Builder licenseAssignmentStates(List<LicenseAssignmentState> licenseAssignmentStates) {
            this.licenseAssignmentStates = licenseAssignmentStates;
            this.changedFields = changedFields.add("licenseAssignmentStates");
            return this;
        }

        public Builder licenseAssignmentStates(LicenseAssignmentState... licenseAssignmentStates) {
            return licenseAssignmentStates(Arrays.asList(licenseAssignmentStates));
        }

        public Builder licenseAssignmentStatesNextLink(String licenseAssignmentStatesNextLink) {
            this.licenseAssignmentStatesNextLink = licenseAssignmentStatesNextLink;
            this.changedFields = changedFields.add("licenseAssignmentStates");
            return this;
        }

        public Builder mail(String mail) {
            this.mail = mail;
            this.changedFields = changedFields.add("mail");
            return this;
        }

        public Builder mailNickname(String mailNickname) {
            this.mailNickname = mailNickname;
            this.changedFields = changedFields.add("mailNickname");
            return this;
        }

        public Builder mobilePhone(String mobilePhone) {
            this.mobilePhone = mobilePhone;
            this.changedFields = changedFields.add("mobilePhone");
            return this;
        }

        public Builder officeLocation(String officeLocation) {
            this.officeLocation = officeLocation;
            this.changedFields = changedFields.add("officeLocation");
            return this;
        }

        public Builder onPremisesDistinguishedName(String onPremisesDistinguishedName) {
            this.onPremisesDistinguishedName = onPremisesDistinguishedName;
            this.changedFields = changedFields.add("onPremisesDistinguishedName");
            return this;
        }

        public Builder onPremisesDomainName(String onPremisesDomainName) {
            this.onPremisesDomainName = onPremisesDomainName;
            this.changedFields = changedFields.add("onPremisesDomainName");
            return this;
        }

        public Builder onPremisesExtensionAttributes(OnPremisesExtensionAttributes onPremisesExtensionAttributes) {
            this.onPremisesExtensionAttributes = onPremisesExtensionAttributes;
            this.changedFields = changedFields.add("onPremisesExtensionAttributes");
            return this;
        }

        public Builder onPremisesImmutableId(String onPremisesImmutableId) {
            this.onPremisesImmutableId = onPremisesImmutableId;
            this.changedFields = changedFields.add("onPremisesImmutableId");
            return this;
        }

        public Builder onPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
            this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            this.changedFields = changedFields.add("onPremisesLastSyncDateTime");
            return this;
        }

        public Builder onPremisesProvisioningErrors(List<OnPremisesProvisioningError> onPremisesProvisioningErrors) {
            this.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
            this.changedFields = changedFields.add("onPremisesProvisioningErrors");
            return this;
        }

        public Builder onPremisesProvisioningErrors(OnPremisesProvisioningError... onPremisesProvisioningErrors) {
            return onPremisesProvisioningErrors(Arrays.asList(onPremisesProvisioningErrors));
        }

        public Builder onPremisesProvisioningErrorsNextLink(String onPremisesProvisioningErrorsNextLink) {
            this.onPremisesProvisioningErrorsNextLink = onPremisesProvisioningErrorsNextLink;
            this.changedFields = changedFields.add("onPremisesProvisioningErrors");
            return this;
        }

        public Builder onPremisesSamAccountName(String onPremisesSamAccountName) {
            this.onPremisesSamAccountName = onPremisesSamAccountName;
            this.changedFields = changedFields.add("onPremisesSamAccountName");
            return this;
        }

        public Builder onPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
            this.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
            this.changedFields = changedFields.add("onPremisesSecurityIdentifier");
            return this;
        }

        public Builder onPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
            this.onPremisesSyncEnabled = onPremisesSyncEnabled;
            this.changedFields = changedFields.add("onPremisesSyncEnabled");
            return this;
        }

        public Builder onPremisesUserPrincipalName(String onPremisesUserPrincipalName) {
            this.onPremisesUserPrincipalName = onPremisesUserPrincipalName;
            this.changedFields = changedFields.add("onPremisesUserPrincipalName");
            return this;
        }

        public Builder otherMails(List<String> otherMails) {
            this.otherMails = otherMails;
            this.changedFields = changedFields.add("otherMails");
            return this;
        }

        public Builder otherMails(String... otherMails) {
            return otherMails(Arrays.asList(otherMails));
        }

        public Builder otherMailsNextLink(String otherMailsNextLink) {
            this.otherMailsNextLink = otherMailsNextLink;
            this.changedFields = changedFields.add("otherMails");
            return this;
        }

        public Builder passwordPolicies(String passwordPolicies) {
            this.passwordPolicies = passwordPolicies;
            this.changedFields = changedFields.add("passwordPolicies");
            return this;
        }

        public Builder passwordProfile(PasswordProfile passwordProfile) {
            this.passwordProfile = passwordProfile;
            this.changedFields = changedFields.add("passwordProfile");
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            this.changedFields = changedFields.add("postalCode");
            return this;
        }

        public Builder preferredDataLocation(String preferredDataLocation) {
            this.preferredDataLocation = preferredDataLocation;
            this.changedFields = changedFields.add("preferredDataLocation");
            return this;
        }

        public Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            this.changedFields = changedFields.add("preferredLanguage");
            return this;
        }

        public Builder provisionedPlans(List<ProvisionedPlan> provisionedPlans) {
            this.provisionedPlans = provisionedPlans;
            this.changedFields = changedFields.add("provisionedPlans");
            return this;
        }

        public Builder provisionedPlans(ProvisionedPlan... provisionedPlans) {
            return provisionedPlans(Arrays.asList(provisionedPlans));
        }

        public Builder provisionedPlansNextLink(String provisionedPlansNextLink) {
            this.provisionedPlansNextLink = provisionedPlansNextLink;
            this.changedFields = changedFields.add("provisionedPlans");
            return this;
        }

        public Builder proxyAddresses(List<String> proxyAddresses) {
            this.proxyAddresses = proxyAddresses;
            this.changedFields = changedFields.add("proxyAddresses");
            return this;
        }

        public Builder proxyAddresses(String... proxyAddresses) {
            return proxyAddresses(Arrays.asList(proxyAddresses));
        }

        public Builder proxyAddressesNextLink(String proxyAddressesNextLink) {
            this.proxyAddressesNextLink = proxyAddressesNextLink;
            this.changedFields = changedFields.add("proxyAddresses");
            return this;
        }

        public Builder refreshTokensValidFromDateTime(OffsetDateTime refreshTokensValidFromDateTime) {
            this.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
            this.changedFields = changedFields.add("refreshTokensValidFromDateTime");
            return this;
        }

        public Builder showInAddressList(Boolean showInAddressList) {
            this.showInAddressList = showInAddressList;
            this.changedFields = changedFields.add("showInAddressList");
            return this;
        }

        public Builder signInSessionsValidFromDateTime(OffsetDateTime signInSessionsValidFromDateTime) {
            this.signInSessionsValidFromDateTime = signInSessionsValidFromDateTime;
            this.changedFields = changedFields.add("signInSessionsValidFromDateTime");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder streetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
            this.changedFields = changedFields.add("streetAddress");
            return this;
        }

        public Builder surname(String surname) {
            this.surname = surname;
            this.changedFields = changedFields.add("surname");
            return this;
        }

        public Builder usageLocation(String usageLocation) {
            this.usageLocation = usageLocation;
            this.changedFields = changedFields.add("usageLocation");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder userType(String userType) {
            this.userType = userType;
            this.changedFields = changedFields.add("userType");
            return this;
        }

        public Builder mailboxSettings(MailboxSettings mailboxSettings) {
            this.mailboxSettings = mailboxSettings;
            this.changedFields = changedFields.add("mailboxSettings");
            return this;
        }

        /**
         * <i>“The limit on the maximum number of devices that the user is permitted to enroll.
         * Allowed values are 5 or 1000.”</i>
         * 
         * @param deviceEnrollmentLimit
         *            value of {@code deviceEnrollmentLimit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceEnrollmentLimit(Integer deviceEnrollmentLimit) {
            this.deviceEnrollmentLimit = deviceEnrollmentLimit;
            this.changedFields = changedFields.add("deviceEnrollmentLimit");
            return this;
        }

        public Builder aboutMe(String aboutMe) {
            this.aboutMe = aboutMe;
            this.changedFields = changedFields.add("aboutMe");
            return this;
        }

        public Builder birthday(OffsetDateTime birthday) {
            this.birthday = birthday;
            this.changedFields = changedFields.add("birthday");
            return this;
        }

        public Builder hireDate(OffsetDateTime hireDate) {
            this.hireDate = hireDate;
            this.changedFields = changedFields.add("hireDate");
            return this;
        }

        public Builder interests(List<String> interests) {
            this.interests = interests;
            this.changedFields = changedFields.add("interests");
            return this;
        }

        public Builder interests(String... interests) {
            return interests(Arrays.asList(interests));
        }

        public Builder interestsNextLink(String interestsNextLink) {
            this.interestsNextLink = interestsNextLink;
            this.changedFields = changedFields.add("interests");
            return this;
        }

        public Builder mySite(String mySite) {
            this.mySite = mySite;
            this.changedFields = changedFields.add("mySite");
            return this;
        }

        public Builder pastProjects(List<String> pastProjects) {
            this.pastProjects = pastProjects;
            this.changedFields = changedFields.add("pastProjects");
            return this;
        }

        public Builder pastProjects(String... pastProjects) {
            return pastProjects(Arrays.asList(pastProjects));
        }

        public Builder pastProjectsNextLink(String pastProjectsNextLink) {
            this.pastProjectsNextLink = pastProjectsNextLink;
            this.changedFields = changedFields.add("pastProjects");
            return this;
        }

        public Builder preferredName(String preferredName) {
            this.preferredName = preferredName;
            this.changedFields = changedFields.add("preferredName");
            return this;
        }

        public Builder responsibilities(List<String> responsibilities) {
            this.responsibilities = responsibilities;
            this.changedFields = changedFields.add("responsibilities");
            return this;
        }

        public Builder responsibilities(String... responsibilities) {
            return responsibilities(Arrays.asList(responsibilities));
        }

        public Builder responsibilitiesNextLink(String responsibilitiesNextLink) {
            this.responsibilitiesNextLink = responsibilitiesNextLink;
            this.changedFields = changedFields.add("responsibilities");
            return this;
        }

        public Builder schools(List<String> schools) {
            this.schools = schools;
            this.changedFields = changedFields.add("schools");
            return this;
        }

        public Builder schools(String... schools) {
            return schools(Arrays.asList(schools));
        }

        public Builder schoolsNextLink(String schoolsNextLink) {
            this.schoolsNextLink = schoolsNextLink;
            this.changedFields = changedFields.add("schools");
            return this;
        }

        public Builder skills(List<String> skills) {
            this.skills = skills;
            this.changedFields = changedFields.add("skills");
            return this;
        }

        public Builder skills(String... skills) {
            return skills(Arrays.asList(skills));
        }

        public Builder skillsNextLink(String skillsNextLink) {
            this.skillsNextLink = skillsNextLink;
            this.changedFields = changedFields.add("skills");
            return this;
        }

        public Builder analytics(UserAnalytics analytics) {
            this.analytics = analytics;
            this.changedFields = changedFields.add("analytics");
            return this;
        }

        public Builder usageRights(List<UsageRight> usageRights) {
            this.usageRights = usageRights;
            this.changedFields = changedFields.add("usageRights");
            return this;
        }

        public Builder usageRights(UsageRight... usageRights) {
            return usageRights(Arrays.asList(usageRights));
        }

        public Builder informationProtection(InformationProtection informationProtection) {
            this.informationProtection = informationProtection;
            this.changedFields = changedFields.add("informationProtection");
            return this;
        }

        public Builder appRoleAssignments(List<AppRoleAssignment> appRoleAssignments) {
            this.appRoleAssignments = appRoleAssignments;
            this.changedFields = changedFields.add("appRoleAssignments");
            return this;
        }

        public Builder appRoleAssignments(AppRoleAssignment... appRoleAssignments) {
            return appRoleAssignments(Arrays.asList(appRoleAssignments));
        }

        public Builder licenseDetails(List<LicenseDetails> licenseDetails) {
            this.licenseDetails = licenseDetails;
            this.changedFields = changedFields.add("licenseDetails");
            return this;
        }

        public Builder licenseDetails(LicenseDetails... licenseDetails) {
            return licenseDetails(Arrays.asList(licenseDetails));
        }

        public Builder scopedRoleMemberOf(List<ScopedRoleMembership> scopedRoleMemberOf) {
            this.scopedRoleMemberOf = scopedRoleMemberOf;
            this.changedFields = changedFields.add("scopedRoleMemberOf");
            return this;
        }

        public Builder scopedRoleMemberOf(ScopedRoleMembership... scopedRoleMemberOf) {
            return scopedRoleMemberOf(Arrays.asList(scopedRoleMemberOf));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param calendar
         *            value of {@code calendar} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendar(Calendar calendar) {
            this.calendar = calendar;
            this.changedFields = changedFields.add("calendar");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param calendarGroups
         *            value of {@code calendarGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendarGroups(List<CalendarGroup> calendarGroups) {
            this.calendarGroups = calendarGroups;
            this.changedFields = changedFields.add("calendarGroups");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param calendarGroups
         *            value of {@code calendarGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendarGroups(CalendarGroup... calendarGroups) {
            return calendarGroups(Arrays.asList(calendarGroups));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param calendars
         *            value of {@code calendars} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendars(List<Calendar> calendars) {
            this.calendars = calendars;
            this.changedFields = changedFields.add("calendars");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param calendars
         *            value of {@code calendars} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendars(Calendar... calendars) {
            return calendars(Arrays.asList(calendars));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param calendarView
         *            value of {@code calendarView} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendarView(List<Event> calendarView) {
            this.calendarView = calendarView;
            this.changedFields = changedFields.add("calendarView");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param calendarView
         *            value of {@code calendarView} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendarView(Event... calendarView) {
            return calendarView(Arrays.asList(calendarView));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param contactFolders
         *            value of {@code contactFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contactFolders(List<ContactFolder> contactFolders) {
            this.contactFolders = contactFolders;
            this.changedFields = changedFields.add("contactFolders");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param contactFolders
         *            value of {@code contactFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contactFolders(ContactFolder... contactFolders) {
            return contactFolders(Arrays.asList(contactFolders));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * 
         * @param contacts
         *            value of {@code contacts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contacts(List<Contact> contacts) {
            this.contacts = contacts;
            this.changedFields = changedFields.add("contacts");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * 
         * @param contacts
         *            value of {@code contacts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contacts(Contact... contacts) {
            return contacts(Arrays.asList(contacts));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param events
         *            value of {@code events} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder events(List<Event> events) {
            this.events = events;
            this.changedFields = changedFields.add("events");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param events
         *            value of {@code events} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder events(Event... events) {
            return events(Arrays.asList(events));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param inferenceClassification
         *            value of {@code inferenceClassification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inferenceClassification(InferenceClassification inferenceClassification) {
            this.inferenceClassification = inferenceClassification;
            this.changedFields = changedFields.add("inferenceClassification");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param joinedGroups
         *            value of {@code joinedGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder joinedGroups(List<Group> joinedGroups) {
            this.joinedGroups = joinedGroups;
            this.changedFields = changedFields.add("joinedGroups");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param joinedGroups
         *            value of {@code joinedGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder joinedGroups(Group... joinedGroups) {
            return joinedGroups(Arrays.asList(joinedGroups));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param mailFolders
         *            value of {@code mailFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mailFolders(List<MailFolder> mailFolders) {
            this.mailFolders = mailFolders;
            this.changedFields = changedFields.add("mailFolders");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param mailFolders
         *            value of {@code mailFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mailFolders(MailFolder... mailFolders) {
            return mailFolders(Arrays.asList(mailFolders));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * 
         * @param messages
         *            value of {@code messages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messages(List<Message> messages) {
            this.messages = messages;
            this.changedFields = changedFields.add("messages");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * 
         * @param messages
         *            value of {@code messages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messages(Message... messages) {
            return messages(Arrays.asList(messages));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param outlook
         *            value of {@code outlook} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder outlook(OutlookUser outlook) {
            this.outlook = outlook;
            this.changedFields = changedFields.add("outlook");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param people
         *            value of {@code people} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder people(List<Person> people) {
            this.people = people;
            this.changedFields = changedFields.add("people");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param people
         *            value of {@code people} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder people(Person... people) {
            return people(Arrays.asList(people));
        }

        public Builder drive(Drive drive) {
            this.drive = drive;
            this.changedFields = changedFields.add("drive");
            return this;
        }

        public Builder drives(List<Drive> drives) {
            this.drives = drives;
            this.changedFields = changedFields.add("drives");
            return this;
        }

        public Builder drives(Drive... drives) {
            return drives(Arrays.asList(drives));
        }

        public Builder extensions(List<Extension> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        public Builder extensions(Extension... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        public Builder appConsentRequestsForApproval(List<AppConsentRequest> appConsentRequestsForApproval) {
            this.appConsentRequestsForApproval = appConsentRequestsForApproval;
            this.changedFields = changedFields.add("appConsentRequestsForApproval");
            return this;
        }

        public Builder appConsentRequestsForApproval(AppConsentRequest... appConsentRequestsForApproval) {
            return appConsentRequestsForApproval(Arrays.asList(appConsentRequestsForApproval));
        }

        public Builder approvals(List<Approval> approvals) {
            this.approvals = approvals;
            this.changedFields = changedFields.add("approvals");
            return this;
        }

        public Builder approvals(Approval... approvals) {
            return approvals(Arrays.asList(approvals));
        }

        public Builder pendingAccessReviewInstances(List<AccessReviewInstance> pendingAccessReviewInstances) {
            this.pendingAccessReviewInstances = pendingAccessReviewInstances;
            this.changedFields = changedFields.add("pendingAccessReviewInstances");
            return this;
        }

        public Builder pendingAccessReviewInstances(AccessReviewInstance... pendingAccessReviewInstances) {
            return pendingAccessReviewInstances(Arrays.asList(pendingAccessReviewInstances));
        }

        public Builder security(Security security) {
            this.security = security;
            this.changedFields = changedFields.add("security");
            return this;
        }

        /**
         * <i>“Get enrollment configurations targeted to the user”</i>
         * 
         * @param deviceEnrollmentConfigurations
         *            value of {@code deviceEnrollmentConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceEnrollmentConfigurations(List<DeviceEnrollmentConfiguration> deviceEnrollmentConfigurations) {
            this.deviceEnrollmentConfigurations = deviceEnrollmentConfigurations;
            this.changedFields = changedFields.add("deviceEnrollmentConfigurations");
            return this;
        }

        /**
         * <i>“Get enrollment configurations targeted to the user”</i>
         * 
         * @param deviceEnrollmentConfigurations
         *            value of {@code deviceEnrollmentConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceEnrollmentConfigurations(DeviceEnrollmentConfiguration... deviceEnrollmentConfigurations) {
            return deviceEnrollmentConfigurations(Arrays.asList(deviceEnrollmentConfigurations));
        }

        /**
         * <i>“The managed devices associated with the user.”</i>
         * 
         * @param managedDevices
         *            value of {@code managedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDevices(List<ManagedDevice> managedDevices) {
            this.managedDevices = managedDevices;
            this.changedFields = changedFields.add("managedDevices");
            return this;
        }

        /**
         * <i>“The managed devices associated with the user.”</i>
         * 
         * @param managedDevices
         *            value of {@code managedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDevices(ManagedDevice... managedDevices) {
            return managedDevices(Arrays.asList(managedDevices));
        }

        /**
         * <i>“The list of troubleshooting events for this user.”</i>
         * 
         * @param deviceManagementTroubleshootingEvents
         *            value of {@code deviceManagementTroubleshootingEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManagementTroubleshootingEvents(List<DeviceManagementTroubleshootingEvent> deviceManagementTroubleshootingEvents) {
            this.deviceManagementTroubleshootingEvents = deviceManagementTroubleshootingEvents;
            this.changedFields = changedFields.add("deviceManagementTroubleshootingEvents");
            return this;
        }

        /**
         * <i>“The list of troubleshooting events for this user.”</i>
         * 
         * @param deviceManagementTroubleshootingEvents
         *            value of {@code deviceManagementTroubleshootingEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManagementTroubleshootingEvents(DeviceManagementTroubleshootingEvent... deviceManagementTroubleshootingEvents) {
            return deviceManagementTroubleshootingEvents(Arrays.asList(deviceManagementTroubleshootingEvents));
        }

        /**
         * <i>“The list of troubleshooting events for this user.”</i>
         * 
         * @param mobileAppIntentAndStates
         *            value of {@code mobileAppIntentAndStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppIntentAndStates(List<MobileAppIntentAndState> mobileAppIntentAndStates) {
            this.mobileAppIntentAndStates = mobileAppIntentAndStates;
            this.changedFields = changedFields.add("mobileAppIntentAndStates");
            return this;
        }

        /**
         * <i>“The list of troubleshooting events for this user.”</i>
         * 
         * @param mobileAppIntentAndStates
         *            value of {@code mobileAppIntentAndStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppIntentAndStates(MobileAppIntentAndState... mobileAppIntentAndStates) {
            return mobileAppIntentAndStates(Arrays.asList(mobileAppIntentAndStates));
        }

        /**
         * <i>“The list of mobile app troubleshooting events for this user.”</i>
         * 
         * @param mobileAppTroubleshootingEvents
         *            value of {@code mobileAppTroubleshootingEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppTroubleshootingEvents(List<MobileAppTroubleshootingEvent> mobileAppTroubleshootingEvents) {
            this.mobileAppTroubleshootingEvents = mobileAppTroubleshootingEvents;
            this.changedFields = changedFields.add("mobileAppTroubleshootingEvents");
            return this;
        }

        /**
         * <i>“The list of mobile app troubleshooting events for this user.”</i>
         * 
         * @param mobileAppTroubleshootingEvents
         *            value of {@code mobileAppTroubleshootingEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppTroubleshootingEvents(MobileAppTroubleshootingEvent... mobileAppTroubleshootingEvents) {
            return mobileAppTroubleshootingEvents(Arrays.asList(mobileAppTroubleshootingEvents));
        }

        public Builder notifications(List<Notification> notifications) {
            this.notifications = notifications;
            this.changedFields = changedFields.add("notifications");
            return this;
        }

        public Builder notifications(Notification... notifications) {
            return notifications(Arrays.asList(notifications));
        }

        public Builder planner(PlannerUser planner) {
            this.planner = planner;
            this.changedFields = changedFields.add("planner");
            return this;
        }

        public Builder insights(ItemInsights insights) {
            this.insights = insights;
            this.changedFields = changedFields.add("insights");
            return this;
        }

        public Builder settings(UserSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder onenote(Onenote onenote) {
            this.onenote = onenote;
            this.changedFields = changedFields.add("onenote");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param photo
         *            value of {@code photo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder photo(ProfilePhoto photo) {
            this.photo = photo;
            this.changedFields = changedFields.add("photo");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param photos
         *            value of {@code photos} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder photos(List<ProfilePhoto> photos) {
            this.photos = photos;
            this.changedFields = changedFields.add("photos");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param photos
         *            value of {@code photos} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder photos(ProfilePhoto... photos) {
            return photos(Arrays.asList(photos));
        }

        public Builder profile(Profile profile) {
            this.profile = profile;
            this.changedFields = changedFields.add("profile");
            return this;
        }

        public Builder activities(List<UserActivity> activities) {
            this.activities = activities;
            this.changedFields = changedFields.add("activities");
            return this;
        }

        public Builder activities(UserActivity... activities) {
            return activities(Arrays.asList(activities));
        }

        public Builder devices(List<Device> devices) {
            this.devices = devices;
            this.changedFields = changedFields.add("devices");
            return this;
        }

        public Builder devices(Device... devices) {
            return devices(Arrays.asList(devices));
        }

        public Builder onlineMeetings(List<OnlineMeeting> onlineMeetings) {
            this.onlineMeetings = onlineMeetings;
            this.changedFields = changedFields.add("onlineMeetings");
            return this;
        }

        public Builder onlineMeetings(OnlineMeeting... onlineMeetings) {
            return onlineMeetings(Arrays.asList(onlineMeetings));
        }

        public Builder presence(Presence presence) {
            this.presence = presence;
            this.changedFields = changedFields.add("presence");
            return this;
        }

        public Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            this.changedFields = changedFields.add("authentication");
            return this;
        }

        public Builder tasks(Tasks tasks) {
            this.tasks = tasks;
            this.changedFields = changedFields.add("tasks");
            return this;
        }

        public Builder chats(List<Chat> chats) {
            this.chats = chats;
            this.changedFields = changedFields.add("chats");
            return this;
        }

        public Builder chats(Chat... chats) {
            return chats(Arrays.asList(chats));
        }

        public Builder teamwork(UserTeamwork teamwork) {
            this.teamwork = teamwork;
            this.changedFields = changedFields.add("teamwork");
            return this;
        }

        public Builder todo(Todo todo) {
            this.todo = todo;
            this.changedFields = changedFields.add("todo");
            return this;
        }

        public User build() {
            User _x = new User();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.user";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.signInActivity = signInActivity;
            _x.accountEnabled = accountEnabled;
            _x.ageGroup = ageGroup;
            _x.assignedLicenses = assignedLicenses;
            _x.assignedLicensesNextLink = assignedLicensesNextLink;
            _x.assignedPlans = assignedPlans;
            _x.assignedPlansNextLink = assignedPlansNextLink;
            _x.businessPhones = businessPhones;
            _x.businessPhonesNextLink = businessPhonesNextLink;
            _x.city = city;
            _x.companyName = companyName;
            _x.consentProvidedForMinor = consentProvidedForMinor;
            _x.country = country;
            _x.createdDateTime = createdDateTime;
            _x.creationType = creationType;
            _x.customSecurityAttributes = customSecurityAttributes;
            _x.department = department;
            _x.deviceKeys = deviceKeys;
            _x.deviceKeysNextLink = deviceKeysNextLink;
            _x.displayName = displayName;
            _x.employeeHireDate = employeeHireDate;
            _x.employeeId = employeeId;
            _x.employeeOrgData = employeeOrgData;
            _x.employeeType = employeeType;
            _x.externalUserState = externalUserState;
            _x.externalUserStateChangeDateTime = externalUserStateChangeDateTime;
            _x.faxNumber = faxNumber;
            _x.givenName = givenName;
            _x.identities = identities;
            _x.identitiesNextLink = identitiesNextLink;
            _x.imAddresses = imAddresses;
            _x.imAddressesNextLink = imAddressesNextLink;
            _x.infoCatalogs = infoCatalogs;
            _x.infoCatalogsNextLink = infoCatalogsNextLink;
            _x.isResourceAccount = isResourceAccount;
            _x.jobTitle = jobTitle;
            _x.lastPasswordChangeDateTime = lastPasswordChangeDateTime;
            _x.legalAgeGroupClassification = legalAgeGroupClassification;
            _x.licenseAssignmentStates = licenseAssignmentStates;
            _x.licenseAssignmentStatesNextLink = licenseAssignmentStatesNextLink;
            _x.mail = mail;
            _x.mailNickname = mailNickname;
            _x.mobilePhone = mobilePhone;
            _x.officeLocation = officeLocation;
            _x.onPremisesDistinguishedName = onPremisesDistinguishedName;
            _x.onPremisesDomainName = onPremisesDomainName;
            _x.onPremisesExtensionAttributes = onPremisesExtensionAttributes;
            _x.onPremisesImmutableId = onPremisesImmutableId;
            _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            _x.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
            _x.onPremisesProvisioningErrorsNextLink = onPremisesProvisioningErrorsNextLink;
            _x.onPremisesSamAccountName = onPremisesSamAccountName;
            _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
            _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
            _x.onPremisesUserPrincipalName = onPremisesUserPrincipalName;
            _x.otherMails = otherMails;
            _x.otherMailsNextLink = otherMailsNextLink;
            _x.passwordPolicies = passwordPolicies;
            _x.passwordProfile = passwordProfile;
            _x.postalCode = postalCode;
            _x.preferredDataLocation = preferredDataLocation;
            _x.preferredLanguage = preferredLanguage;
            _x.provisionedPlans = provisionedPlans;
            _x.provisionedPlansNextLink = provisionedPlansNextLink;
            _x.proxyAddresses = proxyAddresses;
            _x.proxyAddressesNextLink = proxyAddressesNextLink;
            _x.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
            _x.showInAddressList = showInAddressList;
            _x.signInSessionsValidFromDateTime = signInSessionsValidFromDateTime;
            _x.state = state;
            _x.streetAddress = streetAddress;
            _x.surname = surname;
            _x.usageLocation = usageLocation;
            _x.userPrincipalName = userPrincipalName;
            _x.userType = userType;
            _x.mailboxSettings = mailboxSettings;
            _x.deviceEnrollmentLimit = deviceEnrollmentLimit;
            _x.aboutMe = aboutMe;
            _x.birthday = birthday;
            _x.hireDate = hireDate;
            _x.interests = interests;
            _x.interestsNextLink = interestsNextLink;
            _x.mySite = mySite;
            _x.pastProjects = pastProjects;
            _x.pastProjectsNextLink = pastProjectsNextLink;
            _x.preferredName = preferredName;
            _x.responsibilities = responsibilities;
            _x.responsibilitiesNextLink = responsibilitiesNextLink;
            _x.schools = schools;
            _x.schoolsNextLink = schoolsNextLink;
            _x.skills = skills;
            _x.skillsNextLink = skillsNextLink;
            _x.analytics = analytics;
            _x.usageRights = usageRights;
            _x.informationProtection = informationProtection;
            _x.appRoleAssignments = appRoleAssignments;
            _x.licenseDetails = licenseDetails;
            _x.scopedRoleMemberOf = scopedRoleMemberOf;
            _x.calendar = calendar;
            _x.calendarGroups = calendarGroups;
            _x.calendars = calendars;
            _x.calendarView = calendarView;
            _x.contactFolders = contactFolders;
            _x.contacts = contacts;
            _x.events = events;
            _x.inferenceClassification = inferenceClassification;
            _x.joinedGroups = joinedGroups;
            _x.mailFolders = mailFolders;
            _x.messages = messages;
            _x.outlook = outlook;
            _x.people = people;
            _x.drive = drive;
            _x.drives = drives;
            _x.extensions = extensions;
            _x.appConsentRequestsForApproval = appConsentRequestsForApproval;
            _x.approvals = approvals;
            _x.pendingAccessReviewInstances = pendingAccessReviewInstances;
            _x.security = security;
            _x.deviceEnrollmentConfigurations = deviceEnrollmentConfigurations;
            _x.managedDevices = managedDevices;
            _x.deviceManagementTroubleshootingEvents = deviceManagementTroubleshootingEvents;
            _x.mobileAppIntentAndStates = mobileAppIntentAndStates;
            _x.mobileAppTroubleshootingEvents = mobileAppTroubleshootingEvents;
            _x.notifications = notifications;
            _x.planner = planner;
            _x.insights = insights;
            _x.settings = settings;
            _x.onenote = onenote;
            _x.photo = photo;
            _x.photos = photos;
            _x.profile = profile;
            _x.activities = activities;
            _x.devices = devices;
            _x.onlineMeetings = onlineMeetings;
            _x.presence = presence;
            _x.authentication = authentication;
            _x.tasks = tasks;
            _x.chats = chats;
            _x.teamwork = teamwork;
            _x.todo = todo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="signInActivity")
    @JsonIgnore
    public Optional<SignInActivity> getSignInActivity() {
        return Optional.ofNullable(signInActivity);
    }

    public User withSignInActivity(SignInActivity signInActivity) {
        User _x = _copy();
        _x.changedFields = changedFields.add("signInActivity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.signInActivity = signInActivity;
        return _x;
    }

    @Property(name="accountEnabled")
    @JsonIgnore
    public Optional<Boolean> getAccountEnabled() {
        return Optional.ofNullable(accountEnabled);
    }

    public User withAccountEnabled(Boolean accountEnabled) {
        User _x = _copy();
        _x.changedFields = changedFields.add("accountEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.accountEnabled = accountEnabled;
        return _x;
    }

    @Property(name="ageGroup")
    @JsonIgnore
    public Optional<String> getAgeGroup() {
        return Optional.ofNullable(ageGroup);
    }

    public User withAgeGroup(String ageGroup) {
        User _x = _copy();
        _x.changedFields = changedFields.add("ageGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.ageGroup = ageGroup;
        return _x;
    }

    @Property(name="assignedLicenses")
    @JsonIgnore
    public CollectionPage<AssignedLicense> getAssignedLicenses() {
        return new CollectionPage<AssignedLicense>(contextPath, AssignedLicense.class, this.assignedLicenses, Optional.ofNullable(assignedLicensesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withAssignedLicenses(List<AssignedLicense> assignedLicenses) {
        User _x = _copy();
        _x.changedFields = changedFields.add("assignedLicenses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.assignedLicenses = assignedLicenses;
        return _x;
    }

    @Property(name="assignedLicenses")
    @JsonIgnore
    public CollectionPage<AssignedLicense> getAssignedLicenses(HttpRequestOptions options) {
        return new CollectionPage<AssignedLicense>(contextPath, AssignedLicense.class, this.assignedLicenses, Optional.ofNullable(assignedLicensesNextLink), Collections.emptyList(), options);
    }

    @Property(name="assignedPlans")
    @JsonIgnore
    public CollectionPage<AssignedPlan> getAssignedPlans() {
        return new CollectionPage<AssignedPlan>(contextPath, AssignedPlan.class, this.assignedPlans, Optional.ofNullable(assignedPlansNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withAssignedPlans(List<AssignedPlan> assignedPlans) {
        User _x = _copy();
        _x.changedFields = changedFields.add("assignedPlans");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.assignedPlans = assignedPlans;
        return _x;
    }

    @Property(name="assignedPlans")
    @JsonIgnore
    public CollectionPage<AssignedPlan> getAssignedPlans(HttpRequestOptions options) {
        return new CollectionPage<AssignedPlan>(contextPath, AssignedPlan.class, this.assignedPlans, Optional.ofNullable(assignedPlansNextLink), Collections.emptyList(), options);
    }

    @Property(name="businessPhones")
    @JsonIgnore
    public CollectionPage<String> getBusinessPhones() {
        return new CollectionPage<String>(contextPath, String.class, this.businessPhones, Optional.ofNullable(businessPhonesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withBusinessPhones(List<String> businessPhones) {
        User _x = _copy();
        _x.changedFields = changedFields.add("businessPhones");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.businessPhones = businessPhones;
        return _x;
    }

    @Property(name="businessPhones")
    @JsonIgnore
    public CollectionPage<String> getBusinessPhones(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.businessPhones, Optional.ofNullable(businessPhonesNextLink), Collections.emptyList(), options);
    }

    @Property(name="city")
    @JsonIgnore
    public Optional<String> getCity() {
        return Optional.ofNullable(city);
    }

    public User withCity(String city) {
        User _x = _copy();
        _x.changedFields = changedFields.add("city");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.city = city;
        return _x;
    }

    @Property(name="companyName")
    @JsonIgnore
    public Optional<String> getCompanyName() {
        return Optional.ofNullable(companyName);
    }

    public User withCompanyName(String companyName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("companyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.companyName = companyName;
        return _x;
    }

    @Property(name="consentProvidedForMinor")
    @JsonIgnore
    public Optional<String> getConsentProvidedForMinor() {
        return Optional.ofNullable(consentProvidedForMinor);
    }

    public User withConsentProvidedForMinor(String consentProvidedForMinor) {
        User _x = _copy();
        _x.changedFields = changedFields.add("consentProvidedForMinor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.consentProvidedForMinor = consentProvidedForMinor;
        return _x;
    }

    @Property(name="country")
    @JsonIgnore
    public Optional<String> getCountry() {
        return Optional.ofNullable(country);
    }

    public User withCountry(String country) {
        User _x = _copy();
        _x.changedFields = changedFields.add("country");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.country = country;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public User withCreatedDateTime(OffsetDateTime createdDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="creationType")
    @JsonIgnore
    public Optional<String> getCreationType() {
        return Optional.ofNullable(creationType);
    }

    public User withCreationType(String creationType) {
        User _x = _copy();
        _x.changedFields = changedFields.add("creationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.creationType = creationType;
        return _x;
    }

    @Property(name="customSecurityAttributes")
    @JsonIgnore
    public Optional<CustomSecurityAttributeValue> getCustomSecurityAttributes() {
        return Optional.ofNullable(customSecurityAttributes);
    }

    public User withCustomSecurityAttributes(CustomSecurityAttributeValue customSecurityAttributes) {
        User _x = _copy();
        _x.changedFields = changedFields.add("customSecurityAttributes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.customSecurityAttributes = customSecurityAttributes;
        return _x;
    }

    @Property(name="department")
    @JsonIgnore
    public Optional<String> getDepartment() {
        return Optional.ofNullable(department);
    }

    public User withDepartment(String department) {
        User _x = _copy();
        _x.changedFields = changedFields.add("department");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.department = department;
        return _x;
    }

    @Property(name="deviceKeys")
    @JsonIgnore
    public CollectionPage<DeviceKey> getDeviceKeys() {
        return new CollectionPage<DeviceKey>(contextPath, DeviceKey.class, this.deviceKeys, Optional.ofNullable(deviceKeysNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withDeviceKeys(List<DeviceKey> deviceKeys) {
        User _x = _copy();
        _x.changedFields = changedFields.add("deviceKeys");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.deviceKeys = deviceKeys;
        return _x;
    }

    @Property(name="deviceKeys")
    @JsonIgnore
    public CollectionPage<DeviceKey> getDeviceKeys(HttpRequestOptions options) {
        return new CollectionPage<DeviceKey>(contextPath, DeviceKey.class, this.deviceKeys, Optional.ofNullable(deviceKeysNextLink), Collections.emptyList(), options);
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public User withDisplayName(String displayName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="employeeHireDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEmployeeHireDate() {
        return Optional.ofNullable(employeeHireDate);
    }

    public User withEmployeeHireDate(OffsetDateTime employeeHireDate) {
        User _x = _copy();
        _x.changedFields = changedFields.add("employeeHireDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.employeeHireDate = employeeHireDate;
        return _x;
    }

    @Property(name="employeeId")
    @JsonIgnore
    public Optional<String> getEmployeeId() {
        return Optional.ofNullable(employeeId);
    }

    public User withEmployeeId(String employeeId) {
        User _x = _copy();
        _x.changedFields = changedFields.add("employeeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.employeeId = employeeId;
        return _x;
    }

    @Property(name="employeeOrgData")
    @JsonIgnore
    public Optional<EmployeeOrgData> getEmployeeOrgData() {
        return Optional.ofNullable(employeeOrgData);
    }

    public User withEmployeeOrgData(EmployeeOrgData employeeOrgData) {
        User _x = _copy();
        _x.changedFields = changedFields.add("employeeOrgData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.employeeOrgData = employeeOrgData;
        return _x;
    }

    @Property(name="employeeType")
    @JsonIgnore
    public Optional<String> getEmployeeType() {
        return Optional.ofNullable(employeeType);
    }

    public User withEmployeeType(String employeeType) {
        User _x = _copy();
        _x.changedFields = changedFields.add("employeeType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.employeeType = employeeType;
        return _x;
    }

    @Property(name="externalUserState")
    @JsonIgnore
    public Optional<String> getExternalUserState() {
        return Optional.ofNullable(externalUserState);
    }

    public User withExternalUserState(String externalUserState) {
        User _x = _copy();
        _x.changedFields = changedFields.add("externalUserState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.externalUserState = externalUserState;
        return _x;
    }

    @Property(name="externalUserStateChangeDateTime")
    @JsonIgnore
    public Optional<String> getExternalUserStateChangeDateTime() {
        return Optional.ofNullable(externalUserStateChangeDateTime);
    }

    public User withExternalUserStateChangeDateTime(String externalUserStateChangeDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("externalUserStateChangeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.externalUserStateChangeDateTime = externalUserStateChangeDateTime;
        return _x;
    }

    @Property(name="faxNumber")
    @JsonIgnore
    public Optional<String> getFaxNumber() {
        return Optional.ofNullable(faxNumber);
    }

    public User withFaxNumber(String faxNumber) {
        User _x = _copy();
        _x.changedFields = changedFields.add("faxNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.faxNumber = faxNumber;
        return _x;
    }

    @Property(name="givenName")
    @JsonIgnore
    public Optional<String> getGivenName() {
        return Optional.ofNullable(givenName);
    }

    public User withGivenName(String givenName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("givenName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.givenName = givenName;
        return _x;
    }

    @Property(name="identities")
    @JsonIgnore
    public CollectionPage<ObjectIdentity> getIdentities() {
        return new CollectionPage<ObjectIdentity>(contextPath, ObjectIdentity.class, this.identities, Optional.ofNullable(identitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withIdentities(List<ObjectIdentity> identities) {
        User _x = _copy();
        _x.changedFields = changedFields.add("identities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.identities = identities;
        return _x;
    }

    @Property(name="identities")
    @JsonIgnore
    public CollectionPage<ObjectIdentity> getIdentities(HttpRequestOptions options) {
        return new CollectionPage<ObjectIdentity>(contextPath, ObjectIdentity.class, this.identities, Optional.ofNullable(identitiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="imAddresses")
    @JsonIgnore
    public CollectionPage<String> getImAddresses() {
        return new CollectionPage<String>(contextPath, String.class, this.imAddresses, Optional.ofNullable(imAddressesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withImAddresses(List<String> imAddresses) {
        User _x = _copy();
        _x.changedFields = changedFields.add("imAddresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.imAddresses = imAddresses;
        return _x;
    }

    @Property(name="imAddresses")
    @JsonIgnore
    public CollectionPage<String> getImAddresses(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.imAddresses, Optional.ofNullable(imAddressesNextLink), Collections.emptyList(), options);
    }

    @Property(name="infoCatalogs")
    @JsonIgnore
    public CollectionPage<String> getInfoCatalogs() {
        return new CollectionPage<String>(contextPath, String.class, this.infoCatalogs, Optional.ofNullable(infoCatalogsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withInfoCatalogs(List<String> infoCatalogs) {
        User _x = _copy();
        _x.changedFields = changedFields.add("infoCatalogs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.infoCatalogs = infoCatalogs;
        return _x;
    }

    @Property(name="infoCatalogs")
    @JsonIgnore
    public CollectionPage<String> getInfoCatalogs(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.infoCatalogs, Optional.ofNullable(infoCatalogsNextLink), Collections.emptyList(), options);
    }

    @Property(name="isResourceAccount")
    @JsonIgnore
    public Optional<Boolean> getIsResourceAccount() {
        return Optional.ofNullable(isResourceAccount);
    }

    public User withIsResourceAccount(Boolean isResourceAccount) {
        User _x = _copy();
        _x.changedFields = changedFields.add("isResourceAccount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.isResourceAccount = isResourceAccount;
        return _x;
    }

    @Property(name="jobTitle")
    @JsonIgnore
    public Optional<String> getJobTitle() {
        return Optional.ofNullable(jobTitle);
    }

    public User withJobTitle(String jobTitle) {
        User _x = _copy();
        _x.changedFields = changedFields.add("jobTitle");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.jobTitle = jobTitle;
        return _x;
    }

    @Property(name="lastPasswordChangeDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastPasswordChangeDateTime() {
        return Optional.ofNullable(lastPasswordChangeDateTime);
    }

    public User withLastPasswordChangeDateTime(OffsetDateTime lastPasswordChangeDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("lastPasswordChangeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.lastPasswordChangeDateTime = lastPasswordChangeDateTime;
        return _x;
    }

    @Property(name="legalAgeGroupClassification")
    @JsonIgnore
    public Optional<String> getLegalAgeGroupClassification() {
        return Optional.ofNullable(legalAgeGroupClassification);
    }

    public User withLegalAgeGroupClassification(String legalAgeGroupClassification) {
        User _x = _copy();
        _x.changedFields = changedFields.add("legalAgeGroupClassification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.legalAgeGroupClassification = legalAgeGroupClassification;
        return _x;
    }

    @Property(name="licenseAssignmentStates")
    @JsonIgnore
    public CollectionPage<LicenseAssignmentState> getLicenseAssignmentStates() {
        return new CollectionPage<LicenseAssignmentState>(contextPath, LicenseAssignmentState.class, this.licenseAssignmentStates, Optional.ofNullable(licenseAssignmentStatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withLicenseAssignmentStates(List<LicenseAssignmentState> licenseAssignmentStates) {
        User _x = _copy();
        _x.changedFields = changedFields.add("licenseAssignmentStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.licenseAssignmentStates = licenseAssignmentStates;
        return _x;
    }

    @Property(name="licenseAssignmentStates")
    @JsonIgnore
    public CollectionPage<LicenseAssignmentState> getLicenseAssignmentStates(HttpRequestOptions options) {
        return new CollectionPage<LicenseAssignmentState>(contextPath, LicenseAssignmentState.class, this.licenseAssignmentStates, Optional.ofNullable(licenseAssignmentStatesNextLink), Collections.emptyList(), options);
    }

    @Property(name="mail")
    @JsonIgnore
    public Optional<String> getMail() {
        return Optional.ofNullable(mail);
    }

    public User withMail(String mail) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mail = mail;
        return _x;
    }

    @Property(name="mailNickname")
    @JsonIgnore
    public Optional<String> getMailNickname() {
        return Optional.ofNullable(mailNickname);
    }

    public User withMailNickname(String mailNickname) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mailNickname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mailNickname = mailNickname;
        return _x;
    }

    @Property(name="mobilePhone")
    @JsonIgnore
    public Optional<String> getMobilePhone() {
        return Optional.ofNullable(mobilePhone);
    }

    public User withMobilePhone(String mobilePhone) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mobilePhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mobilePhone = mobilePhone;
        return _x;
    }

    @Property(name="officeLocation")
    @JsonIgnore
    public Optional<String> getOfficeLocation() {
        return Optional.ofNullable(officeLocation);
    }

    public User withOfficeLocation(String officeLocation) {
        User _x = _copy();
        _x.changedFields = changedFields.add("officeLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.officeLocation = officeLocation;
        return _x;
    }

    @Property(name="onPremisesDistinguishedName")
    @JsonIgnore
    public Optional<String> getOnPremisesDistinguishedName() {
        return Optional.ofNullable(onPremisesDistinguishedName);
    }

    public User withOnPremisesDistinguishedName(String onPremisesDistinguishedName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesDistinguishedName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesDistinguishedName = onPremisesDistinguishedName;
        return _x;
    }

    @Property(name="onPremisesDomainName")
    @JsonIgnore
    public Optional<String> getOnPremisesDomainName() {
        return Optional.ofNullable(onPremisesDomainName);
    }

    public User withOnPremisesDomainName(String onPremisesDomainName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesDomainName = onPremisesDomainName;
        return _x;
    }

    @Property(name="onPremisesExtensionAttributes")
    @JsonIgnore
    public Optional<OnPremisesExtensionAttributes> getOnPremisesExtensionAttributes() {
        return Optional.ofNullable(onPremisesExtensionAttributes);
    }

    public User withOnPremisesExtensionAttributes(OnPremisesExtensionAttributes onPremisesExtensionAttributes) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesExtensionAttributes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesExtensionAttributes = onPremisesExtensionAttributes;
        return _x;
    }

    @Property(name="onPremisesImmutableId")
    @JsonIgnore
    public Optional<String> getOnPremisesImmutableId() {
        return Optional.ofNullable(onPremisesImmutableId);
    }

    public User withOnPremisesImmutableId(String onPremisesImmutableId) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesImmutableId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesImmutableId = onPremisesImmutableId;
        return _x;
    }

    @Property(name="onPremisesLastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOnPremisesLastSyncDateTime() {
        return Optional.ofNullable(onPremisesLastSyncDateTime);
    }

    public User withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesLastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return _x;
    }

    @Property(name="onPremisesProvisioningErrors")
    @JsonIgnore
    public CollectionPage<OnPremisesProvisioningError> getOnPremisesProvisioningErrors() {
        return new CollectionPage<OnPremisesProvisioningError>(contextPath, OnPremisesProvisioningError.class, this.onPremisesProvisioningErrors, Optional.ofNullable(onPremisesProvisioningErrorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withOnPremisesProvisioningErrors(List<OnPremisesProvisioningError> onPremisesProvisioningErrors) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesProvisioningErrors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
        return _x;
    }

    @Property(name="onPremisesProvisioningErrors")
    @JsonIgnore
    public CollectionPage<OnPremisesProvisioningError> getOnPremisesProvisioningErrors(HttpRequestOptions options) {
        return new CollectionPage<OnPremisesProvisioningError>(contextPath, OnPremisesProvisioningError.class, this.onPremisesProvisioningErrors, Optional.ofNullable(onPremisesProvisioningErrorsNextLink), Collections.emptyList(), options);
    }

    @Property(name="onPremisesSamAccountName")
    @JsonIgnore
    public Optional<String> getOnPremisesSamAccountName() {
        return Optional.ofNullable(onPremisesSamAccountName);
    }

    public User withOnPremisesSamAccountName(String onPremisesSamAccountName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSamAccountName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesSamAccountName = onPremisesSamAccountName;
        return _x;
    }

    @Property(name="onPremisesSecurityIdentifier")
    @JsonIgnore
    public Optional<String> getOnPremisesSecurityIdentifier() {
        return Optional.ofNullable(onPremisesSecurityIdentifier);
    }

    public User withOnPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSecurityIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        return _x;
    }

    @Property(name="onPremisesSyncEnabled")
    @JsonIgnore
    public Optional<Boolean> getOnPremisesSyncEnabled() {
        return Optional.ofNullable(onPremisesSyncEnabled);
    }

    public User withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSyncEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return _x;
    }

    @Property(name="onPremisesUserPrincipalName")
    @JsonIgnore
    public Optional<String> getOnPremisesUserPrincipalName() {
        return Optional.ofNullable(onPremisesUserPrincipalName);
    }

    public User withOnPremisesUserPrincipalName(String onPremisesUserPrincipalName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesUserPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesUserPrincipalName = onPremisesUserPrincipalName;
        return _x;
    }

    @Property(name="otherMails")
    @JsonIgnore
    public CollectionPage<String> getOtherMails() {
        return new CollectionPage<String>(contextPath, String.class, this.otherMails, Optional.ofNullable(otherMailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withOtherMails(List<String> otherMails) {
        User _x = _copy();
        _x.changedFields = changedFields.add("otherMails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.otherMails = otherMails;
        return _x;
    }

    @Property(name="otherMails")
    @JsonIgnore
    public CollectionPage<String> getOtherMails(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.otherMails, Optional.ofNullable(otherMailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="passwordPolicies")
    @JsonIgnore
    public Optional<String> getPasswordPolicies() {
        return Optional.ofNullable(passwordPolicies);
    }

    public User withPasswordPolicies(String passwordPolicies) {
        User _x = _copy();
        _x.changedFields = changedFields.add("passwordPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.passwordPolicies = passwordPolicies;
        return _x;
    }

    @Property(name="passwordProfile")
    @JsonIgnore
    public Optional<PasswordProfile> getPasswordProfile() {
        return Optional.ofNullable(passwordProfile);
    }

    public User withPasswordProfile(PasswordProfile passwordProfile) {
        User _x = _copy();
        _x.changedFields = changedFields.add("passwordProfile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.passwordProfile = passwordProfile;
        return _x;
    }

    @Property(name="postalCode")
    @JsonIgnore
    public Optional<String> getPostalCode() {
        return Optional.ofNullable(postalCode);
    }

    public User withPostalCode(String postalCode) {
        User _x = _copy();
        _x.changedFields = changedFields.add("postalCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.postalCode = postalCode;
        return _x;
    }

    @Property(name="preferredDataLocation")
    @JsonIgnore
    public Optional<String> getPreferredDataLocation() {
        return Optional.ofNullable(preferredDataLocation);
    }

    public User withPreferredDataLocation(String preferredDataLocation) {
        User _x = _copy();
        _x.changedFields = changedFields.add("preferredDataLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.preferredDataLocation = preferredDataLocation;
        return _x;
    }

    @Property(name="preferredLanguage")
    @JsonIgnore
    public Optional<String> getPreferredLanguage() {
        return Optional.ofNullable(preferredLanguage);
    }

    public User withPreferredLanguage(String preferredLanguage) {
        User _x = _copy();
        _x.changedFields = changedFields.add("preferredLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.preferredLanguage = preferredLanguage;
        return _x;
    }

    @Property(name="provisionedPlans")
    @JsonIgnore
    public CollectionPage<ProvisionedPlan> getProvisionedPlans() {
        return new CollectionPage<ProvisionedPlan>(contextPath, ProvisionedPlan.class, this.provisionedPlans, Optional.ofNullable(provisionedPlansNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withProvisionedPlans(List<ProvisionedPlan> provisionedPlans) {
        User _x = _copy();
        _x.changedFields = changedFields.add("provisionedPlans");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.provisionedPlans = provisionedPlans;
        return _x;
    }

    @Property(name="provisionedPlans")
    @JsonIgnore
    public CollectionPage<ProvisionedPlan> getProvisionedPlans(HttpRequestOptions options) {
        return new CollectionPage<ProvisionedPlan>(contextPath, ProvisionedPlan.class, this.provisionedPlans, Optional.ofNullable(provisionedPlansNextLink), Collections.emptyList(), options);
    }

    @Property(name="proxyAddresses")
    @JsonIgnore
    public CollectionPage<String> getProxyAddresses() {
        return new CollectionPage<String>(contextPath, String.class, this.proxyAddresses, Optional.ofNullable(proxyAddressesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withProxyAddresses(List<String> proxyAddresses) {
        User _x = _copy();
        _x.changedFields = changedFields.add("proxyAddresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.proxyAddresses = proxyAddresses;
        return _x;
    }

    @Property(name="proxyAddresses")
    @JsonIgnore
    public CollectionPage<String> getProxyAddresses(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.proxyAddresses, Optional.ofNullable(proxyAddressesNextLink), Collections.emptyList(), options);
    }

    @Property(name="refreshTokensValidFromDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRefreshTokensValidFromDateTime() {
        return Optional.ofNullable(refreshTokensValidFromDateTime);
    }

    public User withRefreshTokensValidFromDateTime(OffsetDateTime refreshTokensValidFromDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("refreshTokensValidFromDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
        return _x;
    }

    @Property(name="showInAddressList")
    @JsonIgnore
    public Optional<Boolean> getShowInAddressList() {
        return Optional.ofNullable(showInAddressList);
    }

    public User withShowInAddressList(Boolean showInAddressList) {
        User _x = _copy();
        _x.changedFields = changedFields.add("showInAddressList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.showInAddressList = showInAddressList;
        return _x;
    }

    @Property(name="signInSessionsValidFromDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSignInSessionsValidFromDateTime() {
        return Optional.ofNullable(signInSessionsValidFromDateTime);
    }

    public User withSignInSessionsValidFromDateTime(OffsetDateTime signInSessionsValidFromDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("signInSessionsValidFromDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.signInSessionsValidFromDateTime = signInSessionsValidFromDateTime;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public User withState(String state) {
        User _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.state = state;
        return _x;
    }

    @Property(name="streetAddress")
    @JsonIgnore
    public Optional<String> getStreetAddress() {
        return Optional.ofNullable(streetAddress);
    }

    public User withStreetAddress(String streetAddress) {
        User _x = _copy();
        _x.changedFields = changedFields.add("streetAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.streetAddress = streetAddress;
        return _x;
    }

    @Property(name="surname")
    @JsonIgnore
    public Optional<String> getSurname() {
        return Optional.ofNullable(surname);
    }

    public User withSurname(String surname) {
        User _x = _copy();
        _x.changedFields = changedFields.add("surname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.surname = surname;
        return _x;
    }

    @Property(name="usageLocation")
    @JsonIgnore
    public Optional<String> getUsageLocation() {
        return Optional.ofNullable(usageLocation);
    }

    public User withUsageLocation(String usageLocation) {
        User _x = _copy();
        _x.changedFields = changedFields.add("usageLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.usageLocation = usageLocation;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public User withUserPrincipalName(String userPrincipalName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="userType")
    @JsonIgnore
    public Optional<String> getUserType() {
        return Optional.ofNullable(userType);
    }

    public User withUserType(String userType) {
        User _x = _copy();
        _x.changedFields = changedFields.add("userType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.userType = userType;
        return _x;
    }

    @Property(name="mailboxSettings")
    @JsonIgnore
    public Optional<MailboxSettings> getMailboxSettings() {
        return Optional.ofNullable(mailboxSettings);
    }

    public User withMailboxSettings(MailboxSettings mailboxSettings) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mailboxSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mailboxSettings = mailboxSettings;
        return _x;
    }

    /**
     * <i>“The limit on the maximum number of devices that the user is permitted to enroll.
     * Allowed values are 5 or 1000.”</i>
     * 
     * @return property deviceEnrollmentLimit
     */
    @Property(name="deviceEnrollmentLimit")
    @JsonIgnore
    public Optional<Integer> getDeviceEnrollmentLimit() {
        return Optional.ofNullable(deviceEnrollmentLimit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceEnrollmentLimit} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The limit on the maximum number of devices that the user is permitted to enroll.
     * Allowed values are 5 or 1000.”</i>
     * 
     * @param deviceEnrollmentLimit
     *            new value of {@code deviceEnrollmentLimit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceEnrollmentLimit} field changed
     */
    public User withDeviceEnrollmentLimit(Integer deviceEnrollmentLimit) {
        User _x = _copy();
        _x.changedFields = changedFields.add("deviceEnrollmentLimit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.deviceEnrollmentLimit = deviceEnrollmentLimit;
        return _x;
    }

    @Property(name="aboutMe")
    @JsonIgnore
    public Optional<String> getAboutMe() {
        return Optional.ofNullable(aboutMe);
    }

    public User withAboutMe(String aboutMe) {
        User _x = _copy();
        _x.changedFields = changedFields.add("aboutMe");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.aboutMe = aboutMe;
        return _x;
    }

    @Property(name="birthday")
    @JsonIgnore
    public Optional<OffsetDateTime> getBirthday() {
        return Optional.ofNullable(birthday);
    }

    public User withBirthday(OffsetDateTime birthday) {
        User _x = _copy();
        _x.changedFields = changedFields.add("birthday");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.birthday = birthday;
        return _x;
    }

    @Property(name="hireDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getHireDate() {
        return Optional.ofNullable(hireDate);
    }

    public User withHireDate(OffsetDateTime hireDate) {
        User _x = _copy();
        _x.changedFields = changedFields.add("hireDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.hireDate = hireDate;
        return _x;
    }

    @Property(name="interests")
    @JsonIgnore
    public CollectionPage<String> getInterests() {
        return new CollectionPage<String>(contextPath, String.class, this.interests, Optional.ofNullable(interestsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withInterests(List<String> interests) {
        User _x = _copy();
        _x.changedFields = changedFields.add("interests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.interests = interests;
        return _x;
    }

    @Property(name="interests")
    @JsonIgnore
    public CollectionPage<String> getInterests(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.interests, Optional.ofNullable(interestsNextLink), Collections.emptyList(), options);
    }

    @Property(name="mySite")
    @JsonIgnore
    public Optional<String> getMySite() {
        return Optional.ofNullable(mySite);
    }

    public User withMySite(String mySite) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mySite");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mySite = mySite;
        return _x;
    }

    @Property(name="pastProjects")
    @JsonIgnore
    public CollectionPage<String> getPastProjects() {
        return new CollectionPage<String>(contextPath, String.class, this.pastProjects, Optional.ofNullable(pastProjectsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withPastProjects(List<String> pastProjects) {
        User _x = _copy();
        _x.changedFields = changedFields.add("pastProjects");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.pastProjects = pastProjects;
        return _x;
    }

    @Property(name="pastProjects")
    @JsonIgnore
    public CollectionPage<String> getPastProjects(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.pastProjects, Optional.ofNullable(pastProjectsNextLink), Collections.emptyList(), options);
    }

    @Property(name="preferredName")
    @JsonIgnore
    public Optional<String> getPreferredName() {
        return Optional.ofNullable(preferredName);
    }

    public User withPreferredName(String preferredName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("preferredName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.preferredName = preferredName;
        return _x;
    }

    @Property(name="responsibilities")
    @JsonIgnore
    public CollectionPage<String> getResponsibilities() {
        return new CollectionPage<String>(contextPath, String.class, this.responsibilities, Optional.ofNullable(responsibilitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withResponsibilities(List<String> responsibilities) {
        User _x = _copy();
        _x.changedFields = changedFields.add("responsibilities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.responsibilities = responsibilities;
        return _x;
    }

    @Property(name="responsibilities")
    @JsonIgnore
    public CollectionPage<String> getResponsibilities(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.responsibilities, Optional.ofNullable(responsibilitiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="schools")
    @JsonIgnore
    public CollectionPage<String> getSchools() {
        return new CollectionPage<String>(contextPath, String.class, this.schools, Optional.ofNullable(schoolsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withSchools(List<String> schools) {
        User _x = _copy();
        _x.changedFields = changedFields.add("schools");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.schools = schools;
        return _x;
    }

    @Property(name="schools")
    @JsonIgnore
    public CollectionPage<String> getSchools(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.schools, Optional.ofNullable(schoolsNextLink), Collections.emptyList(), options);
    }

    @Property(name="skills")
    @JsonIgnore
    public CollectionPage<String> getSkills() {
        return new CollectionPage<String>(contextPath, String.class, this.skills, Optional.ofNullable(skillsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public User withSkills(List<String> skills) {
        User _x = _copy();
        _x.changedFields = changedFields.add("skills");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.skills = skills;
        return _x;
    }

    @Property(name="skills")
    @JsonIgnore
    public CollectionPage<String> getSkills(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.skills, Optional.ofNullable(skillsNextLink), Collections.emptyList(), options);
    }

    public User withUnmappedField(String name, Object value) {
        User _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="analytics")
    @JsonIgnore
    public UserAnalyticsRequest getAnalytics() {
        return new UserAnalyticsRequest(contextPath.addSegment("analytics"), Optional.ofNullable(analytics));
    }

    @NavigationProperty(name="usageRights")
    @JsonIgnore
    public UsageRightCollectionRequest getUsageRights() {
        return new UsageRightCollectionRequest(
                        contextPath.addSegment("usageRights"), Optional.ofNullable(usageRights));
    }

    @NavigationProperty(name="informationProtection")
    @JsonIgnore
    public InformationProtectionRequest getInformationProtection() {
        return new InformationProtectionRequest(contextPath.addSegment("informationProtection"), Optional.ofNullable(informationProtection));
    }

    @NavigationProperty(name="appRoleAssignments")
    @JsonIgnore
    public AppRoleAssignmentCollectionRequest getAppRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignments"), Optional.ofNullable(appRoleAssignments));
    }

    @NavigationProperty(name="createdObjects")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getCreatedObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("createdObjects"), RequestHelper.getValue(unmappedFields, "createdObjects"));
    }

    @NavigationProperty(name="directReports")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getDirectReports() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("directReports"), RequestHelper.getValue(unmappedFields, "directReports"));
    }

    @NavigationProperty(name="licenseDetails")
    @JsonIgnore
    public LicenseDetailsCollectionRequest getLicenseDetails() {
        return new LicenseDetailsCollectionRequest(
                        contextPath.addSegment("licenseDetails"), Optional.ofNullable(licenseDetails));
    }

    @NavigationProperty(name="manager")
    @JsonIgnore
    public DirectoryObjectRequest getManager() {
        return new DirectoryObjectRequest(contextPath.addSegment("manager"), RequestHelper.getValue(unmappedFields, "manager"));
    }

    @NavigationProperty(name="memberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"), RequestHelper.getValue(unmappedFields, "memberOf"));
    }

    @NavigationProperty(name="oauth2PermissionGrants")
    @JsonIgnore
    public OAuth2PermissionGrantCollectionRequest getOauth2PermissionGrants() {
        return new OAuth2PermissionGrantCollectionRequest(
                        contextPath.addSegment("oauth2PermissionGrants"), RequestHelper.getValue(unmappedFields, "oauth2PermissionGrants"));
    }

    @NavigationProperty(name="ownedDevices")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getOwnedDevices() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedDevices"), RequestHelper.getValue(unmappedFields, "ownedDevices"));
    }

    @NavigationProperty(name="ownedObjects")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getOwnedObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedObjects"), RequestHelper.getValue(unmappedFields, "ownedObjects"));
    }

    @NavigationProperty(name="registeredDevices")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getRegisteredDevices() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("registeredDevices"), RequestHelper.getValue(unmappedFields, "registeredDevices"));
    }

    @NavigationProperty(name="scopedRoleMemberOf")
    @JsonIgnore
    public ScopedRoleMembershipCollectionRequest getScopedRoleMemberOf() {
        return new ScopedRoleMembershipCollectionRequest(
                        contextPath.addSegment("scopedRoleMemberOf"), Optional.ofNullable(scopedRoleMemberOf));
    }

    @NavigationProperty(name="transitiveMemberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getTransitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"), RequestHelper.getValue(unmappedFields, "transitiveMemberOf"));
    }

    @NavigationProperty(name="transitiveReports")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getTransitiveReports() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveReports"), RequestHelper.getValue(unmappedFields, "transitiveReports"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property calendar
     */
    @NavigationProperty(name="calendar")
    @JsonIgnore
    public CalendarRequest getCalendar() {
        return new CalendarRequest(contextPath.addSegment("calendar"), Optional.ofNullable(calendar));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property calendarGroups
     */
    @NavigationProperty(name="calendarGroups")
    @JsonIgnore
    public CalendarGroupCollectionRequest getCalendarGroups() {
        return new CalendarGroupCollectionRequest(
                        contextPath.addSegment("calendarGroups"), Optional.ofNullable(calendarGroups));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property calendars
     */
    @NavigationProperty(name="calendars")
    @JsonIgnore
    public CalendarCollectionRequest getCalendars() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("calendars"), Optional.ofNullable(calendars));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property calendarView
     */
    @NavigationProperty(name="calendarView")
    @JsonIgnore
    public EventCollectionRequest getCalendarView() {
        return new EventCollectionRequest(
                        contextPath.addSegment("calendarView"), Optional.ofNullable(calendarView));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property contactFolders
     */
    @NavigationProperty(name="contactFolders")
    @JsonIgnore
    public ContactFolderCollectionRequest getContactFolders() {
        return new ContactFolderCollectionRequest(
                        contextPath.addSegment("contactFolders"), Optional.ofNullable(contactFolders));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @return navigational property contacts
     */
    @NavigationProperty(name="contacts")
    @JsonIgnore
    public ContactCollectionRequest getContacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contacts"), Optional.ofNullable(contacts));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property events
     */
    @NavigationProperty(name="events")
    @JsonIgnore
    public EventCollectionRequest getEvents() {
        return new EventCollectionRequest(
                        contextPath.addSegment("events"), Optional.ofNullable(events));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property inferenceClassification
     */
    @NavigationProperty(name="inferenceClassification")
    @JsonIgnore
    public InferenceClassificationRequest getInferenceClassification() {
        return new InferenceClassificationRequest(contextPath.addSegment("inferenceClassification"), Optional.ofNullable(inferenceClassification));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property joinedGroups
     */
    @NavigationProperty(name="joinedGroups")
    @JsonIgnore
    public GroupCollectionRequest getJoinedGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("joinedGroups"), Optional.ofNullable(joinedGroups));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property mailFolders
     */
    @NavigationProperty(name="mailFolders")
    @JsonIgnore
    public MailFolderCollectionRequest getMailFolders() {
        return new MailFolderCollectionRequest(
                        contextPath.addSegment("mailFolders"), Optional.ofNullable(mailFolders));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @return navigational property messages
     */
    @NavigationProperty(name="messages")
    @JsonIgnore
    public MessageCollectionRequest getMessages() {
        return new MessageCollectionRequest(
                        contextPath.addSegment("messages"), Optional.ofNullable(messages));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property outlook
     */
    @NavigationProperty(name="outlook")
    @JsonIgnore
    public OutlookUserRequest getOutlook() {
        return new OutlookUserRequest(contextPath.addSegment("outlook"), Optional.ofNullable(outlook));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property people
     */
    @NavigationProperty(name="people")
    @JsonIgnore
    public PersonCollectionRequest getPeople() {
        return new PersonCollectionRequest(
                        contextPath.addSegment("people"), Optional.ofNullable(people));
    }

    @NavigationProperty(name="drive")
    @JsonIgnore
    public DriveRequest getDrive() {
        return new DriveRequest(contextPath.addSegment("drive"), Optional.ofNullable(drive));
    }

    @NavigationProperty(name="drives")
    @JsonIgnore
    public DriveCollectionRequest getDrives() {
        return new DriveCollectionRequest(
                        contextPath.addSegment("drives"), Optional.ofNullable(drives));
    }

    @NavigationProperty(name="followedSites")
    @JsonIgnore
    public SiteCollectionRequest getFollowedSites() {
        return new SiteCollectionRequest(
                        contextPath.addSegment("followedSites"), RequestHelper.getValue(unmappedFields, "followedSites"));
    }

    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.ofNullable(extensions));
    }

    @NavigationProperty(name="appConsentRequestsForApproval")
    @JsonIgnore
    public AppConsentRequestCollectionRequest getAppConsentRequestsForApproval() {
        return new AppConsentRequestCollectionRequest(
                        contextPath.addSegment("appConsentRequestsForApproval"), Optional.ofNullable(appConsentRequestsForApproval));
    }

    @NavigationProperty(name="approvals")
    @JsonIgnore
    public ApprovalCollectionRequest getApprovals() {
        return new ApprovalCollectionRequest(
                        contextPath.addSegment("approvals"), Optional.ofNullable(approvals));
    }

    @NavigationProperty(name="pendingAccessReviewInstances")
    @JsonIgnore
    public AccessReviewInstanceCollectionRequest getPendingAccessReviewInstances() {
        return new AccessReviewInstanceCollectionRequest(
                        contextPath.addSegment("pendingAccessReviewInstances"), Optional.ofNullable(pendingAccessReviewInstances));
    }

    @NavigationProperty(name="agreementAcceptances")
    @JsonIgnore
    public AgreementAcceptanceCollectionRequest getAgreementAcceptances() {
        return new AgreementAcceptanceCollectionRequest(
                        contextPath.addSegment("agreementAcceptances"), RequestHelper.getValue(unmappedFields, "agreementAcceptances"));
    }

    @NavigationProperty(name="security")
    @JsonIgnore
    public SecurityEntityRequest getSecurity() {
        return new SecurityEntityRequest(contextPath.addSegment("security"), Optional.ofNullable(security));
    }

    /**
     * <i>“Get enrollment configurations targeted to the user”</i>
     * 
     * @return navigational property deviceEnrollmentConfigurations
     */
    @NavigationProperty(name="deviceEnrollmentConfigurations")
    @JsonIgnore
    public DeviceEnrollmentConfigurationCollectionRequest getDeviceEnrollmentConfigurations() {
        return new DeviceEnrollmentConfigurationCollectionRequest(
                        contextPath.addSegment("deviceEnrollmentConfigurations"), Optional.ofNullable(deviceEnrollmentConfigurations));
    }

    /**
     * <i>“The managed devices associated with the user.”</i>
     * 
     * @return navigational property managedDevices
     */
    @NavigationProperty(name="managedDevices")
    @JsonIgnore
    public ManagedDeviceCollectionRequest getManagedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"), Optional.ofNullable(managedDevices));
    }

    /**
     * <i>“Zero or more managed app registrations that belong to the user.”</i>
     * 
     * @return navigational property managedAppRegistrations
     */
    @NavigationProperty(name="managedAppRegistrations")
    @JsonIgnore
    public ManagedAppRegistrationCollectionRequest getManagedAppRegistrations() {
        return new ManagedAppRegistrationCollectionRequest(
                        contextPath.addSegment("managedAppRegistrations"), RequestHelper.getValue(unmappedFields, "managedAppRegistrations"));
    }

    /**
     * <i>“Zero or more WIP device registrations that belong to the user.”</i>
     * 
     * @return navigational property windowsInformationProtectionDeviceRegistrations
     */
    @NavigationProperty(name="windowsInformationProtectionDeviceRegistrations")
    @JsonIgnore
    public WindowsInformationProtectionDeviceRegistrationCollectionRequest getWindowsInformationProtectionDeviceRegistrations() {
        return new WindowsInformationProtectionDeviceRegistrationCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionDeviceRegistrations"), RequestHelper.getValue(unmappedFields, "windowsInformationProtectionDeviceRegistrations"));
    }

    /**
     * <i>“The list of troubleshooting events for this user.”</i>
     * 
     * @return navigational property deviceManagementTroubleshootingEvents
     */
    @NavigationProperty(name="deviceManagementTroubleshootingEvents")
    @JsonIgnore
    public DeviceManagementTroubleshootingEventCollectionRequest getDeviceManagementTroubleshootingEvents() {
        return new DeviceManagementTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("deviceManagementTroubleshootingEvents"), Optional.ofNullable(deviceManagementTroubleshootingEvents));
    }

    /**
     * <i>“The list of troubleshooting events for this user.”</i>
     * 
     * @return navigational property mobileAppIntentAndStates
     */
    @NavigationProperty(name="mobileAppIntentAndStates")
    @JsonIgnore
    public MobileAppIntentAndStateCollectionRequest getMobileAppIntentAndStates() {
        return new MobileAppIntentAndStateCollectionRequest(
                        contextPath.addSegment("mobileAppIntentAndStates"), Optional.ofNullable(mobileAppIntentAndStates));
    }

    /**
     * <i>“The list of mobile app troubleshooting events for this user.”</i>
     * 
     * @return navigational property mobileAppTroubleshootingEvents
     */
    @NavigationProperty(name="mobileAppTroubleshootingEvents")
    @JsonIgnore
    public MobileAppTroubleshootingEventCollectionRequest getMobileAppTroubleshootingEvents() {
        return new MobileAppTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("mobileAppTroubleshootingEvents"), Optional.ofNullable(mobileAppTroubleshootingEvents));
    }

    @NavigationProperty(name="notifications")
    @JsonIgnore
    public NotificationCollectionRequest getNotifications() {
        return new NotificationCollectionRequest(
                        contextPath.addSegment("notifications"), Optional.ofNullable(notifications));
    }

    @NavigationProperty(name="planner")
    @JsonIgnore
    public PlannerUserRequest getPlanner() {
        return new PlannerUserRequest(contextPath.addSegment("planner"), Optional.ofNullable(planner));
    }

    @NavigationProperty(name="insights")
    @JsonIgnore
    public ItemInsightsRequest getInsights() {
        return new ItemInsightsRequest(contextPath.addSegment("insights"), Optional.ofNullable(insights));
    }

    @NavigationProperty(name="settings")
    @JsonIgnore
    public UserSettingsRequest getSettings() {
        return new UserSettingsRequest(contextPath.addSegment("settings"), Optional.ofNullable(settings));
    }

    @NavigationProperty(name="onenote")
    @JsonIgnore
    public OnenoteRequest getOnenote() {
        return new OnenoteRequest(contextPath.addSegment("onenote"), Optional.ofNullable(onenote));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property photo
     */
    @NavigationProperty(name="photo")
    @JsonIgnore
    public ProfilePhotoRequest getPhoto() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"), Optional.ofNullable(photo));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property photos
     */
    @NavigationProperty(name="photos")
    @JsonIgnore
    public ProfilePhotoCollectionRequest getPhotos() {
        return new ProfilePhotoCollectionRequest(
                        contextPath.addSegment("photos"), Optional.ofNullable(photos));
    }

    @NavigationProperty(name="profile")
    @JsonIgnore
    public ProfileRequest getProfile() {
        return new ProfileRequest(contextPath.addSegment("profile"), Optional.ofNullable(profile));
    }

    @NavigationProperty(name="activities")
    @JsonIgnore
    public UserActivityCollectionRequest getActivities() {
        return new UserActivityCollectionRequest(
                        contextPath.addSegment("activities"), Optional.ofNullable(activities));
    }

    @NavigationProperty(name="devices")
    @JsonIgnore
    public DeviceCollectionRequest getDevices() {
        return new DeviceCollectionRequest(
                        contextPath.addSegment("devices"), Optional.ofNullable(devices));
    }

    @NavigationProperty(name="onlineMeetings")
    @JsonIgnore
    public OnlineMeetingCollectionRequest getOnlineMeetings() {
        return new OnlineMeetingCollectionRequest(
                        contextPath.addSegment("onlineMeetings"), Optional.ofNullable(onlineMeetings));
    }

    @NavigationProperty(name="presence")
    @JsonIgnore
    public PresenceRequest getPresence() {
        return new PresenceRequest(contextPath.addSegment("presence"), Optional.ofNullable(presence));
    }

    @NavigationProperty(name="authentication")
    @JsonIgnore
    public AuthenticationRequest getAuthentication() {
        return new AuthenticationRequest(contextPath.addSegment("authentication"), Optional.ofNullable(authentication));
    }

    @NavigationProperty(name="tasks")
    @JsonIgnore
    public TasksRequest getTasks() {
        return new TasksRequest(contextPath.addSegment("tasks"), Optional.ofNullable(tasks));
    }

    @NavigationProperty(name="chats")
    @JsonIgnore
    public ChatCollectionRequest getChats() {
        return new ChatCollectionRequest(
                        contextPath.addSegment("chats"), Optional.ofNullable(chats));
    }

    @NavigationProperty(name="joinedTeams")
    @JsonIgnore
    public TeamCollectionRequest getJoinedTeams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("joinedTeams"), RequestHelper.getValue(unmappedFields, "joinedTeams"));
    }

    @NavigationProperty(name="teamwork")
    @JsonIgnore
    public UserTeamworkRequest getTeamwork() {
        return new UserTeamworkRequest(contextPath.addSegment("teamwork"), Optional.ofNullable(teamwork));
    }

    @NavigationProperty(name="todo")
    @JsonIgnore
    public TodoRequest getTodo() {
        return new TodoRequest(contextPath.addSegment("todo"), Optional.ofNullable(todo));
    }

    public User withAnalytics(UserAnalytics analytics) {
        User _x = _copy();
        _x.changedFields = changedFields.add("analytics");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.analytics = analytics;
        return _x;
    }

    public User withUsageRights(List<UsageRight> usageRights) {
        User _x = _copy();
        _x.changedFields = changedFields.add("usageRights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.usageRights = usageRights;
        return _x;
    }

    public User withInformationProtection(InformationProtection informationProtection) {
        User _x = _copy();
        _x.changedFields = changedFields.add("informationProtection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.informationProtection = informationProtection;
        return _x;
    }

    public User withAppRoleAssignments(List<AppRoleAssignment> appRoleAssignments) {
        User _x = _copy();
        _x.changedFields = changedFields.add("appRoleAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.appRoleAssignments = appRoleAssignments;
        return _x;
    }

    public User withLicenseDetails(List<LicenseDetails> licenseDetails) {
        User _x = _copy();
        _x.changedFields = changedFields.add("licenseDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.licenseDetails = licenseDetails;
        return _x;
    }

    public User withScopedRoleMemberOf(List<ScopedRoleMembership> scopedRoleMemberOf) {
        User _x = _copy();
        _x.changedFields = changedFields.add("scopedRoleMemberOf");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.scopedRoleMemberOf = scopedRoleMemberOf;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code calendar} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param calendar
     *            new value of {@code calendar} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code calendar} field changed
     */
    public User withCalendar(Calendar calendar) {
        User _x = _copy();
        _x.changedFields = changedFields.add("calendar");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.calendar = calendar;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code calendarGroups}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param calendarGroups
     *            new value of {@code calendarGroups} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code calendarGroups} field changed
     */
    public User withCalendarGroups(List<CalendarGroup> calendarGroups) {
        User _x = _copy();
        _x.changedFields = changedFields.add("calendarGroups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.calendarGroups = calendarGroups;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code calendars} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param calendars
     *            new value of {@code calendars} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code calendars} field changed
     */
    public User withCalendars(List<Calendar> calendars) {
        User _x = _copy();
        _x.changedFields = changedFields.add("calendars");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.calendars = calendars;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code calendarView}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param calendarView
     *            new value of {@code calendarView} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code calendarView} field changed
     */
    public User withCalendarView(List<Event> calendarView) {
        User _x = _copy();
        _x.changedFields = changedFields.add("calendarView");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.calendarView = calendarView;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code contactFolders}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param contactFolders
     *            new value of {@code contactFolders} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contactFolders} field changed
     */
    public User withContactFolders(List<ContactFolder> contactFolders) {
        User _x = _copy();
        _x.changedFields = changedFields.add("contactFolders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.contactFolders = contactFolders;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code contacts} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @param contacts
     *            new value of {@code contacts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contacts} field changed
     */
    public User withContacts(List<Contact> contacts) {
        User _x = _copy();
        _x.changedFields = changedFields.add("contacts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.contacts = contacts;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code events} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param events
     *            new value of {@code events} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code events} field changed
     */
    public User withEvents(List<Event> events) {
        User _x = _copy();
        _x.changedFields = changedFields.add("events");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.events = events;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inferenceClassification} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param inferenceClassification
     *            new value of {@code inferenceClassification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inferenceClassification} field changed
     */
    public User withInferenceClassification(InferenceClassification inferenceClassification) {
        User _x = _copy();
        _x.changedFields = changedFields.add("inferenceClassification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.inferenceClassification = inferenceClassification;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code joinedGroups}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param joinedGroups
     *            new value of {@code joinedGroups} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code joinedGroups} field changed
     */
    public User withJoinedGroups(List<Group> joinedGroups) {
        User _x = _copy();
        _x.changedFields = changedFields.add("joinedGroups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.joinedGroups = joinedGroups;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mailFolders}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param mailFolders
     *            new value of {@code mailFolders} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mailFolders} field changed
     */
    public User withMailFolders(List<MailFolder> mailFolders) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mailFolders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mailFolders = mailFolders;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code messages} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @param messages
     *            new value of {@code messages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code messages} field changed
     */
    public User withMessages(List<Message> messages) {
        User _x = _copy();
        _x.changedFields = changedFields.add("messages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.messages = messages;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code outlook} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param outlook
     *            new value of {@code outlook} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code outlook} field changed
     */
    public User withOutlook(OutlookUser outlook) {
        User _x = _copy();
        _x.changedFields = changedFields.add("outlook");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.outlook = outlook;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code people} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param people
     *            new value of {@code people} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code people} field changed
     */
    public User withPeople(List<Person> people) {
        User _x = _copy();
        _x.changedFields = changedFields.add("people");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.people = people;
        return _x;
    }

    public User withDrive(Drive drive) {
        User _x = _copy();
        _x.changedFields = changedFields.add("drive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.drive = drive;
        return _x;
    }

    public User withDrives(List<Drive> drives) {
        User _x = _copy();
        _x.changedFields = changedFields.add("drives");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.drives = drives;
        return _x;
    }

    public User withExtensions(List<Extension> extensions) {
        User _x = _copy();
        _x.changedFields = changedFields.add("extensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.extensions = extensions;
        return _x;
    }

    public User withAppConsentRequestsForApproval(List<AppConsentRequest> appConsentRequestsForApproval) {
        User _x = _copy();
        _x.changedFields = changedFields.add("appConsentRequestsForApproval");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.appConsentRequestsForApproval = appConsentRequestsForApproval;
        return _x;
    }

    public User withApprovals(List<Approval> approvals) {
        User _x = _copy();
        _x.changedFields = changedFields.add("approvals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.approvals = approvals;
        return _x;
    }

    public User withPendingAccessReviewInstances(List<AccessReviewInstance> pendingAccessReviewInstances) {
        User _x = _copy();
        _x.changedFields = changedFields.add("pendingAccessReviewInstances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.pendingAccessReviewInstances = pendingAccessReviewInstances;
        return _x;
    }

    public User withSecurity(Security security) {
        User _x = _copy();
        _x.changedFields = changedFields.add("security");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.security = security;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceEnrollmentConfigurations} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Get enrollment configurations targeted to the user”</i>
     * 
     * @param deviceEnrollmentConfigurations
     *            new value of {@code deviceEnrollmentConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceEnrollmentConfigurations} field changed
     */
    public User withDeviceEnrollmentConfigurations(List<DeviceEnrollmentConfiguration> deviceEnrollmentConfigurations) {
        User _x = _copy();
        _x.changedFields = changedFields.add("deviceEnrollmentConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.deviceEnrollmentConfigurations = deviceEnrollmentConfigurations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The managed devices associated with the user.”</i>
     * 
     * @param managedDevices
     *            new value of {@code managedDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDevices} field changed
     */
    public User withManagedDevices(List<ManagedDevice> managedDevices) {
        User _x = _copy();
        _x.changedFields = changedFields.add("managedDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.managedDevices = managedDevices;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementTroubleshootingEvents} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The list of troubleshooting events for this user.”</i>
     * 
     * @param deviceManagementTroubleshootingEvents
     *            new value of {@code deviceManagementTroubleshootingEvents} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementTroubleshootingEvents} field changed
     */
    public User withDeviceManagementTroubleshootingEvents(List<DeviceManagementTroubleshootingEvent> deviceManagementTroubleshootingEvents) {
        User _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementTroubleshootingEvents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.deviceManagementTroubleshootingEvents = deviceManagementTroubleshootingEvents;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileAppIntentAndStates} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of troubleshooting events for this user.”</i>
     * 
     * @param mobileAppIntentAndStates
     *            new value of {@code mobileAppIntentAndStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppIntentAndStates} field changed
     */
    public User withMobileAppIntentAndStates(List<MobileAppIntentAndState> mobileAppIntentAndStates) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mobileAppIntentAndStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mobileAppIntentAndStates = mobileAppIntentAndStates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileAppTroubleshootingEvents} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The list of mobile app troubleshooting events for this user.”</i>
     * 
     * @param mobileAppTroubleshootingEvents
     *            new value of {@code mobileAppTroubleshootingEvents} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppTroubleshootingEvents} field changed
     */
    public User withMobileAppTroubleshootingEvents(List<MobileAppTroubleshootingEvent> mobileAppTroubleshootingEvents) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mobileAppTroubleshootingEvents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mobileAppTroubleshootingEvents = mobileAppTroubleshootingEvents;
        return _x;
    }

    public User withNotifications(List<Notification> notifications) {
        User _x = _copy();
        _x.changedFields = changedFields.add("notifications");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.notifications = notifications;
        return _x;
    }

    public User withPlanner(PlannerUser planner) {
        User _x = _copy();
        _x.changedFields = changedFields.add("planner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.planner = planner;
        return _x;
    }

    public User withInsights(ItemInsights insights) {
        User _x = _copy();
        _x.changedFields = changedFields.add("insights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.insights = insights;
        return _x;
    }

    public User withSettings(UserSettings settings) {
        User _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.settings = settings;
        return _x;
    }

    public User withOnenote(Onenote onenote) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onenote");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onenote = onenote;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code photo} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param photo
     *            new value of {@code photo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code photo} field changed
     */
    public User withPhoto(ProfilePhoto photo) {
        User _x = _copy();
        _x.changedFields = changedFields.add("photo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.photo = photo;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code photos} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param photos
     *            new value of {@code photos} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code photos} field changed
     */
    public User withPhotos(List<ProfilePhoto> photos) {
        User _x = _copy();
        _x.changedFields = changedFields.add("photos");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.photos = photos;
        return _x;
    }

    public User withProfile(Profile profile) {
        User _x = _copy();
        _x.changedFields = changedFields.add("profile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.profile = profile;
        return _x;
    }

    public User withActivities(List<UserActivity> activities) {
        User _x = _copy();
        _x.changedFields = changedFields.add("activities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.activities = activities;
        return _x;
    }

    public User withDevices(List<Device> devices) {
        User _x = _copy();
        _x.changedFields = changedFields.add("devices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.devices = devices;
        return _x;
    }

    public User withOnlineMeetings(List<OnlineMeeting> onlineMeetings) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onlineMeetings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onlineMeetings = onlineMeetings;
        return _x;
    }

    public User withPresence(Presence presence) {
        User _x = _copy();
        _x.changedFields = changedFields.add("presence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.presence = presence;
        return _x;
    }

    public User withAuthentication(Authentication authentication) {
        User _x = _copy();
        _x.changedFields = changedFields.add("authentication");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.authentication = authentication;
        return _x;
    }

    public User withTasks(Tasks tasks) {
        User _x = _copy();
        _x.changedFields = changedFields.add("tasks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.tasks = tasks;
        return _x;
    }

    public User withChats(List<Chat> chats) {
        User _x = _copy();
        _x.changedFields = changedFields.add("chats");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.chats = chats;
        return _x;
    }

    public User withTeamwork(UserTeamwork teamwork) {
        User _x = _copy();
        _x.changedFields = changedFields.add("teamwork");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.teamwork = teamwork;
        return _x;
    }

    public User withTodo(Todo todo) {
        User _x = _copy();
        _x.changedFields = changedFields.add("todo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.todo = todo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public User patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        User _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public User put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        User _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private User _copy() {
        User _x = new User();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.signInActivity = signInActivity;
        _x.accountEnabled = accountEnabled;
        _x.ageGroup = ageGroup;
        _x.assignedLicenses = assignedLicenses;
        _x.assignedPlans = assignedPlans;
        _x.businessPhones = businessPhones;
        _x.city = city;
        _x.companyName = companyName;
        _x.consentProvidedForMinor = consentProvidedForMinor;
        _x.country = country;
        _x.createdDateTime = createdDateTime;
        _x.creationType = creationType;
        _x.customSecurityAttributes = customSecurityAttributes;
        _x.department = department;
        _x.deviceKeys = deviceKeys;
        _x.displayName = displayName;
        _x.employeeHireDate = employeeHireDate;
        _x.employeeId = employeeId;
        _x.employeeOrgData = employeeOrgData;
        _x.employeeType = employeeType;
        _x.externalUserState = externalUserState;
        _x.externalUserStateChangeDateTime = externalUserStateChangeDateTime;
        _x.faxNumber = faxNumber;
        _x.givenName = givenName;
        _x.identities = identities;
        _x.imAddresses = imAddresses;
        _x.infoCatalogs = infoCatalogs;
        _x.isResourceAccount = isResourceAccount;
        _x.jobTitle = jobTitle;
        _x.lastPasswordChangeDateTime = lastPasswordChangeDateTime;
        _x.legalAgeGroupClassification = legalAgeGroupClassification;
        _x.licenseAssignmentStates = licenseAssignmentStates;
        _x.mail = mail;
        _x.mailNickname = mailNickname;
        _x.mobilePhone = mobilePhone;
        _x.officeLocation = officeLocation;
        _x.onPremisesDistinguishedName = onPremisesDistinguishedName;
        _x.onPremisesDomainName = onPremisesDomainName;
        _x.onPremisesExtensionAttributes = onPremisesExtensionAttributes;
        _x.onPremisesImmutableId = onPremisesImmutableId;
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        _x.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
        _x.onPremisesSamAccountName = onPremisesSamAccountName;
        _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        _x.onPremisesUserPrincipalName = onPremisesUserPrincipalName;
        _x.otherMails = otherMails;
        _x.passwordPolicies = passwordPolicies;
        _x.passwordProfile = passwordProfile;
        _x.postalCode = postalCode;
        _x.preferredDataLocation = preferredDataLocation;
        _x.preferredLanguage = preferredLanguage;
        _x.provisionedPlans = provisionedPlans;
        _x.proxyAddresses = proxyAddresses;
        _x.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
        _x.showInAddressList = showInAddressList;
        _x.signInSessionsValidFromDateTime = signInSessionsValidFromDateTime;
        _x.state = state;
        _x.streetAddress = streetAddress;
        _x.surname = surname;
        _x.usageLocation = usageLocation;
        _x.userPrincipalName = userPrincipalName;
        _x.userType = userType;
        _x.mailboxSettings = mailboxSettings;
        _x.deviceEnrollmentLimit = deviceEnrollmentLimit;
        _x.aboutMe = aboutMe;
        _x.birthday = birthday;
        _x.hireDate = hireDate;
        _x.interests = interests;
        _x.mySite = mySite;
        _x.pastProjects = pastProjects;
        _x.preferredName = preferredName;
        _x.responsibilities = responsibilities;
        _x.schools = schools;
        _x.skills = skills;
        _x.analytics = analytics;
        _x.usageRights = usageRights;
        _x.informationProtection = informationProtection;
        _x.appRoleAssignments = appRoleAssignments;
        _x.licenseDetails = licenseDetails;
        _x.scopedRoleMemberOf = scopedRoleMemberOf;
        _x.calendar = calendar;
        _x.calendarGroups = calendarGroups;
        _x.calendars = calendars;
        _x.calendarView = calendarView;
        _x.contactFolders = contactFolders;
        _x.contacts = contacts;
        _x.events = events;
        _x.inferenceClassification = inferenceClassification;
        _x.joinedGroups = joinedGroups;
        _x.mailFolders = mailFolders;
        _x.messages = messages;
        _x.outlook = outlook;
        _x.people = people;
        _x.drive = drive;
        _x.drives = drives;
        _x.extensions = extensions;
        _x.appConsentRequestsForApproval = appConsentRequestsForApproval;
        _x.approvals = approvals;
        _x.pendingAccessReviewInstances = pendingAccessReviewInstances;
        _x.security = security;
        _x.deviceEnrollmentConfigurations = deviceEnrollmentConfigurations;
        _x.managedDevices = managedDevices;
        _x.deviceManagementTroubleshootingEvents = deviceManagementTroubleshootingEvents;
        _x.mobileAppIntentAndStates = mobileAppIntentAndStates;
        _x.mobileAppTroubleshootingEvents = mobileAppTroubleshootingEvents;
        _x.notifications = notifications;
        _x.planner = planner;
        _x.insights = insights;
        _x.settings = settings;
        _x.onenote = onenote;
        _x.photo = photo;
        _x.photos = photos;
        _x.profile = profile;
        _x.activities = activities;
        _x.devices = devices;
        _x.onlineMeetings = onlineMeetings;
        _x.presence = presence;
        _x.authentication = authentication;
        _x.tasks = tasks;
        _x.chats = chats;
        _x.teamwork = teamwork;
        _x.todo = todo;
        return _x;
    }

    @Action(name = "activateServicePlan")
    @JsonIgnore
    public ActionRequestNoReturn activateServicePlan(UUID servicePlanId, UUID skuId) {
        Preconditions.checkNotNull(servicePlanId, "servicePlanId cannot be null");
        Preconditions.checkNotNull(skuId, "skuId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("servicePlanId", "Edm.Guid", servicePlanId)
            .put("skuId", "Edm.Guid", skuId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.activateServicePlan"), _parameters);
    }

    @Action(name = "assignLicense")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<User> assignLicense(List<AssignedLicense> addLicenses, List<UUID> removeLicenses) {
        Preconditions.checkNotNull(addLicenses, "addLicenses cannot be null");
        Preconditions.checkNotNull(removeLicenses, "removeLicenses cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("addLicenses", "Collection(microsoft.graph.assignedLicense)", addLicenses)
            .put("removeLicenses", "Collection(Edm.Guid)", removeLicenses)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<User>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignLicense"), User.class, _parameters);
    }

    @Action(name = "changePassword")
    @JsonIgnore
    public ActionRequestNoReturn changePassword(String currentPassword, String newPassword) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("currentPassword", "Edm.String", Checks.checkIsAscii(currentPassword))
            .put("newPassword", "Edm.String", Checks.checkIsAscii(newPassword))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.changePassword"), _parameters);
    }

    @Action(name = "invalidateAllRefreshTokens")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> invalidateAllRefreshTokens() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.invalidateAllRefreshTokens"), Boolean.class, _parameters);
    }

    @Action(name = "reprocessLicenseAssignment")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<User> reprocessLicenseAssignment() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<User>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reprocessLicenseAssignment"), User.class, _parameters);
    }

    @Action(name = "revokeSignInSessions")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> revokeSignInSessions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeSignInSessions"), Boolean.class, _parameters);
    }

    @Action(name = "findMeetingTimes")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MeetingTimeSuggestionsResult> findMeetingTimes(List<AttendeeBase> attendees, LocationConstraint locationConstraint, TimeConstraint timeConstraint, Duration meetingDuration, Integer maxCandidates, Boolean isOrganizerOptional, Boolean returnSuggestionReasons, Double minimumAttendeePercentage) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("attendees", "Collection(microsoft.graph.attendeeBase)", attendees)
            .put("locationConstraint", "microsoft.graph.locationConstraint", locationConstraint)
            .put("timeConstraint", "microsoft.graph.timeConstraint", timeConstraint)
            .put("meetingDuration", "Edm.Duration", meetingDuration)
            .put("maxCandidates", "Edm.Int32", maxCandidates)
            .put("isOrganizerOptional", "Edm.Boolean", isOrganizerOptional)
            .put("returnSuggestionReasons", "Edm.Boolean", returnSuggestionReasons)
            .put("minimumAttendeePercentage", "Edm.Double", minimumAttendeePercentage)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MeetingTimeSuggestionsResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findMeetingTimes"), MeetingTimeSuggestionsResult.class, _parameters);
    }

    @Action(name = "getMailTips")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MailTips> getMailTips(List<String> emailAddresses, MailTipsType mailTipsOptions) {
        Preconditions.checkNotNull(emailAddresses, "emailAddresses cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EmailAddresses", "Collection(Edm.String)", Checks.checkIsAscii(emailAddresses))
            .put("MailTipsOptions", "microsoft.graph.mailTipsType", mailTipsOptions)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailTips"), MailTips.class, _parameters);
    }

    @Action(name = "sendMail")
    @JsonIgnore
    public ActionRequestNoReturn sendMail(Message message, Boolean saveToSentItems) {
        Preconditions.checkNotNull(message, "message cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("SaveToSentItems", "Edm.Boolean", saveToSentItems)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendMail"), _parameters);
    }

    @Action(name = "translateExchangeIds")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ConvertIdResult> translateExchangeIds(List<String> inputIds, ExchangeIdFormat targetIdType, ExchangeIdFormat sourceIdType) {
        Preconditions.checkNotNull(inputIds, "inputIds cannot be null");
        Preconditions.checkNotNull(targetIdType, "targetIdType cannot be null");
        Preconditions.checkNotNull(sourceIdType, "sourceIdType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("InputIds", "Collection(Edm.String)", Checks.checkIsAscii(inputIds))
            .put("TargetIdType", "microsoft.graph.exchangeIdFormat", targetIdType)
            .put("SourceIdType", "microsoft.graph.exchangeIdFormat", sourceIdType)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.translateExchangeIds"), ConvertIdResult.class, _parameters);
    }

    @Action(name = "removeAllDevicesFromManagement")
    @JsonIgnore
    public ActionRequestNoReturn removeAllDevicesFromManagement() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeAllDevicesFromManagement"), _parameters);
    }

    @Action(name = "unblockManagedApps")
    @JsonIgnore
    public ActionRequestNoReturn unblockManagedApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unblockManagedApps"), _parameters);
    }

    @Action(name = "wipeAndBlockManagedApps")
    @JsonIgnore
    public ActionRequestNoReturn wipeAndBlockManagedApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeAndBlockManagedApps"), _parameters);
    }

    @Action(name = "wipeManagedAppRegistrationByDeviceTag")
    @JsonIgnore
    public ActionRequestNoReturn wipeManagedAppRegistrationByDeviceTag(String deviceTag) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceTag", "Edm.String", Checks.checkIsAscii(deviceTag))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeManagedAppRegistrationByDeviceTag"), _parameters);
    }

    @Action(name = "wipeManagedAppRegistrationsByDeviceTag")
    @JsonIgnore
    public ActionRequestNoReturn wipeManagedAppRegistrationsByDeviceTag(String deviceTag) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceTag", "Edm.String", Checks.checkIsAscii(deviceTag))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeManagedAppRegistrationsByDeviceTag"), _parameters);
    }

    @Action(name = "exportPersonalData")
    @JsonIgnore
    public ActionRequestNoReturn exportPersonalData(String storageLocation) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("storageLocation", "Edm.String", Checks.checkIsAscii(storageLocation))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportPersonalData"), _parameters);
    }

    @Function(name = "findRoomLists")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRoomLists() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRoomLists"), EmailAddress.class, _parameters);
    }

    @Function(name = "findRooms")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRooms() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRooms"), EmailAddress.class, _parameters);
    }

    @Function(name = "findRooms")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRooms_Function(String roomList) {
        Preconditions.checkNotNull(roomList, "roomList cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("RoomList", "Edm.String", Checks.checkIsAscii(roomList))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRooms"), EmailAddress.class, _parameters);
    }

    @Function(name = "reminderView")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Reminder> reminderView(String startDateTime, String endDateTime) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("StartDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("EndDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reminderView"), Reminder.class, _parameters);
    }

    @Function(name = "exportDeviceAndAppManagementData")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData> exportDeviceAndAppManagementData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportDeviceAndAppManagementData"), DeviceAndAppManagementData.class, _parameters);
    }

    @Function(name = "exportDeviceAndAppManagementData")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData> exportDeviceAndAppManagementData_Function(Integer skip, Integer top) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportDeviceAndAppManagementData"), DeviceAndAppManagementData.class, _parameters);
    }

    @Function(name = "getEffectiveDeviceEnrollmentConfigurations")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceEnrollmentConfiguration> getEffectiveDeviceEnrollmentConfigurations() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectiveDeviceEnrollmentConfigurations"), DeviceEnrollmentConfiguration.class, _parameters);
    }

    @Function(name = "getLoggedOnManagedDevices")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedDevice> getLoggedOnManagedDevices() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getLoggedOnManagedDevices"), ManagedDevice.class, _parameters);
    }

    @Function(name = "getManagedAppDiagnosticStatuses")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedAppDiagnosticStatus> getManagedAppDiagnosticStatuses() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedAppDiagnosticStatuses"), ManagedAppDiagnosticStatus.class, _parameters);
    }

    @Function(name = "getManagedAppPolicies")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedAppPolicy> getManagedAppPolicies() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedAppPolicies"), ManagedAppPolicy.class, _parameters);
    }

    @Function(name = "isManagedAppUserBlocked")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> isManagedAppUserBlocked() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isManagedAppUserBlocked"), Boolean.class, _parameters);
    }

    @Function(name = "getManagedDevicesWithAppFailures")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getManagedDevicesWithAppFailures() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedDevicesWithAppFailures"), String.class, _parameters);
    }

    @Function(name = "getManagedDevicesWithFailedOrPendingApps")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedDeviceSummarizedAppState> getManagedDevicesWithFailedOrPendingApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedDevicesWithFailedOrPendingApps"), ManagedDeviceSummarizedAppState.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("User[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("signInActivity=");
        b.append(this.signInActivity);
        b.append(", ");
        b.append("accountEnabled=");
        b.append(this.accountEnabled);
        b.append(", ");
        b.append("ageGroup=");
        b.append(this.ageGroup);
        b.append(", ");
        b.append("assignedLicenses=");
        b.append(this.assignedLicenses);
        b.append(", ");
        b.append("assignedPlans=");
        b.append(this.assignedPlans);
        b.append(", ");
        b.append("businessPhones=");
        b.append(this.businessPhones);
        b.append(", ");
        b.append("city=");
        b.append(this.city);
        b.append(", ");
        b.append("companyName=");
        b.append(this.companyName);
        b.append(", ");
        b.append("consentProvidedForMinor=");
        b.append(this.consentProvidedForMinor);
        b.append(", ");
        b.append("country=");
        b.append(this.country);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("creationType=");
        b.append(this.creationType);
        b.append(", ");
        b.append("customSecurityAttributes=");
        b.append(this.customSecurityAttributes);
        b.append(", ");
        b.append("department=");
        b.append(this.department);
        b.append(", ");
        b.append("deviceKeys=");
        b.append(this.deviceKeys);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("employeeHireDate=");
        b.append(this.employeeHireDate);
        b.append(", ");
        b.append("employeeId=");
        b.append(this.employeeId);
        b.append(", ");
        b.append("employeeOrgData=");
        b.append(this.employeeOrgData);
        b.append(", ");
        b.append("employeeType=");
        b.append(this.employeeType);
        b.append(", ");
        b.append("externalUserState=");
        b.append(this.externalUserState);
        b.append(", ");
        b.append("externalUserStateChangeDateTime=");
        b.append(this.externalUserStateChangeDateTime);
        b.append(", ");
        b.append("faxNumber=");
        b.append(this.faxNumber);
        b.append(", ");
        b.append("givenName=");
        b.append(this.givenName);
        b.append(", ");
        b.append("identities=");
        b.append(this.identities);
        b.append(", ");
        b.append("imAddresses=");
        b.append(this.imAddresses);
        b.append(", ");
        b.append("infoCatalogs=");
        b.append(this.infoCatalogs);
        b.append(", ");
        b.append("isResourceAccount=");
        b.append(this.isResourceAccount);
        b.append(", ");
        b.append("jobTitle=");
        b.append(this.jobTitle);
        b.append(", ");
        b.append("lastPasswordChangeDateTime=");
        b.append(this.lastPasswordChangeDateTime);
        b.append(", ");
        b.append("legalAgeGroupClassification=");
        b.append(this.legalAgeGroupClassification);
        b.append(", ");
        b.append("licenseAssignmentStates=");
        b.append(this.licenseAssignmentStates);
        b.append(", ");
        b.append("mail=");
        b.append(this.mail);
        b.append(", ");
        b.append("mailNickname=");
        b.append(this.mailNickname);
        b.append(", ");
        b.append("mobilePhone=");
        b.append(this.mobilePhone);
        b.append(", ");
        b.append("officeLocation=");
        b.append(this.officeLocation);
        b.append(", ");
        b.append("onPremisesDistinguishedName=");
        b.append(this.onPremisesDistinguishedName);
        b.append(", ");
        b.append("onPremisesDomainName=");
        b.append(this.onPremisesDomainName);
        b.append(", ");
        b.append("onPremisesExtensionAttributes=");
        b.append(this.onPremisesExtensionAttributes);
        b.append(", ");
        b.append("onPremisesImmutableId=");
        b.append(this.onPremisesImmutableId);
        b.append(", ");
        b.append("onPremisesLastSyncDateTime=");
        b.append(this.onPremisesLastSyncDateTime);
        b.append(", ");
        b.append("onPremisesProvisioningErrors=");
        b.append(this.onPremisesProvisioningErrors);
        b.append(", ");
        b.append("onPremisesSamAccountName=");
        b.append(this.onPremisesSamAccountName);
        b.append(", ");
        b.append("onPremisesSecurityIdentifier=");
        b.append(this.onPremisesSecurityIdentifier);
        b.append(", ");
        b.append("onPremisesSyncEnabled=");
        b.append(this.onPremisesSyncEnabled);
        b.append(", ");
        b.append("onPremisesUserPrincipalName=");
        b.append(this.onPremisesUserPrincipalName);
        b.append(", ");
        b.append("otherMails=");
        b.append(this.otherMails);
        b.append(", ");
        b.append("passwordPolicies=");
        b.append(this.passwordPolicies);
        b.append(", ");
        b.append("passwordProfile=");
        b.append(this.passwordProfile);
        b.append(", ");
        b.append("postalCode=");
        b.append(this.postalCode);
        b.append(", ");
        b.append("preferredDataLocation=");
        b.append(this.preferredDataLocation);
        b.append(", ");
        b.append("preferredLanguage=");
        b.append(this.preferredLanguage);
        b.append(", ");
        b.append("provisionedPlans=");
        b.append(this.provisionedPlans);
        b.append(", ");
        b.append("proxyAddresses=");
        b.append(this.proxyAddresses);
        b.append(", ");
        b.append("refreshTokensValidFromDateTime=");
        b.append(this.refreshTokensValidFromDateTime);
        b.append(", ");
        b.append("showInAddressList=");
        b.append(this.showInAddressList);
        b.append(", ");
        b.append("signInSessionsValidFromDateTime=");
        b.append(this.signInSessionsValidFromDateTime);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("streetAddress=");
        b.append(this.streetAddress);
        b.append(", ");
        b.append("surname=");
        b.append(this.surname);
        b.append(", ");
        b.append("usageLocation=");
        b.append(this.usageLocation);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("userType=");
        b.append(this.userType);
        b.append(", ");
        b.append("mailboxSettings=");
        b.append(this.mailboxSettings);
        b.append(", ");
        b.append("deviceEnrollmentLimit=");
        b.append(this.deviceEnrollmentLimit);
        b.append(", ");
        b.append("aboutMe=");
        b.append(this.aboutMe);
        b.append(", ");
        b.append("birthday=");
        b.append(this.birthday);
        b.append(", ");
        b.append("hireDate=");
        b.append(this.hireDate);
        b.append(", ");
        b.append("interests=");
        b.append(this.interests);
        b.append(", ");
        b.append("mySite=");
        b.append(this.mySite);
        b.append(", ");
        b.append("pastProjects=");
        b.append(this.pastProjects);
        b.append(", ");
        b.append("preferredName=");
        b.append(this.preferredName);
        b.append(", ");
        b.append("responsibilities=");
        b.append(this.responsibilities);
        b.append(", ");
        b.append("schools=");
        b.append(this.schools);
        b.append(", ");
        b.append("skills=");
        b.append(this.skills);
        b.append(", ");
        b.append("analytics=");
        b.append(this.analytics);
        b.append(", ");
        b.append("usageRights=");
        b.append(this.usageRights);
        b.append(", ");
        b.append("informationProtection=");
        b.append(this.informationProtection);
        b.append(", ");
        b.append("appRoleAssignments=");
        b.append(this.appRoleAssignments);
        b.append(", ");
        b.append("licenseDetails=");
        b.append(this.licenseDetails);
        b.append(", ");
        b.append("scopedRoleMemberOf=");
        b.append(this.scopedRoleMemberOf);
        b.append(", ");
        b.append("calendar=");
        b.append(this.calendar);
        b.append(", ");
        b.append("calendarGroups=");
        b.append(this.calendarGroups);
        b.append(", ");
        b.append("calendars=");
        b.append(this.calendars);
        b.append(", ");
        b.append("calendarView=");
        b.append(this.calendarView);
        b.append(", ");
        b.append("contactFolders=");
        b.append(this.contactFolders);
        b.append(", ");
        b.append("contacts=");
        b.append(this.contacts);
        b.append(", ");
        b.append("events=");
        b.append(this.events);
        b.append(", ");
        b.append("inferenceClassification=");
        b.append(this.inferenceClassification);
        b.append(", ");
        b.append("joinedGroups=");
        b.append(this.joinedGroups);
        b.append(", ");
        b.append("mailFolders=");
        b.append(this.mailFolders);
        b.append(", ");
        b.append("messages=");
        b.append(this.messages);
        b.append(", ");
        b.append("outlook=");
        b.append(this.outlook);
        b.append(", ");
        b.append("people=");
        b.append(this.people);
        b.append(", ");
        b.append("drive=");
        b.append(this.drive);
        b.append(", ");
        b.append("drives=");
        b.append(this.drives);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("appConsentRequestsForApproval=");
        b.append(this.appConsentRequestsForApproval);
        b.append(", ");
        b.append("approvals=");
        b.append(this.approvals);
        b.append(", ");
        b.append("pendingAccessReviewInstances=");
        b.append(this.pendingAccessReviewInstances);
        b.append(", ");
        b.append("security=");
        b.append(this.security);
        b.append(", ");
        b.append("deviceEnrollmentConfigurations=");
        b.append(this.deviceEnrollmentConfigurations);
        b.append(", ");
        b.append("managedDevices=");
        b.append(this.managedDevices);
        b.append(", ");
        b.append("deviceManagementTroubleshootingEvents=");
        b.append(this.deviceManagementTroubleshootingEvents);
        b.append(", ");
        b.append("mobileAppIntentAndStates=");
        b.append(this.mobileAppIntentAndStates);
        b.append(", ");
        b.append("mobileAppTroubleshootingEvents=");
        b.append(this.mobileAppTroubleshootingEvents);
        b.append(", ");
        b.append("notifications=");
        b.append(this.notifications);
        b.append(", ");
        b.append("planner=");
        b.append(this.planner);
        b.append(", ");
        b.append("insights=");
        b.append(this.insights);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("onenote=");
        b.append(this.onenote);
        b.append(", ");
        b.append("photo=");
        b.append(this.photo);
        b.append(", ");
        b.append("photos=");
        b.append(this.photos);
        b.append(", ");
        b.append("profile=");
        b.append(this.profile);
        b.append(", ");
        b.append("activities=");
        b.append(this.activities);
        b.append(", ");
        b.append("devices=");
        b.append(this.devices);
        b.append(", ");
        b.append("onlineMeetings=");
        b.append(this.onlineMeetings);
        b.append(", ");
        b.append("presence=");
        b.append(this.presence);
        b.append(", ");
        b.append("authentication=");
        b.append(this.authentication);
        b.append(", ");
        b.append("tasks=");
        b.append(this.tasks);
        b.append(", ");
        b.append("chats=");
        b.append(this.chats);
        b.append(", ");
        b.append("teamwork=");
        b.append(this.teamwork);
        b.append(", ");
        b.append("todo=");
        b.append(this.todo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
