package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UnmanagedDevice;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskCategory;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskPriority;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskStatus;


/**
 * <i>“This task derived type represents a list of unmanaged devices discovered in the
 * network.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "unmanagedDevices"})
@JsonInclude(Include.NON_NULL)
public class UnmanagedDeviceDiscoveryTask extends DeviceAppManagementTask implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unmanagedDeviceDiscoveryTask";
    }

    @JsonProperty("unmanagedDevices")
    protected List<UnmanagedDevice> unmanagedDevices;

    @JsonProperty("unmanagedDevices@nextLink")
    protected String unmanagedDevicesNextLink;

    protected UnmanagedDeviceDiscoveryTask() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnmanagedDeviceDiscoveryTask() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String assignedTo;
        private DeviceAppManagementTaskCategory category;
        private OffsetDateTime createdDateTime;
        private String creator;
        private String creatorNotes;
        private String description;
        private String displayName;
        private OffsetDateTime dueDateTime;
        private DeviceAppManagementTaskPriority priority;
        private DeviceAppManagementTaskStatus status;
        private List<UnmanagedDevice> unmanagedDevices;
        private String unmanagedDevicesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        public Builder category(DeviceAppManagementTaskCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder creator(String creator) {
            this.creator = creator;
            this.changedFields = changedFields.add("creator");
            return this;
        }

        public Builder creatorNotes(String creatorNotes) {
            this.creatorNotes = creatorNotes;
            this.changedFields = changedFields.add("creatorNotes");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder dueDateTime(OffsetDateTime dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        public Builder priority(DeviceAppManagementTaskPriority priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder status(DeviceAppManagementTaskStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“Unmanaged devices discovered in the network.”</i>
         * 
         * @param unmanagedDevices
         *            value of {@code unmanagedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unmanagedDevices(List<UnmanagedDevice> unmanagedDevices) {
            this.unmanagedDevices = unmanagedDevices;
            this.changedFields = changedFields.add("unmanagedDevices");
            return this;
        }

        /**
         * <i>“Unmanaged devices discovered in the network.”</i>
         * 
         * @param unmanagedDevices
         *            value of {@code unmanagedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unmanagedDevices(UnmanagedDevice... unmanagedDevices) {
            return unmanagedDevices(Arrays.asList(unmanagedDevices));
        }

        /**
         * <i>“Unmanaged devices discovered in the network.”</i>
         * 
         * @param unmanagedDevicesNextLink
         *            value of {@code unmanagedDevices@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unmanagedDevicesNextLink(String unmanagedDevicesNextLink) {
            this.unmanagedDevicesNextLink = unmanagedDevicesNextLink;
            this.changedFields = changedFields.add("unmanagedDevices");
            return this;
        }

        public UnmanagedDeviceDiscoveryTask build() {
            UnmanagedDeviceDiscoveryTask _x = new UnmanagedDeviceDiscoveryTask();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unmanagedDeviceDiscoveryTask";
            _x.id = id;
            _x.assignedTo = assignedTo;
            _x.category = category;
            _x.createdDateTime = createdDateTime;
            _x.creator = creator;
            _x.creatorNotes = creatorNotes;
            _x.description = description;
            _x.displayName = displayName;
            _x.dueDateTime = dueDateTime;
            _x.priority = priority;
            _x.status = status;
            _x.unmanagedDevices = unmanagedDevices;
            _x.unmanagedDevicesNextLink = unmanagedDevicesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Unmanaged devices discovered in the network.”</i>
     * 
     * @return property unmanagedDevices
     */
    @Property(name="unmanagedDevices")
    @JsonIgnore
    public CollectionPage<UnmanagedDevice> getUnmanagedDevices() {
        return new CollectionPage<UnmanagedDevice>(contextPath, UnmanagedDevice.class, this.unmanagedDevices, Optional.ofNullable(unmanagedDevicesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code unmanagedDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Unmanaged devices discovered in the network.”</i>
     * 
     * @param unmanagedDevices
     *            new value of {@code unmanagedDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unmanagedDevices} field changed
     */
    public UnmanagedDeviceDiscoveryTask withUnmanagedDevices(List<UnmanagedDevice> unmanagedDevices) {
        UnmanagedDeviceDiscoveryTask _x = _copy();
        _x.changedFields = changedFields.add("unmanagedDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDeviceDiscoveryTask");
        _x.unmanagedDevices = unmanagedDevices;
        return _x;
    }

    /**
     * <i>“Unmanaged devices discovered in the network.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property unmanagedDevices
     */
    @Property(name="unmanagedDevices")
    @JsonIgnore
    public CollectionPage<UnmanagedDevice> getUnmanagedDevices(HttpRequestOptions options) {
        return new CollectionPage<UnmanagedDevice>(contextPath, UnmanagedDevice.class, this.unmanagedDevices, Optional.ofNullable(unmanagedDevicesNextLink), Collections.emptyList(), options);
    }

    public UnmanagedDeviceDiscoveryTask withUnmappedField(String name, Object value) {
        UnmanagedDeviceDiscoveryTask _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnmanagedDeviceDiscoveryTask patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnmanagedDeviceDiscoveryTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnmanagedDeviceDiscoveryTask put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnmanagedDeviceDiscoveryTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnmanagedDeviceDiscoveryTask _copy() {
        UnmanagedDeviceDiscoveryTask _x = new UnmanagedDeviceDiscoveryTask();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.assignedTo = assignedTo;
        _x.category = category;
        _x.createdDateTime = createdDateTime;
        _x.creator = creator;
        _x.creatorNotes = creatorNotes;
        _x.description = description;
        _x.displayName = displayName;
        _x.dueDateTime = dueDateTime;
        _x.priority = priority;
        _x.status = status;
        _x.unmanagedDevices = unmanagedDevices;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnmanagedDeviceDiscoveryTask[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("creator=");
        b.append(this.creator);
        b.append(", ");
        b.append("creatorNotes=");
        b.append(this.creatorNotes);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("unmanagedDevices=");
        b.append(this.unmanagedDevices);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
