package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UnifiedRoleManagementPolicyRuleTarget;

@JsonPropertyOrder({
    "@odata.type", 
    "isDefaultRecipientsEnabled", 
    "notificationLevel", 
    "notificationRecipients", 
    "notificationType", 
    "recipientType"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleManagementPolicyNotificationRule extends UnifiedRoleManagementPolicyRule implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleManagementPolicyNotificationRule";
    }

    @JsonProperty("isDefaultRecipientsEnabled")
    protected Boolean isDefaultRecipientsEnabled;

    @JsonProperty("notificationLevel")
    protected String notificationLevel;

    @JsonProperty("notificationRecipients")
    protected List<String> notificationRecipients;

    @JsonProperty("notificationRecipients@nextLink")
    protected String notificationRecipientsNextLink;

    @JsonProperty("notificationType")
    protected String notificationType;

    @JsonProperty("recipientType")
    protected String recipientType;

    protected UnifiedRoleManagementPolicyNotificationRule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleManagementPolicyNotificationRule() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UnifiedRoleManagementPolicyRuleTarget target;
        private Boolean isDefaultRecipientsEnabled;
        private String notificationLevel;
        private List<String> notificationRecipients;
        private String notificationRecipientsNextLink;
        private String notificationType;
        private String recipientType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder target(UnifiedRoleManagementPolicyRuleTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public Builder isDefaultRecipientsEnabled(Boolean isDefaultRecipientsEnabled) {
            this.isDefaultRecipientsEnabled = isDefaultRecipientsEnabled;
            this.changedFields = changedFields.add("isDefaultRecipientsEnabled");
            return this;
        }

        public Builder notificationLevel(String notificationLevel) {
            this.notificationLevel = notificationLevel;
            this.changedFields = changedFields.add("notificationLevel");
            return this;
        }

        public Builder notificationRecipients(List<String> notificationRecipients) {
            this.notificationRecipients = notificationRecipients;
            this.changedFields = changedFields.add("notificationRecipients");
            return this;
        }

        public Builder notificationRecipients(String... notificationRecipients) {
            return notificationRecipients(Arrays.asList(notificationRecipients));
        }

        public Builder notificationRecipientsNextLink(String notificationRecipientsNextLink) {
            this.notificationRecipientsNextLink = notificationRecipientsNextLink;
            this.changedFields = changedFields.add("notificationRecipients");
            return this;
        }

        public Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            this.changedFields = changedFields.add("notificationType");
            return this;
        }

        public Builder recipientType(String recipientType) {
            this.recipientType = recipientType;
            this.changedFields = changedFields.add("recipientType");
            return this;
        }

        public UnifiedRoleManagementPolicyNotificationRule build() {
            UnifiedRoleManagementPolicyNotificationRule _x = new UnifiedRoleManagementPolicyNotificationRule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleManagementPolicyNotificationRule";
            _x.id = id;
            _x.target = target;
            _x.isDefaultRecipientsEnabled = isDefaultRecipientsEnabled;
            _x.notificationLevel = notificationLevel;
            _x.notificationRecipients = notificationRecipients;
            _x.notificationRecipientsNextLink = notificationRecipientsNextLink;
            _x.notificationType = notificationType;
            _x.recipientType = recipientType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="isDefaultRecipientsEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsDefaultRecipientsEnabled() {
        return Optional.ofNullable(isDefaultRecipientsEnabled);
    }

    public UnifiedRoleManagementPolicyNotificationRule withIsDefaultRecipientsEnabled(Boolean isDefaultRecipientsEnabled) {
        UnifiedRoleManagementPolicyNotificationRule _x = _copy();
        _x.changedFields = changedFields.add("isDefaultRecipientsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyNotificationRule");
        _x.isDefaultRecipientsEnabled = isDefaultRecipientsEnabled;
        return _x;
    }

    @Property(name="notificationLevel")
    @JsonIgnore
    public Optional<String> getNotificationLevel() {
        return Optional.ofNullable(notificationLevel);
    }

    public UnifiedRoleManagementPolicyNotificationRule withNotificationLevel(String notificationLevel) {
        UnifiedRoleManagementPolicyNotificationRule _x = _copy();
        _x.changedFields = changedFields.add("notificationLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyNotificationRule");
        _x.notificationLevel = notificationLevel;
        return _x;
    }

    @Property(name="notificationRecipients")
    @JsonIgnore
    public CollectionPage<String> getNotificationRecipients() {
        return new CollectionPage<String>(contextPath, String.class, this.notificationRecipients, Optional.ofNullable(notificationRecipientsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public UnifiedRoleManagementPolicyNotificationRule withNotificationRecipients(List<String> notificationRecipients) {
        UnifiedRoleManagementPolicyNotificationRule _x = _copy();
        _x.changedFields = changedFields.add("notificationRecipients");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyNotificationRule");
        _x.notificationRecipients = notificationRecipients;
        return _x;
    }

    @Property(name="notificationRecipients")
    @JsonIgnore
    public CollectionPage<String> getNotificationRecipients(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.notificationRecipients, Optional.ofNullable(notificationRecipientsNextLink), Collections.emptyList(), options);
    }

    @Property(name="notificationType")
    @JsonIgnore
    public Optional<String> getNotificationType() {
        return Optional.ofNullable(notificationType);
    }

    public UnifiedRoleManagementPolicyNotificationRule withNotificationType(String notificationType) {
        UnifiedRoleManagementPolicyNotificationRule _x = _copy();
        _x.changedFields = changedFields.add("notificationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyNotificationRule");
        _x.notificationType = notificationType;
        return _x;
    }

    @Property(name="recipientType")
    @JsonIgnore
    public Optional<String> getRecipientType() {
        return Optional.ofNullable(recipientType);
    }

    public UnifiedRoleManagementPolicyNotificationRule withRecipientType(String recipientType) {
        UnifiedRoleManagementPolicyNotificationRule _x = _copy();
        _x.changedFields = changedFields.add("recipientType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyNotificationRule");
        _x.recipientType = recipientType;
        return _x;
    }

    public UnifiedRoleManagementPolicyNotificationRule withUnmappedField(String name, Object value) {
        UnifiedRoleManagementPolicyNotificationRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleManagementPolicyNotificationRule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleManagementPolicyNotificationRule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleManagementPolicyNotificationRule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleManagementPolicyNotificationRule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleManagementPolicyNotificationRule _copy() {
        UnifiedRoleManagementPolicyNotificationRule _x = new UnifiedRoleManagementPolicyNotificationRule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.target = target;
        _x.isDefaultRecipientsEnabled = isDefaultRecipientsEnabled;
        _x.notificationLevel = notificationLevel;
        _x.notificationRecipients = notificationRecipients;
        _x.notificationType = notificationType;
        _x.recipientType = recipientType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleManagementPolicyNotificationRule[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append(", ");
        b.append("isDefaultRecipientsEnabled=");
        b.append(this.isDefaultRecipientsEnabled);
        b.append(", ");
        b.append("notificationLevel=");
        b.append(this.notificationLevel);
        b.append(", ");
        b.append("notificationRecipients=");
        b.append(this.notificationRecipients);
        b.append(", ");
        b.append("notificationType=");
        b.append(this.notificationType);
        b.append(", ");
        b.append("recipientType=");
        b.append(this.recipientType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
