package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UnifiedRoleManagementPolicyRuleTarget;

@JsonPropertyOrder({
    "@odata.type", 
    "claimValue", 
    "isEnabled"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleManagementPolicyAuthenticationContextRule extends UnifiedRoleManagementPolicyRule implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleManagementPolicyAuthenticationContextRule";
    }

    @JsonProperty("claimValue")
    protected String claimValue;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    protected UnifiedRoleManagementPolicyAuthenticationContextRule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleManagementPolicyAuthenticationContextRule() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UnifiedRoleManagementPolicyRuleTarget target;
        private String claimValue;
        private Boolean isEnabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder target(UnifiedRoleManagementPolicyRuleTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public Builder claimValue(String claimValue) {
            this.claimValue = claimValue;
            this.changedFields = changedFields.add("claimValue");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public UnifiedRoleManagementPolicyAuthenticationContextRule build() {
            UnifiedRoleManagementPolicyAuthenticationContextRule _x = new UnifiedRoleManagementPolicyAuthenticationContextRule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleManagementPolicyAuthenticationContextRule";
            _x.id = id;
            _x.target = target;
            _x.claimValue = claimValue;
            _x.isEnabled = isEnabled;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="claimValue")
    @JsonIgnore
    public Optional<String> getClaimValue() {
        return Optional.ofNullable(claimValue);
    }

    public UnifiedRoleManagementPolicyAuthenticationContextRule withClaimValue(String claimValue) {
        UnifiedRoleManagementPolicyAuthenticationContextRule _x = _copy();
        _x.changedFields = changedFields.add("claimValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyAuthenticationContextRule");
        _x.claimValue = claimValue;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public UnifiedRoleManagementPolicyAuthenticationContextRule withIsEnabled(Boolean isEnabled) {
        UnifiedRoleManagementPolicyAuthenticationContextRule _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyAuthenticationContextRule");
        _x.isEnabled = isEnabled;
        return _x;
    }

    public UnifiedRoleManagementPolicyAuthenticationContextRule withUnmappedField(String name, Object value) {
        UnifiedRoleManagementPolicyAuthenticationContextRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleManagementPolicyAuthenticationContextRule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleManagementPolicyAuthenticationContextRule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleManagementPolicyAuthenticationContextRule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleManagementPolicyAuthenticationContextRule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleManagementPolicyAuthenticationContextRule _copy() {
        UnifiedRoleManagementPolicyAuthenticationContextRule _x = new UnifiedRoleManagementPolicyAuthenticationContextRule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.target = target;
        _x.claimValue = claimValue;
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleManagementPolicyAuthenticationContextRule[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append(", ");
        b.append("claimValue=");
        b.append(this.claimValue);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
