package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UnifiedRolePermission;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleDefinitionCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "isBuiltIn", 
    "isEnabled", 
    "resourceScopes", 
    "rolePermissions", 
    "templateId", 
    "version", 
    "inheritsPermissionsFrom"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleDefinition";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isBuiltIn")
    protected Boolean isBuiltIn;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("resourceScopes")
    protected List<String> resourceScopes;

    @JsonProperty("resourceScopes@nextLink")
    protected String resourceScopesNextLink;

    @JsonProperty("rolePermissions")
    protected List<UnifiedRolePermission> rolePermissions;

    @JsonProperty("rolePermissions@nextLink")
    protected String rolePermissionsNextLink;

    @JsonProperty("templateId")
    protected String templateId;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("inheritsPermissionsFrom")
    protected List<UnifiedRoleDefinition> inheritsPermissionsFrom;

    protected UnifiedRoleDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private Boolean isBuiltIn;
        private Boolean isEnabled;
        private List<String> resourceScopes;
        private String resourceScopesNextLink;
        private List<UnifiedRolePermission> rolePermissions;
        private String rolePermissionsNextLink;
        private String templateId;
        private String version;
        private List<UnifiedRoleDefinition> inheritsPermissionsFrom;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isBuiltIn(Boolean isBuiltIn) {
            this.isBuiltIn = isBuiltIn;
            this.changedFields = changedFields.add("isBuiltIn");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder resourceScopes(List<String> resourceScopes) {
            this.resourceScopes = resourceScopes;
            this.changedFields = changedFields.add("resourceScopes");
            return this;
        }

        public Builder resourceScopes(String... resourceScopes) {
            return resourceScopes(Arrays.asList(resourceScopes));
        }

        public Builder resourceScopesNextLink(String resourceScopesNextLink) {
            this.resourceScopesNextLink = resourceScopesNextLink;
            this.changedFields = changedFields.add("resourceScopes");
            return this;
        }

        public Builder rolePermissions(List<UnifiedRolePermission> rolePermissions) {
            this.rolePermissions = rolePermissions;
            this.changedFields = changedFields.add("rolePermissions");
            return this;
        }

        public Builder rolePermissions(UnifiedRolePermission... rolePermissions) {
            return rolePermissions(Arrays.asList(rolePermissions));
        }

        public Builder rolePermissionsNextLink(String rolePermissionsNextLink) {
            this.rolePermissionsNextLink = rolePermissionsNextLink;
            this.changedFields = changedFields.add("rolePermissions");
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            this.changedFields = changedFields.add("templateId");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder inheritsPermissionsFrom(List<UnifiedRoleDefinition> inheritsPermissionsFrom) {
            this.inheritsPermissionsFrom = inheritsPermissionsFrom;
            this.changedFields = changedFields.add("inheritsPermissionsFrom");
            return this;
        }

        public Builder inheritsPermissionsFrom(UnifiedRoleDefinition... inheritsPermissionsFrom) {
            return inheritsPermissionsFrom(Arrays.asList(inheritsPermissionsFrom));
        }

        public UnifiedRoleDefinition build() {
            UnifiedRoleDefinition _x = new UnifiedRoleDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleDefinition";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.isBuiltIn = isBuiltIn;
            _x.isEnabled = isEnabled;
            _x.resourceScopes = resourceScopes;
            _x.resourceScopesNextLink = resourceScopesNextLink;
            _x.rolePermissions = rolePermissions;
            _x.rolePermissionsNextLink = rolePermissionsNextLink;
            _x.templateId = templateId;
            _x.version = version;
            _x.inheritsPermissionsFrom = inheritsPermissionsFrom;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public UnifiedRoleDefinition withDescription(String description) {
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleDefinition");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public UnifiedRoleDefinition withDisplayName(String displayName) {
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleDefinition");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isBuiltIn")
    @JsonIgnore
    public Optional<Boolean> getIsBuiltIn() {
        return Optional.ofNullable(isBuiltIn);
    }

    public UnifiedRoleDefinition withIsBuiltIn(Boolean isBuiltIn) {
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("isBuiltIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleDefinition");
        _x.isBuiltIn = isBuiltIn;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public UnifiedRoleDefinition withIsEnabled(Boolean isEnabled) {
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleDefinition");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="resourceScopes")
    @JsonIgnore
    public CollectionPage<String> getResourceScopes() {
        return new CollectionPage<String>(contextPath, String.class, this.resourceScopes, Optional.ofNullable(resourceScopesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public UnifiedRoleDefinition withResourceScopes(List<String> resourceScopes) {
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("resourceScopes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleDefinition");
        _x.resourceScopes = resourceScopes;
        return _x;
    }

    @Property(name="resourceScopes")
    @JsonIgnore
    public CollectionPage<String> getResourceScopes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.resourceScopes, Optional.ofNullable(resourceScopesNextLink), Collections.emptyList(), options);
    }

    @Property(name="rolePermissions")
    @JsonIgnore
    public CollectionPage<UnifiedRolePermission> getRolePermissions() {
        return new CollectionPage<UnifiedRolePermission>(contextPath, UnifiedRolePermission.class, this.rolePermissions, Optional.ofNullable(rolePermissionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public UnifiedRoleDefinition withRolePermissions(List<UnifiedRolePermission> rolePermissions) {
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("rolePermissions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleDefinition");
        _x.rolePermissions = rolePermissions;
        return _x;
    }

    @Property(name="rolePermissions")
    @JsonIgnore
    public CollectionPage<UnifiedRolePermission> getRolePermissions(HttpRequestOptions options) {
        return new CollectionPage<UnifiedRolePermission>(contextPath, UnifiedRolePermission.class, this.rolePermissions, Optional.ofNullable(rolePermissionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="templateId")
    @JsonIgnore
    public Optional<String> getTemplateId() {
        return Optional.ofNullable(templateId);
    }

    public UnifiedRoleDefinition withTemplateId(String templateId) {
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("templateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleDefinition");
        _x.templateId = templateId;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public UnifiedRoleDefinition withVersion(String version) {
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleDefinition");
        _x.version = version;
        return _x;
    }

    public UnifiedRoleDefinition withUnmappedField(String name, Object value) {
        UnifiedRoleDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="inheritsPermissionsFrom")
    @JsonIgnore
    public UnifiedRoleDefinitionCollectionRequest getInheritsPermissionsFrom() {
        return new UnifiedRoleDefinitionCollectionRequest(
                        contextPath.addSegment("inheritsPermissionsFrom"), Optional.ofNullable(inheritsPermissionsFrom));
    }

    public UnifiedRoleDefinition withInheritsPermissionsFrom(List<UnifiedRoleDefinition> inheritsPermissionsFrom) {
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("inheritsPermissionsFrom");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleDefinition");
        _x.inheritsPermissionsFrom = inheritsPermissionsFrom;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleDefinition _copy() {
        UnifiedRoleDefinition _x = new UnifiedRoleDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.isBuiltIn = isBuiltIn;
        _x.isEnabled = isEnabled;
        _x.resourceScopes = resourceScopes;
        _x.rolePermissions = rolePermissions;
        _x.templateId = templateId;
        _x.version = version;
        _x.inheritsPermissionsFrom = inheritsPermissionsFrom;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isBuiltIn=");
        b.append(this.isBuiltIn);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("resourceScopes=");
        b.append(this.resourceScopes);
        b.append(", ");
        b.append("rolePermissions=");
        b.append(this.rolePermissions);
        b.append(", ");
        b.append("templateId=");
        b.append(this.templateId);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("inheritsPermissionsFrom=");
        b.append(this.inheritsPermissionsFrom);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
