package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.RequestSchedule;
import odata.msgraph.client.beta.complex.TicketInfo;
import odata.msgraph.client.beta.entity.request.AppScopeRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleDefinitionRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleEligibilityScheduleRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "action", 
    "appScopeId", 
    "directoryScopeId", 
    "isValidationOnly", 
    "justification", 
    "principalId", 
    "roleDefinitionId", 
    "scheduleInfo", 
    "targetScheduleId", 
    "ticketInfo"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleAssignmentScheduleRequest extends Request implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleAssignmentScheduleRequest";
    }

    @JsonProperty("action")
    protected String action;

    @JsonProperty("appScopeId")
    protected String appScopeId;

    @JsonProperty("directoryScopeId")
    protected String directoryScopeId;

    @JsonProperty("isValidationOnly")
    protected Boolean isValidationOnly;

    @JsonProperty("justification")
    protected String justification;

    @JsonProperty("principalId")
    protected String principalId;

    @JsonProperty("roleDefinitionId")
    protected String roleDefinitionId;

    @JsonProperty("scheduleInfo")
    protected RequestSchedule scheduleInfo;

    @JsonProperty("targetScheduleId")
    protected String targetScheduleId;

    @JsonProperty("ticketInfo")
    protected TicketInfo ticketInfo;

    protected UnifiedRoleAssignmentScheduleRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleAssignmentScheduleRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String approvalId;
        private OffsetDateTime completedDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String customData;
        private String status;
        private String action;
        private String appScopeId;
        private String directoryScopeId;
        private Boolean isValidationOnly;
        private String justification;
        private String principalId;
        private String roleDefinitionId;
        private RequestSchedule scheduleInfo;
        private String targetScheduleId;
        private TicketInfo ticketInfo;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder approvalId(String approvalId) {
            this.approvalId = approvalId;
            this.changedFields = changedFields.add("approvalId");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder customData(String customData) {
            this.customData = customData;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder appScopeId(String appScopeId) {
            this.appScopeId = appScopeId;
            this.changedFields = changedFields.add("appScopeId");
            return this;
        }

        public Builder directoryScopeId(String directoryScopeId) {
            this.directoryScopeId = directoryScopeId;
            this.changedFields = changedFields.add("directoryScopeId");
            return this;
        }

        public Builder isValidationOnly(Boolean isValidationOnly) {
            this.isValidationOnly = isValidationOnly;
            this.changedFields = changedFields.add("isValidationOnly");
            return this;
        }

        public Builder justification(String justification) {
            this.justification = justification;
            this.changedFields = changedFields.add("justification");
            return this;
        }

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            this.changedFields = changedFields.add("principalId");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder scheduleInfo(RequestSchedule scheduleInfo) {
            this.scheduleInfo = scheduleInfo;
            this.changedFields = changedFields.add("scheduleInfo");
            return this;
        }

        public Builder targetScheduleId(String targetScheduleId) {
            this.targetScheduleId = targetScheduleId;
            this.changedFields = changedFields.add("targetScheduleId");
            return this;
        }

        public Builder ticketInfo(TicketInfo ticketInfo) {
            this.ticketInfo = ticketInfo;
            this.changedFields = changedFields.add("ticketInfo");
            return this;
        }

        public UnifiedRoleAssignmentScheduleRequest build() {
            UnifiedRoleAssignmentScheduleRequest _x = new UnifiedRoleAssignmentScheduleRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleAssignmentScheduleRequest";
            _x.id = id;
            _x.approvalId = approvalId;
            _x.completedDateTime = completedDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.customData = customData;
            _x.status = status;
            _x.action = action;
            _x.appScopeId = appScopeId;
            _x.directoryScopeId = directoryScopeId;
            _x.isValidationOnly = isValidationOnly;
            _x.justification = justification;
            _x.principalId = principalId;
            _x.roleDefinitionId = roleDefinitionId;
            _x.scheduleInfo = scheduleInfo;
            _x.targetScheduleId = targetScheduleId;
            _x.ticketInfo = ticketInfo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="action")
    @JsonIgnore
    public Optional<String> getAction() {
        return Optional.ofNullable(action);
    }

    public UnifiedRoleAssignmentScheduleRequest withAction(String action) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = changedFields.add("action");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleRequest");
        _x.action = action;
        return _x;
    }

    @Property(name="appScopeId")
    @JsonIgnore
    public Optional<String> getAppScopeId() {
        return Optional.ofNullable(appScopeId);
    }

    public UnifiedRoleAssignmentScheduleRequest withAppScopeId(String appScopeId) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = changedFields.add("appScopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleRequest");
        _x.appScopeId = appScopeId;
        return _x;
    }

    @Property(name="directoryScopeId")
    @JsonIgnore
    public Optional<String> getDirectoryScopeId() {
        return Optional.ofNullable(directoryScopeId);
    }

    public UnifiedRoleAssignmentScheduleRequest withDirectoryScopeId(String directoryScopeId) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = changedFields.add("directoryScopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleRequest");
        _x.directoryScopeId = directoryScopeId;
        return _x;
    }

    @Property(name="isValidationOnly")
    @JsonIgnore
    public Optional<Boolean> getIsValidationOnly() {
        return Optional.ofNullable(isValidationOnly);
    }

    public UnifiedRoleAssignmentScheduleRequest withIsValidationOnly(Boolean isValidationOnly) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = changedFields.add("isValidationOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleRequest");
        _x.isValidationOnly = isValidationOnly;
        return _x;
    }

    @Property(name="justification")
    @JsonIgnore
    public Optional<String> getJustification() {
        return Optional.ofNullable(justification);
    }

    public UnifiedRoleAssignmentScheduleRequest withJustification(String justification) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = changedFields.add("justification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleRequest");
        _x.justification = justification;
        return _x;
    }

    @Property(name="principalId")
    @JsonIgnore
    public Optional<String> getPrincipalId() {
        return Optional.ofNullable(principalId);
    }

    public UnifiedRoleAssignmentScheduleRequest withPrincipalId(String principalId) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = changedFields.add("principalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleRequest");
        _x.principalId = principalId;
        return _x;
    }

    @Property(name="roleDefinitionId")
    @JsonIgnore
    public Optional<String> getRoleDefinitionId() {
        return Optional.ofNullable(roleDefinitionId);
    }

    public UnifiedRoleAssignmentScheduleRequest withRoleDefinitionId(String roleDefinitionId) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleRequest");
        _x.roleDefinitionId = roleDefinitionId;
        return _x;
    }

    @Property(name="scheduleInfo")
    @JsonIgnore
    public Optional<RequestSchedule> getScheduleInfo() {
        return Optional.ofNullable(scheduleInfo);
    }

    public UnifiedRoleAssignmentScheduleRequest withScheduleInfo(RequestSchedule scheduleInfo) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = changedFields.add("scheduleInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleRequest");
        _x.scheduleInfo = scheduleInfo;
        return _x;
    }

    @Property(name="targetScheduleId")
    @JsonIgnore
    public Optional<String> getTargetScheduleId() {
        return Optional.ofNullable(targetScheduleId);
    }

    public UnifiedRoleAssignmentScheduleRequest withTargetScheduleId(String targetScheduleId) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = changedFields.add("targetScheduleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleRequest");
        _x.targetScheduleId = targetScheduleId;
        return _x;
    }

    @Property(name="ticketInfo")
    @JsonIgnore
    public Optional<TicketInfo> getTicketInfo() {
        return Optional.ofNullable(ticketInfo);
    }

    public UnifiedRoleAssignmentScheduleRequest withTicketInfo(TicketInfo ticketInfo) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = changedFields.add("ticketInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleRequest");
        _x.ticketInfo = ticketInfo;
        return _x;
    }

    public UnifiedRoleAssignmentScheduleRequest withUnmappedField(String name, Object value) {
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="activatedUsing")
    @JsonIgnore
    public UnifiedRoleEligibilityScheduleRequest getActivatedUsing() {
        return new UnifiedRoleEligibilityScheduleRequest(contextPath.addSegment("activatedUsing"), RequestHelper.getValue(unmappedFields, "activatedUsing"));
    }

    @NavigationProperty(name="appScope")
    @JsonIgnore
    public AppScopeRequest getAppScope() {
        return new AppScopeRequest(contextPath.addSegment("appScope"), RequestHelper.getValue(unmappedFields, "appScope"));
    }

    @NavigationProperty(name="directoryScope")
    @JsonIgnore
    public DirectoryObjectRequest getDirectoryScope() {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScope"), RequestHelper.getValue(unmappedFields, "directoryScope"));
    }

    @NavigationProperty(name="principal")
    @JsonIgnore
    public DirectoryObjectRequest getPrincipal() {
        return new DirectoryObjectRequest(contextPath.addSegment("principal"), RequestHelper.getValue(unmappedFields, "principal"));
    }

    @NavigationProperty(name="roleDefinition")
    @JsonIgnore
    public UnifiedRoleDefinitionRequest getRoleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), RequestHelper.getValue(unmappedFields, "roleDefinition"));
    }

    @NavigationProperty(name="targetSchedule")
    @JsonIgnore
    public odata.msgraph.client.beta.entity.request.UnifiedRoleAssignmentScheduleRequest getTargetSchedule() {
        return new odata.msgraph.client.beta.entity.request.UnifiedRoleAssignmentScheduleRequest(contextPath.addSegment("targetSchedule"), RequestHelper.getValue(unmappedFields, "targetSchedule"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignmentScheduleRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignmentScheduleRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignmentScheduleRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleAssignmentScheduleRequest _copy() {
        UnifiedRoleAssignmentScheduleRequest _x = new UnifiedRoleAssignmentScheduleRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.approvalId = approvalId;
        _x.completedDateTime = completedDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.customData = customData;
        _x.status = status;
        _x.action = action;
        _x.appScopeId = appScopeId;
        _x.directoryScopeId = directoryScopeId;
        _x.isValidationOnly = isValidationOnly;
        _x.justification = justification;
        _x.principalId = principalId;
        _x.roleDefinitionId = roleDefinitionId;
        _x.scheduleInfo = scheduleInfo;
        _x.targetScheduleId = targetScheduleId;
        _x.ticketInfo = ticketInfo;
        return _x;
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleAssignmentScheduleRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("approvalId=");
        b.append(this.approvalId);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("customData=");
        b.append(this.customData);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("appScopeId=");
        b.append(this.appScopeId);
        b.append(", ");
        b.append("directoryScopeId=");
        b.append(this.directoryScopeId);
        b.append(", ");
        b.append("isValidationOnly=");
        b.append(this.isValidationOnly);
        b.append(", ");
        b.append("justification=");
        b.append(this.justification);
        b.append(", ");
        b.append("principalId=");
        b.append(this.principalId);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("scheduleInfo=");
        b.append(this.scheduleInfo);
        b.append(", ");
        b.append("targetScheduleId=");
        b.append(this.targetScheduleId);
        b.append(", ");
        b.append("ticketInfo=");
        b.append(this.ticketInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
