package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AppScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleDefinitionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "appScopeIds", 
    "condition", 
    "description", 
    "directoryScopeIds", 
    "displayName", 
    "principalIds", 
    "roleDefinitionId", 
    "appScopes"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleAssignmentMultiple extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleAssignmentMultiple";
    }

    @JsonProperty("appScopeIds")
    protected List<String> appScopeIds;

    @JsonProperty("appScopeIds@nextLink")
    protected String appScopeIdsNextLink;

    @JsonProperty("condition")
    protected String condition;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("directoryScopeIds")
    protected List<String> directoryScopeIds;

    @JsonProperty("directoryScopeIds@nextLink")
    protected String directoryScopeIdsNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("principalIds")
    protected List<String> principalIds;

    @JsonProperty("principalIds@nextLink")
    protected String principalIdsNextLink;

    @JsonProperty("roleDefinitionId")
    protected String roleDefinitionId;

    @JsonProperty("appScopes")
    protected List<AppScope> appScopes;

    protected UnifiedRoleAssignmentMultiple() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleAssignmentMultiple() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> appScopeIds;
        private String appScopeIdsNextLink;
        private String condition;
        private String description;
        private List<String> directoryScopeIds;
        private String directoryScopeIdsNextLink;
        private String displayName;
        private List<String> principalIds;
        private String principalIdsNextLink;
        private String roleDefinitionId;
        private List<AppScope> appScopes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appScopeIds(List<String> appScopeIds) {
            this.appScopeIds = appScopeIds;
            this.changedFields = changedFields.add("appScopeIds");
            return this;
        }

        public Builder appScopeIds(String... appScopeIds) {
            return appScopeIds(Arrays.asList(appScopeIds));
        }

        public Builder appScopeIdsNextLink(String appScopeIdsNextLink) {
            this.appScopeIdsNextLink = appScopeIdsNextLink;
            this.changedFields = changedFields.add("appScopeIds");
            return this;
        }

        public Builder condition(String condition) {
            this.condition = condition;
            this.changedFields = changedFields.add("condition");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder directoryScopeIds(List<String> directoryScopeIds) {
            this.directoryScopeIds = directoryScopeIds;
            this.changedFields = changedFields.add("directoryScopeIds");
            return this;
        }

        public Builder directoryScopeIds(String... directoryScopeIds) {
            return directoryScopeIds(Arrays.asList(directoryScopeIds));
        }

        public Builder directoryScopeIdsNextLink(String directoryScopeIdsNextLink) {
            this.directoryScopeIdsNextLink = directoryScopeIdsNextLink;
            this.changedFields = changedFields.add("directoryScopeIds");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder principalIds(List<String> principalIds) {
            this.principalIds = principalIds;
            this.changedFields = changedFields.add("principalIds");
            return this;
        }

        public Builder principalIds(String... principalIds) {
            return principalIds(Arrays.asList(principalIds));
        }

        public Builder principalIdsNextLink(String principalIdsNextLink) {
            this.principalIdsNextLink = principalIdsNextLink;
            this.changedFields = changedFields.add("principalIds");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder appScopes(List<AppScope> appScopes) {
            this.appScopes = appScopes;
            this.changedFields = changedFields.add("appScopes");
            return this;
        }

        public Builder appScopes(AppScope... appScopes) {
            return appScopes(Arrays.asList(appScopes));
        }

        public UnifiedRoleAssignmentMultiple build() {
            UnifiedRoleAssignmentMultiple _x = new UnifiedRoleAssignmentMultiple();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleAssignmentMultiple";
            _x.id = id;
            _x.appScopeIds = appScopeIds;
            _x.appScopeIdsNextLink = appScopeIdsNextLink;
            _x.condition = condition;
            _x.description = description;
            _x.directoryScopeIds = directoryScopeIds;
            _x.directoryScopeIdsNextLink = directoryScopeIdsNextLink;
            _x.displayName = displayName;
            _x.principalIds = principalIds;
            _x.principalIdsNextLink = principalIdsNextLink;
            _x.roleDefinitionId = roleDefinitionId;
            _x.appScopes = appScopes;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="appScopeIds")
    @JsonIgnore
    public CollectionPage<String> getAppScopeIds() {
        return new CollectionPage<String>(contextPath, String.class, this.appScopeIds, Optional.ofNullable(appScopeIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public UnifiedRoleAssignmentMultiple withAppScopeIds(List<String> appScopeIds) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("appScopeIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.appScopeIds = appScopeIds;
        return _x;
    }

    @Property(name="appScopeIds")
    @JsonIgnore
    public CollectionPage<String> getAppScopeIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.appScopeIds, Optional.ofNullable(appScopeIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="condition")
    @JsonIgnore
    public Optional<String> getCondition() {
        return Optional.ofNullable(condition);
    }

    public UnifiedRoleAssignmentMultiple withCondition(String condition) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("condition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.condition = condition;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public UnifiedRoleAssignmentMultiple withDescription(String description) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.description = description;
        return _x;
    }

    @Property(name="directoryScopeIds")
    @JsonIgnore
    public CollectionPage<String> getDirectoryScopeIds() {
        return new CollectionPage<String>(contextPath, String.class, this.directoryScopeIds, Optional.ofNullable(directoryScopeIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public UnifiedRoleAssignmentMultiple withDirectoryScopeIds(List<String> directoryScopeIds) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("directoryScopeIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.directoryScopeIds = directoryScopeIds;
        return _x;
    }

    @Property(name="directoryScopeIds")
    @JsonIgnore
    public CollectionPage<String> getDirectoryScopeIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.directoryScopeIds, Optional.ofNullable(directoryScopeIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public UnifiedRoleAssignmentMultiple withDisplayName(String displayName) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="principalIds")
    @JsonIgnore
    public CollectionPage<String> getPrincipalIds() {
        return new CollectionPage<String>(contextPath, String.class, this.principalIds, Optional.ofNullable(principalIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public UnifiedRoleAssignmentMultiple withPrincipalIds(List<String> principalIds) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("principalIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.principalIds = principalIds;
        return _x;
    }

    @Property(name="principalIds")
    @JsonIgnore
    public CollectionPage<String> getPrincipalIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.principalIds, Optional.ofNullable(principalIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="roleDefinitionId")
    @JsonIgnore
    public Optional<String> getRoleDefinitionId() {
        return Optional.ofNullable(roleDefinitionId);
    }

    public UnifiedRoleAssignmentMultiple withRoleDefinitionId(String roleDefinitionId) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.roleDefinitionId = roleDefinitionId;
        return _x;
    }

    public UnifiedRoleAssignmentMultiple withUnmappedField(String name, Object value) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appScopes")
    @JsonIgnore
    public AppScopeCollectionRequest getAppScopes() {
        return new AppScopeCollectionRequest(
                        contextPath.addSegment("appScopes"), Optional.ofNullable(appScopes));
    }

    @NavigationProperty(name="directoryScopes")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getDirectoryScopes() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("directoryScopes"), RequestHelper.getValue(unmappedFields, "directoryScopes"));
    }

    @NavigationProperty(name="principals")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getPrincipals() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("principals"), RequestHelper.getValue(unmappedFields, "principals"));
    }

    @NavigationProperty(name="roleDefinition")
    @JsonIgnore
    public UnifiedRoleDefinitionRequest getRoleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), RequestHelper.getValue(unmappedFields, "roleDefinition"));
    }

    public UnifiedRoleAssignmentMultiple withAppScopes(List<AppScope> appScopes) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("appScopes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.appScopes = appScopes;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignmentMultiple patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignmentMultiple put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleAssignmentMultiple _copy() {
        UnifiedRoleAssignmentMultiple _x = new UnifiedRoleAssignmentMultiple();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appScopeIds = appScopeIds;
        _x.condition = condition;
        _x.description = description;
        _x.directoryScopeIds = directoryScopeIds;
        _x.displayName = displayName;
        _x.principalIds = principalIds;
        _x.roleDefinitionId = roleDefinitionId;
        _x.appScopes = appScopes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleAssignmentMultiple[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appScopeIds=");
        b.append(this.appScopeIds);
        b.append(", ");
        b.append("condition=");
        b.append(this.condition);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("directoryScopeIds=");
        b.append(this.directoryScopeIds);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("principalIds=");
        b.append(this.principalIds);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("appScopes=");
        b.append(this.appScopes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
