package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.UnifiedRbacResourceActionCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "resourceActions"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRbacResourceNamespace extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRbacResourceNamespace";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("resourceActions")
    protected List<UnifiedRbacResourceAction> resourceActions;

    protected UnifiedRbacResourceNamespace() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRbacResourceNamespace() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private List<UnifiedRbacResourceAction> resourceActions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder resourceActions(List<UnifiedRbacResourceAction> resourceActions) {
            this.resourceActions = resourceActions;
            this.changedFields = changedFields.add("resourceActions");
            return this;
        }

        public Builder resourceActions(UnifiedRbacResourceAction... resourceActions) {
            return resourceActions(Arrays.asList(resourceActions));
        }

        public UnifiedRbacResourceNamespace build() {
            UnifiedRbacResourceNamespace _x = new UnifiedRbacResourceNamespace();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRbacResourceNamespace";
            _x.id = id;
            _x.name = name;
            _x.resourceActions = resourceActions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public UnifiedRbacResourceNamespace withName(String name) {
        UnifiedRbacResourceNamespace _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRbacResourceNamespace");
        _x.name = name;
        return _x;
    }

    public UnifiedRbacResourceNamespace withUnmappedField(String name, Object value) {
        UnifiedRbacResourceNamespace _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="resourceActions")
    @JsonIgnore
    public UnifiedRbacResourceActionCollectionRequest getResourceActions() {
        return new UnifiedRbacResourceActionCollectionRequest(
                        contextPath.addSegment("resourceActions"), Optional.ofNullable(resourceActions));
    }

    public UnifiedRbacResourceNamespace withResourceActions(List<UnifiedRbacResourceAction> resourceActions) {
        UnifiedRbacResourceNamespace _x = _copy();
        _x.changedFields = changedFields.add("resourceActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRbacResourceNamespace");
        _x.resourceActions = resourceActions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRbacResourceNamespace patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRbacResourceNamespace _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRbacResourceNamespace put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRbacResourceNamespace _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRbacResourceNamespace _copy() {
        UnifiedRbacResourceNamespace _x = new UnifiedRbacResourceNamespace();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.resourceActions = resourceActions;
        return _x;
    }

    @Action(name = "importResourceActions")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UnifiedRbacResourceNamespace> importResourceActions(String format, String value, Boolean overwriteResourceNamespace) {
        Preconditions.checkNotNull(format, "format cannot be null");
        Preconditions.checkNotNull(value, "value cannot be null");
        Preconditions.checkNotNull(overwriteResourceNamespace, "overwriteResourceNamespace cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("format", "Edm.String", Checks.checkIsAscii(format))
            .put("value", "Edm.String", Checks.checkIsAscii(value))
            .put("overwriteResourceNamespace", "Edm.Boolean", overwriteResourceNamespace)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UnifiedRbacResourceNamespace>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.importResourceActions"), UnifiedRbacResourceNamespace.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRbacResourceNamespace[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("resourceActions=");
        b.append(this.resourceActions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
