package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.UnifiedRbacResourceScopeRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "actionVerb", 
    "description", 
    "name", 
    "resourceScopeId", 
    "resourceScope"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRbacResourceAction extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRbacResourceAction";
    }

    @JsonProperty("actionVerb")
    protected String actionVerb;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("resourceScopeId")
    protected String resourceScopeId;

    @JsonProperty("resourceScope")
    protected UnifiedRbacResourceScope resourceScope;

    protected UnifiedRbacResourceAction() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRbacResourceAction() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String actionVerb;
        private String description;
        private String name;
        private String resourceScopeId;
        private UnifiedRbacResourceScope resourceScope;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder actionVerb(String actionVerb) {
            this.actionVerb = actionVerb;
            this.changedFields = changedFields.add("actionVerb");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder resourceScopeId(String resourceScopeId) {
            this.resourceScopeId = resourceScopeId;
            this.changedFields = changedFields.add("resourceScopeId");
            return this;
        }

        public Builder resourceScope(UnifiedRbacResourceScope resourceScope) {
            this.resourceScope = resourceScope;
            this.changedFields = changedFields.add("resourceScope");
            return this;
        }

        public UnifiedRbacResourceAction build() {
            UnifiedRbacResourceAction _x = new UnifiedRbacResourceAction();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRbacResourceAction";
            _x.id = id;
            _x.actionVerb = actionVerb;
            _x.description = description;
            _x.name = name;
            _x.resourceScopeId = resourceScopeId;
            _x.resourceScope = resourceScope;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="actionVerb")
    @JsonIgnore
    public Optional<String> getActionVerb() {
        return Optional.ofNullable(actionVerb);
    }

    public UnifiedRbacResourceAction withActionVerb(String actionVerb) {
        UnifiedRbacResourceAction _x = _copy();
        _x.changedFields = changedFields.add("actionVerb");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRbacResourceAction");
        _x.actionVerb = actionVerb;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public UnifiedRbacResourceAction withDescription(String description) {
        UnifiedRbacResourceAction _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRbacResourceAction");
        _x.description = description;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public UnifiedRbacResourceAction withName(String name) {
        UnifiedRbacResourceAction _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRbacResourceAction");
        _x.name = name;
        return _x;
    }

    @Property(name="resourceScopeId")
    @JsonIgnore
    public Optional<String> getResourceScopeId() {
        return Optional.ofNullable(resourceScopeId);
    }

    public UnifiedRbacResourceAction withResourceScopeId(String resourceScopeId) {
        UnifiedRbacResourceAction _x = _copy();
        _x.changedFields = changedFields.add("resourceScopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRbacResourceAction");
        _x.resourceScopeId = resourceScopeId;
        return _x;
    }

    public UnifiedRbacResourceAction withUnmappedField(String name, Object value) {
        UnifiedRbacResourceAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="resourceScope")
    @JsonIgnore
    public UnifiedRbacResourceScopeRequest getResourceScope() {
        return new UnifiedRbacResourceScopeRequest(contextPath.addSegment("resourceScope"), Optional.ofNullable(resourceScope));
    }

    public UnifiedRbacResourceAction withResourceScope(UnifiedRbacResourceScope resourceScope) {
        UnifiedRbacResourceAction _x = _copy();
        _x.changedFields = changedFields.add("resourceScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRbacResourceAction");
        _x.resourceScope = resourceScope;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRbacResourceAction patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRbacResourceAction _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRbacResourceAction put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRbacResourceAction _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRbacResourceAction _copy() {
        UnifiedRbacResourceAction _x = new UnifiedRbacResourceAction();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.actionVerb = actionVerb;
        _x.description = description;
        _x.name = name;
        _x.resourceScopeId = resourceScopeId;
        _x.resourceScope = resourceScope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRbacResourceAction[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("actionVerb=");
        b.append(this.actionVerb);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("resourceScopeId=");
        b.append(this.resourceScopeId);
        b.append(", ");
        b.append("resourceScope=");
        b.append(this.resourceScope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
