package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.TrustFrameworkKeySetCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TrustFrameworkPolicyCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "keySets", 
    "policies"})
@JsonInclude(Include.NON_NULL)
public class TrustFramework implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.trustFramework";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("keySets")
    protected List<TrustFrameworkKeySet> keySets;

    @JsonProperty("policies")
    protected List<TrustFrameworkPolicy> policies;

    protected TrustFramework() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<TrustFrameworkKeySet> keySets;
        private List<TrustFrameworkPolicy> policies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder keySets(List<TrustFrameworkKeySet> keySets) {
            this.keySets = keySets;
            this.changedFields = changedFields.add("keySets");
            return this;
        }

        public Builder keySets(TrustFrameworkKeySet... keySets) {
            return keySets(Arrays.asList(keySets));
        }

        public Builder policies(List<TrustFrameworkPolicy> policies) {
            this.policies = policies;
            this.changedFields = changedFields.add("policies");
            return this;
        }

        public Builder policies(TrustFrameworkPolicy... policies) {
            return policies(Arrays.asList(policies));
        }

        public TrustFramework build() {
            TrustFramework _x = new TrustFramework();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.trustFramework";
            _x.keySets = keySets;
            _x.policies = policies;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public TrustFramework withUnmappedField(String name, Object value) {
        TrustFramework _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="keySets")
    @JsonIgnore
    public TrustFrameworkKeySetCollectionRequest getKeySets() {
        return new TrustFrameworkKeySetCollectionRequest(
                        contextPath.addSegment("keySets"), Optional.ofNullable(keySets));
    }

    @NavigationProperty(name="policies")
    @JsonIgnore
    public TrustFrameworkPolicyCollectionRequest getPolicies() {
        return new TrustFrameworkPolicyCollectionRequest(
                        contextPath.addSegment("policies"), Optional.ofNullable(policies));
    }

    public TrustFramework withKeySets(List<TrustFrameworkKeySet> keySets) {
        TrustFramework _x = _copy();
        _x.changedFields = changedFields.add("keySets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFramework");
        _x.keySets = keySets;
        return _x;
    }

    public TrustFramework withPolicies(List<TrustFrameworkPolicy> policies) {
        TrustFramework _x = _copy();
        _x.changedFields = changedFields.add("policies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFramework");
        _x.policies = policies;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TrustFramework patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TrustFramework _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TrustFramework put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TrustFramework _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TrustFramework _copy() {
        TrustFramework _x = new TrustFramework();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.keySets = keySets;
        _x.policies = policies;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TrustFramework[");
        b.append("keySets=");
        b.append(this.keySets);
        b.append(", ");
        b.append("policies=");
        b.append(this.policies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
