package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DateTimeTimeZone;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.PatternedRecurrence;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LinkedResourceCollectionRequest;
import odata.msgraph.client.beta.enums.Importance;
import odata.msgraph.client.beta.enums.TaskStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "body", 
    "bodyLastModifiedDateTime", 
    "completedDateTime", 
    "createdDateTime", 
    "dueDateTime", 
    "importance", 
    "isReminderOn", 
    "lastModifiedDateTime", 
    "recurrence", 
    "reminderDateTime", 
    "status", 
    "title", 
    "extensions", 
    "linkedResources"})
@JsonInclude(Include.NON_NULL)
public class TodoTask extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.todoTask";
    }

    @JsonProperty("body")
    protected ItemBody body;

    @JsonProperty("bodyLastModifiedDateTime")
    protected OffsetDateTime bodyLastModifiedDateTime;

    @JsonProperty("completedDateTime")
    protected DateTimeTimeZone completedDateTime;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("dueDateTime")
    protected DateTimeTimeZone dueDateTime;

    @JsonProperty("importance")
    protected Importance importance;

    @JsonProperty("isReminderOn")
    protected Boolean isReminderOn;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("recurrence")
    protected PatternedRecurrence recurrence;

    @JsonProperty("reminderDateTime")
    protected DateTimeTimeZone reminderDateTime;

    @JsonProperty("status")
    protected TaskStatus status;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("extensions")
    protected List<Extension> extensions;

    @JsonProperty("linkedResources")
    protected List<LinkedResource> linkedResources;

    protected TodoTask() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTodoTask() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ItemBody body;
        private OffsetDateTime bodyLastModifiedDateTime;
        private DateTimeTimeZone completedDateTime;
        private OffsetDateTime createdDateTime;
        private DateTimeTimeZone dueDateTime;
        private Importance importance;
        private Boolean isReminderOn;
        private OffsetDateTime lastModifiedDateTime;
        private PatternedRecurrence recurrence;
        private DateTimeTimeZone reminderDateTime;
        private TaskStatus status;
        private String title;
        private List<Extension> extensions;
        private List<LinkedResource> linkedResources;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder body(ItemBody body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder bodyLastModifiedDateTime(OffsetDateTime bodyLastModifiedDateTime) {
            this.bodyLastModifiedDateTime = bodyLastModifiedDateTime;
            this.changedFields = changedFields.add("bodyLastModifiedDateTime");
            return this;
        }

        public Builder completedDateTime(DateTimeTimeZone completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dueDateTime(DateTimeTimeZone dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        public Builder importance(Importance importance) {
            this.importance = importance;
            this.changedFields = changedFields.add("importance");
            return this;
        }

        public Builder isReminderOn(Boolean isReminderOn) {
            this.isReminderOn = isReminderOn;
            this.changedFields = changedFields.add("isReminderOn");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder recurrence(PatternedRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        public Builder reminderDateTime(DateTimeTimeZone reminderDateTime) {
            this.reminderDateTime = reminderDateTime;
            this.changedFields = changedFields.add("reminderDateTime");
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder extensions(List<Extension> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        public Builder extensions(Extension... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        public Builder linkedResources(List<LinkedResource> linkedResources) {
            this.linkedResources = linkedResources;
            this.changedFields = changedFields.add("linkedResources");
            return this;
        }

        public Builder linkedResources(LinkedResource... linkedResources) {
            return linkedResources(Arrays.asList(linkedResources));
        }

        public TodoTask build() {
            TodoTask _x = new TodoTask();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.todoTask";
            _x.id = id;
            _x.body = body;
            _x.bodyLastModifiedDateTime = bodyLastModifiedDateTime;
            _x.completedDateTime = completedDateTime;
            _x.createdDateTime = createdDateTime;
            _x.dueDateTime = dueDateTime;
            _x.importance = importance;
            _x.isReminderOn = isReminderOn;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.recurrence = recurrence;
            _x.reminderDateTime = reminderDateTime;
            _x.status = status;
            _x.title = title;
            _x.extensions = extensions;
            _x.linkedResources = linkedResources;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<ItemBody> getBody() {
        return Optional.ofNullable(body);
    }

    public TodoTask withBody(ItemBody body) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.body = body;
        return _x;
    }

    @Property(name="bodyLastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getBodyLastModifiedDateTime() {
        return Optional.ofNullable(bodyLastModifiedDateTime);
    }

    public TodoTask withBodyLastModifiedDateTime(OffsetDateTime bodyLastModifiedDateTime) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("bodyLastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.bodyLastModifiedDateTime = bodyLastModifiedDateTime;
        return _x;
    }

    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    public TodoTask withCompletedDateTime(DateTimeTimeZone completedDateTime) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("completedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public TodoTask withCreatedDateTime(OffsetDateTime createdDateTime) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="dueDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getDueDateTime() {
        return Optional.ofNullable(dueDateTime);
    }

    public TodoTask withDueDateTime(DateTimeTimeZone dueDateTime) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("dueDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.dueDateTime = dueDateTime;
        return _x;
    }

    @Property(name="importance")
    @JsonIgnore
    public Optional<Importance> getImportance() {
        return Optional.ofNullable(importance);
    }

    public TodoTask withImportance(Importance importance) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("importance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.importance = importance;
        return _x;
    }

    @Property(name="isReminderOn")
    @JsonIgnore
    public Optional<Boolean> getIsReminderOn() {
        return Optional.ofNullable(isReminderOn);
    }

    public TodoTask withIsReminderOn(Boolean isReminderOn) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("isReminderOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.isReminderOn = isReminderOn;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public TodoTask withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="recurrence")
    @JsonIgnore
    public Optional<PatternedRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    public TodoTask withRecurrence(PatternedRecurrence recurrence) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("recurrence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.recurrence = recurrence;
        return _x;
    }

    @Property(name="reminderDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getReminderDateTime() {
        return Optional.ofNullable(reminderDateTime);
    }

    public TodoTask withReminderDateTime(DateTimeTimeZone reminderDateTime) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("reminderDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.reminderDateTime = reminderDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<TaskStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public TodoTask withStatus(TaskStatus status) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.status = status;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public TodoTask withTitle(String title) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.title = title;
        return _x;
    }

    public TodoTask withUnmappedField(String name, Object value) {
        TodoTask _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.ofNullable(extensions));
    }

    @NavigationProperty(name="linkedResources")
    @JsonIgnore
    public LinkedResourceCollectionRequest getLinkedResources() {
        return new LinkedResourceCollectionRequest(
                        contextPath.addSegment("linkedResources"), Optional.ofNullable(linkedResources));
    }

    public TodoTask withExtensions(List<Extension> extensions) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("extensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.extensions = extensions;
        return _x;
    }

    public TodoTask withLinkedResources(List<LinkedResource> linkedResources) {
        TodoTask _x = _copy();
        _x.changedFields = changedFields.add("linkedResources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTask");
        _x.linkedResources = linkedResources;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TodoTask patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TodoTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TodoTask put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TodoTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TodoTask _copy() {
        TodoTask _x = new TodoTask();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.body = body;
        _x.bodyLastModifiedDateTime = bodyLastModifiedDateTime;
        _x.completedDateTime = completedDateTime;
        _x.createdDateTime = createdDateTime;
        _x.dueDateTime = dueDateTime;
        _x.importance = importance;
        _x.isReminderOn = isReminderOn;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.recurrence = recurrence;
        _x.reminderDateTime = reminderDateTime;
        _x.status = status;
        _x.title = title;
        _x.extensions = extensions;
        _x.linkedResources = linkedResources;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TodoTask[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("bodyLastModifiedDateTime=");
        b.append(this.bodyLastModifiedDateTime);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("isReminderOn=");
        b.append(this.isReminderOn);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("reminderDateTime=");
        b.append(this.reminderDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("linkedResources=");
        b.append(this.linkedResources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
