package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.TimeCardBreak;
import odata.msgraph.client.beta.complex.TimeCardEntry;
import odata.msgraph.client.beta.complex.TimeCardEvent;
import odata.msgraph.client.beta.enums.ConfirmedBy;
import odata.msgraph.client.beta.enums.TimeCardState;

@JsonPropertyOrder({
    "@odata.type", 
    "breaks", 
    "clockInEvent", 
    "clockOutEvent", 
    "confirmedBy", 
    "notes", 
    "originalEntry", 
    "state", 
    "userId"})
@JsonInclude(Include.NON_NULL)
public class TimeCard extends ChangeTrackedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeCard";
    }

    @JsonProperty("breaks")
    protected List<TimeCardBreak> breaks;

    @JsonProperty("breaks@nextLink")
    protected String breaksNextLink;

    @JsonProperty("clockInEvent")
    protected TimeCardEvent clockInEvent;

    @JsonProperty("clockOutEvent")
    protected TimeCardEvent clockOutEvent;

    @JsonProperty("confirmedBy")
    protected ConfirmedBy confirmedBy;

    @JsonProperty("notes")
    protected ItemBody notes;

    @JsonProperty("originalEntry")
    protected TimeCardEntry originalEntry;

    @JsonProperty("state")
    protected TimeCardState state;

    @JsonProperty("userId")
    protected String userId;

    protected TimeCard() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTimeCard() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private List<TimeCardBreak> breaks;
        private String breaksNextLink;
        private TimeCardEvent clockInEvent;
        private TimeCardEvent clockOutEvent;
        private ConfirmedBy confirmedBy;
        private ItemBody notes;
        private TimeCardEntry originalEntry;
        private TimeCardState state;
        private String userId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder breaks(List<TimeCardBreak> breaks) {
            this.breaks = breaks;
            this.changedFields = changedFields.add("breaks");
            return this;
        }

        public Builder breaks(TimeCardBreak... breaks) {
            return breaks(Arrays.asList(breaks));
        }

        public Builder breaksNextLink(String breaksNextLink) {
            this.breaksNextLink = breaksNextLink;
            this.changedFields = changedFields.add("breaks");
            return this;
        }

        public Builder clockInEvent(TimeCardEvent clockInEvent) {
            this.clockInEvent = clockInEvent;
            this.changedFields = changedFields.add("clockInEvent");
            return this;
        }

        public Builder clockOutEvent(TimeCardEvent clockOutEvent) {
            this.clockOutEvent = clockOutEvent;
            this.changedFields = changedFields.add("clockOutEvent");
            return this;
        }

        public Builder confirmedBy(ConfirmedBy confirmedBy) {
            this.confirmedBy = confirmedBy;
            this.changedFields = changedFields.add("confirmedBy");
            return this;
        }

        public Builder notes(ItemBody notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder originalEntry(TimeCardEntry originalEntry) {
            this.originalEntry = originalEntry;
            this.changedFields = changedFields.add("originalEntry");
            return this;
        }

        public Builder state(TimeCardState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public TimeCard build() {
            TimeCard _x = new TimeCard();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.timeCard";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.breaks = breaks;
            _x.breaksNextLink = breaksNextLink;
            _x.clockInEvent = clockInEvent;
            _x.clockOutEvent = clockOutEvent;
            _x.confirmedBy = confirmedBy;
            _x.notes = notes;
            _x.originalEntry = originalEntry;
            _x.state = state;
            _x.userId = userId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="breaks")
    @JsonIgnore
    public CollectionPage<TimeCardBreak> getBreaks() {
        return new CollectionPage<TimeCardBreak>(contextPath, TimeCardBreak.class, this.breaks, Optional.ofNullable(breaksNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TimeCard withBreaks(List<TimeCardBreak> breaks) {
        TimeCard _x = _copy();
        _x.changedFields = changedFields.add("breaks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCard");
        _x.breaks = breaks;
        return _x;
    }

    @Property(name="breaks")
    @JsonIgnore
    public CollectionPage<TimeCardBreak> getBreaks(HttpRequestOptions options) {
        return new CollectionPage<TimeCardBreak>(contextPath, TimeCardBreak.class, this.breaks, Optional.ofNullable(breaksNextLink), Collections.emptyList(), options);
    }

    @Property(name="clockInEvent")
    @JsonIgnore
    public Optional<TimeCardEvent> getClockInEvent() {
        return Optional.ofNullable(clockInEvent);
    }

    public TimeCard withClockInEvent(TimeCardEvent clockInEvent) {
        TimeCard _x = _copy();
        _x.changedFields = changedFields.add("clockInEvent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCard");
        _x.clockInEvent = clockInEvent;
        return _x;
    }

    @Property(name="clockOutEvent")
    @JsonIgnore
    public Optional<TimeCardEvent> getClockOutEvent() {
        return Optional.ofNullable(clockOutEvent);
    }

    public TimeCard withClockOutEvent(TimeCardEvent clockOutEvent) {
        TimeCard _x = _copy();
        _x.changedFields = changedFields.add("clockOutEvent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCard");
        _x.clockOutEvent = clockOutEvent;
        return _x;
    }

    @Property(name="confirmedBy")
    @JsonIgnore
    public Optional<ConfirmedBy> getConfirmedBy() {
        return Optional.ofNullable(confirmedBy);
    }

    public TimeCard withConfirmedBy(ConfirmedBy confirmedBy) {
        TimeCard _x = _copy();
        _x.changedFields = changedFields.add("confirmedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCard");
        _x.confirmedBy = confirmedBy;
        return _x;
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<ItemBody> getNotes() {
        return Optional.ofNullable(notes);
    }

    public TimeCard withNotes(ItemBody notes) {
        TimeCard _x = _copy();
        _x.changedFields = changedFields.add("notes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCard");
        _x.notes = notes;
        return _x;
    }

    @Property(name="originalEntry")
    @JsonIgnore
    public Optional<TimeCardEntry> getOriginalEntry() {
        return Optional.ofNullable(originalEntry);
    }

    public TimeCard withOriginalEntry(TimeCardEntry originalEntry) {
        TimeCard _x = _copy();
        _x.changedFields = changedFields.add("originalEntry");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCard");
        _x.originalEntry = originalEntry;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<TimeCardState> getState() {
        return Optional.ofNullable(state);
    }

    public TimeCard withState(TimeCardState state) {
        TimeCard _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCard");
        _x.state = state;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public TimeCard withUserId(String userId) {
        TimeCard _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCard");
        _x.userId = userId;
        return _x;
    }

    public TimeCard withUnmappedField(String name, Object value) {
        TimeCard _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TimeCard patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TimeCard _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TimeCard put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TimeCard _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TimeCard _copy() {
        TimeCard _x = new TimeCard();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.breaks = breaks;
        _x.clockInEvent = clockInEvent;
        _x.clockOutEvent = clockOutEvent;
        _x.confirmedBy = confirmedBy;
        _x.notes = notes;
        _x.originalEntry = originalEntry;
        _x.state = state;
        _x.userId = userId;
        return _x;
    }

    @Action(name = "clockOut")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TimeCard> clockOut(Boolean atApprovedLocation, ItemBody notes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("atApprovedLocation", "Edm.Boolean", atApprovedLocation)
            .put("notes", "microsoft.graph.itemBody", notes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TimeCard>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clockOut"), TimeCard.class, _parameters);
    }

    @Action(name = "confirm")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TimeCard> confirm() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<TimeCard>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.confirm"), TimeCard.class, _parameters);
    }

    @Action(name = "endBreak")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TimeCard> endBreak(Boolean atApprovedLocation, ItemBody notes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("atApprovedLocation", "Edm.Boolean", atApprovedLocation)
            .put("notes", "microsoft.graph.itemBody", notes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TimeCard>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.endBreak"), TimeCard.class, _parameters);
    }

    @Action(name = "startBreak")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TimeCard> startBreak(Boolean atApprovedLocation, ItemBody notes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("atApprovedLocation", "Edm.Boolean", atApprovedLocation)
            .put("notes", "microsoft.graph.itemBody", notes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TimeCard>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.startBreak"), TimeCard.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeCard[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("breaks=");
        b.append(this.breaks);
        b.append(", ");
        b.append("clockInEvent=");
        b.append(this.clockInEvent);
        b.append(", ");
        b.append("clockOutEvent=");
        b.append(this.clockOutEvent);
        b.append(", ");
        b.append("confirmedBy=");
        b.append(this.confirmedBy);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("originalEntry=");
        b.append(this.originalEntry);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
