package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DiamondModel;
import odata.msgraph.client.beta.enums.FileHashType;
import odata.msgraph.client.beta.enums.TiAction;
import odata.msgraph.client.beta.enums.TlpLevel;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "action", 
    "activityGroupNames", 
    "additionalInformation", 
    "azureTenantId", 
    "confidence", 
    "description", 
    "diamondModel", 
    "domainName", 
    "emailEncoding", 
    "emailLanguage", 
    "emailRecipient", 
    "emailSenderAddress", 
    "emailSenderName", 
    "emailSourceDomain", 
    "emailSourceIpAddress", 
    "emailSubject", 
    "emailXMailer", 
    "expirationDateTime", 
    "externalId", 
    "fileCompileDateTime", 
    "fileCreatedDateTime", 
    "fileHashType", 
    "fileHashValue", 
    "fileMutexName", 
    "fileName", 
    "filePacker", 
    "filePath", 
    "fileSize", 
    "fileType", 
    "ingestedDateTime", 
    "isActive", 
    "killChain", 
    "knownFalsePositives", 
    "lastReportedDateTime", 
    "malwareFamilyNames", 
    "networkCidrBlock", 
    "networkDestinationAsn", 
    "networkDestinationCidrBlock", 
    "networkDestinationIPv4", 
    "networkDestinationIPv6", 
    "networkDestinationPort", 
    "networkIPv4", 
    "networkIPv6", 
    "networkPort", 
    "networkProtocol", 
    "networkSourceAsn", 
    "networkSourceCidrBlock", 
    "networkSourceIPv4", 
    "networkSourceIPv6", 
    "networkSourcePort", 
    "passiveOnly", 
    "severity", 
    "tags", 
    "targetProduct", 
    "threatType", 
    "tlpLevel", 
    "url", 
    "userAgent"})
@JsonInclude(Include.NON_NULL)
public class TiIndicator extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.tiIndicator";
    }

    @JsonProperty("action")
    protected TiAction action;

    @JsonProperty("activityGroupNames")
    protected List<String> activityGroupNames;

    @JsonProperty("activityGroupNames@nextLink")
    protected String activityGroupNamesNextLink;

    @JsonProperty("additionalInformation")
    protected String additionalInformation;

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("confidence")
    protected Integer confidence;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("diamondModel")
    protected DiamondModel diamondModel;

    @JsonProperty("domainName")
    protected String domainName;

    @JsonProperty("emailEncoding")
    protected String emailEncoding;

    @JsonProperty("emailLanguage")
    protected String emailLanguage;

    @JsonProperty("emailRecipient")
    protected String emailRecipient;

    @JsonProperty("emailSenderAddress")
    protected String emailSenderAddress;

    @JsonProperty("emailSenderName")
    protected String emailSenderName;

    @JsonProperty("emailSourceDomain")
    protected String emailSourceDomain;

    @JsonProperty("emailSourceIpAddress")
    protected String emailSourceIpAddress;

    @JsonProperty("emailSubject")
    protected String emailSubject;

    @JsonProperty("emailXMailer")
    protected String emailXMailer;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("fileCompileDateTime")
    protected OffsetDateTime fileCompileDateTime;

    @JsonProperty("fileCreatedDateTime")
    protected OffsetDateTime fileCreatedDateTime;

    @JsonProperty("fileHashType")
    protected FileHashType fileHashType;

    @JsonProperty("fileHashValue")
    protected String fileHashValue;

    @JsonProperty("fileMutexName")
    protected String fileMutexName;

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("filePacker")
    protected String filePacker;

    @JsonProperty("filePath")
    protected String filePath;

    @JsonProperty("fileSize")
    protected Long fileSize;

    @JsonProperty("fileType")
    protected String fileType;

    @JsonProperty("ingestedDateTime")
    protected OffsetDateTime ingestedDateTime;

    @JsonProperty("isActive")
    protected Boolean isActive;

    @JsonProperty("killChain")
    protected List<String> killChain;

    @JsonProperty("killChain@nextLink")
    protected String killChainNextLink;

    @JsonProperty("knownFalsePositives")
    protected String knownFalsePositives;

    @JsonProperty("lastReportedDateTime")
    protected OffsetDateTime lastReportedDateTime;

    @JsonProperty("malwareFamilyNames")
    protected List<String> malwareFamilyNames;

    @JsonProperty("malwareFamilyNames@nextLink")
    protected String malwareFamilyNamesNextLink;

    @JsonProperty("networkCidrBlock")
    protected String networkCidrBlock;

    @JsonProperty("networkDestinationAsn")
    protected Long networkDestinationAsn;

    @JsonProperty("networkDestinationCidrBlock")
    protected String networkDestinationCidrBlock;

    @JsonProperty("networkDestinationIPv4")
    protected String networkDestinationIPv4;

    @JsonProperty("networkDestinationIPv6")
    protected String networkDestinationIPv6;

    @JsonProperty("networkDestinationPort")
    protected Integer networkDestinationPort;

    @JsonProperty("networkIPv4")
    protected String networkIPv4;

    @JsonProperty("networkIPv6")
    protected String networkIPv6;

    @JsonProperty("networkPort")
    protected Integer networkPort;

    @JsonProperty("networkProtocol")
    protected Integer networkProtocol;

    @JsonProperty("networkSourceAsn")
    protected Long networkSourceAsn;

    @JsonProperty("networkSourceCidrBlock")
    protected String networkSourceCidrBlock;

    @JsonProperty("networkSourceIPv4")
    protected String networkSourceIPv4;

    @JsonProperty("networkSourceIPv6")
    protected String networkSourceIPv6;

    @JsonProperty("networkSourcePort")
    protected Integer networkSourcePort;

    @JsonProperty("passiveOnly")
    protected Boolean passiveOnly;

    @JsonProperty("severity")
    protected Integer severity;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("targetProduct")
    protected String targetProduct;

    @JsonProperty("threatType")
    protected String threatType;

    @JsonProperty("tlpLevel")
    protected TlpLevel tlpLevel;

    @JsonProperty("url")
    protected String url;

    @JsonProperty("userAgent")
    protected String userAgent;

    protected TiIndicator() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTiIndicator() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private TiAction action;
        private List<String> activityGroupNames;
        private String activityGroupNamesNextLink;
        private String additionalInformation;
        private String azureTenantId;
        private Integer confidence;
        private String description;
        private DiamondModel diamondModel;
        private String domainName;
        private String emailEncoding;
        private String emailLanguage;
        private String emailRecipient;
        private String emailSenderAddress;
        private String emailSenderName;
        private String emailSourceDomain;
        private String emailSourceIpAddress;
        private String emailSubject;
        private String emailXMailer;
        private OffsetDateTime expirationDateTime;
        private String externalId;
        private OffsetDateTime fileCompileDateTime;
        private OffsetDateTime fileCreatedDateTime;
        private FileHashType fileHashType;
        private String fileHashValue;
        private String fileMutexName;
        private String fileName;
        private String filePacker;
        private String filePath;
        private Long fileSize;
        private String fileType;
        private OffsetDateTime ingestedDateTime;
        private Boolean isActive;
        private List<String> killChain;
        private String killChainNextLink;
        private String knownFalsePositives;
        private OffsetDateTime lastReportedDateTime;
        private List<String> malwareFamilyNames;
        private String malwareFamilyNamesNextLink;
        private String networkCidrBlock;
        private Long networkDestinationAsn;
        private String networkDestinationCidrBlock;
        private String networkDestinationIPv4;
        private String networkDestinationIPv6;
        private Integer networkDestinationPort;
        private String networkIPv4;
        private String networkIPv6;
        private Integer networkPort;
        private Integer networkProtocol;
        private Long networkSourceAsn;
        private String networkSourceCidrBlock;
        private String networkSourceIPv4;
        private String networkSourceIPv6;
        private Integer networkSourcePort;
        private Boolean passiveOnly;
        private Integer severity;
        private List<String> tags;
        private String tagsNextLink;
        private String targetProduct;
        private String threatType;
        private TlpLevel tlpLevel;
        private String url;
        private String userAgent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder action(TiAction action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder activityGroupNames(List<String> activityGroupNames) {
            this.activityGroupNames = activityGroupNames;
            this.changedFields = changedFields.add("activityGroupNames");
            return this;
        }

        public Builder activityGroupNames(String... activityGroupNames) {
            return activityGroupNames(Arrays.asList(activityGroupNames));
        }

        public Builder activityGroupNamesNextLink(String activityGroupNamesNextLink) {
            this.activityGroupNamesNextLink = activityGroupNamesNextLink;
            this.changedFields = changedFields.add("activityGroupNames");
            return this;
        }

        public Builder additionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
            this.changedFields = changedFields.add("additionalInformation");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder diamondModel(DiamondModel diamondModel) {
            this.diamondModel = diamondModel;
            this.changedFields = changedFields.add("diamondModel");
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            this.changedFields = changedFields.add("domainName");
            return this;
        }

        public Builder emailEncoding(String emailEncoding) {
            this.emailEncoding = emailEncoding;
            this.changedFields = changedFields.add("emailEncoding");
            return this;
        }

        public Builder emailLanguage(String emailLanguage) {
            this.emailLanguage = emailLanguage;
            this.changedFields = changedFields.add("emailLanguage");
            return this;
        }

        public Builder emailRecipient(String emailRecipient) {
            this.emailRecipient = emailRecipient;
            this.changedFields = changedFields.add("emailRecipient");
            return this;
        }

        public Builder emailSenderAddress(String emailSenderAddress) {
            this.emailSenderAddress = emailSenderAddress;
            this.changedFields = changedFields.add("emailSenderAddress");
            return this;
        }

        public Builder emailSenderName(String emailSenderName) {
            this.emailSenderName = emailSenderName;
            this.changedFields = changedFields.add("emailSenderName");
            return this;
        }

        public Builder emailSourceDomain(String emailSourceDomain) {
            this.emailSourceDomain = emailSourceDomain;
            this.changedFields = changedFields.add("emailSourceDomain");
            return this;
        }

        public Builder emailSourceIpAddress(String emailSourceIpAddress) {
            this.emailSourceIpAddress = emailSourceIpAddress;
            this.changedFields = changedFields.add("emailSourceIpAddress");
            return this;
        }

        public Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            this.changedFields = changedFields.add("emailSubject");
            return this;
        }

        public Builder emailXMailer(String emailXMailer) {
            this.emailXMailer = emailXMailer;
            this.changedFields = changedFields.add("emailXMailer");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder fileCompileDateTime(OffsetDateTime fileCompileDateTime) {
            this.fileCompileDateTime = fileCompileDateTime;
            this.changedFields = changedFields.add("fileCompileDateTime");
            return this;
        }

        public Builder fileCreatedDateTime(OffsetDateTime fileCreatedDateTime) {
            this.fileCreatedDateTime = fileCreatedDateTime;
            this.changedFields = changedFields.add("fileCreatedDateTime");
            return this;
        }

        public Builder fileHashType(FileHashType fileHashType) {
            this.fileHashType = fileHashType;
            this.changedFields = changedFields.add("fileHashType");
            return this;
        }

        public Builder fileHashValue(String fileHashValue) {
            this.fileHashValue = fileHashValue;
            this.changedFields = changedFields.add("fileHashValue");
            return this;
        }

        public Builder fileMutexName(String fileMutexName) {
            this.fileMutexName = fileMutexName;
            this.changedFields = changedFields.add("fileMutexName");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder filePacker(String filePacker) {
            this.filePacker = filePacker;
            this.changedFields = changedFields.add("filePacker");
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            this.changedFields = changedFields.add("filePath");
            return this;
        }

        public Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            this.changedFields = changedFields.add("fileSize");
            return this;
        }

        public Builder fileType(String fileType) {
            this.fileType = fileType;
            this.changedFields = changedFields.add("fileType");
            return this;
        }

        public Builder ingestedDateTime(OffsetDateTime ingestedDateTime) {
            this.ingestedDateTime = ingestedDateTime;
            this.changedFields = changedFields.add("ingestedDateTime");
            return this;
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            this.changedFields = changedFields.add("isActive");
            return this;
        }

        public Builder killChain(List<String> killChain) {
            this.killChain = killChain;
            this.changedFields = changedFields.add("killChain");
            return this;
        }

        public Builder killChain(String... killChain) {
            return killChain(Arrays.asList(killChain));
        }

        public Builder killChainNextLink(String killChainNextLink) {
            this.killChainNextLink = killChainNextLink;
            this.changedFields = changedFields.add("killChain");
            return this;
        }

        public Builder knownFalsePositives(String knownFalsePositives) {
            this.knownFalsePositives = knownFalsePositives;
            this.changedFields = changedFields.add("knownFalsePositives");
            return this;
        }

        public Builder lastReportedDateTime(OffsetDateTime lastReportedDateTime) {
            this.lastReportedDateTime = lastReportedDateTime;
            this.changedFields = changedFields.add("lastReportedDateTime");
            return this;
        }

        public Builder malwareFamilyNames(List<String> malwareFamilyNames) {
            this.malwareFamilyNames = malwareFamilyNames;
            this.changedFields = changedFields.add("malwareFamilyNames");
            return this;
        }

        public Builder malwareFamilyNames(String... malwareFamilyNames) {
            return malwareFamilyNames(Arrays.asList(malwareFamilyNames));
        }

        public Builder malwareFamilyNamesNextLink(String malwareFamilyNamesNextLink) {
            this.malwareFamilyNamesNextLink = malwareFamilyNamesNextLink;
            this.changedFields = changedFields.add("malwareFamilyNames");
            return this;
        }

        public Builder networkCidrBlock(String networkCidrBlock) {
            this.networkCidrBlock = networkCidrBlock;
            this.changedFields = changedFields.add("networkCidrBlock");
            return this;
        }

        public Builder networkDestinationAsn(Long networkDestinationAsn) {
            this.networkDestinationAsn = networkDestinationAsn;
            this.changedFields = changedFields.add("networkDestinationAsn");
            return this;
        }

        public Builder networkDestinationCidrBlock(String networkDestinationCidrBlock) {
            this.networkDestinationCidrBlock = networkDestinationCidrBlock;
            this.changedFields = changedFields.add("networkDestinationCidrBlock");
            return this;
        }

        public Builder networkDestinationIPv4(String networkDestinationIPv4) {
            this.networkDestinationIPv4 = networkDestinationIPv4;
            this.changedFields = changedFields.add("networkDestinationIPv4");
            return this;
        }

        public Builder networkDestinationIPv6(String networkDestinationIPv6) {
            this.networkDestinationIPv6 = networkDestinationIPv6;
            this.changedFields = changedFields.add("networkDestinationIPv6");
            return this;
        }

        public Builder networkDestinationPort(Integer networkDestinationPort) {
            this.networkDestinationPort = networkDestinationPort;
            this.changedFields = changedFields.add("networkDestinationPort");
            return this;
        }

        public Builder networkIPv4(String networkIPv4) {
            this.networkIPv4 = networkIPv4;
            this.changedFields = changedFields.add("networkIPv4");
            return this;
        }

        public Builder networkIPv6(String networkIPv6) {
            this.networkIPv6 = networkIPv6;
            this.changedFields = changedFields.add("networkIPv6");
            return this;
        }

        public Builder networkPort(Integer networkPort) {
            this.networkPort = networkPort;
            this.changedFields = changedFields.add("networkPort");
            return this;
        }

        public Builder networkProtocol(Integer networkProtocol) {
            this.networkProtocol = networkProtocol;
            this.changedFields = changedFields.add("networkProtocol");
            return this;
        }

        public Builder networkSourceAsn(Long networkSourceAsn) {
            this.networkSourceAsn = networkSourceAsn;
            this.changedFields = changedFields.add("networkSourceAsn");
            return this;
        }

        public Builder networkSourceCidrBlock(String networkSourceCidrBlock) {
            this.networkSourceCidrBlock = networkSourceCidrBlock;
            this.changedFields = changedFields.add("networkSourceCidrBlock");
            return this;
        }

        public Builder networkSourceIPv4(String networkSourceIPv4) {
            this.networkSourceIPv4 = networkSourceIPv4;
            this.changedFields = changedFields.add("networkSourceIPv4");
            return this;
        }

        public Builder networkSourceIPv6(String networkSourceIPv6) {
            this.networkSourceIPv6 = networkSourceIPv6;
            this.changedFields = changedFields.add("networkSourceIPv6");
            return this;
        }

        public Builder networkSourcePort(Integer networkSourcePort) {
            this.networkSourcePort = networkSourcePort;
            this.changedFields = changedFields.add("networkSourcePort");
            return this;
        }

        public Builder passiveOnly(Boolean passiveOnly) {
            this.passiveOnly = passiveOnly;
            this.changedFields = changedFields.add("passiveOnly");
            return this;
        }

        public Builder severity(Integer severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("severity");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder targetProduct(String targetProduct) {
            this.targetProduct = targetProduct;
            this.changedFields = changedFields.add("targetProduct");
            return this;
        }

        public Builder threatType(String threatType) {
            this.threatType = threatType;
            this.changedFields = changedFields.add("threatType");
            return this;
        }

        public Builder tlpLevel(TlpLevel tlpLevel) {
            this.tlpLevel = tlpLevel;
            this.changedFields = changedFields.add("tlpLevel");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            this.changedFields = changedFields.add("userAgent");
            return this;
        }

        public TiIndicator build() {
            TiIndicator _x = new TiIndicator();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.tiIndicator";
            _x.id = id;
            _x.action = action;
            _x.activityGroupNames = activityGroupNames;
            _x.activityGroupNamesNextLink = activityGroupNamesNextLink;
            _x.additionalInformation = additionalInformation;
            _x.azureTenantId = azureTenantId;
            _x.confidence = confidence;
            _x.description = description;
            _x.diamondModel = diamondModel;
            _x.domainName = domainName;
            _x.emailEncoding = emailEncoding;
            _x.emailLanguage = emailLanguage;
            _x.emailRecipient = emailRecipient;
            _x.emailSenderAddress = emailSenderAddress;
            _x.emailSenderName = emailSenderName;
            _x.emailSourceDomain = emailSourceDomain;
            _x.emailSourceIpAddress = emailSourceIpAddress;
            _x.emailSubject = emailSubject;
            _x.emailXMailer = emailXMailer;
            _x.expirationDateTime = expirationDateTime;
            _x.externalId = externalId;
            _x.fileCompileDateTime = fileCompileDateTime;
            _x.fileCreatedDateTime = fileCreatedDateTime;
            _x.fileHashType = fileHashType;
            _x.fileHashValue = fileHashValue;
            _x.fileMutexName = fileMutexName;
            _x.fileName = fileName;
            _x.filePacker = filePacker;
            _x.filePath = filePath;
            _x.fileSize = fileSize;
            _x.fileType = fileType;
            _x.ingestedDateTime = ingestedDateTime;
            _x.isActive = isActive;
            _x.killChain = killChain;
            _x.killChainNextLink = killChainNextLink;
            _x.knownFalsePositives = knownFalsePositives;
            _x.lastReportedDateTime = lastReportedDateTime;
            _x.malwareFamilyNames = malwareFamilyNames;
            _x.malwareFamilyNamesNextLink = malwareFamilyNamesNextLink;
            _x.networkCidrBlock = networkCidrBlock;
            _x.networkDestinationAsn = networkDestinationAsn;
            _x.networkDestinationCidrBlock = networkDestinationCidrBlock;
            _x.networkDestinationIPv4 = networkDestinationIPv4;
            _x.networkDestinationIPv6 = networkDestinationIPv6;
            _x.networkDestinationPort = networkDestinationPort;
            _x.networkIPv4 = networkIPv4;
            _x.networkIPv6 = networkIPv6;
            _x.networkPort = networkPort;
            _x.networkProtocol = networkProtocol;
            _x.networkSourceAsn = networkSourceAsn;
            _x.networkSourceCidrBlock = networkSourceCidrBlock;
            _x.networkSourceIPv4 = networkSourceIPv4;
            _x.networkSourceIPv6 = networkSourceIPv6;
            _x.networkSourcePort = networkSourcePort;
            _x.passiveOnly = passiveOnly;
            _x.severity = severity;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.targetProduct = targetProduct;
            _x.threatType = threatType;
            _x.tlpLevel = tlpLevel;
            _x.url = url;
            _x.userAgent = userAgent;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="action")
    @JsonIgnore
    public Optional<TiAction> getAction() {
        return Optional.ofNullable(action);
    }

    public TiIndicator withAction(TiAction action) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("action");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.action = action;
        return _x;
    }

    @Property(name="activityGroupNames")
    @JsonIgnore
    public CollectionPage<String> getActivityGroupNames() {
        return new CollectionPage<String>(contextPath, String.class, this.activityGroupNames, Optional.ofNullable(activityGroupNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TiIndicator withActivityGroupNames(List<String> activityGroupNames) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("activityGroupNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.activityGroupNames = activityGroupNames;
        return _x;
    }

    @Property(name="activityGroupNames")
    @JsonIgnore
    public CollectionPage<String> getActivityGroupNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.activityGroupNames, Optional.ofNullable(activityGroupNamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="additionalInformation")
    @JsonIgnore
    public Optional<String> getAdditionalInformation() {
        return Optional.ofNullable(additionalInformation);
    }

    public TiIndicator withAdditionalInformation(String additionalInformation) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("additionalInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.additionalInformation = additionalInformation;
        return _x;
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public TiIndicator withAzureTenantId(String azureTenantId) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="confidence")
    @JsonIgnore
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(confidence);
    }

    public TiIndicator withConfidence(Integer confidence) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("confidence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.confidence = confidence;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public TiIndicator withDescription(String description) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.description = description;
        return _x;
    }

    @Property(name="diamondModel")
    @JsonIgnore
    public Optional<DiamondModel> getDiamondModel() {
        return Optional.ofNullable(diamondModel);
    }

    public TiIndicator withDiamondModel(DiamondModel diamondModel) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("diamondModel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.diamondModel = diamondModel;
        return _x;
    }

    @Property(name="domainName")
    @JsonIgnore
    public Optional<String> getDomainName() {
        return Optional.ofNullable(domainName);
    }

    public TiIndicator withDomainName(String domainName) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("domainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.domainName = domainName;
        return _x;
    }

    @Property(name="emailEncoding")
    @JsonIgnore
    public Optional<String> getEmailEncoding() {
        return Optional.ofNullable(emailEncoding);
    }

    public TiIndicator withEmailEncoding(String emailEncoding) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("emailEncoding");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.emailEncoding = emailEncoding;
        return _x;
    }

    @Property(name="emailLanguage")
    @JsonIgnore
    public Optional<String> getEmailLanguage() {
        return Optional.ofNullable(emailLanguage);
    }

    public TiIndicator withEmailLanguage(String emailLanguage) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("emailLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.emailLanguage = emailLanguage;
        return _x;
    }

    @Property(name="emailRecipient")
    @JsonIgnore
    public Optional<String> getEmailRecipient() {
        return Optional.ofNullable(emailRecipient);
    }

    public TiIndicator withEmailRecipient(String emailRecipient) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("emailRecipient");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.emailRecipient = emailRecipient;
        return _x;
    }

    @Property(name="emailSenderAddress")
    @JsonIgnore
    public Optional<String> getEmailSenderAddress() {
        return Optional.ofNullable(emailSenderAddress);
    }

    public TiIndicator withEmailSenderAddress(String emailSenderAddress) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("emailSenderAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.emailSenderAddress = emailSenderAddress;
        return _x;
    }

    @Property(name="emailSenderName")
    @JsonIgnore
    public Optional<String> getEmailSenderName() {
        return Optional.ofNullable(emailSenderName);
    }

    public TiIndicator withEmailSenderName(String emailSenderName) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("emailSenderName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.emailSenderName = emailSenderName;
        return _x;
    }

    @Property(name="emailSourceDomain")
    @JsonIgnore
    public Optional<String> getEmailSourceDomain() {
        return Optional.ofNullable(emailSourceDomain);
    }

    public TiIndicator withEmailSourceDomain(String emailSourceDomain) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("emailSourceDomain");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.emailSourceDomain = emailSourceDomain;
        return _x;
    }

    @Property(name="emailSourceIpAddress")
    @JsonIgnore
    public Optional<String> getEmailSourceIpAddress() {
        return Optional.ofNullable(emailSourceIpAddress);
    }

    public TiIndicator withEmailSourceIpAddress(String emailSourceIpAddress) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("emailSourceIpAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.emailSourceIpAddress = emailSourceIpAddress;
        return _x;
    }

    @Property(name="emailSubject")
    @JsonIgnore
    public Optional<String> getEmailSubject() {
        return Optional.ofNullable(emailSubject);
    }

    public TiIndicator withEmailSubject(String emailSubject) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("emailSubject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.emailSubject = emailSubject;
        return _x;
    }

    @Property(name="emailXMailer")
    @JsonIgnore
    public Optional<String> getEmailXMailer() {
        return Optional.ofNullable(emailXMailer);
    }

    public TiIndicator withEmailXMailer(String emailXMailer) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("emailXMailer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.emailXMailer = emailXMailer;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public TiIndicator withExpirationDateTime(OffsetDateTime expirationDateTime) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public TiIndicator withExternalId(String externalId) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="fileCompileDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFileCompileDateTime() {
        return Optional.ofNullable(fileCompileDateTime);
    }

    public TiIndicator withFileCompileDateTime(OffsetDateTime fileCompileDateTime) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("fileCompileDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.fileCompileDateTime = fileCompileDateTime;
        return _x;
    }

    @Property(name="fileCreatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFileCreatedDateTime() {
        return Optional.ofNullable(fileCreatedDateTime);
    }

    public TiIndicator withFileCreatedDateTime(OffsetDateTime fileCreatedDateTime) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("fileCreatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.fileCreatedDateTime = fileCreatedDateTime;
        return _x;
    }

    @Property(name="fileHashType")
    @JsonIgnore
    public Optional<FileHashType> getFileHashType() {
        return Optional.ofNullable(fileHashType);
    }

    public TiIndicator withFileHashType(FileHashType fileHashType) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("fileHashType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.fileHashType = fileHashType;
        return _x;
    }

    @Property(name="fileHashValue")
    @JsonIgnore
    public Optional<String> getFileHashValue() {
        return Optional.ofNullable(fileHashValue);
    }

    public TiIndicator withFileHashValue(String fileHashValue) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("fileHashValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.fileHashValue = fileHashValue;
        return _x;
    }

    @Property(name="fileMutexName")
    @JsonIgnore
    public Optional<String> getFileMutexName() {
        return Optional.ofNullable(fileMutexName);
    }

    public TiIndicator withFileMutexName(String fileMutexName) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("fileMutexName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.fileMutexName = fileMutexName;
        return _x;
    }

    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public TiIndicator withFileName(String fileName) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("fileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="filePacker")
    @JsonIgnore
    public Optional<String> getFilePacker() {
        return Optional.ofNullable(filePacker);
    }

    public TiIndicator withFilePacker(String filePacker) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("filePacker");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.filePacker = filePacker;
        return _x;
    }

    @Property(name="filePath")
    @JsonIgnore
    public Optional<String> getFilePath() {
        return Optional.ofNullable(filePath);
    }

    public TiIndicator withFilePath(String filePath) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("filePath");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.filePath = filePath;
        return _x;
    }

    @Property(name="fileSize")
    @JsonIgnore
    public Optional<Long> getFileSize() {
        return Optional.ofNullable(fileSize);
    }

    public TiIndicator withFileSize(Long fileSize) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("fileSize");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.fileSize = fileSize;
        return _x;
    }

    @Property(name="fileType")
    @JsonIgnore
    public Optional<String> getFileType() {
        return Optional.ofNullable(fileType);
    }

    public TiIndicator withFileType(String fileType) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("fileType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.fileType = fileType;
        return _x;
    }

    @Property(name="ingestedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getIngestedDateTime() {
        return Optional.ofNullable(ingestedDateTime);
    }

    public TiIndicator withIngestedDateTime(OffsetDateTime ingestedDateTime) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("ingestedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.ingestedDateTime = ingestedDateTime;
        return _x;
    }

    @Property(name="isActive")
    @JsonIgnore
    public Optional<Boolean> getIsActive() {
        return Optional.ofNullable(isActive);
    }

    public TiIndicator withIsActive(Boolean isActive) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("isActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.isActive = isActive;
        return _x;
    }

    @Property(name="killChain")
    @JsonIgnore
    public CollectionPage<String> getKillChain() {
        return new CollectionPage<String>(contextPath, String.class, this.killChain, Optional.ofNullable(killChainNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TiIndicator withKillChain(List<String> killChain) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("killChain");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.killChain = killChain;
        return _x;
    }

    @Property(name="killChain")
    @JsonIgnore
    public CollectionPage<String> getKillChain(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.killChain, Optional.ofNullable(killChainNextLink), Collections.emptyList(), options);
    }

    @Property(name="knownFalsePositives")
    @JsonIgnore
    public Optional<String> getKnownFalsePositives() {
        return Optional.ofNullable(knownFalsePositives);
    }

    public TiIndicator withKnownFalsePositives(String knownFalsePositives) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("knownFalsePositives");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.knownFalsePositives = knownFalsePositives;
        return _x;
    }

    @Property(name="lastReportedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastReportedDateTime() {
        return Optional.ofNullable(lastReportedDateTime);
    }

    public TiIndicator withLastReportedDateTime(OffsetDateTime lastReportedDateTime) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("lastReportedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.lastReportedDateTime = lastReportedDateTime;
        return _x;
    }

    @Property(name="malwareFamilyNames")
    @JsonIgnore
    public CollectionPage<String> getMalwareFamilyNames() {
        return new CollectionPage<String>(contextPath, String.class, this.malwareFamilyNames, Optional.ofNullable(malwareFamilyNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TiIndicator withMalwareFamilyNames(List<String> malwareFamilyNames) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("malwareFamilyNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.malwareFamilyNames = malwareFamilyNames;
        return _x;
    }

    @Property(name="malwareFamilyNames")
    @JsonIgnore
    public CollectionPage<String> getMalwareFamilyNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.malwareFamilyNames, Optional.ofNullable(malwareFamilyNamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="networkCidrBlock")
    @JsonIgnore
    public Optional<String> getNetworkCidrBlock() {
        return Optional.ofNullable(networkCidrBlock);
    }

    public TiIndicator withNetworkCidrBlock(String networkCidrBlock) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkCidrBlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkCidrBlock = networkCidrBlock;
        return _x;
    }

    @Property(name="networkDestinationAsn")
    @JsonIgnore
    public Optional<Long> getNetworkDestinationAsn() {
        return Optional.ofNullable(networkDestinationAsn);
    }

    public TiIndicator withNetworkDestinationAsn(Long networkDestinationAsn) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkDestinationAsn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkDestinationAsn = networkDestinationAsn;
        return _x;
    }

    @Property(name="networkDestinationCidrBlock")
    @JsonIgnore
    public Optional<String> getNetworkDestinationCidrBlock() {
        return Optional.ofNullable(networkDestinationCidrBlock);
    }

    public TiIndicator withNetworkDestinationCidrBlock(String networkDestinationCidrBlock) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkDestinationCidrBlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkDestinationCidrBlock = networkDestinationCidrBlock;
        return _x;
    }

    @Property(name="networkDestinationIPv4")
    @JsonIgnore
    public Optional<String> getNetworkDestinationIPv4() {
        return Optional.ofNullable(networkDestinationIPv4);
    }

    public TiIndicator withNetworkDestinationIPv4(String networkDestinationIPv4) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkDestinationIPv4");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkDestinationIPv4 = networkDestinationIPv4;
        return _x;
    }

    @Property(name="networkDestinationIPv6")
    @JsonIgnore
    public Optional<String> getNetworkDestinationIPv6() {
        return Optional.ofNullable(networkDestinationIPv6);
    }

    public TiIndicator withNetworkDestinationIPv6(String networkDestinationIPv6) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkDestinationIPv6");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkDestinationIPv6 = networkDestinationIPv6;
        return _x;
    }

    @Property(name="networkDestinationPort")
    @JsonIgnore
    public Optional<Integer> getNetworkDestinationPort() {
        return Optional.ofNullable(networkDestinationPort);
    }

    public TiIndicator withNetworkDestinationPort(Integer networkDestinationPort) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkDestinationPort");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkDestinationPort = networkDestinationPort;
        return _x;
    }

    @Property(name="networkIPv4")
    @JsonIgnore
    public Optional<String> getNetworkIPv4() {
        return Optional.ofNullable(networkIPv4);
    }

    public TiIndicator withNetworkIPv4(String networkIPv4) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkIPv4");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkIPv4 = networkIPv4;
        return _x;
    }

    @Property(name="networkIPv6")
    @JsonIgnore
    public Optional<String> getNetworkIPv6() {
        return Optional.ofNullable(networkIPv6);
    }

    public TiIndicator withNetworkIPv6(String networkIPv6) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkIPv6");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkIPv6 = networkIPv6;
        return _x;
    }

    @Property(name="networkPort")
    @JsonIgnore
    public Optional<Integer> getNetworkPort() {
        return Optional.ofNullable(networkPort);
    }

    public TiIndicator withNetworkPort(Integer networkPort) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkPort");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkPort = networkPort;
        return _x;
    }

    @Property(name="networkProtocol")
    @JsonIgnore
    public Optional<Integer> getNetworkProtocol() {
        return Optional.ofNullable(networkProtocol);
    }

    public TiIndicator withNetworkProtocol(Integer networkProtocol) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkProtocol");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkProtocol = networkProtocol;
        return _x;
    }

    @Property(name="networkSourceAsn")
    @JsonIgnore
    public Optional<Long> getNetworkSourceAsn() {
        return Optional.ofNullable(networkSourceAsn);
    }

    public TiIndicator withNetworkSourceAsn(Long networkSourceAsn) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkSourceAsn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkSourceAsn = networkSourceAsn;
        return _x;
    }

    @Property(name="networkSourceCidrBlock")
    @JsonIgnore
    public Optional<String> getNetworkSourceCidrBlock() {
        return Optional.ofNullable(networkSourceCidrBlock);
    }

    public TiIndicator withNetworkSourceCidrBlock(String networkSourceCidrBlock) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkSourceCidrBlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkSourceCidrBlock = networkSourceCidrBlock;
        return _x;
    }

    @Property(name="networkSourceIPv4")
    @JsonIgnore
    public Optional<String> getNetworkSourceIPv4() {
        return Optional.ofNullable(networkSourceIPv4);
    }

    public TiIndicator withNetworkSourceIPv4(String networkSourceIPv4) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkSourceIPv4");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkSourceIPv4 = networkSourceIPv4;
        return _x;
    }

    @Property(name="networkSourceIPv6")
    @JsonIgnore
    public Optional<String> getNetworkSourceIPv6() {
        return Optional.ofNullable(networkSourceIPv6);
    }

    public TiIndicator withNetworkSourceIPv6(String networkSourceIPv6) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkSourceIPv6");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkSourceIPv6 = networkSourceIPv6;
        return _x;
    }

    @Property(name="networkSourcePort")
    @JsonIgnore
    public Optional<Integer> getNetworkSourcePort() {
        return Optional.ofNullable(networkSourcePort);
    }

    public TiIndicator withNetworkSourcePort(Integer networkSourcePort) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("networkSourcePort");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.networkSourcePort = networkSourcePort;
        return _x;
    }

    @Property(name="passiveOnly")
    @JsonIgnore
    public Optional<Boolean> getPassiveOnly() {
        return Optional.ofNullable(passiveOnly);
    }

    public TiIndicator withPassiveOnly(Boolean passiveOnly) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("passiveOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.passiveOnly = passiveOnly;
        return _x;
    }

    @Property(name="severity")
    @JsonIgnore
    public Optional<Integer> getSeverity() {
        return Optional.ofNullable(severity);
    }

    public TiIndicator withSeverity(Integer severity) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("severity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.severity = severity;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, this.tags, Optional.ofNullable(tagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TiIndicator withTags(List<String> tags) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("tags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.tags = tags;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.tags, Optional.ofNullable(tagsNextLink), Collections.emptyList(), options);
    }

    @Property(name="targetProduct")
    @JsonIgnore
    public Optional<String> getTargetProduct() {
        return Optional.ofNullable(targetProduct);
    }

    public TiIndicator withTargetProduct(String targetProduct) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("targetProduct");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.targetProduct = targetProduct;
        return _x;
    }

    @Property(name="threatType")
    @JsonIgnore
    public Optional<String> getThreatType() {
        return Optional.ofNullable(threatType);
    }

    public TiIndicator withThreatType(String threatType) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("threatType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.threatType = threatType;
        return _x;
    }

    @Property(name="tlpLevel")
    @JsonIgnore
    public Optional<TlpLevel> getTlpLevel() {
        return Optional.ofNullable(tlpLevel);
    }

    public TiIndicator withTlpLevel(TlpLevel tlpLevel) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("tlpLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.tlpLevel = tlpLevel;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public TiIndicator withUrl(String url) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.url = url;
        return _x;
    }

    @Property(name="userAgent")
    @JsonIgnore
    public Optional<String> getUserAgent() {
        return Optional.ofNullable(userAgent);
    }

    public TiIndicator withUserAgent(String userAgent) {
        TiIndicator _x = _copy();
        _x.changedFields = changedFields.add("userAgent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tiIndicator");
        _x.userAgent = userAgent;
        return _x;
    }

    public TiIndicator withUnmappedField(String name, Object value) {
        TiIndicator _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TiIndicator patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TiIndicator _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TiIndicator put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TiIndicator _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TiIndicator _copy() {
        TiIndicator _x = new TiIndicator();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.action = action;
        _x.activityGroupNames = activityGroupNames;
        _x.additionalInformation = additionalInformation;
        _x.azureTenantId = azureTenantId;
        _x.confidence = confidence;
        _x.description = description;
        _x.diamondModel = diamondModel;
        _x.domainName = domainName;
        _x.emailEncoding = emailEncoding;
        _x.emailLanguage = emailLanguage;
        _x.emailRecipient = emailRecipient;
        _x.emailSenderAddress = emailSenderAddress;
        _x.emailSenderName = emailSenderName;
        _x.emailSourceDomain = emailSourceDomain;
        _x.emailSourceIpAddress = emailSourceIpAddress;
        _x.emailSubject = emailSubject;
        _x.emailXMailer = emailXMailer;
        _x.expirationDateTime = expirationDateTime;
        _x.externalId = externalId;
        _x.fileCompileDateTime = fileCompileDateTime;
        _x.fileCreatedDateTime = fileCreatedDateTime;
        _x.fileHashType = fileHashType;
        _x.fileHashValue = fileHashValue;
        _x.fileMutexName = fileMutexName;
        _x.fileName = fileName;
        _x.filePacker = filePacker;
        _x.filePath = filePath;
        _x.fileSize = fileSize;
        _x.fileType = fileType;
        _x.ingestedDateTime = ingestedDateTime;
        _x.isActive = isActive;
        _x.killChain = killChain;
        _x.knownFalsePositives = knownFalsePositives;
        _x.lastReportedDateTime = lastReportedDateTime;
        _x.malwareFamilyNames = malwareFamilyNames;
        _x.networkCidrBlock = networkCidrBlock;
        _x.networkDestinationAsn = networkDestinationAsn;
        _x.networkDestinationCidrBlock = networkDestinationCidrBlock;
        _x.networkDestinationIPv4 = networkDestinationIPv4;
        _x.networkDestinationIPv6 = networkDestinationIPv6;
        _x.networkDestinationPort = networkDestinationPort;
        _x.networkIPv4 = networkIPv4;
        _x.networkIPv6 = networkIPv6;
        _x.networkPort = networkPort;
        _x.networkProtocol = networkProtocol;
        _x.networkSourceAsn = networkSourceAsn;
        _x.networkSourceCidrBlock = networkSourceCidrBlock;
        _x.networkSourceIPv4 = networkSourceIPv4;
        _x.networkSourceIPv6 = networkSourceIPv6;
        _x.networkSourcePort = networkSourcePort;
        _x.passiveOnly = passiveOnly;
        _x.severity = severity;
        _x.tags = tags;
        _x.targetProduct = targetProduct;
        _x.threatType = threatType;
        _x.tlpLevel = tlpLevel;
        _x.url = url;
        _x.userAgent = userAgent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TiIndicator[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("activityGroupNames=");
        b.append(this.activityGroupNames);
        b.append(", ");
        b.append("additionalInformation=");
        b.append(this.additionalInformation);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("diamondModel=");
        b.append(this.diamondModel);
        b.append(", ");
        b.append("domainName=");
        b.append(this.domainName);
        b.append(", ");
        b.append("emailEncoding=");
        b.append(this.emailEncoding);
        b.append(", ");
        b.append("emailLanguage=");
        b.append(this.emailLanguage);
        b.append(", ");
        b.append("emailRecipient=");
        b.append(this.emailRecipient);
        b.append(", ");
        b.append("emailSenderAddress=");
        b.append(this.emailSenderAddress);
        b.append(", ");
        b.append("emailSenderName=");
        b.append(this.emailSenderName);
        b.append(", ");
        b.append("emailSourceDomain=");
        b.append(this.emailSourceDomain);
        b.append(", ");
        b.append("emailSourceIpAddress=");
        b.append(this.emailSourceIpAddress);
        b.append(", ");
        b.append("emailSubject=");
        b.append(this.emailSubject);
        b.append(", ");
        b.append("emailXMailer=");
        b.append(this.emailXMailer);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("fileCompileDateTime=");
        b.append(this.fileCompileDateTime);
        b.append(", ");
        b.append("fileCreatedDateTime=");
        b.append(this.fileCreatedDateTime);
        b.append(", ");
        b.append("fileHashType=");
        b.append(this.fileHashType);
        b.append(", ");
        b.append("fileHashValue=");
        b.append(this.fileHashValue);
        b.append(", ");
        b.append("fileMutexName=");
        b.append(this.fileMutexName);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("filePacker=");
        b.append(this.filePacker);
        b.append(", ");
        b.append("filePath=");
        b.append(this.filePath);
        b.append(", ");
        b.append("fileSize=");
        b.append(this.fileSize);
        b.append(", ");
        b.append("fileType=");
        b.append(this.fileType);
        b.append(", ");
        b.append("ingestedDateTime=");
        b.append(this.ingestedDateTime);
        b.append(", ");
        b.append("isActive=");
        b.append(this.isActive);
        b.append(", ");
        b.append("killChain=");
        b.append(this.killChain);
        b.append(", ");
        b.append("knownFalsePositives=");
        b.append(this.knownFalsePositives);
        b.append(", ");
        b.append("lastReportedDateTime=");
        b.append(this.lastReportedDateTime);
        b.append(", ");
        b.append("malwareFamilyNames=");
        b.append(this.malwareFamilyNames);
        b.append(", ");
        b.append("networkCidrBlock=");
        b.append(this.networkCidrBlock);
        b.append(", ");
        b.append("networkDestinationAsn=");
        b.append(this.networkDestinationAsn);
        b.append(", ");
        b.append("networkDestinationCidrBlock=");
        b.append(this.networkDestinationCidrBlock);
        b.append(", ");
        b.append("networkDestinationIPv4=");
        b.append(this.networkDestinationIPv4);
        b.append(", ");
        b.append("networkDestinationIPv6=");
        b.append(this.networkDestinationIPv6);
        b.append(", ");
        b.append("networkDestinationPort=");
        b.append(this.networkDestinationPort);
        b.append(", ");
        b.append("networkIPv4=");
        b.append(this.networkIPv4);
        b.append(", ");
        b.append("networkIPv6=");
        b.append(this.networkIPv6);
        b.append(", ");
        b.append("networkPort=");
        b.append(this.networkPort);
        b.append(", ");
        b.append("networkProtocol=");
        b.append(this.networkProtocol);
        b.append(", ");
        b.append("networkSourceAsn=");
        b.append(this.networkSourceAsn);
        b.append(", ");
        b.append("networkSourceCidrBlock=");
        b.append(this.networkSourceCidrBlock);
        b.append(", ");
        b.append("networkSourceIPv4=");
        b.append(this.networkSourceIPv4);
        b.append(", ");
        b.append("networkSourceIPv6=");
        b.append(this.networkSourceIPv6);
        b.append(", ");
        b.append("networkSourcePort=");
        b.append(this.networkSourcePort);
        b.append(", ");
        b.append("passiveOnly=");
        b.append(this.passiveOnly);
        b.append(", ");
        b.append("severity=");
        b.append(this.severity);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("targetProduct=");
        b.append(this.targetProduct);
        b.append(", ");
        b.append("threatType=");
        b.append(this.threatType);
        b.append(", ");
        b.append("tlpLevel=");
        b.append(this.tlpLevel);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append(", ");
        b.append("userAgent=");
        b.append(this.userAgent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
