package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AgreementAcceptanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgreementCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "agreementAcceptances", 
    "agreements"})
@JsonInclude(Include.NON_NULL)
public class TermsOfUseContainer extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termsOfUseContainer";
    }

    @JsonProperty("agreementAcceptances")
    protected List<AgreementAcceptance> agreementAcceptances;

    @JsonProperty("agreements")
    protected List<Agreement> agreements;

    protected TermsOfUseContainer() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTermsOfUseContainer() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<AgreementAcceptance> agreementAcceptances;
        private List<Agreement> agreements;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder agreementAcceptances(List<AgreementAcceptance> agreementAcceptances) {
            this.agreementAcceptances = agreementAcceptances;
            this.changedFields = changedFields.add("agreementAcceptances");
            return this;
        }

        public Builder agreementAcceptances(AgreementAcceptance... agreementAcceptances) {
            return agreementAcceptances(Arrays.asList(agreementAcceptances));
        }

        public Builder agreements(List<Agreement> agreements) {
            this.agreements = agreements;
            this.changedFields = changedFields.add("agreements");
            return this;
        }

        public Builder agreements(Agreement... agreements) {
            return agreements(Arrays.asList(agreements));
        }

        public TermsOfUseContainer build() {
            TermsOfUseContainer _x = new TermsOfUseContainer();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.termsOfUseContainer";
            _x.id = id;
            _x.agreementAcceptances = agreementAcceptances;
            _x.agreements = agreements;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public TermsOfUseContainer withUnmappedField(String name, Object value) {
        TermsOfUseContainer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="agreementAcceptances")
    @JsonIgnore
    public AgreementAcceptanceCollectionRequest getAgreementAcceptances() {
        return new AgreementAcceptanceCollectionRequest(
                        contextPath.addSegment("agreementAcceptances"), Optional.ofNullable(agreementAcceptances));
    }

    @NavigationProperty(name="agreements")
    @JsonIgnore
    public AgreementCollectionRequest getAgreements() {
        return new AgreementCollectionRequest(
                        contextPath.addSegment("agreements"), Optional.ofNullable(agreements));
    }

    public TermsOfUseContainer withAgreementAcceptances(List<AgreementAcceptance> agreementAcceptances) {
        TermsOfUseContainer _x = _copy();
        _x.changedFields = changedFields.add("agreementAcceptances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsOfUseContainer");
        _x.agreementAcceptances = agreementAcceptances;
        return _x;
    }

    public TermsOfUseContainer withAgreements(List<Agreement> agreements) {
        TermsOfUseContainer _x = _copy();
        _x.changedFields = changedFields.add("agreements");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsOfUseContainer");
        _x.agreements = agreements;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TermsOfUseContainer patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TermsOfUseContainer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TermsOfUseContainer put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TermsOfUseContainer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TermsOfUseContainer _copy() {
        TermsOfUseContainer _x = new TermsOfUseContainer();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.agreementAcceptances = agreementAcceptances;
        _x.agreements = agreements;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TermsOfUseContainer[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("agreementAcceptances=");
        b.append(this.agreementAcceptances);
        b.append(", ");
        b.append("agreements=");
        b.append(this.agreements);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
