package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminCustomerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminRelationshipCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.ManagedTenant;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagedTenantRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "managedTenants", 
    "delegatedAdminCustomers", 
    "delegatedAdminRelationships"})
@JsonInclude(Include.NON_NULL)
public class TenantRelationship extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.tenantRelationship";
    }

    @JsonProperty("managedTenants")
    protected ManagedTenant managedTenants;

    @JsonProperty("delegatedAdminCustomers")
    protected List<DelegatedAdminCustomer> delegatedAdminCustomers;

    @JsonProperty("delegatedAdminRelationships")
    protected List<DelegatedAdminRelationship> delegatedAdminRelationships;

    protected TenantRelationship() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTenantRelationship() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ManagedTenant managedTenants;
        private List<DelegatedAdminCustomer> delegatedAdminCustomers;
        private List<DelegatedAdminRelationship> delegatedAdminRelationships;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder managedTenants(ManagedTenant managedTenants) {
            this.managedTenants = managedTenants;
            this.changedFields = changedFields.add("managedTenants");
            return this;
        }

        public Builder delegatedAdminCustomers(List<DelegatedAdminCustomer> delegatedAdminCustomers) {
            this.delegatedAdminCustomers = delegatedAdminCustomers;
            this.changedFields = changedFields.add("delegatedAdminCustomers");
            return this;
        }

        public Builder delegatedAdminCustomers(DelegatedAdminCustomer... delegatedAdminCustomers) {
            return delegatedAdminCustomers(Arrays.asList(delegatedAdminCustomers));
        }

        public Builder delegatedAdminRelationships(List<DelegatedAdminRelationship> delegatedAdminRelationships) {
            this.delegatedAdminRelationships = delegatedAdminRelationships;
            this.changedFields = changedFields.add("delegatedAdminRelationships");
            return this;
        }

        public Builder delegatedAdminRelationships(DelegatedAdminRelationship... delegatedAdminRelationships) {
            return delegatedAdminRelationships(Arrays.asList(delegatedAdminRelationships));
        }

        public TenantRelationship build() {
            TenantRelationship _x = new TenantRelationship();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.tenantRelationship";
            _x.id = id;
            _x.managedTenants = managedTenants;
            _x.delegatedAdminCustomers = delegatedAdminCustomers;
            _x.delegatedAdminRelationships = delegatedAdminRelationships;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public TenantRelationship withUnmappedField(String name, Object value) {
        TenantRelationship _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="managedTenants")
    @JsonIgnore
    public ManagedTenantRequest getManagedTenants() {
        return new ManagedTenantRequest(contextPath.addSegment("managedTenants"), Optional.ofNullable(managedTenants));
    }

    @NavigationProperty(name="delegatedAdminCustomers")
    @JsonIgnore
    public DelegatedAdminCustomerCollectionRequest getDelegatedAdminCustomers() {
        return new DelegatedAdminCustomerCollectionRequest(
                        contextPath.addSegment("delegatedAdminCustomers"), Optional.ofNullable(delegatedAdminCustomers));
    }

    @NavigationProperty(name="delegatedAdminRelationships")
    @JsonIgnore
    public DelegatedAdminRelationshipCollectionRequest getDelegatedAdminRelationships() {
        return new DelegatedAdminRelationshipCollectionRequest(
                        contextPath.addSegment("delegatedAdminRelationships"), Optional.ofNullable(delegatedAdminRelationships));
    }

    public TenantRelationship withManagedTenants(ManagedTenant managedTenants) {
        TenantRelationship _x = _copy();
        _x.changedFields = changedFields.add("managedTenants");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tenantRelationship");
        _x.managedTenants = managedTenants;
        return _x;
    }

    public TenantRelationship withDelegatedAdminCustomers(List<DelegatedAdminCustomer> delegatedAdminCustomers) {
        TenantRelationship _x = _copy();
        _x.changedFields = changedFields.add("delegatedAdminCustomers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tenantRelationship");
        _x.delegatedAdminCustomers = delegatedAdminCustomers;
        return _x;
    }

    public TenantRelationship withDelegatedAdminRelationships(List<DelegatedAdminRelationship> delegatedAdminRelationships) {
        TenantRelationship _x = _copy();
        _x.changedFields = changedFields.add("delegatedAdminRelationships");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tenantRelationship");
        _x.delegatedAdminRelationships = delegatedAdminRelationships;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantRelationship patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TenantRelationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantRelationship put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TenantRelationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TenantRelationship _copy() {
        TenantRelationship _x = new TenantRelationship();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.managedTenants = managedTenants;
        _x.delegatedAdminCustomers = delegatedAdminCustomers;
        _x.delegatedAdminRelationships = delegatedAdminRelationships;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TenantRelationship[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("managedTenants=");
        b.append(this.managedTenants);
        b.append(", ");
        b.append("delegatedAdminCustomers=");
        b.append(this.delegatedAdminCustomers);
        b.append(", ");
        b.append("delegatedAdminRelationships=");
        b.append(this.delegatedAdminRelationships);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
