package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodTargetCollectionRequest;
import odata.msgraph.client.beta.enums.AuthenticationMethodState;

@JsonPropertyOrder({
    "@odata.type", 
    "defaultLength", 
    "defaultLifetimeInMinutes", 
    "isUsableOnce", 
    "maximumLifetimeInMinutes", 
    "minimumLifetimeInMinutes", 
    "includeTargets"})
@JsonInclude(Include.NON_NULL)
public class TemporaryAccessPassAuthenticationMethodConfiguration extends AuthenticationMethodConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.temporaryAccessPassAuthenticationMethodConfiguration";
    }

    @JsonProperty("defaultLength")
    protected Integer defaultLength;

    @JsonProperty("defaultLifetimeInMinutes")
    protected Integer defaultLifetimeInMinutes;

    @JsonProperty("isUsableOnce")
    protected Boolean isUsableOnce;

    @JsonProperty("maximumLifetimeInMinutes")
    protected Integer maximumLifetimeInMinutes;

    @JsonProperty("minimumLifetimeInMinutes")
    protected Integer minimumLifetimeInMinutes;

    @JsonProperty("includeTargets")
    protected List<AuthenticationMethodTarget> includeTargets;

    protected TemporaryAccessPassAuthenticationMethodConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTemporaryAccessPassAuthenticationMethodConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AuthenticationMethodState state;
        private Integer defaultLength;
        private Integer defaultLifetimeInMinutes;
        private Boolean isUsableOnce;
        private Integer maximumLifetimeInMinutes;
        private Integer minimumLifetimeInMinutes;
        private List<AuthenticationMethodTarget> includeTargets;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder state(AuthenticationMethodState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder defaultLength(Integer defaultLength) {
            this.defaultLength = defaultLength;
            this.changedFields = changedFields.add("defaultLength");
            return this;
        }

        public Builder defaultLifetimeInMinutes(Integer defaultLifetimeInMinutes) {
            this.defaultLifetimeInMinutes = defaultLifetimeInMinutes;
            this.changedFields = changedFields.add("defaultLifetimeInMinutes");
            return this;
        }

        public Builder isUsableOnce(Boolean isUsableOnce) {
            this.isUsableOnce = isUsableOnce;
            this.changedFields = changedFields.add("isUsableOnce");
            return this;
        }

        public Builder maximumLifetimeInMinutes(Integer maximumLifetimeInMinutes) {
            this.maximumLifetimeInMinutes = maximumLifetimeInMinutes;
            this.changedFields = changedFields.add("maximumLifetimeInMinutes");
            return this;
        }

        public Builder minimumLifetimeInMinutes(Integer minimumLifetimeInMinutes) {
            this.minimumLifetimeInMinutes = minimumLifetimeInMinutes;
            this.changedFields = changedFields.add("minimumLifetimeInMinutes");
            return this;
        }

        public Builder includeTargets(List<AuthenticationMethodTarget> includeTargets) {
            this.includeTargets = includeTargets;
            this.changedFields = changedFields.add("includeTargets");
            return this;
        }

        public Builder includeTargets(AuthenticationMethodTarget... includeTargets) {
            return includeTargets(Arrays.asList(includeTargets));
        }

        public TemporaryAccessPassAuthenticationMethodConfiguration build() {
            TemporaryAccessPassAuthenticationMethodConfiguration _x = new TemporaryAccessPassAuthenticationMethodConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.temporaryAccessPassAuthenticationMethodConfiguration";
            _x.id = id;
            _x.state = state;
            _x.defaultLength = defaultLength;
            _x.defaultLifetimeInMinutes = defaultLifetimeInMinutes;
            _x.isUsableOnce = isUsableOnce;
            _x.maximumLifetimeInMinutes = maximumLifetimeInMinutes;
            _x.minimumLifetimeInMinutes = minimumLifetimeInMinutes;
            _x.includeTargets = includeTargets;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="defaultLength")
    @JsonIgnore
    public Optional<Integer> getDefaultLength() {
        return Optional.ofNullable(defaultLength);
    }

    public TemporaryAccessPassAuthenticationMethodConfiguration withDefaultLength(Integer defaultLength) {
        TemporaryAccessPassAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defaultLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethodConfiguration");
        _x.defaultLength = defaultLength;
        return _x;
    }

    @Property(name="defaultLifetimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getDefaultLifetimeInMinutes() {
        return Optional.ofNullable(defaultLifetimeInMinutes);
    }

    public TemporaryAccessPassAuthenticationMethodConfiguration withDefaultLifetimeInMinutes(Integer defaultLifetimeInMinutes) {
        TemporaryAccessPassAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defaultLifetimeInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethodConfiguration");
        _x.defaultLifetimeInMinutes = defaultLifetimeInMinutes;
        return _x;
    }

    @Property(name="isUsableOnce")
    @JsonIgnore
    public Optional<Boolean> getIsUsableOnce() {
        return Optional.ofNullable(isUsableOnce);
    }

    public TemporaryAccessPassAuthenticationMethodConfiguration withIsUsableOnce(Boolean isUsableOnce) {
        TemporaryAccessPassAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("isUsableOnce");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethodConfiguration");
        _x.isUsableOnce = isUsableOnce;
        return _x;
    }

    @Property(name="maximumLifetimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getMaximumLifetimeInMinutes() {
        return Optional.ofNullable(maximumLifetimeInMinutes);
    }

    public TemporaryAccessPassAuthenticationMethodConfiguration withMaximumLifetimeInMinutes(Integer maximumLifetimeInMinutes) {
        TemporaryAccessPassAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("maximumLifetimeInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethodConfiguration");
        _x.maximumLifetimeInMinutes = maximumLifetimeInMinutes;
        return _x;
    }

    @Property(name="minimumLifetimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getMinimumLifetimeInMinutes() {
        return Optional.ofNullable(minimumLifetimeInMinutes);
    }

    public TemporaryAccessPassAuthenticationMethodConfiguration withMinimumLifetimeInMinutes(Integer minimumLifetimeInMinutes) {
        TemporaryAccessPassAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("minimumLifetimeInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethodConfiguration");
        _x.minimumLifetimeInMinutes = minimumLifetimeInMinutes;
        return _x;
    }

    public TemporaryAccessPassAuthenticationMethodConfiguration withUnmappedField(String name, Object value) {
        TemporaryAccessPassAuthenticationMethodConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="includeTargets")
    @JsonIgnore
    public AuthenticationMethodTargetCollectionRequest getIncludeTargets() {
        return new AuthenticationMethodTargetCollectionRequest(
                        contextPath.addSegment("includeTargets"), Optional.ofNullable(includeTargets));
    }

    public TemporaryAccessPassAuthenticationMethodConfiguration withIncludeTargets(List<AuthenticationMethodTarget> includeTargets) {
        TemporaryAccessPassAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("includeTargets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethodConfiguration");
        _x.includeTargets = includeTargets;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TemporaryAccessPassAuthenticationMethodConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TemporaryAccessPassAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TemporaryAccessPassAuthenticationMethodConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TemporaryAccessPassAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TemporaryAccessPassAuthenticationMethodConfiguration _copy() {
        TemporaryAccessPassAuthenticationMethodConfiguration _x = new TemporaryAccessPassAuthenticationMethodConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.state = state;
        _x.defaultLength = defaultLength;
        _x.defaultLifetimeInMinutes = defaultLifetimeInMinutes;
        _x.isUsableOnce = isUsableOnce;
        _x.maximumLifetimeInMinutes = maximumLifetimeInMinutes;
        _x.minimumLifetimeInMinutes = minimumLifetimeInMinutes;
        _x.includeTargets = includeTargets;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TemporaryAccessPassAuthenticationMethodConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("defaultLength=");
        b.append(this.defaultLength);
        b.append(", ");
        b.append("defaultLifetimeInMinutes=");
        b.append(this.defaultLifetimeInMinutes);
        b.append(", ");
        b.append("isUsableOnce=");
        b.append(this.isUsableOnce);
        b.append(", ");
        b.append("maximumLifetimeInMinutes=");
        b.append(this.maximumLifetimeInMinutes);
        b.append(", ");
        b.append("minimumLifetimeInMinutes=");
        b.append(this.minimumLifetimeInMinutes);
        b.append(", ");
        b.append("includeTargets=");
        b.append(this.includeTargets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
