package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "productId", 
    "vendorId"})
@JsonInclude(Include.NON_NULL)
public class TeamworkPeripheral extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkPeripheral";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("productId")
    protected String productId;

    @JsonProperty("vendorId")
    protected String vendorId;

    protected TeamworkPeripheral() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamworkPeripheral() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String productId;
        private String vendorId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder productId(String productId) {
            this.productId = productId;
            this.changedFields = changedFields.add("productId");
            return this;
        }

        public Builder vendorId(String vendorId) {
            this.vendorId = vendorId;
            this.changedFields = changedFields.add("vendorId");
            return this;
        }

        public TeamworkPeripheral build() {
            TeamworkPeripheral _x = new TeamworkPeripheral();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkPeripheral";
            _x.id = id;
            _x.displayName = displayName;
            _x.productId = productId;
            _x.vendorId = vendorId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TeamworkPeripheral withDisplayName(String displayName) {
        TeamworkPeripheral _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkPeripheral");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="productId")
    @JsonIgnore
    public Optional<String> getProductId() {
        return Optional.ofNullable(productId);
    }

    public TeamworkPeripheral withProductId(String productId) {
        TeamworkPeripheral _x = _copy();
        _x.changedFields = changedFields.add("productId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkPeripheral");
        _x.productId = productId;
        return _x;
    }

    @Property(name="vendorId")
    @JsonIgnore
    public Optional<String> getVendorId() {
        return Optional.ofNullable(vendorId);
    }

    public TeamworkPeripheral withVendorId(String vendorId) {
        TeamworkPeripheral _x = _copy();
        _x.changedFields = changedFields.add("vendorId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkPeripheral");
        _x.vendorId = vendorId;
        return _x;
    }

    public TeamworkPeripheral withUnmappedField(String name, Object value) {
        TeamworkPeripheral _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkPeripheral patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamworkPeripheral _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkPeripheral put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamworkPeripheral _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamworkPeripheral _copy() {
        TeamworkPeripheral _x = new TeamworkPeripheral();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.productId = productId;
        _x.vendorId = vendorId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkPeripheral[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("productId=");
        b.append(this.productId);
        b.append(", ");
        b.append("vendorId=");
        b.append(this.vendorId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
