package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.OperationError;
import odata.msgraph.client.beta.enums.TeamworkDeviceOperationType;

@JsonPropertyOrder({
    "@odata.type", 
    "completedDateTime", 
    "createdBy", 
    "createdDateTime", 
    "error", 
    "lastActionBy", 
    "lastActionDateTime", 
    "operationType", 
    "startedDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class TeamworkDeviceOperation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkDeviceOperation";
    }

    @JsonProperty("completedDateTime")
    protected OffsetDateTime completedDateTime;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("error")
    protected OperationError error;

    @JsonProperty("lastActionBy")
    protected IdentitySet lastActionBy;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    @JsonProperty("operationType")
    protected TeamworkDeviceOperationType operationType;

    @JsonProperty("startedDateTime")
    protected OffsetDateTime startedDateTime;

    @JsonProperty("status")
    protected String status;

    protected TeamworkDeviceOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamworkDeviceOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime completedDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private OperationError error;
        private IdentitySet lastActionBy;
        private OffsetDateTime lastActionDateTime;
        private TeamworkDeviceOperationType operationType;
        private OffsetDateTime startedDateTime;
        private String status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder error(OperationError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder lastActionBy(IdentitySet lastActionBy) {
            this.lastActionBy = lastActionBy;
            this.changedFields = changedFields.add("lastActionBy");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder operationType(TeamworkDeviceOperationType operationType) {
            this.operationType = operationType;
            this.changedFields = changedFields.add("operationType");
            return this;
        }

        public Builder startedDateTime(OffsetDateTime startedDateTime) {
            this.startedDateTime = startedDateTime;
            this.changedFields = changedFields.add("startedDateTime");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public TeamworkDeviceOperation build() {
            TeamworkDeviceOperation _x = new TeamworkDeviceOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkDeviceOperation";
            _x.id = id;
            _x.completedDateTime = completedDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.error = error;
            _x.lastActionBy = lastActionBy;
            _x.lastActionDateTime = lastActionDateTime;
            _x.operationType = operationType;
            _x.startedDateTime = startedDateTime;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    public TeamworkDeviceOperation withCompletedDateTime(OffsetDateTime completedDateTime) {
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = changedFields.add("completedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceOperation");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public TeamworkDeviceOperation withCreatedBy(IdentitySet createdBy) {
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceOperation");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public TeamworkDeviceOperation withCreatedDateTime(OffsetDateTime createdDateTime) {
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceOperation");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<OperationError> getError() {
        return Optional.ofNullable(error);
    }

    public TeamworkDeviceOperation withError(OperationError error) {
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = changedFields.add("error");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceOperation");
        _x.error = error;
        return _x;
    }

    @Property(name="lastActionBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastActionBy() {
        return Optional.ofNullable(lastActionBy);
    }

    public TeamworkDeviceOperation withLastActionBy(IdentitySet lastActionBy) {
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = changedFields.add("lastActionBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceOperation");
        _x.lastActionBy = lastActionBy;
        return _x;
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public TeamworkDeviceOperation withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = changedFields.add("lastActionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceOperation");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Property(name="operationType")
    @JsonIgnore
    public Optional<TeamworkDeviceOperationType> getOperationType() {
        return Optional.ofNullable(operationType);
    }

    public TeamworkDeviceOperation withOperationType(TeamworkDeviceOperationType operationType) {
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = changedFields.add("operationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceOperation");
        _x.operationType = operationType;
        return _x;
    }

    @Property(name="startedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartedDateTime() {
        return Optional.ofNullable(startedDateTime);
    }

    public TeamworkDeviceOperation withStartedDateTime(OffsetDateTime startedDateTime) {
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = changedFields.add("startedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceOperation");
        _x.startedDateTime = startedDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public TeamworkDeviceOperation withStatus(String status) {
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceOperation");
        _x.status = status;
        return _x;
    }

    public TeamworkDeviceOperation withUnmappedField(String name, Object value) {
        TeamworkDeviceOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkDeviceOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkDeviceOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamworkDeviceOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamworkDeviceOperation _copy() {
        TeamworkDeviceOperation _x = new TeamworkDeviceOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.completedDateTime = completedDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.error = error;
        _x.lastActionBy = lastActionBy;
        _x.lastActionDateTime = lastActionDateTime;
        _x.operationType = operationType;
        _x.startedDateTime = startedDateTime;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkDeviceOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("lastActionBy=");
        b.append(this.lastActionBy);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("operationType=");
        b.append(this.operationType);
        b.append(", ");
        b.append("startedDateTime=");
        b.append(this.startedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
