package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.TeamworkCameraConfiguration;
import odata.msgraph.client.beta.complex.TeamworkDeviceSoftwareVersions;
import odata.msgraph.client.beta.complex.TeamworkDisplayConfiguration;
import odata.msgraph.client.beta.complex.TeamworkHardwareConfiguration;
import odata.msgraph.client.beta.complex.TeamworkMicrophoneConfiguration;
import odata.msgraph.client.beta.complex.TeamworkSpeakerConfiguration;
import odata.msgraph.client.beta.complex.TeamworkSystemConfiguration;
import odata.msgraph.client.beta.complex.TeamworkTeamsClientConfiguration;

@JsonPropertyOrder({
    "@odata.type", 
    "cameraConfiguration", 
    "createdBy", 
    "createdDateTime", 
    "displayConfiguration", 
    "hardwareConfiguration", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "microphoneConfiguration", 
    "softwareVersions", 
    "speakerConfiguration", 
    "systemConfiguration", 
    "teamsClientConfiguration"})
@JsonInclude(Include.NON_NULL)
public class TeamworkDeviceConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkDeviceConfiguration";
    }

    @JsonProperty("cameraConfiguration")
    protected TeamworkCameraConfiguration cameraConfiguration;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayConfiguration")
    protected TeamworkDisplayConfiguration displayConfiguration;

    @JsonProperty("hardwareConfiguration")
    protected TeamworkHardwareConfiguration hardwareConfiguration;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("microphoneConfiguration")
    protected TeamworkMicrophoneConfiguration microphoneConfiguration;

    @JsonProperty("softwareVersions")
    protected TeamworkDeviceSoftwareVersions softwareVersions;

    @JsonProperty("speakerConfiguration")
    protected TeamworkSpeakerConfiguration speakerConfiguration;

    @JsonProperty("systemConfiguration")
    protected TeamworkSystemConfiguration systemConfiguration;

    @JsonProperty("teamsClientConfiguration")
    protected TeamworkTeamsClientConfiguration teamsClientConfiguration;

    protected TeamworkDeviceConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamworkDeviceConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private TeamworkCameraConfiguration cameraConfiguration;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private TeamworkDisplayConfiguration displayConfiguration;
        private TeamworkHardwareConfiguration hardwareConfiguration;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private TeamworkMicrophoneConfiguration microphoneConfiguration;
        private TeamworkDeviceSoftwareVersions softwareVersions;
        private TeamworkSpeakerConfiguration speakerConfiguration;
        private TeamworkSystemConfiguration systemConfiguration;
        private TeamworkTeamsClientConfiguration teamsClientConfiguration;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder cameraConfiguration(TeamworkCameraConfiguration cameraConfiguration) {
            this.cameraConfiguration = cameraConfiguration;
            this.changedFields = changedFields.add("cameraConfiguration");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayConfiguration(TeamworkDisplayConfiguration displayConfiguration) {
            this.displayConfiguration = displayConfiguration;
            this.changedFields = changedFields.add("displayConfiguration");
            return this;
        }

        public Builder hardwareConfiguration(TeamworkHardwareConfiguration hardwareConfiguration) {
            this.hardwareConfiguration = hardwareConfiguration;
            this.changedFields = changedFields.add("hardwareConfiguration");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder microphoneConfiguration(TeamworkMicrophoneConfiguration microphoneConfiguration) {
            this.microphoneConfiguration = microphoneConfiguration;
            this.changedFields = changedFields.add("microphoneConfiguration");
            return this;
        }

        public Builder softwareVersions(TeamworkDeviceSoftwareVersions softwareVersions) {
            this.softwareVersions = softwareVersions;
            this.changedFields = changedFields.add("softwareVersions");
            return this;
        }

        public Builder speakerConfiguration(TeamworkSpeakerConfiguration speakerConfiguration) {
            this.speakerConfiguration = speakerConfiguration;
            this.changedFields = changedFields.add("speakerConfiguration");
            return this;
        }

        public Builder systemConfiguration(TeamworkSystemConfiguration systemConfiguration) {
            this.systemConfiguration = systemConfiguration;
            this.changedFields = changedFields.add("systemConfiguration");
            return this;
        }

        public Builder teamsClientConfiguration(TeamworkTeamsClientConfiguration teamsClientConfiguration) {
            this.teamsClientConfiguration = teamsClientConfiguration;
            this.changedFields = changedFields.add("teamsClientConfiguration");
            return this;
        }

        public TeamworkDeviceConfiguration build() {
            TeamworkDeviceConfiguration _x = new TeamworkDeviceConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkDeviceConfiguration";
            _x.id = id;
            _x.cameraConfiguration = cameraConfiguration;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.displayConfiguration = displayConfiguration;
            _x.hardwareConfiguration = hardwareConfiguration;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.microphoneConfiguration = microphoneConfiguration;
            _x.softwareVersions = softwareVersions;
            _x.speakerConfiguration = speakerConfiguration;
            _x.systemConfiguration = systemConfiguration;
            _x.teamsClientConfiguration = teamsClientConfiguration;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="cameraConfiguration")
    @JsonIgnore
    public Optional<TeamworkCameraConfiguration> getCameraConfiguration() {
        return Optional.ofNullable(cameraConfiguration);
    }

    public TeamworkDeviceConfiguration withCameraConfiguration(TeamworkCameraConfiguration cameraConfiguration) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cameraConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.cameraConfiguration = cameraConfiguration;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public TeamworkDeviceConfiguration withCreatedBy(IdentitySet createdBy) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public TeamworkDeviceConfiguration withCreatedDateTime(OffsetDateTime createdDateTime) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayConfiguration")
    @JsonIgnore
    public Optional<TeamworkDisplayConfiguration> getDisplayConfiguration() {
        return Optional.ofNullable(displayConfiguration);
    }

    public TeamworkDeviceConfiguration withDisplayConfiguration(TeamworkDisplayConfiguration displayConfiguration) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.displayConfiguration = displayConfiguration;
        return _x;
    }

    @Property(name="hardwareConfiguration")
    @JsonIgnore
    public Optional<TeamworkHardwareConfiguration> getHardwareConfiguration() {
        return Optional.ofNullable(hardwareConfiguration);
    }

    public TeamworkDeviceConfiguration withHardwareConfiguration(TeamworkHardwareConfiguration hardwareConfiguration) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("hardwareConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.hardwareConfiguration = hardwareConfiguration;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public TeamworkDeviceConfiguration withLastModifiedBy(IdentitySet lastModifiedBy) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public TeamworkDeviceConfiguration withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="microphoneConfiguration")
    @JsonIgnore
    public Optional<TeamworkMicrophoneConfiguration> getMicrophoneConfiguration() {
        return Optional.ofNullable(microphoneConfiguration);
    }

    public TeamworkDeviceConfiguration withMicrophoneConfiguration(TeamworkMicrophoneConfiguration microphoneConfiguration) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microphoneConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.microphoneConfiguration = microphoneConfiguration;
        return _x;
    }

    @Property(name="softwareVersions")
    @JsonIgnore
    public Optional<TeamworkDeviceSoftwareVersions> getSoftwareVersions() {
        return Optional.ofNullable(softwareVersions);
    }

    public TeamworkDeviceConfiguration withSoftwareVersions(TeamworkDeviceSoftwareVersions softwareVersions) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("softwareVersions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.softwareVersions = softwareVersions;
        return _x;
    }

    @Property(name="speakerConfiguration")
    @JsonIgnore
    public Optional<TeamworkSpeakerConfiguration> getSpeakerConfiguration() {
        return Optional.ofNullable(speakerConfiguration);
    }

    public TeamworkDeviceConfiguration withSpeakerConfiguration(TeamworkSpeakerConfiguration speakerConfiguration) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("speakerConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.speakerConfiguration = speakerConfiguration;
        return _x;
    }

    @Property(name="systemConfiguration")
    @JsonIgnore
    public Optional<TeamworkSystemConfiguration> getSystemConfiguration() {
        return Optional.ofNullable(systemConfiguration);
    }

    public TeamworkDeviceConfiguration withSystemConfiguration(TeamworkSystemConfiguration systemConfiguration) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("systemConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.systemConfiguration = systemConfiguration;
        return _x;
    }

    @Property(name="teamsClientConfiguration")
    @JsonIgnore
    public Optional<TeamworkTeamsClientConfiguration> getTeamsClientConfiguration() {
        return Optional.ofNullable(teamsClientConfiguration);
    }

    public TeamworkDeviceConfiguration withTeamsClientConfiguration(TeamworkTeamsClientConfiguration teamsClientConfiguration) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("teamsClientConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceConfiguration");
        _x.teamsClientConfiguration = teamsClientConfiguration;
        return _x;
    }

    public TeamworkDeviceConfiguration withUnmappedField(String name, Object value) {
        TeamworkDeviceConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkDeviceConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkDeviceConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamworkDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamworkDeviceConfiguration _copy() {
        TeamworkDeviceConfiguration _x = new TeamworkDeviceConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.cameraConfiguration = cameraConfiguration;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.displayConfiguration = displayConfiguration;
        _x.hardwareConfiguration = hardwareConfiguration;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.microphoneConfiguration = microphoneConfiguration;
        _x.softwareVersions = softwareVersions;
        _x.speakerConfiguration = speakerConfiguration;
        _x.systemConfiguration = systemConfiguration;
        _x.teamsClientConfiguration = teamsClientConfiguration;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkDeviceConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("cameraConfiguration=");
        b.append(this.cameraConfiguration);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayConfiguration=");
        b.append(this.displayConfiguration);
        b.append(", ");
        b.append("hardwareConfiguration=");
        b.append(this.hardwareConfiguration);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("microphoneConfiguration=");
        b.append(this.microphoneConfiguration);
        b.append(", ");
        b.append("softwareVersions=");
        b.append(this.softwareVersions);
        b.append(", ");
        b.append("speakerConfiguration=");
        b.append(this.speakerConfiguration);
        b.append(", ");
        b.append("systemConfiguration=");
        b.append(this.systemConfiguration);
        b.append(", ");
        b.append("teamsClientConfiguration=");
        b.append(this.teamsClientConfiguration);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
