package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.TeamworkActivePeripherals;

@JsonPropertyOrder({
    "@odata.type", 
    "activePeripherals", 
    "createdBy", 
    "createdDateTime", 
    "lastModifiedBy", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class TeamworkDeviceActivity extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkDeviceActivity";
    }

    @JsonProperty("activePeripherals")
    protected TeamworkActivePeripherals activePeripherals;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected TeamworkDeviceActivity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamworkDeviceActivity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private TeamworkActivePeripherals activePeripherals;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activePeripherals(TeamworkActivePeripherals activePeripherals) {
            this.activePeripherals = activePeripherals;
            this.changedFields = changedFields.add("activePeripherals");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public TeamworkDeviceActivity build() {
            TeamworkDeviceActivity _x = new TeamworkDeviceActivity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkDeviceActivity";
            _x.id = id;
            _x.activePeripherals = activePeripherals;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activePeripherals")
    @JsonIgnore
    public Optional<TeamworkActivePeripherals> getActivePeripherals() {
        return Optional.ofNullable(activePeripherals);
    }

    public TeamworkDeviceActivity withActivePeripherals(TeamworkActivePeripherals activePeripherals) {
        TeamworkDeviceActivity _x = _copy();
        _x.changedFields = changedFields.add("activePeripherals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceActivity");
        _x.activePeripherals = activePeripherals;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public TeamworkDeviceActivity withCreatedBy(IdentitySet createdBy) {
        TeamworkDeviceActivity _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceActivity");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public TeamworkDeviceActivity withCreatedDateTime(OffsetDateTime createdDateTime) {
        TeamworkDeviceActivity _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceActivity");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public TeamworkDeviceActivity withLastModifiedBy(IdentitySet lastModifiedBy) {
        TeamworkDeviceActivity _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceActivity");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public TeamworkDeviceActivity withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        TeamworkDeviceActivity _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceActivity");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    public TeamworkDeviceActivity withUnmappedField(String name, Object value) {
        TeamworkDeviceActivity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkDeviceActivity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamworkDeviceActivity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkDeviceActivity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamworkDeviceActivity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamworkDeviceActivity _copy() {
        TeamworkDeviceActivity _x = new TeamworkDeviceActivity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activePeripherals = activePeripherals;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkDeviceActivity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activePeripherals=");
        b.append(this.activePeripherals);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
