package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.TeamworkDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkforceIntegrationCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "workforceIntegrations", 
    "devices"})
@JsonInclude(Include.NON_NULL)
public class Teamwork extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamwork";
    }

    @JsonProperty("workforceIntegrations")
    protected List<WorkforceIntegration> workforceIntegrations;

    @JsonProperty("devices")
    protected List<TeamworkDevice> devices;

    protected Teamwork() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamwork() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<WorkforceIntegration> workforceIntegrations;
        private List<TeamworkDevice> devices;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder workforceIntegrations(List<WorkforceIntegration> workforceIntegrations) {
            this.workforceIntegrations = workforceIntegrations;
            this.changedFields = changedFields.add("workforceIntegrations");
            return this;
        }

        public Builder workforceIntegrations(WorkforceIntegration... workforceIntegrations) {
            return workforceIntegrations(Arrays.asList(workforceIntegrations));
        }

        public Builder devices(List<TeamworkDevice> devices) {
            this.devices = devices;
            this.changedFields = changedFields.add("devices");
            return this;
        }

        public Builder devices(TeamworkDevice... devices) {
            return devices(Arrays.asList(devices));
        }

        public Teamwork build() {
            Teamwork _x = new Teamwork();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamwork";
            _x.id = id;
            _x.workforceIntegrations = workforceIntegrations;
            _x.devices = devices;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public Teamwork withUnmappedField(String name, Object value) {
        Teamwork _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="workforceIntegrations")
    @JsonIgnore
    public WorkforceIntegrationCollectionRequest getWorkforceIntegrations() {
        return new WorkforceIntegrationCollectionRequest(
                        contextPath.addSegment("workforceIntegrations"), Optional.ofNullable(workforceIntegrations));
    }

    @NavigationProperty(name="devices")
    @JsonIgnore
    public TeamworkDeviceCollectionRequest getDevices() {
        return new TeamworkDeviceCollectionRequest(
                        contextPath.addSegment("devices"), Optional.ofNullable(devices));
    }

    public Teamwork withWorkforceIntegrations(List<WorkforceIntegration> workforceIntegrations) {
        Teamwork _x = _copy();
        _x.changedFields = changedFields.add("workforceIntegrations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamwork");
        _x.workforceIntegrations = workforceIntegrations;
        return _x;
    }

    public Teamwork withDevices(List<TeamworkDevice> devices) {
        Teamwork _x = _copy();
        _x.changedFields = changedFields.add("devices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamwork");
        _x.devices = devices;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teamwork patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Teamwork _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teamwork put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Teamwork _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Teamwork _copy() {
        Teamwork _x = new Teamwork();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.workforceIntegrations = workforceIntegrations;
        _x.devices = devices;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Teamwork[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("workforceIntegrations=");
        b.append(this.workforceIntegrations);
        b.append(", ");
        b.append("devices=");
        b.append(this.devices);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
