package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.TeamsTabConfiguration;
import odata.msgraph.client.beta.entity.request.TeamsAppRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "configuration", 
    "displayName", 
    "messageId", 
    "sortOrderIndex", 
    "teamsAppId", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class TeamsTab extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamsTab";
    }

    @JsonProperty("configuration")
    protected TeamsTabConfiguration configuration;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("messageId")
    protected String messageId;

    @JsonProperty("sortOrderIndex")
    protected String sortOrderIndex;

    @JsonProperty("teamsAppId")
    protected String teamsAppId;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected TeamsTab() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamsTab() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private TeamsTabConfiguration configuration;
        private String displayName;
        private String messageId;
        private String sortOrderIndex;
        private String teamsAppId;
        private String webUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder configuration(TeamsTabConfiguration configuration) {
            this.configuration = configuration;
            this.changedFields = changedFields.add("configuration");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            this.changedFields = changedFields.add("messageId");
            return this;
        }

        public Builder sortOrderIndex(String sortOrderIndex) {
            this.sortOrderIndex = sortOrderIndex;
            this.changedFields = changedFields.add("sortOrderIndex");
            return this;
        }

        public Builder teamsAppId(String teamsAppId) {
            this.teamsAppId = teamsAppId;
            this.changedFields = changedFields.add("teamsAppId");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public TeamsTab build() {
            TeamsTab _x = new TeamsTab();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamsTab";
            _x.id = id;
            _x.configuration = configuration;
            _x.displayName = displayName;
            _x.messageId = messageId;
            _x.sortOrderIndex = sortOrderIndex;
            _x.teamsAppId = teamsAppId;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="configuration")
    @JsonIgnore
    public Optional<TeamsTabConfiguration> getConfiguration() {
        return Optional.ofNullable(configuration);
    }

    public TeamsTab withConfiguration(TeamsTabConfiguration configuration) {
        TeamsTab _x = _copy();
        _x.changedFields = changedFields.add("configuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsTab");
        _x.configuration = configuration;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TeamsTab withDisplayName(String displayName) {
        TeamsTab _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsTab");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="messageId")
    @JsonIgnore
    public Optional<String> getMessageId() {
        return Optional.ofNullable(messageId);
    }

    public TeamsTab withMessageId(String messageId) {
        TeamsTab _x = _copy();
        _x.changedFields = changedFields.add("messageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsTab");
        _x.messageId = messageId;
        return _x;
    }

    @Property(name="sortOrderIndex")
    @JsonIgnore
    public Optional<String> getSortOrderIndex() {
        return Optional.ofNullable(sortOrderIndex);
    }

    public TeamsTab withSortOrderIndex(String sortOrderIndex) {
        TeamsTab _x = _copy();
        _x.changedFields = changedFields.add("sortOrderIndex");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsTab");
        _x.sortOrderIndex = sortOrderIndex;
        return _x;
    }

    @Property(name="teamsAppId")
    @JsonIgnore
    public Optional<String> getTeamsAppId() {
        return Optional.ofNullable(teamsAppId);
    }

    public TeamsTab withTeamsAppId(String teamsAppId) {
        TeamsTab _x = _copy();
        _x.changedFields = changedFields.add("teamsAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsTab");
        _x.teamsAppId = teamsAppId;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public TeamsTab withWebUrl(String webUrl) {
        TeamsTab _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsTab");
        _x.webUrl = webUrl;
        return _x;
    }

    public TeamsTab withUnmappedField(String name, Object value) {
        TeamsTab _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="teamsApp")
    @JsonIgnore
    public TeamsAppRequest getTeamsApp() {
        return new TeamsAppRequest(contextPath.addSegment("teamsApp"), RequestHelper.getValue(unmappedFields, "teamsApp"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsTab patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamsTab _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsTab put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamsTab _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamsTab _copy() {
        TeamsTab _x = new TeamsTab();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.configuration = configuration;
        _x.displayName = displayName;
        _x.messageId = messageId;
        _x.sortOrderIndex = sortOrderIndex;
        _x.teamsAppId = teamsAppId;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamsTab[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("configuration=");
        b.append(this.configuration);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("messageId=");
        b.append(this.messageId);
        b.append(", ");
        b.append("sortOrderIndex=");
        b.append(this.sortOrderIndex);
        b.append(", ");
        b.append("teamsAppId=");
        b.append(this.teamsAppId);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
