package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OperationError;
import odata.msgraph.client.beta.enums.TeamsAsyncOperationStatus;
import odata.msgraph.client.beta.enums.TeamsAsyncOperationType;

@JsonPropertyOrder({
    "@odata.type", 
    "attemptsCount", 
    "createdDateTime", 
    "error", 
    "lastActionDateTime", 
    "operationType", 
    "status", 
    "targetResourceId", 
    "targetResourceLocation"})
@JsonInclude(Include.NON_NULL)
public class TeamsAsyncOperation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamsAsyncOperation";
    }

    @JsonProperty("attemptsCount")
    protected Integer attemptsCount;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("error")
    protected OperationError error;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    @JsonProperty("operationType")
    protected TeamsAsyncOperationType operationType;

    @JsonProperty("status")
    protected TeamsAsyncOperationStatus status;

    @JsonProperty("targetResourceId")
    protected String targetResourceId;

    @JsonProperty("targetResourceLocation")
    protected String targetResourceLocation;

    protected TeamsAsyncOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamsAsyncOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer attemptsCount;
        private OffsetDateTime createdDateTime;
        private OperationError error;
        private OffsetDateTime lastActionDateTime;
        private TeamsAsyncOperationType operationType;
        private TeamsAsyncOperationStatus status;
        private String targetResourceId;
        private String targetResourceLocation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder attemptsCount(Integer attemptsCount) {
            this.attemptsCount = attemptsCount;
            this.changedFields = changedFields.add("attemptsCount");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder error(OperationError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder operationType(TeamsAsyncOperationType operationType) {
            this.operationType = operationType;
            this.changedFields = changedFields.add("operationType");
            return this;
        }

        public Builder status(TeamsAsyncOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            this.changedFields = changedFields.add("targetResourceId");
            return this;
        }

        public Builder targetResourceLocation(String targetResourceLocation) {
            this.targetResourceLocation = targetResourceLocation;
            this.changedFields = changedFields.add("targetResourceLocation");
            return this;
        }

        public TeamsAsyncOperation build() {
            TeamsAsyncOperation _x = new TeamsAsyncOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamsAsyncOperation";
            _x.id = id;
            _x.attemptsCount = attemptsCount;
            _x.createdDateTime = createdDateTime;
            _x.error = error;
            _x.lastActionDateTime = lastActionDateTime;
            _x.operationType = operationType;
            _x.status = status;
            _x.targetResourceId = targetResourceId;
            _x.targetResourceLocation = targetResourceLocation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="attemptsCount")
    @JsonIgnore
    public Optional<Integer> getAttemptsCount() {
        return Optional.ofNullable(attemptsCount);
    }

    public TeamsAsyncOperation withAttemptsCount(Integer attemptsCount) {
        TeamsAsyncOperation _x = _copy();
        _x.changedFields = changedFields.add("attemptsCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAsyncOperation");
        _x.attemptsCount = attemptsCount;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public TeamsAsyncOperation withCreatedDateTime(OffsetDateTime createdDateTime) {
        TeamsAsyncOperation _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAsyncOperation");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<OperationError> getError() {
        return Optional.ofNullable(error);
    }

    public TeamsAsyncOperation withError(OperationError error) {
        TeamsAsyncOperation _x = _copy();
        _x.changedFields = changedFields.add("error");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAsyncOperation");
        _x.error = error;
        return _x;
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public TeamsAsyncOperation withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        TeamsAsyncOperation _x = _copy();
        _x.changedFields = changedFields.add("lastActionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAsyncOperation");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Property(name="operationType")
    @JsonIgnore
    public Optional<TeamsAsyncOperationType> getOperationType() {
        return Optional.ofNullable(operationType);
    }

    public TeamsAsyncOperation withOperationType(TeamsAsyncOperationType operationType) {
        TeamsAsyncOperation _x = _copy();
        _x.changedFields = changedFields.add("operationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAsyncOperation");
        _x.operationType = operationType;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<TeamsAsyncOperationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public TeamsAsyncOperation withStatus(TeamsAsyncOperationStatus status) {
        TeamsAsyncOperation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAsyncOperation");
        _x.status = status;
        return _x;
    }

    @Property(name="targetResourceId")
    @JsonIgnore
    public Optional<String> getTargetResourceId() {
        return Optional.ofNullable(targetResourceId);
    }

    public TeamsAsyncOperation withTargetResourceId(String targetResourceId) {
        TeamsAsyncOperation _x = _copy();
        _x.changedFields = changedFields.add("targetResourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAsyncOperation");
        _x.targetResourceId = targetResourceId;
        return _x;
    }

    @Property(name="targetResourceLocation")
    @JsonIgnore
    public Optional<String> getTargetResourceLocation() {
        return Optional.ofNullable(targetResourceLocation);
    }

    public TeamsAsyncOperation withTargetResourceLocation(String targetResourceLocation) {
        TeamsAsyncOperation _x = _copy();
        _x.changedFields = changedFields.add("targetResourceLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAsyncOperation");
        _x.targetResourceLocation = targetResourceLocation;
        return _x;
    }

    public TeamsAsyncOperation withUnmappedField(String name, Object value) {
        TeamsAsyncOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsAsyncOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamsAsyncOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsAsyncOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamsAsyncOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamsAsyncOperation _copy() {
        TeamsAsyncOperation _x = new TeamsAsyncOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.attemptsCount = attemptsCount;
        _x.createdDateTime = createdDateTime;
        _x.error = error;
        _x.lastActionDateTime = lastActionDateTime;
        _x.operationType = operationType;
        _x.status = status;
        _x.targetResourceId = targetResourceId;
        _x.targetResourceLocation = targetResourceLocation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamsAsyncOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("attemptsCount=");
        b.append(this.attemptsCount);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("operationType=");
        b.append(this.operationType);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("targetResourceId=");
        b.append(this.targetResourceId);
        b.append(", ");
        b.append("targetResourceLocation=");
        b.append(this.targetResourceLocation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
