package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.TeamworkHostedContentRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "webUrl", 
    "hostedContent"})
@JsonInclude(Include.NON_NULL)
public class TeamsAppIcon extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamsAppIcon";
    }

    @JsonProperty("webUrl")
    protected String webUrl;

    @JsonProperty("hostedContent")
    protected TeamworkHostedContent hostedContent;

    protected TeamsAppIcon() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamsAppIcon() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String webUrl;
        private TeamworkHostedContent hostedContent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder hostedContent(TeamworkHostedContent hostedContent) {
            this.hostedContent = hostedContent;
            this.changedFields = changedFields.add("hostedContent");
            return this;
        }

        public TeamsAppIcon build() {
            TeamsAppIcon _x = new TeamsAppIcon();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamsAppIcon";
            _x.id = id;
            _x.webUrl = webUrl;
            _x.hostedContent = hostedContent;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public TeamsAppIcon withWebUrl(String webUrl) {
        TeamsAppIcon _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppIcon");
        _x.webUrl = webUrl;
        return _x;
    }

    public TeamsAppIcon withUnmappedField(String name, Object value) {
        TeamsAppIcon _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="hostedContent")
    @JsonIgnore
    public TeamworkHostedContentRequest getHostedContent() {
        return new TeamworkHostedContentRequest(contextPath.addSegment("hostedContent"), Optional.ofNullable(hostedContent));
    }

    public TeamsAppIcon withHostedContent(TeamworkHostedContent hostedContent) {
        TeamsAppIcon _x = _copy();
        _x.changedFields = changedFields.add("hostedContent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppIcon");
        _x.hostedContent = hostedContent;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsAppIcon patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamsAppIcon _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsAppIcon put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamsAppIcon _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamsAppIcon _copy() {
        TeamsAppIcon _x = new TeamsAppIcon();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.webUrl = webUrl;
        _x.hostedContent = hostedContent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamsAppIcon[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("hostedContent=");
        b.append(this.hostedContent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
