package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.request.TeamsAppIconRequest;
import odata.msgraph.client.beta.entity.request.TeamworkBotRequest;
import odata.msgraph.client.beta.enums.TeamsAppInstallationScopes;
import odata.msgraph.client.beta.enums.TeamsAppPublishingState;

@JsonPropertyOrder({
    "@odata.type", 
    "allowedInstallationScopes", 
    "azureADAppId", 
    "createdBy", 
    "description", 
    "displayName", 
    "lastModifiedDateTime", 
    "publishingState", 
    "shortdescription", 
    "teamsAppId", 
    "version", 
    "bot", 
    "colorIcon", 
    "outlineIcon"})
@JsonInclude(Include.NON_NULL)
public class TeamsAppDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamsAppDefinition";
    }

    @JsonProperty("allowedInstallationScopes")
    protected TeamsAppInstallationScopes allowedInstallationScopes;

    @JsonProperty("azureADAppId")
    protected String azureADAppId;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("publishingState")
    protected TeamsAppPublishingState publishingState;

    @JsonProperty("shortdescription")
    protected String shortdescription;

    @JsonProperty("teamsAppId")
    protected String teamsAppId;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("bot")
    protected TeamworkBot bot;

    @JsonProperty("colorIcon")
    protected TeamsAppIcon colorIcon;

    @JsonProperty("outlineIcon")
    protected TeamsAppIcon outlineIcon;

    protected TeamsAppDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamsAppDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private TeamsAppInstallationScopes allowedInstallationScopes;
        private String azureADAppId;
        private IdentitySet createdBy;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private TeamsAppPublishingState publishingState;
        private String shortdescription;
        private String teamsAppId;
        private String version;
        private TeamworkBot bot;
        private TeamsAppIcon colorIcon;
        private TeamsAppIcon outlineIcon;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedInstallationScopes(TeamsAppInstallationScopes allowedInstallationScopes) {
            this.allowedInstallationScopes = allowedInstallationScopes;
            this.changedFields = changedFields.add("allowedInstallationScopes");
            return this;
        }

        public Builder azureADAppId(String azureADAppId) {
            this.azureADAppId = azureADAppId;
            this.changedFields = changedFields.add("azureADAppId");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder publishingState(TeamsAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder shortdescription(String shortdescription) {
            this.shortdescription = shortdescription;
            this.changedFields = changedFields.add("shortdescription");
            return this;
        }

        public Builder teamsAppId(String teamsAppId) {
            this.teamsAppId = teamsAppId;
            this.changedFields = changedFields.add("teamsAppId");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder bot(TeamworkBot bot) {
            this.bot = bot;
            this.changedFields = changedFields.add("bot");
            return this;
        }

        public Builder colorIcon(TeamsAppIcon colorIcon) {
            this.colorIcon = colorIcon;
            this.changedFields = changedFields.add("colorIcon");
            return this;
        }

        public Builder outlineIcon(TeamsAppIcon outlineIcon) {
            this.outlineIcon = outlineIcon;
            this.changedFields = changedFields.add("outlineIcon");
            return this;
        }

        public TeamsAppDefinition build() {
            TeamsAppDefinition _x = new TeamsAppDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamsAppDefinition";
            _x.id = id;
            _x.allowedInstallationScopes = allowedInstallationScopes;
            _x.azureADAppId = azureADAppId;
            _x.createdBy = createdBy;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.publishingState = publishingState;
            _x.shortdescription = shortdescription;
            _x.teamsAppId = teamsAppId;
            _x.version = version;
            _x.bot = bot;
            _x.colorIcon = colorIcon;
            _x.outlineIcon = outlineIcon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="allowedInstallationScopes")
    @JsonIgnore
    public Optional<TeamsAppInstallationScopes> getAllowedInstallationScopes() {
        return Optional.ofNullable(allowedInstallationScopes);
    }

    public TeamsAppDefinition withAllowedInstallationScopes(TeamsAppInstallationScopes allowedInstallationScopes) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("allowedInstallationScopes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.allowedInstallationScopes = allowedInstallationScopes;
        return _x;
    }

    @Property(name="azureADAppId")
    @JsonIgnore
    public Optional<String> getAzureADAppId() {
        return Optional.ofNullable(azureADAppId);
    }

    public TeamsAppDefinition withAzureADAppId(String azureADAppId) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("azureADAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.azureADAppId = azureADAppId;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public TeamsAppDefinition withCreatedBy(IdentitySet createdBy) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public TeamsAppDefinition withDescription(String description) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TeamsAppDefinition withDisplayName(String displayName) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public TeamsAppDefinition withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="publishingState")
    @JsonIgnore
    public Optional<TeamsAppPublishingState> getPublishingState() {
        return Optional.ofNullable(publishingState);
    }

    public TeamsAppDefinition withPublishingState(TeamsAppPublishingState publishingState) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("publishingState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.publishingState = publishingState;
        return _x;
    }

    @Property(name="shortdescription")
    @JsonIgnore
    public Optional<String> getShortdescription() {
        return Optional.ofNullable(shortdescription);
    }

    public TeamsAppDefinition withShortdescription(String shortdescription) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("shortdescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.shortdescription = shortdescription;
        return _x;
    }

    @Property(name="teamsAppId")
    @JsonIgnore
    public Optional<String> getTeamsAppId() {
        return Optional.ofNullable(teamsAppId);
    }

    public TeamsAppDefinition withTeamsAppId(String teamsAppId) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("teamsAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.teamsAppId = teamsAppId;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public TeamsAppDefinition withVersion(String version) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.version = version;
        return _x;
    }

    public TeamsAppDefinition withUnmappedField(String name, Object value) {
        TeamsAppDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="bot")
    @JsonIgnore
    public TeamworkBotRequest getBot() {
        return new TeamworkBotRequest(contextPath.addSegment("bot"), Optional.ofNullable(bot));
    }

    @NavigationProperty(name="colorIcon")
    @JsonIgnore
    public TeamsAppIconRequest getColorIcon() {
        return new TeamsAppIconRequest(contextPath.addSegment("colorIcon"), Optional.ofNullable(colorIcon));
    }

    @NavigationProperty(name="outlineIcon")
    @JsonIgnore
    public TeamsAppIconRequest getOutlineIcon() {
        return new TeamsAppIconRequest(contextPath.addSegment("outlineIcon"), Optional.ofNullable(outlineIcon));
    }

    public TeamsAppDefinition withBot(TeamworkBot bot) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("bot");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.bot = bot;
        return _x;
    }

    public TeamsAppDefinition withColorIcon(TeamsAppIcon colorIcon) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("colorIcon");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.colorIcon = colorIcon;
        return _x;
    }

    public TeamsAppDefinition withOutlineIcon(TeamsAppIcon outlineIcon) {
        TeamsAppDefinition _x = _copy();
        _x.changedFields = changedFields.add("outlineIcon");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppDefinition");
        _x.outlineIcon = outlineIcon;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsAppDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamsAppDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsAppDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamsAppDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamsAppDefinition _copy() {
        TeamsAppDefinition _x = new TeamsAppDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedInstallationScopes = allowedInstallationScopes;
        _x.azureADAppId = azureADAppId;
        _x.createdBy = createdBy;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.publishingState = publishingState;
        _x.shortdescription = shortdescription;
        _x.teamsAppId = teamsAppId;
        _x.version = version;
        _x.bot = bot;
        _x.colorIcon = colorIcon;
        _x.outlineIcon = outlineIcon;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamsAppDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedInstallationScopes=");
        b.append(this.allowedInstallationScopes);
        b.append(", ");
        b.append("azureADAppId=");
        b.append(this.azureADAppId);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("shortdescription=");
        b.append(this.shortdescription);
        b.append(", ");
        b.append("teamsAppId=");
        b.append(this.teamsAppId);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("bot=");
        b.append(this.bot);
        b.append(", ");
        b.append("colorIcon=");
        b.append(this.colorIcon);
        b.append(", ");
        b.append("outlineIcon=");
        b.append(this.outlineIcon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
