package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.TeamsAppDefinitionCollectionRequest;
import odata.msgraph.client.beta.enums.TeamsAppDistributionMethod;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "distributionMethod", 
    "externalId", 
    "appDefinitions"})
@JsonInclude(Include.NON_NULL)
public class TeamsApp extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamsApp";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("distributionMethod")
    protected TeamsAppDistributionMethod distributionMethod;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("appDefinitions")
    protected List<TeamsAppDefinition> appDefinitions;

    protected TeamsApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamsApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private TeamsAppDistributionMethod distributionMethod;
        private String externalId;
        private List<TeamsAppDefinition> appDefinitions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder distributionMethod(TeamsAppDistributionMethod distributionMethod) {
            this.distributionMethod = distributionMethod;
            this.changedFields = changedFields.add("distributionMethod");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder appDefinitions(List<TeamsAppDefinition> appDefinitions) {
            this.appDefinitions = appDefinitions;
            this.changedFields = changedFields.add("appDefinitions");
            return this;
        }

        public Builder appDefinitions(TeamsAppDefinition... appDefinitions) {
            return appDefinitions(Arrays.asList(appDefinitions));
        }

        public TeamsApp build() {
            TeamsApp _x = new TeamsApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamsApp";
            _x.id = id;
            _x.displayName = displayName;
            _x.distributionMethod = distributionMethod;
            _x.externalId = externalId;
            _x.appDefinitions = appDefinitions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TeamsApp withDisplayName(String displayName) {
        TeamsApp _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsApp");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="distributionMethod")
    @JsonIgnore
    public Optional<TeamsAppDistributionMethod> getDistributionMethod() {
        return Optional.ofNullable(distributionMethod);
    }

    public TeamsApp withDistributionMethod(TeamsAppDistributionMethod distributionMethod) {
        TeamsApp _x = _copy();
        _x.changedFields = changedFields.add("distributionMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsApp");
        _x.distributionMethod = distributionMethod;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public TeamsApp withExternalId(String externalId) {
        TeamsApp _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsApp");
        _x.externalId = externalId;
        return _x;
    }

    public TeamsApp withUnmappedField(String name, Object value) {
        TeamsApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appDefinitions")
    @JsonIgnore
    public TeamsAppDefinitionCollectionRequest getAppDefinitions() {
        return new TeamsAppDefinitionCollectionRequest(
                        contextPath.addSegment("appDefinitions"), Optional.ofNullable(appDefinitions));
    }

    public TeamsApp withAppDefinitions(List<TeamsAppDefinition> appDefinitions) {
        TeamsApp _x = _copy();
        _x.changedFields = changedFields.add("appDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsApp");
        _x.appDefinitions = appDefinitions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamsApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamsApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamsApp _copy() {
        TeamsApp _x = new TeamsApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.distributionMethod = distributionMethod;
        _x.externalId = externalId;
        _x.appDefinitions = appDefinitions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamsApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("distributionMethod=");
        b.append(this.distributionMethod);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("appDefinitions=");
        b.append(this.appDefinitions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
