package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.BaseTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.BaseTaskListCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "alltasks", 
    "lists"})
@JsonInclude(Include.NON_NULL)
public class Tasks extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.tasks";
    }

    @JsonProperty("alltasks")
    protected List<BaseTask> alltasks;

    @JsonProperty("lists")
    protected List<BaseTaskList> lists;

    protected Tasks() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTasks() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<BaseTask> alltasks;
        private List<BaseTaskList> lists;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder alltasks(List<BaseTask> alltasks) {
            this.alltasks = alltasks;
            this.changedFields = changedFields.add("alltasks");
            return this;
        }

        public Builder alltasks(BaseTask... alltasks) {
            return alltasks(Arrays.asList(alltasks));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param lists
         *            value of {@code lists} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lists(List<BaseTaskList> lists) {
            this.lists = lists;
            this.changedFields = changedFields.add("lists");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param lists
         *            value of {@code lists} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lists(BaseTaskList... lists) {
            return lists(Arrays.asList(lists));
        }

        public Tasks build() {
            Tasks _x = new Tasks();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.tasks";
            _x.id = id;
            _x.alltasks = alltasks;
            _x.lists = lists;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public Tasks withUnmappedField(String name, Object value) {
        Tasks _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="alltasks")
    @JsonIgnore
    public BaseTaskCollectionRequest getAlltasks() {
        return new BaseTaskCollectionRequest(
                        contextPath.addSegment("alltasks"), Optional.ofNullable(alltasks));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property lists
     */
    @NavigationProperty(name="lists")
    @JsonIgnore
    public BaseTaskListCollectionRequest getLists() {
        return new BaseTaskListCollectionRequest(
                        contextPath.addSegment("lists"), Optional.ofNullable(lists));
    }

    public Tasks withAlltasks(List<BaseTask> alltasks) {
        Tasks _x = _copy();
        _x.changedFields = changedFields.add("alltasks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tasks");
        _x.alltasks = alltasks;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lists} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @param lists
     *            new value of {@code lists} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lists} field changed
     */
    public Tasks withLists(List<BaseTaskList> lists) {
        Tasks _x = _copy();
        _x.changedFields = changedFields.add("lists");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tasks");
        _x.lists = lists;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Tasks patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Tasks _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Tasks put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Tasks _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Tasks _copy() {
        Tasks _x = new Tasks();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.alltasks = alltasks;
        _x.lists = lists;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Tasks[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("alltasks=");
        b.append(this.alltasks);
        b.append(", ");
        b.append("lists=");
        b.append(this.lists);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
