package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.SynchronizationSecretKeyStringValuePair;
import odata.msgraph.client.beta.entity.collection.request.SynchronizationJobCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SynchronizationTemplateCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "secrets", 
    "jobs", 
    "templates"})
@JsonInclude(Include.NON_NULL)
public class Synchronization extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronization";
    }

    @JsonProperty("secrets")
    protected List<SynchronizationSecretKeyStringValuePair> secrets;

    @JsonProperty("secrets@nextLink")
    protected String secretsNextLink;

    @JsonProperty("jobs")
    protected List<SynchronizationJob> jobs;

    @JsonProperty("templates")
    protected List<SynchronizationTemplate> templates;

    protected Synchronization() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSynchronization() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<SynchronizationSecretKeyStringValuePair> secrets;
        private String secretsNextLink;
        private List<SynchronizationJob> jobs;
        private List<SynchronizationTemplate> templates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder secrets(List<SynchronizationSecretKeyStringValuePair> secrets) {
            this.secrets = secrets;
            this.changedFields = changedFields.add("secrets");
            return this;
        }

        public Builder secrets(SynchronizationSecretKeyStringValuePair... secrets) {
            return secrets(Arrays.asList(secrets));
        }

        public Builder secretsNextLink(String secretsNextLink) {
            this.secretsNextLink = secretsNextLink;
            this.changedFields = changedFields.add("secrets");
            return this;
        }

        public Builder jobs(List<SynchronizationJob> jobs) {
            this.jobs = jobs;
            this.changedFields = changedFields.add("jobs");
            return this;
        }

        public Builder jobs(SynchronizationJob... jobs) {
            return jobs(Arrays.asList(jobs));
        }

        public Builder templates(List<SynchronizationTemplate> templates) {
            this.templates = templates;
            this.changedFields = changedFields.add("templates");
            return this;
        }

        public Builder templates(SynchronizationTemplate... templates) {
            return templates(Arrays.asList(templates));
        }

        public Synchronization build() {
            Synchronization _x = new Synchronization();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.synchronization";
            _x.id = id;
            _x.secrets = secrets;
            _x.secretsNextLink = secretsNextLink;
            _x.jobs = jobs;
            _x.templates = templates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="secrets")
    @JsonIgnore
    public CollectionPage<SynchronizationSecretKeyStringValuePair> getSecrets() {
        return new CollectionPage<SynchronizationSecretKeyStringValuePair>(contextPath, SynchronizationSecretKeyStringValuePair.class, this.secrets, Optional.ofNullable(secretsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Synchronization withSecrets(List<SynchronizationSecretKeyStringValuePair> secrets) {
        Synchronization _x = _copy();
        _x.changedFields = changedFields.add("secrets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronization");
        _x.secrets = secrets;
        return _x;
    }

    @Property(name="secrets")
    @JsonIgnore
    public CollectionPage<SynchronizationSecretKeyStringValuePair> getSecrets(HttpRequestOptions options) {
        return new CollectionPage<SynchronizationSecretKeyStringValuePair>(contextPath, SynchronizationSecretKeyStringValuePair.class, this.secrets, Optional.ofNullable(secretsNextLink), Collections.emptyList(), options);
    }

    public Synchronization withUnmappedField(String name, Object value) {
        Synchronization _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="jobs")
    @JsonIgnore
    public SynchronizationJobCollectionRequest getJobs() {
        return new SynchronizationJobCollectionRequest(
                        contextPath.addSegment("jobs"), Optional.ofNullable(jobs));
    }

    @NavigationProperty(name="templates")
    @JsonIgnore
    public SynchronizationTemplateCollectionRequest getTemplates() {
        return new SynchronizationTemplateCollectionRequest(
                        contextPath.addSegment("templates"), Optional.ofNullable(templates));
    }

    public Synchronization withJobs(List<SynchronizationJob> jobs) {
        Synchronization _x = _copy();
        _x.changedFields = changedFields.add("jobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronization");
        _x.jobs = jobs;
        return _x;
    }

    public Synchronization withTemplates(List<SynchronizationTemplate> templates) {
        Synchronization _x = _copy();
        _x.changedFields = changedFields.add("templates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronization");
        _x.templates = templates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Synchronization patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Synchronization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Synchronization put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Synchronization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Synchronization _copy() {
        Synchronization _x = new Synchronization();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.secrets = secrets;
        _x.jobs = jobs;
        _x.templates = templates;
        return _x;
    }

    @Action(name = "acquireAccessToken")
    @JsonIgnore
    public ActionRequestNoReturn acquireAccessToken(List<SynchronizationSecretKeyStringValuePair> credentials) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("credentials", "Collection(microsoft.graph.synchronizationSecretKeyStringValuePair)", credentials)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.acquireAccessToken"), _parameters);
    }

    @Function(name = "Ping")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> ping() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.Ping"), String.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Synchronization[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("secrets=");
        b.append(this.secrets);
        b.append(", ");
        b.append("jobs=");
        b.append(this.jobs);
        b.append(", ");
        b.append("templates=");
        b.append(this.templates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
