package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
 * <p>
 * Referenceable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicationId", 
    "changeType", 
    "clientState", 
    "creatorId", 
    "encryptionCertificate", 
    "encryptionCertificateId", 
    "expirationDateTime", 
    "includeResourceData", 
    "latestSupportedTlsVersion", 
    "lifecycleNotificationUrl", 
    "notificationContentType", 
    "notificationQueryOptions", 
    "notificationUrl", 
    "notificationUrlAppId", 
    "resource"})
@JsonInclude(Include.NON_NULL)
public class Subscription extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.subscription";
    }

    @JsonProperty("applicationId")
    protected String applicationId;

    @JsonProperty("changeType")
    protected String changeType;

    @JsonProperty("clientState")
    protected String clientState;

    @JsonProperty("creatorId")
    protected String creatorId;

    @JsonProperty("encryptionCertificate")
    protected String encryptionCertificate;

    @JsonProperty("encryptionCertificateId")
    protected String encryptionCertificateId;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("includeResourceData")
    protected Boolean includeResourceData;

    @JsonProperty("latestSupportedTlsVersion")
    protected String latestSupportedTlsVersion;

    @JsonProperty("lifecycleNotificationUrl")
    protected String lifecycleNotificationUrl;

    @JsonProperty("notificationContentType")
    protected String notificationContentType;

    @JsonProperty("notificationQueryOptions")
    protected String notificationQueryOptions;

    @JsonProperty("notificationUrl")
    protected String notificationUrl;

    @JsonProperty("notificationUrlAppId")
    protected String notificationUrlAppId;

    @JsonProperty("resource")
    protected String resource;

    protected Subscription() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSubscription() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String applicationId;
        private String changeType;
        private String clientState;
        private String creatorId;
        private String encryptionCertificate;
        private String encryptionCertificateId;
        private OffsetDateTime expirationDateTime;
        private Boolean includeResourceData;
        private String latestSupportedTlsVersion;
        private String lifecycleNotificationUrl;
        private String notificationContentType;
        private String notificationQueryOptions;
        private String notificationUrl;
        private String notificationUrlAppId;
        private String resource;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.changedFields = changedFields.add("applicationId");
            return this;
        }

        public Builder changeType(String changeType) {
            this.changeType = changeType;
            this.changedFields = changedFields.add("changeType");
            return this;
        }

        public Builder clientState(String clientState) {
            this.clientState = clientState;
            this.changedFields = changedFields.add("clientState");
            return this;
        }

        public Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            this.changedFields = changedFields.add("creatorId");
            return this;
        }

        public Builder encryptionCertificate(String encryptionCertificate) {
            this.encryptionCertificate = encryptionCertificate;
            this.changedFields = changedFields.add("encryptionCertificate");
            return this;
        }

        public Builder encryptionCertificateId(String encryptionCertificateId) {
            this.encryptionCertificateId = encryptionCertificateId;
            this.changedFields = changedFields.add("encryptionCertificateId");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder includeResourceData(Boolean includeResourceData) {
            this.includeResourceData = includeResourceData;
            this.changedFields = changedFields.add("includeResourceData");
            return this;
        }

        public Builder latestSupportedTlsVersion(String latestSupportedTlsVersion) {
            this.latestSupportedTlsVersion = latestSupportedTlsVersion;
            this.changedFields = changedFields.add("latestSupportedTlsVersion");
            return this;
        }

        public Builder lifecycleNotificationUrl(String lifecycleNotificationUrl) {
            this.lifecycleNotificationUrl = lifecycleNotificationUrl;
            this.changedFields = changedFields.add("lifecycleNotificationUrl");
            return this;
        }

        public Builder notificationContentType(String notificationContentType) {
            this.notificationContentType = notificationContentType;
            this.changedFields = changedFields.add("notificationContentType");
            return this;
        }

        public Builder notificationQueryOptions(String notificationQueryOptions) {
            this.notificationQueryOptions = notificationQueryOptions;
            this.changedFields = changedFields.add("notificationQueryOptions");
            return this;
        }

        public Builder notificationUrl(String notificationUrl) {
            this.notificationUrl = notificationUrl;
            this.changedFields = changedFields.add("notificationUrl");
            return this;
        }

        public Builder notificationUrlAppId(String notificationUrlAppId) {
            this.notificationUrlAppId = notificationUrlAppId;
            this.changedFields = changedFields.add("notificationUrlAppId");
            return this;
        }

        public Builder resource(String resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public Subscription build() {
            Subscription _x = new Subscription();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.subscription";
            _x.id = id;
            _x.applicationId = applicationId;
            _x.changeType = changeType;
            _x.clientState = clientState;
            _x.creatorId = creatorId;
            _x.encryptionCertificate = encryptionCertificate;
            _x.encryptionCertificateId = encryptionCertificateId;
            _x.expirationDateTime = expirationDateTime;
            _x.includeResourceData = includeResourceData;
            _x.latestSupportedTlsVersion = latestSupportedTlsVersion;
            _x.lifecycleNotificationUrl = lifecycleNotificationUrl;
            _x.notificationContentType = notificationContentType;
            _x.notificationQueryOptions = notificationQueryOptions;
            _x.notificationUrl = notificationUrl;
            _x.notificationUrlAppId = notificationUrlAppId;
            _x.resource = resource;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="applicationId")
    @JsonIgnore
    public Optional<String> getApplicationId() {
        return Optional.ofNullable(applicationId);
    }

    public Subscription withApplicationId(String applicationId) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("applicationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.applicationId = applicationId;
        return _x;
    }

    @Property(name="changeType")
    @JsonIgnore
    public Optional<String> getChangeType() {
        return Optional.ofNullable(changeType);
    }

    public Subscription withChangeType(String changeType) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("changeType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.changeType = changeType;
        return _x;
    }

    @Property(name="clientState")
    @JsonIgnore
    public Optional<String> getClientState() {
        return Optional.ofNullable(clientState);
    }

    public Subscription withClientState(String clientState) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("clientState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.clientState = clientState;
        return _x;
    }

    @Property(name="creatorId")
    @JsonIgnore
    public Optional<String> getCreatorId() {
        return Optional.ofNullable(creatorId);
    }

    public Subscription withCreatorId(String creatorId) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("creatorId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.creatorId = creatorId;
        return _x;
    }

    @Property(name="encryptionCertificate")
    @JsonIgnore
    public Optional<String> getEncryptionCertificate() {
        return Optional.ofNullable(encryptionCertificate);
    }

    public Subscription withEncryptionCertificate(String encryptionCertificate) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("encryptionCertificate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.encryptionCertificate = encryptionCertificate;
        return _x;
    }

    @Property(name="encryptionCertificateId")
    @JsonIgnore
    public Optional<String> getEncryptionCertificateId() {
        return Optional.ofNullable(encryptionCertificateId);
    }

    public Subscription withEncryptionCertificateId(String encryptionCertificateId) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("encryptionCertificateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.encryptionCertificateId = encryptionCertificateId;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public Subscription withExpirationDateTime(OffsetDateTime expirationDateTime) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="includeResourceData")
    @JsonIgnore
    public Optional<Boolean> getIncludeResourceData() {
        return Optional.ofNullable(includeResourceData);
    }

    public Subscription withIncludeResourceData(Boolean includeResourceData) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("includeResourceData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.includeResourceData = includeResourceData;
        return _x;
    }

    @Property(name="latestSupportedTlsVersion")
    @JsonIgnore
    public Optional<String> getLatestSupportedTlsVersion() {
        return Optional.ofNullable(latestSupportedTlsVersion);
    }

    public Subscription withLatestSupportedTlsVersion(String latestSupportedTlsVersion) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("latestSupportedTlsVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.latestSupportedTlsVersion = latestSupportedTlsVersion;
        return _x;
    }

    @Property(name="lifecycleNotificationUrl")
    @JsonIgnore
    public Optional<String> getLifecycleNotificationUrl() {
        return Optional.ofNullable(lifecycleNotificationUrl);
    }

    public Subscription withLifecycleNotificationUrl(String lifecycleNotificationUrl) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("lifecycleNotificationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.lifecycleNotificationUrl = lifecycleNotificationUrl;
        return _x;
    }

    @Property(name="notificationContentType")
    @JsonIgnore
    public Optional<String> getNotificationContentType() {
        return Optional.ofNullable(notificationContentType);
    }

    public Subscription withNotificationContentType(String notificationContentType) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("notificationContentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.notificationContentType = notificationContentType;
        return _x;
    }

    @Property(name="notificationQueryOptions")
    @JsonIgnore
    public Optional<String> getNotificationQueryOptions() {
        return Optional.ofNullable(notificationQueryOptions);
    }

    public Subscription withNotificationQueryOptions(String notificationQueryOptions) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("notificationQueryOptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.notificationQueryOptions = notificationQueryOptions;
        return _x;
    }

    @Property(name="notificationUrl")
    @JsonIgnore
    public Optional<String> getNotificationUrl() {
        return Optional.ofNullable(notificationUrl);
    }

    public Subscription withNotificationUrl(String notificationUrl) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("notificationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.notificationUrl = notificationUrl;
        return _x;
    }

    @Property(name="notificationUrlAppId")
    @JsonIgnore
    public Optional<String> getNotificationUrlAppId() {
        return Optional.ofNullable(notificationUrlAppId);
    }

    public Subscription withNotificationUrlAppId(String notificationUrlAppId) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("notificationUrlAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.notificationUrlAppId = notificationUrlAppId;
        return _x;
    }

    @Property(name="resource")
    @JsonIgnore
    public Optional<String> getResource() {
        return Optional.ofNullable(resource);
    }

    public Subscription withResource(String resource) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("resource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.resource = resource;
        return _x;
    }

    public Subscription withUnmappedField(String name, Object value) {
        Subscription _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subscription patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Subscription _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subscription put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Subscription _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Subscription _copy() {
        Subscription _x = new Subscription();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.applicationId = applicationId;
        _x.changeType = changeType;
        _x.clientState = clientState;
        _x.creatorId = creatorId;
        _x.encryptionCertificate = encryptionCertificate;
        _x.encryptionCertificateId = encryptionCertificateId;
        _x.expirationDateTime = expirationDateTime;
        _x.includeResourceData = includeResourceData;
        _x.latestSupportedTlsVersion = latestSupportedTlsVersion;
        _x.lifecycleNotificationUrl = lifecycleNotificationUrl;
        _x.notificationContentType = notificationContentType;
        _x.notificationQueryOptions = notificationQueryOptions;
        _x.notificationUrl = notificationUrl;
        _x.notificationUrlAppId = notificationUrlAppId;
        _x.resource = resource;
        return _x;
    }

    @Action(name = "reauthorize")
    @JsonIgnore
    public ActionRequestNoReturn reauthorize() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reauthorize"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Subscription[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicationId=");
        b.append(this.applicationId);
        b.append(", ");
        b.append("changeType=");
        b.append(this.changeType);
        b.append(", ");
        b.append("clientState=");
        b.append(this.clientState);
        b.append(", ");
        b.append("creatorId=");
        b.append(this.creatorId);
        b.append(", ");
        b.append("encryptionCertificate=");
        b.append(this.encryptionCertificate);
        b.append(", ");
        b.append("encryptionCertificateId=");
        b.append(this.encryptionCertificateId);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("includeResourceData=");
        b.append(this.includeResourceData);
        b.append(", ");
        b.append("latestSupportedTlsVersion=");
        b.append(this.latestSupportedTlsVersion);
        b.append(", ");
        b.append("lifecycleNotificationUrl=");
        b.append(this.lifecycleNotificationUrl);
        b.append(", ");
        b.append("notificationContentType=");
        b.append(this.notificationContentType);
        b.append(", ");
        b.append("notificationQueryOptions=");
        b.append(this.notificationQueryOptions);
        b.append(", ");
        b.append("notificationUrl=");
        b.append(this.notificationUrl);
        b.append(", ");
        b.append("notificationUrlAppId=");
        b.append(this.notificationUrlAppId);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
