package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DataSubject;
import odata.msgraph.client.beta.complex.Identity;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.SubjectRightsRequestDetail;
import odata.msgraph.client.beta.complex.SubjectRightsRequestHistory;
import odata.msgraph.client.beta.complex.SubjectRightsRequestStageDetail;
import odata.msgraph.client.beta.entity.collection.request.AuthoredNoteCollectionRequest;
import odata.msgraph.client.beta.entity.request.TeamRequest;
import odata.msgraph.client.beta.enums.DataSubjectType;
import odata.msgraph.client.beta.enums.SubjectRightsRequestStatus;
import odata.msgraph.client.beta.enums.SubjectRightsRequestType;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedTo", 
    "closedDateTime", 
    "createdBy", 
    "createdDateTime", 
    "dataSubject", 
    "dataSubjectType", 
    "description", 
    "displayName", 
    "history", 
    "insight", 
    "internalDueDateTime", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "regulations", 
    "stages", 
    "status", 
    "type", 
    "notes"})
@JsonInclude(Include.NON_NULL)
public class SubjectRightsRequest extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.subjectRightsRequest";
    }

    @JsonProperty("assignedTo")
    protected Identity assignedTo;

    @JsonProperty("closedDateTime")
    protected OffsetDateTime closedDateTime;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("dataSubject")
    protected DataSubject dataSubject;

    @JsonProperty("dataSubjectType")
    protected DataSubjectType dataSubjectType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("history")
    protected List<SubjectRightsRequestHistory> history;

    @JsonProperty("history@nextLink")
    protected String historyNextLink;

    @JsonProperty("insight")
    protected SubjectRightsRequestDetail insight;

    @JsonProperty("internalDueDateTime")
    protected OffsetDateTime internalDueDateTime;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("regulations")
    protected List<String> regulations;

    @JsonProperty("regulations@nextLink")
    protected String regulationsNextLink;

    @JsonProperty("stages")
    protected List<SubjectRightsRequestStageDetail> stages;

    @JsonProperty("stages@nextLink")
    protected String stagesNextLink;

    @JsonProperty("status")
    protected SubjectRightsRequestStatus status;

    @JsonProperty("type")
    protected SubjectRightsRequestType type;

    @JsonProperty("notes")
    protected List<AuthoredNote> notes;

    protected SubjectRightsRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSubjectRightsRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Identity assignedTo;
        private OffsetDateTime closedDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private DataSubject dataSubject;
        private DataSubjectType dataSubjectType;
        private String description;
        private String displayName;
        private List<SubjectRightsRequestHistory> history;
        private String historyNextLink;
        private SubjectRightsRequestDetail insight;
        private OffsetDateTime internalDueDateTime;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> regulations;
        private String regulationsNextLink;
        private List<SubjectRightsRequestStageDetail> stages;
        private String stagesNextLink;
        private SubjectRightsRequestStatus status;
        private SubjectRightsRequestType type;
        private List<AuthoredNote> notes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder assignedTo(Identity assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        public Builder closedDateTime(OffsetDateTime closedDateTime) {
            this.closedDateTime = closedDateTime;
            this.changedFields = changedFields.add("closedDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dataSubject(DataSubject dataSubject) {
            this.dataSubject = dataSubject;
            this.changedFields = changedFields.add("dataSubject");
            return this;
        }

        public Builder dataSubjectType(DataSubjectType dataSubjectType) {
            this.dataSubjectType = dataSubjectType;
            this.changedFields = changedFields.add("dataSubjectType");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder history(List<SubjectRightsRequestHistory> history) {
            this.history = history;
            this.changedFields = changedFields.add("history");
            return this;
        }

        public Builder history(SubjectRightsRequestHistory... history) {
            return history(Arrays.asList(history));
        }

        public Builder historyNextLink(String historyNextLink) {
            this.historyNextLink = historyNextLink;
            this.changedFields = changedFields.add("history");
            return this;
        }

        public Builder insight(SubjectRightsRequestDetail insight) {
            this.insight = insight;
            this.changedFields = changedFields.add("insight");
            return this;
        }

        public Builder internalDueDateTime(OffsetDateTime internalDueDateTime) {
            this.internalDueDateTime = internalDueDateTime;
            this.changedFields = changedFields.add("internalDueDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder regulations(List<String> regulations) {
            this.regulations = regulations;
            this.changedFields = changedFields.add("regulations");
            return this;
        }

        public Builder regulations(String... regulations) {
            return regulations(Arrays.asList(regulations));
        }

        public Builder regulationsNextLink(String regulationsNextLink) {
            this.regulationsNextLink = regulationsNextLink;
            this.changedFields = changedFields.add("regulations");
            return this;
        }

        public Builder stages(List<SubjectRightsRequestStageDetail> stages) {
            this.stages = stages;
            this.changedFields = changedFields.add("stages");
            return this;
        }

        public Builder stages(SubjectRightsRequestStageDetail... stages) {
            return stages(Arrays.asList(stages));
        }

        public Builder stagesNextLink(String stagesNextLink) {
            this.stagesNextLink = stagesNextLink;
            this.changedFields = changedFields.add("stages");
            return this;
        }

        public Builder status(SubjectRightsRequestStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder type(SubjectRightsRequestType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder notes(List<AuthoredNote> notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder notes(AuthoredNote... notes) {
            return notes(Arrays.asList(notes));
        }

        public SubjectRightsRequest build() {
            SubjectRightsRequest _x = new SubjectRightsRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.subjectRightsRequest";
            _x.id = id;
            _x.assignedTo = assignedTo;
            _x.closedDateTime = closedDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.dataSubject = dataSubject;
            _x.dataSubjectType = dataSubjectType;
            _x.description = description;
            _x.displayName = displayName;
            _x.history = history;
            _x.historyNextLink = historyNextLink;
            _x.insight = insight;
            _x.internalDueDateTime = internalDueDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.regulations = regulations;
            _x.regulationsNextLink = regulationsNextLink;
            _x.stages = stages;
            _x.stagesNextLink = stagesNextLink;
            _x.status = status;
            _x.type = type;
            _x.notes = notes;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="assignedTo")
    @JsonIgnore
    public Optional<Identity> getAssignedTo() {
        return Optional.ofNullable(assignedTo);
    }

    public SubjectRightsRequest withAssignedTo(Identity assignedTo) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("assignedTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.assignedTo = assignedTo;
        return _x;
    }

    @Property(name="closedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getClosedDateTime() {
        return Optional.ofNullable(closedDateTime);
    }

    public SubjectRightsRequest withClosedDateTime(OffsetDateTime closedDateTime) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("closedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.closedDateTime = closedDateTime;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public SubjectRightsRequest withCreatedBy(IdentitySet createdBy) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public SubjectRightsRequest withCreatedDateTime(OffsetDateTime createdDateTime) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="dataSubject")
    @JsonIgnore
    public Optional<DataSubject> getDataSubject() {
        return Optional.ofNullable(dataSubject);
    }

    public SubjectRightsRequest withDataSubject(DataSubject dataSubject) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("dataSubject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.dataSubject = dataSubject;
        return _x;
    }

    @Property(name="dataSubjectType")
    @JsonIgnore
    public Optional<DataSubjectType> getDataSubjectType() {
        return Optional.ofNullable(dataSubjectType);
    }

    public SubjectRightsRequest withDataSubjectType(DataSubjectType dataSubjectType) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("dataSubjectType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.dataSubjectType = dataSubjectType;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public SubjectRightsRequest withDescription(String description) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public SubjectRightsRequest withDisplayName(String displayName) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="history")
    @JsonIgnore
    public CollectionPage<SubjectRightsRequestHistory> getHistory() {
        return new CollectionPage<SubjectRightsRequestHistory>(contextPath, SubjectRightsRequestHistory.class, this.history, Optional.ofNullable(historyNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SubjectRightsRequest withHistory(List<SubjectRightsRequestHistory> history) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("history");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.history = history;
        return _x;
    }

    @Property(name="history")
    @JsonIgnore
    public CollectionPage<SubjectRightsRequestHistory> getHistory(HttpRequestOptions options) {
        return new CollectionPage<SubjectRightsRequestHistory>(contextPath, SubjectRightsRequestHistory.class, this.history, Optional.ofNullable(historyNextLink), Collections.emptyList(), options);
    }

    @Property(name="insight")
    @JsonIgnore
    public Optional<SubjectRightsRequestDetail> getInsight() {
        return Optional.ofNullable(insight);
    }

    public SubjectRightsRequest withInsight(SubjectRightsRequestDetail insight) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("insight");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.insight = insight;
        return _x;
    }

    @Property(name="internalDueDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getInternalDueDateTime() {
        return Optional.ofNullable(internalDueDateTime);
    }

    public SubjectRightsRequest withInternalDueDateTime(OffsetDateTime internalDueDateTime) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("internalDueDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.internalDueDateTime = internalDueDateTime;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public SubjectRightsRequest withLastModifiedBy(IdentitySet lastModifiedBy) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public SubjectRightsRequest withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="regulations")
    @JsonIgnore
    public CollectionPage<String> getRegulations() {
        return new CollectionPage<String>(contextPath, String.class, this.regulations, Optional.ofNullable(regulationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SubjectRightsRequest withRegulations(List<String> regulations) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("regulations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.regulations = regulations;
        return _x;
    }

    @Property(name="regulations")
    @JsonIgnore
    public CollectionPage<String> getRegulations(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.regulations, Optional.ofNullable(regulationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="stages")
    @JsonIgnore
    public CollectionPage<SubjectRightsRequestStageDetail> getStages() {
        return new CollectionPage<SubjectRightsRequestStageDetail>(contextPath, SubjectRightsRequestStageDetail.class, this.stages, Optional.ofNullable(stagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SubjectRightsRequest withStages(List<SubjectRightsRequestStageDetail> stages) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("stages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.stages = stages;
        return _x;
    }

    @Property(name="stages")
    @JsonIgnore
    public CollectionPage<SubjectRightsRequestStageDetail> getStages(HttpRequestOptions options) {
        return new CollectionPage<SubjectRightsRequestStageDetail>(contextPath, SubjectRightsRequestStageDetail.class, this.stages, Optional.ofNullable(stagesNextLink), Collections.emptyList(), options);
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<SubjectRightsRequestStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public SubjectRightsRequest withStatus(SubjectRightsRequestStatus status) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.status = status;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<SubjectRightsRequestType> getType() {
        return Optional.ofNullable(type);
    }

    public SubjectRightsRequest withType(SubjectRightsRequestType type) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.type = type;
        return _x;
    }

    public SubjectRightsRequest withUnmappedField(String name, Object value) {
        SubjectRightsRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="notes")
    @JsonIgnore
    public AuthoredNoteCollectionRequest getNotes() {
        return new AuthoredNoteCollectionRequest(
                        contextPath.addSegment("notes"), Optional.ofNullable(notes));
    }

    @NavigationProperty(name="team")
    @JsonIgnore
    public TeamRequest getTeam() {
        return new TeamRequest(contextPath.addSegment("team"), RequestHelper.getValue(unmappedFields, "team"));
    }

    public SubjectRightsRequest withNotes(List<AuthoredNote> notes) {
        SubjectRightsRequest _x = _copy();
        _x.changedFields = changedFields.add("notes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequest");
        _x.notes = notes;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SubjectRightsRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SubjectRightsRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SubjectRightsRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SubjectRightsRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SubjectRightsRequest _copy() {
        SubjectRightsRequest _x = new SubjectRightsRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.assignedTo = assignedTo;
        _x.closedDateTime = closedDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.dataSubject = dataSubject;
        _x.dataSubjectType = dataSubjectType;
        _x.description = description;
        _x.displayName = displayName;
        _x.history = history;
        _x.insight = insight;
        _x.internalDueDateTime = internalDueDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.regulations = regulations;
        _x.stages = stages;
        _x.status = status;
        _x.type = type;
        _x.notes = notes;
        return _x;
    }

    @Function(name = "getFinalAttachment")
    @JsonIgnore
    public FunctionRequestReturningStream getFinalAttachment() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getFinalAttachment"), _parameters);
    }

    @Function(name = "getFinalReport")
    @JsonIgnore
    public FunctionRequestReturningStream getFinalReport() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getFinalReport"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SubjectRightsRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("closedDateTime=");
        b.append(this.closedDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dataSubject=");
        b.append(this.dataSubject);
        b.append(", ");
        b.append("dataSubjectType=");
        b.append(this.dataSubjectType);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("history=");
        b.append(this.history);
        b.append(", ");
        b.append("insight=");
        b.append(this.insight);
        b.append(", ");
        b.append("internalDueDateTime=");
        b.append(this.internalDueDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("regulations=");
        b.append(this.regulations);
        b.append(", ");
        b.append("stages=");
        b.append(this.stages);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
