package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "clientId", 
    "clientSecret", 
    "identityProviderType"})
@JsonInclude(Include.NON_NULL)
public class SocialIdentityProvider extends IdentityProviderBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.socialIdentityProvider";
    }

    @JsonProperty("clientId")
    protected String clientId;

    @JsonProperty("clientSecret")
    protected String clientSecret;

    @JsonProperty("identityProviderType")
    protected String identityProviderType;

    protected SocialIdentityProvider() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSocialIdentityProvider() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String clientId;
        private String clientSecret;
        private String identityProviderType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.changedFields = changedFields.add("clientId");
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.changedFields = changedFields.add("clientSecret");
            return this;
        }

        public Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            this.changedFields = changedFields.add("identityProviderType");
            return this;
        }

        public SocialIdentityProvider build() {
            SocialIdentityProvider _x = new SocialIdentityProvider();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.socialIdentityProvider";
            _x.id = id;
            _x.displayName = displayName;
            _x.clientId = clientId;
            _x.clientSecret = clientSecret;
            _x.identityProviderType = identityProviderType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="clientId")
    @JsonIgnore
    public Optional<String> getClientId() {
        return Optional.ofNullable(clientId);
    }

    public SocialIdentityProvider withClientId(String clientId) {
        SocialIdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("clientId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.socialIdentityProvider");
        _x.clientId = clientId;
        return _x;
    }

    @Property(name="clientSecret")
    @JsonIgnore
    public Optional<String> getClientSecret() {
        return Optional.ofNullable(clientSecret);
    }

    public SocialIdentityProvider withClientSecret(String clientSecret) {
        SocialIdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("clientSecret");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.socialIdentityProvider");
        _x.clientSecret = clientSecret;
        return _x;
    }

    @Property(name="identityProviderType")
    @JsonIgnore
    public Optional<String> getIdentityProviderType() {
        return Optional.ofNullable(identityProviderType);
    }

    public SocialIdentityProvider withIdentityProviderType(String identityProviderType) {
        SocialIdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("identityProviderType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.socialIdentityProvider");
        _x.identityProviderType = identityProviderType;
        return _x;
    }

    public SocialIdentityProvider withUnmappedField(String name, Object value) {
        SocialIdentityProvider _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SocialIdentityProvider patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SocialIdentityProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SocialIdentityProvider put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SocialIdentityProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SocialIdentityProvider _copy() {
        SocialIdentityProvider _x = new SocialIdentityProvider();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.clientId = clientId;
        _x.clientSecret = clientSecret;
        _x.identityProviderType = identityProviderType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SocialIdentityProvider[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("clientId=");
        b.append(this.clientId);
        b.append(", ");
        b.append("clientSecret=");
        b.append(this.clientSecret);
        b.append(", ");
        b.append("identityProviderType=");
        b.append(this.identityProviderType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
