package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ContentTypeInfo;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.complex.PublicationFacet;
import odata.msgraph.client.beta.complex.WebPart;

@JsonPropertyOrder({
    "@odata.type", 
    "contentType", 
    "pageLayoutType", 
    "publishingState", 
    "title", 
    "webParts"})
@JsonInclude(Include.NON_NULL)
public class SitePage extends BaseItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sitePage";
    }

    @JsonProperty("contentType")
    protected ContentTypeInfo contentType;

    @JsonProperty("pageLayoutType")
    protected String pageLayoutType;

    @JsonProperty("publishingState")
    protected PublicationFacet publishingState;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("webParts")
    protected List<WebPart> webParts;

    @JsonProperty("webParts@nextLink")
    protected String webPartsNextLink;

    protected SitePage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSitePage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String eTag;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private ItemReference parentReference;
        private String webUrl;
        private ContentTypeInfo contentType;
        private String pageLayoutType;
        private PublicationFacet publishingState;
        private String title;
        private List<WebPart> webParts;
        private String webPartsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            this.changedFields = changedFields.add("eTag");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parentReference(ItemReference parentReference) {
            this.parentReference = parentReference;
            this.changedFields = changedFields.add("parentReference");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder contentType(ContentTypeInfo contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder pageLayoutType(String pageLayoutType) {
            this.pageLayoutType = pageLayoutType;
            this.changedFields = changedFields.add("pageLayoutType");
            return this;
        }

        public Builder publishingState(PublicationFacet publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder webParts(List<WebPart> webParts) {
            this.webParts = webParts;
            this.changedFields = changedFields.add("webParts");
            return this;
        }

        public Builder webParts(WebPart... webParts) {
            return webParts(Arrays.asList(webParts));
        }

        public Builder webPartsNextLink(String webPartsNextLink) {
            this.webPartsNextLink = webPartsNextLink;
            this.changedFields = changedFields.add("webParts");
            return this;
        }

        public SitePage build() {
            SitePage _x = new SitePage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sitePage";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.eTag = eTag;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.parentReference = parentReference;
            _x.webUrl = webUrl;
            _x.contentType = contentType;
            _x.pageLayoutType = pageLayoutType;
            _x.publishingState = publishingState;
            _x.title = title;
            _x.webParts = webParts;
            _x.webPartsNextLink = webPartsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<ContentTypeInfo> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public SitePage withContentType(ContentTypeInfo contentType) {
        SitePage _x = _copy();
        _x.changedFields = changedFields.add("contentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sitePage");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="pageLayoutType")
    @JsonIgnore
    public Optional<String> getPageLayoutType() {
        return Optional.ofNullable(pageLayoutType);
    }

    public SitePage withPageLayoutType(String pageLayoutType) {
        SitePage _x = _copy();
        _x.changedFields = changedFields.add("pageLayoutType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sitePage");
        _x.pageLayoutType = pageLayoutType;
        return _x;
    }

    @Property(name="publishingState")
    @JsonIgnore
    public Optional<PublicationFacet> getPublishingState() {
        return Optional.ofNullable(publishingState);
    }

    public SitePage withPublishingState(PublicationFacet publishingState) {
        SitePage _x = _copy();
        _x.changedFields = changedFields.add("publishingState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sitePage");
        _x.publishingState = publishingState;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public SitePage withTitle(String title) {
        SitePage _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sitePage");
        _x.title = title;
        return _x;
    }

    @Property(name="webParts")
    @JsonIgnore
    public CollectionPage<WebPart> getWebParts() {
        return new CollectionPage<WebPart>(contextPath, WebPart.class, this.webParts, Optional.ofNullable(webPartsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SitePage withWebParts(List<WebPart> webParts) {
        SitePage _x = _copy();
        _x.changedFields = changedFields.add("webParts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sitePage");
        _x.webParts = webParts;
        return _x;
    }

    @Property(name="webParts")
    @JsonIgnore
    public CollectionPage<WebPart> getWebParts(HttpRequestOptions options) {
        return new CollectionPage<WebPart>(contextPath, WebPart.class, this.webParts, Optional.ofNullable(webPartsNextLink), Collections.emptyList(), options);
    }

    public SitePage withUnmappedField(String name, Object value) {
        SitePage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SitePage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SitePage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SitePage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SitePage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SitePage _copy() {
        SitePage _x = new SitePage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.eTag = eTag;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.parentReference = parentReference;
        _x.webUrl = webUrl;
        _x.contentType = contentType;
        _x.pageLayoutType = pageLayoutType;
        _x.publishingState = publishingState;
        _x.title = title;
        _x.webParts = webParts;
        return _x;
    }

    @Action(name = "publish")
    @JsonIgnore
    public ActionRequestNoReturn publish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.publish"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SitePage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parentReference=");
        b.append(this.parentReference);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("pageLayoutType=");
        b.append(this.pageLayoutType);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("webParts=");
        b.append(this.webParts);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
