package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SimulationAutomationRunStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "endDateTime", 
    "simulationId", 
    "startDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class SimulationAutomationRun extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.simulationAutomationRun";
    }

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("simulationId")
    protected String simulationId;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("status")
    protected SimulationAutomationRunStatus status;

    protected SimulationAutomationRun() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSimulationAutomationRun() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime endDateTime;
        private String simulationId;
        private OffsetDateTime startDateTime;
        private SimulationAutomationRunStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder simulationId(String simulationId) {
            this.simulationId = simulationId;
            this.changedFields = changedFields.add("simulationId");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder status(SimulationAutomationRunStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public SimulationAutomationRun build() {
            SimulationAutomationRun _x = new SimulationAutomationRun();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.simulationAutomationRun";
            _x.id = id;
            _x.endDateTime = endDateTime;
            _x.simulationId = simulationId;
            _x.startDateTime = startDateTime;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public SimulationAutomationRun withEndDateTime(OffsetDateTime endDateTime) {
        SimulationAutomationRun _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomationRun");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="simulationId")
    @JsonIgnore
    public Optional<String> getSimulationId() {
        return Optional.ofNullable(simulationId);
    }

    public SimulationAutomationRun withSimulationId(String simulationId) {
        SimulationAutomationRun _x = _copy();
        _x.changedFields = changedFields.add("simulationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomationRun");
        _x.simulationId = simulationId;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public SimulationAutomationRun withStartDateTime(OffsetDateTime startDateTime) {
        SimulationAutomationRun _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomationRun");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<SimulationAutomationRunStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public SimulationAutomationRun withStatus(SimulationAutomationRunStatus status) {
        SimulationAutomationRun _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomationRun");
        _x.status = status;
        return _x;
    }

    public SimulationAutomationRun withUnmappedField(String name, Object value) {
        SimulationAutomationRun _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SimulationAutomationRun patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SimulationAutomationRun _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SimulationAutomationRun put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SimulationAutomationRun _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SimulationAutomationRun _copy() {
        SimulationAutomationRun _x = new SimulationAutomationRun();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.endDateTime = endDateTime;
        _x.simulationId = simulationId;
        _x.startDateTime = startDateTime;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SimulationAutomationRun[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("simulationId=");
        b.append(this.simulationId);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
