package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EmailIdentity;
import odata.msgraph.client.beta.entity.collection.request.SimulationAutomationRunCollectionRequest;
import odata.msgraph.client.beta.enums.SimulationAutomationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "createdBy", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "lastRunDateTime", 
    "nextRunDateTime", 
    "status", 
    "runs"})
@JsonInclude(Include.NON_NULL)
public class SimulationAutomation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.simulationAutomation";
    }

    @JsonProperty("createdBy")
    protected EmailIdentity createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedBy")
    protected EmailIdentity lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lastRunDateTime")
    protected OffsetDateTime lastRunDateTime;

    @JsonProperty("nextRunDateTime")
    protected OffsetDateTime nextRunDateTime;

    @JsonProperty("status")
    protected SimulationAutomationStatus status;

    @JsonProperty("runs")
    protected List<SimulationAutomationRun> runs;

    protected SimulationAutomation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSimulationAutomation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private EmailIdentity createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private EmailIdentity lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime lastRunDateTime;
        private OffsetDateTime nextRunDateTime;
        private SimulationAutomationStatus status;
        private List<SimulationAutomationRun> runs;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(EmailIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedBy(EmailIdentity lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastRunDateTime(OffsetDateTime lastRunDateTime) {
            this.lastRunDateTime = lastRunDateTime;
            this.changedFields = changedFields.add("lastRunDateTime");
            return this;
        }

        public Builder nextRunDateTime(OffsetDateTime nextRunDateTime) {
            this.nextRunDateTime = nextRunDateTime;
            this.changedFields = changedFields.add("nextRunDateTime");
            return this;
        }

        public Builder status(SimulationAutomationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder runs(List<SimulationAutomationRun> runs) {
            this.runs = runs;
            this.changedFields = changedFields.add("runs");
            return this;
        }

        public Builder runs(SimulationAutomationRun... runs) {
            return runs(Arrays.asList(runs));
        }

        public SimulationAutomation build() {
            SimulationAutomation _x = new SimulationAutomation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.simulationAutomation";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastRunDateTime = lastRunDateTime;
            _x.nextRunDateTime = nextRunDateTime;
            _x.status = status;
            _x.runs = runs;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<EmailIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public SimulationAutomation withCreatedBy(EmailIdentity createdBy) {
        SimulationAutomation _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomation");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public SimulationAutomation withCreatedDateTime(OffsetDateTime createdDateTime) {
        SimulationAutomation _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomation");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public SimulationAutomation withDescription(String description) {
        SimulationAutomation _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomation");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public SimulationAutomation withDisplayName(String displayName) {
        SimulationAutomation _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomation");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<EmailIdentity> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public SimulationAutomation withLastModifiedBy(EmailIdentity lastModifiedBy) {
        SimulationAutomation _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomation");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public SimulationAutomation withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        SimulationAutomation _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomation");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="lastRunDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRunDateTime() {
        return Optional.ofNullable(lastRunDateTime);
    }

    public SimulationAutomation withLastRunDateTime(OffsetDateTime lastRunDateTime) {
        SimulationAutomation _x = _copy();
        _x.changedFields = changedFields.add("lastRunDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomation");
        _x.lastRunDateTime = lastRunDateTime;
        return _x;
    }

    @Property(name="nextRunDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getNextRunDateTime() {
        return Optional.ofNullable(nextRunDateTime);
    }

    public SimulationAutomation withNextRunDateTime(OffsetDateTime nextRunDateTime) {
        SimulationAutomation _x = _copy();
        _x.changedFields = changedFields.add("nextRunDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomation");
        _x.nextRunDateTime = nextRunDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<SimulationAutomationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public SimulationAutomation withStatus(SimulationAutomationStatus status) {
        SimulationAutomation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomation");
        _x.status = status;
        return _x;
    }

    public SimulationAutomation withUnmappedField(String name, Object value) {
        SimulationAutomation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="runs")
    @JsonIgnore
    public SimulationAutomationRunCollectionRequest getRuns() {
        return new SimulationAutomationRunCollectionRequest(
                        contextPath.addSegment("runs"), Optional.ofNullable(runs));
    }

    public SimulationAutomation withRuns(List<SimulationAutomationRun> runs) {
        SimulationAutomation _x = _copy();
        _x.changedFields = changedFields.add("runs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationAutomation");
        _x.runs = runs;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SimulationAutomation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SimulationAutomation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SimulationAutomation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SimulationAutomation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SimulationAutomation _copy() {
        SimulationAutomation _x = new SimulationAutomation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastRunDateTime = lastRunDateTime;
        _x.nextRunDateTime = nextRunDateTime;
        _x.status = status;
        _x.runs = runs;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SimulationAutomation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastRunDateTime=");
        b.append(this.lastRunDateTime);
        b.append(", ");
        b.append("nextRunDateTime=");
        b.append(this.nextRunDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("runs=");
        b.append(this.runs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
