package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppliedConditionalAccessPolicy;
import odata.msgraph.client.beta.complex.AuthenticationContext;
import odata.msgraph.client.beta.complex.AuthenticationDetail;
import odata.msgraph.client.beta.complex.AuthenticationRequirementPolicy;
import odata.msgraph.client.beta.complex.DeviceDetail;
import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.complex.MfaDetail;
import odata.msgraph.client.beta.complex.NetworkLocationDetail;
import odata.msgraph.client.beta.complex.PrivateLinkDetails;
import odata.msgraph.client.beta.complex.SessionLifetimePolicy;
import odata.msgraph.client.beta.complex.SignInLocation;
import odata.msgraph.client.beta.complex.SignInStatus;
import odata.msgraph.client.beta.enums.ConditionalAccessStatus;
import odata.msgraph.client.beta.enums.IncomingTokenType;
import odata.msgraph.client.beta.enums.ProtocolType;
import odata.msgraph.client.beta.enums.RiskDetail;
import odata.msgraph.client.beta.enums.RiskLevel;
import odata.msgraph.client.beta.enums.RiskState;
import odata.msgraph.client.beta.enums.SignInAccessType;
import odata.msgraph.client.beta.enums.SignInIdentifierType;
import odata.msgraph.client.beta.enums.SignInUserType;
import odata.msgraph.client.beta.enums.TokenIssuerType;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "appDisplayName", 
    "appId", 
    "appliedConditionalAccessPolicies", 
    "authenticationContextClassReferences", 
    "authenticationDetails", 
    "authenticationMethodsUsed", 
    "authenticationProcessingDetails", 
    "authenticationProtocol", 
    "authenticationRequirement", 
    "authenticationRequirementPolicies", 
    "autonomousSystemNumber", 
    "azureResourceId", 
    "clientAppUsed", 
    "conditionalAccessStatus", 
    "correlationId", 
    "createdDateTime", 
    "crossTenantAccessType", 
    "deviceDetail", 
    "federatedCredentialId", 
    "flaggedForReview", 
    "homeTenantId", 
    "homeTenantName", 
    "incomingTokenType", 
    "ipAddress", 
    "ipAddressFromResourceProvider", 
    "isInteractive", 
    "isTenantRestricted", 
    "location", 
    "mfaDetail", 
    "networkLocationDetails", 
    "originalRequestId", 
    "privateLinkDetails", 
    "processingTimeInMilliseconds", 
    "resourceDisplayName", 
    "resourceId", 
    "resourceServicePrincipalId", 
    "resourceTenantId", 
    "riskDetail", 
    "riskEventTypes_v2", 
    "riskLevelAggregated", 
    "riskLevelDuringSignIn", 
    "riskState", 
    "servicePrincipalCredentialKeyId", 
    "servicePrincipalCredentialThumbprint", 
    "servicePrincipalId", 
    "servicePrincipalName", 
    "sessionLifetimePolicies", 
    "signInEventTypes", 
    "signInIdentifier", 
    "signInIdentifierType", 
    "status", 
    "tokenIssuerName", 
    "tokenIssuerType", 
    "uniqueTokenIdentifier", 
    "userAgent", 
    "userDisplayName", 
    "userId", 
    "userPrincipalName", 
    "userType"})
@JsonInclude(Include.NON_NULL)
public class SignIn extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.signIn";
    }

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("appliedConditionalAccessPolicies")
    protected List<AppliedConditionalAccessPolicy> appliedConditionalAccessPolicies;

    @JsonProperty("appliedConditionalAccessPolicies@nextLink")
    protected String appliedConditionalAccessPoliciesNextLink;

    @JsonProperty("authenticationContextClassReferences")
    protected List<AuthenticationContext> authenticationContextClassReferences;

    @JsonProperty("authenticationContextClassReferences@nextLink")
    protected String authenticationContextClassReferencesNextLink;

    @JsonProperty("authenticationDetails")
    protected List<AuthenticationDetail> authenticationDetails;

    @JsonProperty("authenticationDetails@nextLink")
    protected String authenticationDetailsNextLink;

    @JsonProperty("authenticationMethodsUsed")
    protected List<String> authenticationMethodsUsed;

    @JsonProperty("authenticationMethodsUsed@nextLink")
    protected String authenticationMethodsUsedNextLink;

    @JsonProperty("authenticationProcessingDetails")
    protected List<KeyValue> authenticationProcessingDetails;

    @JsonProperty("authenticationProcessingDetails@nextLink")
    protected String authenticationProcessingDetailsNextLink;

    @JsonProperty("authenticationProtocol")
    protected ProtocolType authenticationProtocol;

    @JsonProperty("authenticationRequirement")
    protected String authenticationRequirement;

    @JsonProperty("authenticationRequirementPolicies")
    protected List<AuthenticationRequirementPolicy> authenticationRequirementPolicies;

    @JsonProperty("authenticationRequirementPolicies@nextLink")
    protected String authenticationRequirementPoliciesNextLink;

    @JsonProperty("autonomousSystemNumber")
    protected Integer autonomousSystemNumber;

    @JsonProperty("azureResourceId")
    protected String azureResourceId;

    @JsonProperty("clientAppUsed")
    protected String clientAppUsed;

    @JsonProperty("conditionalAccessStatus")
    protected ConditionalAccessStatus conditionalAccessStatus;

    @JsonProperty("correlationId")
    protected String correlationId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("crossTenantAccessType")
    protected SignInAccessType crossTenantAccessType;

    @JsonProperty("deviceDetail")
    protected DeviceDetail deviceDetail;

    @JsonProperty("federatedCredentialId")
    protected String federatedCredentialId;

    @JsonProperty("flaggedForReview")
    protected Boolean flaggedForReview;

    @JsonProperty("homeTenantId")
    protected String homeTenantId;

    @JsonProperty("homeTenantName")
    protected String homeTenantName;

    @JsonProperty("incomingTokenType")
    protected IncomingTokenType incomingTokenType;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("ipAddressFromResourceProvider")
    protected String ipAddressFromResourceProvider;

    @JsonProperty("isInteractive")
    protected Boolean isInteractive;

    @JsonProperty("isTenantRestricted")
    protected Boolean isTenantRestricted;

    @JsonProperty("location")
    protected SignInLocation location;

    @JsonProperty("mfaDetail")
    protected MfaDetail mfaDetail;

    @JsonProperty("networkLocationDetails")
    protected List<NetworkLocationDetail> networkLocationDetails;

    @JsonProperty("networkLocationDetails@nextLink")
    protected String networkLocationDetailsNextLink;

    @JsonProperty("originalRequestId")
    protected String originalRequestId;

    @JsonProperty("privateLinkDetails")
    protected PrivateLinkDetails privateLinkDetails;

    @JsonProperty("processingTimeInMilliseconds")
    protected Integer processingTimeInMilliseconds;

    @JsonProperty("resourceDisplayName")
    protected String resourceDisplayName;

    @JsonProperty("resourceId")
    protected String resourceId;

    @JsonProperty("resourceServicePrincipalId")
    protected String resourceServicePrincipalId;

    @JsonProperty("resourceTenantId")
    protected String resourceTenantId;

    @JsonProperty("riskDetail")
    protected RiskDetail riskDetail;

    @JsonProperty("riskEventTypes_v2")
    protected List<String> riskEventTypes_v2;

    @JsonProperty("riskEventTypes_v2@nextLink")
    protected String riskEventTypes_v2NextLink;

    @JsonProperty("riskLevelAggregated")
    protected RiskLevel riskLevelAggregated;

    @JsonProperty("riskLevelDuringSignIn")
    protected RiskLevel riskLevelDuringSignIn;

    @JsonProperty("riskState")
    protected RiskState riskState;

    @JsonProperty("servicePrincipalCredentialKeyId")
    protected String servicePrincipalCredentialKeyId;

    @JsonProperty("servicePrincipalCredentialThumbprint")
    protected String servicePrincipalCredentialThumbprint;

    @JsonProperty("servicePrincipalId")
    protected String servicePrincipalId;

    @JsonProperty("servicePrincipalName")
    protected String servicePrincipalName;

    @JsonProperty("sessionLifetimePolicies")
    protected List<SessionLifetimePolicy> sessionLifetimePolicies;

    @JsonProperty("sessionLifetimePolicies@nextLink")
    protected String sessionLifetimePoliciesNextLink;

    @JsonProperty("signInEventTypes")
    protected List<String> signInEventTypes;

    @JsonProperty("signInEventTypes@nextLink")
    protected String signInEventTypesNextLink;

    @JsonProperty("signInIdentifier")
    protected String signInIdentifier;

    @JsonProperty("signInIdentifierType")
    protected SignInIdentifierType signInIdentifierType;

    @JsonProperty("status")
    protected SignInStatus status;

    @JsonProperty("tokenIssuerName")
    protected String tokenIssuerName;

    @JsonProperty("tokenIssuerType")
    protected TokenIssuerType tokenIssuerType;

    @JsonProperty("uniqueTokenIdentifier")
    protected String uniqueTokenIdentifier;

    @JsonProperty("userAgent")
    protected String userAgent;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("userType")
    protected SignInUserType userType;

    protected SignIn() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSignIn() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appDisplayName;
        private String appId;
        private List<AppliedConditionalAccessPolicy> appliedConditionalAccessPolicies;
        private String appliedConditionalAccessPoliciesNextLink;
        private List<AuthenticationContext> authenticationContextClassReferences;
        private String authenticationContextClassReferencesNextLink;
        private List<AuthenticationDetail> authenticationDetails;
        private String authenticationDetailsNextLink;
        private List<String> authenticationMethodsUsed;
        private String authenticationMethodsUsedNextLink;
        private List<KeyValue> authenticationProcessingDetails;
        private String authenticationProcessingDetailsNextLink;
        private ProtocolType authenticationProtocol;
        private String authenticationRequirement;
        private List<AuthenticationRequirementPolicy> authenticationRequirementPolicies;
        private String authenticationRequirementPoliciesNextLink;
        private Integer autonomousSystemNumber;
        private String azureResourceId;
        private String clientAppUsed;
        private ConditionalAccessStatus conditionalAccessStatus;
        private String correlationId;
        private OffsetDateTime createdDateTime;
        private SignInAccessType crossTenantAccessType;
        private DeviceDetail deviceDetail;
        private String federatedCredentialId;
        private Boolean flaggedForReview;
        private String homeTenantId;
        private String homeTenantName;
        private IncomingTokenType incomingTokenType;
        private String ipAddress;
        private String ipAddressFromResourceProvider;
        private Boolean isInteractive;
        private Boolean isTenantRestricted;
        private SignInLocation location;
        private MfaDetail mfaDetail;
        private List<NetworkLocationDetail> networkLocationDetails;
        private String networkLocationDetailsNextLink;
        private String originalRequestId;
        private PrivateLinkDetails privateLinkDetails;
        private Integer processingTimeInMilliseconds;
        private String resourceDisplayName;
        private String resourceId;
        private String resourceServicePrincipalId;
        private String resourceTenantId;
        private RiskDetail riskDetail;
        private List<String> riskEventTypes_v2;
        private String riskEventTypes_v2NextLink;
        private RiskLevel riskLevelAggregated;
        private RiskLevel riskLevelDuringSignIn;
        private RiskState riskState;
        private String servicePrincipalCredentialKeyId;
        private String servicePrincipalCredentialThumbprint;
        private String servicePrincipalId;
        private String servicePrincipalName;
        private List<SessionLifetimePolicy> sessionLifetimePolicies;
        private String sessionLifetimePoliciesNextLink;
        private List<String> signInEventTypes;
        private String signInEventTypesNextLink;
        private String signInIdentifier;
        private SignInIdentifierType signInIdentifierType;
        private SignInStatus status;
        private String tokenIssuerName;
        private TokenIssuerType tokenIssuerType;
        private String uniqueTokenIdentifier;
        private String userAgent;
        private String userDisplayName;
        private String userId;
        private String userPrincipalName;
        private SignInUserType userType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder appliedConditionalAccessPolicies(List<AppliedConditionalAccessPolicy> appliedConditionalAccessPolicies) {
            this.appliedConditionalAccessPolicies = appliedConditionalAccessPolicies;
            this.changedFields = changedFields.add("appliedConditionalAccessPolicies");
            return this;
        }

        public Builder appliedConditionalAccessPolicies(AppliedConditionalAccessPolicy... appliedConditionalAccessPolicies) {
            return appliedConditionalAccessPolicies(Arrays.asList(appliedConditionalAccessPolicies));
        }

        public Builder appliedConditionalAccessPoliciesNextLink(String appliedConditionalAccessPoliciesNextLink) {
            this.appliedConditionalAccessPoliciesNextLink = appliedConditionalAccessPoliciesNextLink;
            this.changedFields = changedFields.add("appliedConditionalAccessPolicies");
            return this;
        }

        public Builder authenticationContextClassReferences(List<AuthenticationContext> authenticationContextClassReferences) {
            this.authenticationContextClassReferences = authenticationContextClassReferences;
            this.changedFields = changedFields.add("authenticationContextClassReferences");
            return this;
        }

        public Builder authenticationContextClassReferences(AuthenticationContext... authenticationContextClassReferences) {
            return authenticationContextClassReferences(Arrays.asList(authenticationContextClassReferences));
        }

        public Builder authenticationContextClassReferencesNextLink(String authenticationContextClassReferencesNextLink) {
            this.authenticationContextClassReferencesNextLink = authenticationContextClassReferencesNextLink;
            this.changedFields = changedFields.add("authenticationContextClassReferences");
            return this;
        }

        public Builder authenticationDetails(List<AuthenticationDetail> authenticationDetails) {
            this.authenticationDetails = authenticationDetails;
            this.changedFields = changedFields.add("authenticationDetails");
            return this;
        }

        public Builder authenticationDetails(AuthenticationDetail... authenticationDetails) {
            return authenticationDetails(Arrays.asList(authenticationDetails));
        }

        public Builder authenticationDetailsNextLink(String authenticationDetailsNextLink) {
            this.authenticationDetailsNextLink = authenticationDetailsNextLink;
            this.changedFields = changedFields.add("authenticationDetails");
            return this;
        }

        public Builder authenticationMethodsUsed(List<String> authenticationMethodsUsed) {
            this.authenticationMethodsUsed = authenticationMethodsUsed;
            this.changedFields = changedFields.add("authenticationMethodsUsed");
            return this;
        }

        public Builder authenticationMethodsUsed(String... authenticationMethodsUsed) {
            return authenticationMethodsUsed(Arrays.asList(authenticationMethodsUsed));
        }

        public Builder authenticationMethodsUsedNextLink(String authenticationMethodsUsedNextLink) {
            this.authenticationMethodsUsedNextLink = authenticationMethodsUsedNextLink;
            this.changedFields = changedFields.add("authenticationMethodsUsed");
            return this;
        }

        public Builder authenticationProcessingDetails(List<KeyValue> authenticationProcessingDetails) {
            this.authenticationProcessingDetails = authenticationProcessingDetails;
            this.changedFields = changedFields.add("authenticationProcessingDetails");
            return this;
        }

        public Builder authenticationProcessingDetails(KeyValue... authenticationProcessingDetails) {
            return authenticationProcessingDetails(Arrays.asList(authenticationProcessingDetails));
        }

        public Builder authenticationProcessingDetailsNextLink(String authenticationProcessingDetailsNextLink) {
            this.authenticationProcessingDetailsNextLink = authenticationProcessingDetailsNextLink;
            this.changedFields = changedFields.add("authenticationProcessingDetails");
            return this;
        }

        public Builder authenticationProtocol(ProtocolType authenticationProtocol) {
            this.authenticationProtocol = authenticationProtocol;
            this.changedFields = changedFields.add("authenticationProtocol");
            return this;
        }

        public Builder authenticationRequirement(String authenticationRequirement) {
            this.authenticationRequirement = authenticationRequirement;
            this.changedFields = changedFields.add("authenticationRequirement");
            return this;
        }

        public Builder authenticationRequirementPolicies(List<AuthenticationRequirementPolicy> authenticationRequirementPolicies) {
            this.authenticationRequirementPolicies = authenticationRequirementPolicies;
            this.changedFields = changedFields.add("authenticationRequirementPolicies");
            return this;
        }

        public Builder authenticationRequirementPolicies(AuthenticationRequirementPolicy... authenticationRequirementPolicies) {
            return authenticationRequirementPolicies(Arrays.asList(authenticationRequirementPolicies));
        }

        public Builder authenticationRequirementPoliciesNextLink(String authenticationRequirementPoliciesNextLink) {
            this.authenticationRequirementPoliciesNextLink = authenticationRequirementPoliciesNextLink;
            this.changedFields = changedFields.add("authenticationRequirementPolicies");
            return this;
        }

        public Builder autonomousSystemNumber(Integer autonomousSystemNumber) {
            this.autonomousSystemNumber = autonomousSystemNumber;
            this.changedFields = changedFields.add("autonomousSystemNumber");
            return this;
        }

        public Builder azureResourceId(String azureResourceId) {
            this.azureResourceId = azureResourceId;
            this.changedFields = changedFields.add("azureResourceId");
            return this;
        }

        public Builder clientAppUsed(String clientAppUsed) {
            this.clientAppUsed = clientAppUsed;
            this.changedFields = changedFields.add("clientAppUsed");
            return this;
        }

        public Builder conditionalAccessStatus(ConditionalAccessStatus conditionalAccessStatus) {
            this.conditionalAccessStatus = conditionalAccessStatus;
            this.changedFields = changedFields.add("conditionalAccessStatus");
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            this.changedFields = changedFields.add("correlationId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder crossTenantAccessType(SignInAccessType crossTenantAccessType) {
            this.crossTenantAccessType = crossTenantAccessType;
            this.changedFields = changedFields.add("crossTenantAccessType");
            return this;
        }

        public Builder deviceDetail(DeviceDetail deviceDetail) {
            this.deviceDetail = deviceDetail;
            this.changedFields = changedFields.add("deviceDetail");
            return this;
        }

        public Builder federatedCredentialId(String federatedCredentialId) {
            this.federatedCredentialId = federatedCredentialId;
            this.changedFields = changedFields.add("federatedCredentialId");
            return this;
        }

        public Builder flaggedForReview(Boolean flaggedForReview) {
            this.flaggedForReview = flaggedForReview;
            this.changedFields = changedFields.add("flaggedForReview");
            return this;
        }

        public Builder homeTenantId(String homeTenantId) {
            this.homeTenantId = homeTenantId;
            this.changedFields = changedFields.add("homeTenantId");
            return this;
        }

        public Builder homeTenantName(String homeTenantName) {
            this.homeTenantName = homeTenantName;
            this.changedFields = changedFields.add("homeTenantName");
            return this;
        }

        public Builder incomingTokenType(IncomingTokenType incomingTokenType) {
            this.incomingTokenType = incomingTokenType;
            this.changedFields = changedFields.add("incomingTokenType");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        public Builder ipAddressFromResourceProvider(String ipAddressFromResourceProvider) {
            this.ipAddressFromResourceProvider = ipAddressFromResourceProvider;
            this.changedFields = changedFields.add("ipAddressFromResourceProvider");
            return this;
        }

        public Builder isInteractive(Boolean isInteractive) {
            this.isInteractive = isInteractive;
            this.changedFields = changedFields.add("isInteractive");
            return this;
        }

        public Builder isTenantRestricted(Boolean isTenantRestricted) {
            this.isTenantRestricted = isTenantRestricted;
            this.changedFields = changedFields.add("isTenantRestricted");
            return this;
        }

        public Builder location(SignInLocation location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder mfaDetail(MfaDetail mfaDetail) {
            this.mfaDetail = mfaDetail;
            this.changedFields = changedFields.add("mfaDetail");
            return this;
        }

        public Builder networkLocationDetails(List<NetworkLocationDetail> networkLocationDetails) {
            this.networkLocationDetails = networkLocationDetails;
            this.changedFields = changedFields.add("networkLocationDetails");
            return this;
        }

        public Builder networkLocationDetails(NetworkLocationDetail... networkLocationDetails) {
            return networkLocationDetails(Arrays.asList(networkLocationDetails));
        }

        public Builder networkLocationDetailsNextLink(String networkLocationDetailsNextLink) {
            this.networkLocationDetailsNextLink = networkLocationDetailsNextLink;
            this.changedFields = changedFields.add("networkLocationDetails");
            return this;
        }

        public Builder originalRequestId(String originalRequestId) {
            this.originalRequestId = originalRequestId;
            this.changedFields = changedFields.add("originalRequestId");
            return this;
        }

        public Builder privateLinkDetails(PrivateLinkDetails privateLinkDetails) {
            this.privateLinkDetails = privateLinkDetails;
            this.changedFields = changedFields.add("privateLinkDetails");
            return this;
        }

        public Builder processingTimeInMilliseconds(Integer processingTimeInMilliseconds) {
            this.processingTimeInMilliseconds = processingTimeInMilliseconds;
            this.changedFields = changedFields.add("processingTimeInMilliseconds");
            return this;
        }

        public Builder resourceDisplayName(String resourceDisplayName) {
            this.resourceDisplayName = resourceDisplayName;
            this.changedFields = changedFields.add("resourceDisplayName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public Builder resourceServicePrincipalId(String resourceServicePrincipalId) {
            this.resourceServicePrincipalId = resourceServicePrincipalId;
            this.changedFields = changedFields.add("resourceServicePrincipalId");
            return this;
        }

        public Builder resourceTenantId(String resourceTenantId) {
            this.resourceTenantId = resourceTenantId;
            this.changedFields = changedFields.add("resourceTenantId");
            return this;
        }

        public Builder riskDetail(RiskDetail riskDetail) {
            this.riskDetail = riskDetail;
            this.changedFields = changedFields.add("riskDetail");
            return this;
        }

        public Builder riskEventTypes_v2(List<String> riskEventTypes_v2) {
            this.riskEventTypes_v2 = riskEventTypes_v2;
            this.changedFields = changedFields.add("riskEventTypes_v2");
            return this;
        }

        public Builder riskEventTypes_v2(String... riskEventTypes_v2) {
            return riskEventTypes_v2(Arrays.asList(riskEventTypes_v2));
        }

        public Builder riskEventTypes_v2NextLink(String riskEventTypes_v2NextLink) {
            this.riskEventTypes_v2NextLink = riskEventTypes_v2NextLink;
            this.changedFields = changedFields.add("riskEventTypes_v2");
            return this;
        }

        public Builder riskLevelAggregated(RiskLevel riskLevelAggregated) {
            this.riskLevelAggregated = riskLevelAggregated;
            this.changedFields = changedFields.add("riskLevelAggregated");
            return this;
        }

        public Builder riskLevelDuringSignIn(RiskLevel riskLevelDuringSignIn) {
            this.riskLevelDuringSignIn = riskLevelDuringSignIn;
            this.changedFields = changedFields.add("riskLevelDuringSignIn");
            return this;
        }

        public Builder riskState(RiskState riskState) {
            this.riskState = riskState;
            this.changedFields = changedFields.add("riskState");
            return this;
        }

        public Builder servicePrincipalCredentialKeyId(String servicePrincipalCredentialKeyId) {
            this.servicePrincipalCredentialKeyId = servicePrincipalCredentialKeyId;
            this.changedFields = changedFields.add("servicePrincipalCredentialKeyId");
            return this;
        }

        public Builder servicePrincipalCredentialThumbprint(String servicePrincipalCredentialThumbprint) {
            this.servicePrincipalCredentialThumbprint = servicePrincipalCredentialThumbprint;
            this.changedFields = changedFields.add("servicePrincipalCredentialThumbprint");
            return this;
        }

        public Builder servicePrincipalId(String servicePrincipalId) {
            this.servicePrincipalId = servicePrincipalId;
            this.changedFields = changedFields.add("servicePrincipalId");
            return this;
        }

        public Builder servicePrincipalName(String servicePrincipalName) {
            this.servicePrincipalName = servicePrincipalName;
            this.changedFields = changedFields.add("servicePrincipalName");
            return this;
        }

        public Builder sessionLifetimePolicies(List<SessionLifetimePolicy> sessionLifetimePolicies) {
            this.sessionLifetimePolicies = sessionLifetimePolicies;
            this.changedFields = changedFields.add("sessionLifetimePolicies");
            return this;
        }

        public Builder sessionLifetimePolicies(SessionLifetimePolicy... sessionLifetimePolicies) {
            return sessionLifetimePolicies(Arrays.asList(sessionLifetimePolicies));
        }

        public Builder sessionLifetimePoliciesNextLink(String sessionLifetimePoliciesNextLink) {
            this.sessionLifetimePoliciesNextLink = sessionLifetimePoliciesNextLink;
            this.changedFields = changedFields.add("sessionLifetimePolicies");
            return this;
        }

        public Builder signInEventTypes(List<String> signInEventTypes) {
            this.signInEventTypes = signInEventTypes;
            this.changedFields = changedFields.add("signInEventTypes");
            return this;
        }

        public Builder signInEventTypes(String... signInEventTypes) {
            return signInEventTypes(Arrays.asList(signInEventTypes));
        }

        public Builder signInEventTypesNextLink(String signInEventTypesNextLink) {
            this.signInEventTypesNextLink = signInEventTypesNextLink;
            this.changedFields = changedFields.add("signInEventTypes");
            return this;
        }

        public Builder signInIdentifier(String signInIdentifier) {
            this.signInIdentifier = signInIdentifier;
            this.changedFields = changedFields.add("signInIdentifier");
            return this;
        }

        public Builder signInIdentifierType(SignInIdentifierType signInIdentifierType) {
            this.signInIdentifierType = signInIdentifierType;
            this.changedFields = changedFields.add("signInIdentifierType");
            return this;
        }

        public Builder status(SignInStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder tokenIssuerName(String tokenIssuerName) {
            this.tokenIssuerName = tokenIssuerName;
            this.changedFields = changedFields.add("tokenIssuerName");
            return this;
        }

        public Builder tokenIssuerType(TokenIssuerType tokenIssuerType) {
            this.tokenIssuerType = tokenIssuerType;
            this.changedFields = changedFields.add("tokenIssuerType");
            return this;
        }

        public Builder uniqueTokenIdentifier(String uniqueTokenIdentifier) {
            this.uniqueTokenIdentifier = uniqueTokenIdentifier;
            this.changedFields = changedFields.add("uniqueTokenIdentifier");
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            this.changedFields = changedFields.add("userAgent");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder userType(SignInUserType userType) {
            this.userType = userType;
            this.changedFields = changedFields.add("userType");
            return this;
        }

        public SignIn build() {
            SignIn _x = new SignIn();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.signIn";
            _x.id = id;
            _x.appDisplayName = appDisplayName;
            _x.appId = appId;
            _x.appliedConditionalAccessPolicies = appliedConditionalAccessPolicies;
            _x.appliedConditionalAccessPoliciesNextLink = appliedConditionalAccessPoliciesNextLink;
            _x.authenticationContextClassReferences = authenticationContextClassReferences;
            _x.authenticationContextClassReferencesNextLink = authenticationContextClassReferencesNextLink;
            _x.authenticationDetails = authenticationDetails;
            _x.authenticationDetailsNextLink = authenticationDetailsNextLink;
            _x.authenticationMethodsUsed = authenticationMethodsUsed;
            _x.authenticationMethodsUsedNextLink = authenticationMethodsUsedNextLink;
            _x.authenticationProcessingDetails = authenticationProcessingDetails;
            _x.authenticationProcessingDetailsNextLink = authenticationProcessingDetailsNextLink;
            _x.authenticationProtocol = authenticationProtocol;
            _x.authenticationRequirement = authenticationRequirement;
            _x.authenticationRequirementPolicies = authenticationRequirementPolicies;
            _x.authenticationRequirementPoliciesNextLink = authenticationRequirementPoliciesNextLink;
            _x.autonomousSystemNumber = autonomousSystemNumber;
            _x.azureResourceId = azureResourceId;
            _x.clientAppUsed = clientAppUsed;
            _x.conditionalAccessStatus = conditionalAccessStatus;
            _x.correlationId = correlationId;
            _x.createdDateTime = createdDateTime;
            _x.crossTenantAccessType = crossTenantAccessType;
            _x.deviceDetail = deviceDetail;
            _x.federatedCredentialId = federatedCredentialId;
            _x.flaggedForReview = flaggedForReview;
            _x.homeTenantId = homeTenantId;
            _x.homeTenantName = homeTenantName;
            _x.incomingTokenType = incomingTokenType;
            _x.ipAddress = ipAddress;
            _x.ipAddressFromResourceProvider = ipAddressFromResourceProvider;
            _x.isInteractive = isInteractive;
            _x.isTenantRestricted = isTenantRestricted;
            _x.location = location;
            _x.mfaDetail = mfaDetail;
            _x.networkLocationDetails = networkLocationDetails;
            _x.networkLocationDetailsNextLink = networkLocationDetailsNextLink;
            _x.originalRequestId = originalRequestId;
            _x.privateLinkDetails = privateLinkDetails;
            _x.processingTimeInMilliseconds = processingTimeInMilliseconds;
            _x.resourceDisplayName = resourceDisplayName;
            _x.resourceId = resourceId;
            _x.resourceServicePrincipalId = resourceServicePrincipalId;
            _x.resourceTenantId = resourceTenantId;
            _x.riskDetail = riskDetail;
            _x.riskEventTypes_v2 = riskEventTypes_v2;
            _x.riskEventTypes_v2NextLink = riskEventTypes_v2NextLink;
            _x.riskLevelAggregated = riskLevelAggregated;
            _x.riskLevelDuringSignIn = riskLevelDuringSignIn;
            _x.riskState = riskState;
            _x.servicePrincipalCredentialKeyId = servicePrincipalCredentialKeyId;
            _x.servicePrincipalCredentialThumbprint = servicePrincipalCredentialThumbprint;
            _x.servicePrincipalId = servicePrincipalId;
            _x.servicePrincipalName = servicePrincipalName;
            _x.sessionLifetimePolicies = sessionLifetimePolicies;
            _x.sessionLifetimePoliciesNextLink = sessionLifetimePoliciesNextLink;
            _x.signInEventTypes = signInEventTypes;
            _x.signInEventTypesNextLink = signInEventTypesNextLink;
            _x.signInIdentifier = signInIdentifier;
            _x.signInIdentifierType = signInIdentifierType;
            _x.status = status;
            _x.tokenIssuerName = tokenIssuerName;
            _x.tokenIssuerType = tokenIssuerType;
            _x.uniqueTokenIdentifier = uniqueTokenIdentifier;
            _x.userAgent = userAgent;
            _x.userDisplayName = userDisplayName;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            _x.userType = userType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    public SignIn withAppDisplayName(String appDisplayName) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public SignIn withAppId(String appId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("appId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.appId = appId;
        return _x;
    }

    @Property(name="appliedConditionalAccessPolicies")
    @JsonIgnore
    public CollectionPage<AppliedConditionalAccessPolicy> getAppliedConditionalAccessPolicies() {
        return new CollectionPage<AppliedConditionalAccessPolicy>(contextPath, AppliedConditionalAccessPolicy.class, this.appliedConditionalAccessPolicies, Optional.ofNullable(appliedConditionalAccessPoliciesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SignIn withAppliedConditionalAccessPolicies(List<AppliedConditionalAccessPolicy> appliedConditionalAccessPolicies) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("appliedConditionalAccessPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.appliedConditionalAccessPolicies = appliedConditionalAccessPolicies;
        return _x;
    }

    @Property(name="appliedConditionalAccessPolicies")
    @JsonIgnore
    public CollectionPage<AppliedConditionalAccessPolicy> getAppliedConditionalAccessPolicies(HttpRequestOptions options) {
        return new CollectionPage<AppliedConditionalAccessPolicy>(contextPath, AppliedConditionalAccessPolicy.class, this.appliedConditionalAccessPolicies, Optional.ofNullable(appliedConditionalAccessPoliciesNextLink), Collections.emptyList(), options);
    }

    @Property(name="authenticationContextClassReferences")
    @JsonIgnore
    public CollectionPage<AuthenticationContext> getAuthenticationContextClassReferences() {
        return new CollectionPage<AuthenticationContext>(contextPath, AuthenticationContext.class, this.authenticationContextClassReferences, Optional.ofNullable(authenticationContextClassReferencesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SignIn withAuthenticationContextClassReferences(List<AuthenticationContext> authenticationContextClassReferences) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("authenticationContextClassReferences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.authenticationContextClassReferences = authenticationContextClassReferences;
        return _x;
    }

    @Property(name="authenticationContextClassReferences")
    @JsonIgnore
    public CollectionPage<AuthenticationContext> getAuthenticationContextClassReferences(HttpRequestOptions options) {
        return new CollectionPage<AuthenticationContext>(contextPath, AuthenticationContext.class, this.authenticationContextClassReferences, Optional.ofNullable(authenticationContextClassReferencesNextLink), Collections.emptyList(), options);
    }

    @Property(name="authenticationDetails")
    @JsonIgnore
    public CollectionPage<AuthenticationDetail> getAuthenticationDetails() {
        return new CollectionPage<AuthenticationDetail>(contextPath, AuthenticationDetail.class, this.authenticationDetails, Optional.ofNullable(authenticationDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SignIn withAuthenticationDetails(List<AuthenticationDetail> authenticationDetails) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("authenticationDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.authenticationDetails = authenticationDetails;
        return _x;
    }

    @Property(name="authenticationDetails")
    @JsonIgnore
    public CollectionPage<AuthenticationDetail> getAuthenticationDetails(HttpRequestOptions options) {
        return new CollectionPage<AuthenticationDetail>(contextPath, AuthenticationDetail.class, this.authenticationDetails, Optional.ofNullable(authenticationDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="authenticationMethodsUsed")
    @JsonIgnore
    public CollectionPage<String> getAuthenticationMethodsUsed() {
        return new CollectionPage<String>(contextPath, String.class, this.authenticationMethodsUsed, Optional.ofNullable(authenticationMethodsUsedNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SignIn withAuthenticationMethodsUsed(List<String> authenticationMethodsUsed) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethodsUsed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.authenticationMethodsUsed = authenticationMethodsUsed;
        return _x;
    }

    @Property(name="authenticationMethodsUsed")
    @JsonIgnore
    public CollectionPage<String> getAuthenticationMethodsUsed(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.authenticationMethodsUsed, Optional.ofNullable(authenticationMethodsUsedNextLink), Collections.emptyList(), options);
    }

    @Property(name="authenticationProcessingDetails")
    @JsonIgnore
    public CollectionPage<KeyValue> getAuthenticationProcessingDetails() {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.authenticationProcessingDetails, Optional.ofNullable(authenticationProcessingDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SignIn withAuthenticationProcessingDetails(List<KeyValue> authenticationProcessingDetails) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("authenticationProcessingDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.authenticationProcessingDetails = authenticationProcessingDetails;
        return _x;
    }

    @Property(name="authenticationProcessingDetails")
    @JsonIgnore
    public CollectionPage<KeyValue> getAuthenticationProcessingDetails(HttpRequestOptions options) {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.authenticationProcessingDetails, Optional.ofNullable(authenticationProcessingDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="authenticationProtocol")
    @JsonIgnore
    public Optional<ProtocolType> getAuthenticationProtocol() {
        return Optional.ofNullable(authenticationProtocol);
    }

    public SignIn withAuthenticationProtocol(ProtocolType authenticationProtocol) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("authenticationProtocol");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.authenticationProtocol = authenticationProtocol;
        return _x;
    }

    @Property(name="authenticationRequirement")
    @JsonIgnore
    public Optional<String> getAuthenticationRequirement() {
        return Optional.ofNullable(authenticationRequirement);
    }

    public SignIn withAuthenticationRequirement(String authenticationRequirement) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("authenticationRequirement");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.authenticationRequirement = authenticationRequirement;
        return _x;
    }

    @Property(name="authenticationRequirementPolicies")
    @JsonIgnore
    public CollectionPage<AuthenticationRequirementPolicy> getAuthenticationRequirementPolicies() {
        return new CollectionPage<AuthenticationRequirementPolicy>(contextPath, AuthenticationRequirementPolicy.class, this.authenticationRequirementPolicies, Optional.ofNullable(authenticationRequirementPoliciesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SignIn withAuthenticationRequirementPolicies(List<AuthenticationRequirementPolicy> authenticationRequirementPolicies) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("authenticationRequirementPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.authenticationRequirementPolicies = authenticationRequirementPolicies;
        return _x;
    }

    @Property(name="authenticationRequirementPolicies")
    @JsonIgnore
    public CollectionPage<AuthenticationRequirementPolicy> getAuthenticationRequirementPolicies(HttpRequestOptions options) {
        return new CollectionPage<AuthenticationRequirementPolicy>(contextPath, AuthenticationRequirementPolicy.class, this.authenticationRequirementPolicies, Optional.ofNullable(authenticationRequirementPoliciesNextLink), Collections.emptyList(), options);
    }

    @Property(name="autonomousSystemNumber")
    @JsonIgnore
    public Optional<Integer> getAutonomousSystemNumber() {
        return Optional.ofNullable(autonomousSystemNumber);
    }

    public SignIn withAutonomousSystemNumber(Integer autonomousSystemNumber) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("autonomousSystemNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.autonomousSystemNumber = autonomousSystemNumber;
        return _x;
    }

    @Property(name="azureResourceId")
    @JsonIgnore
    public Optional<String> getAzureResourceId() {
        return Optional.ofNullable(azureResourceId);
    }

    public SignIn withAzureResourceId(String azureResourceId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("azureResourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.azureResourceId = azureResourceId;
        return _x;
    }

    @Property(name="clientAppUsed")
    @JsonIgnore
    public Optional<String> getClientAppUsed() {
        return Optional.ofNullable(clientAppUsed);
    }

    public SignIn withClientAppUsed(String clientAppUsed) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("clientAppUsed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.clientAppUsed = clientAppUsed;
        return _x;
    }

    @Property(name="conditionalAccessStatus")
    @JsonIgnore
    public Optional<ConditionalAccessStatus> getConditionalAccessStatus() {
        return Optional.ofNullable(conditionalAccessStatus);
    }

    public SignIn withConditionalAccessStatus(ConditionalAccessStatus conditionalAccessStatus) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("conditionalAccessStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.conditionalAccessStatus = conditionalAccessStatus;
        return _x;
    }

    @Property(name="correlationId")
    @JsonIgnore
    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(correlationId);
    }

    public SignIn withCorrelationId(String correlationId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("correlationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.correlationId = correlationId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public SignIn withCreatedDateTime(OffsetDateTime createdDateTime) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="crossTenantAccessType")
    @JsonIgnore
    public Optional<SignInAccessType> getCrossTenantAccessType() {
        return Optional.ofNullable(crossTenantAccessType);
    }

    public SignIn withCrossTenantAccessType(SignInAccessType crossTenantAccessType) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("crossTenantAccessType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.crossTenantAccessType = crossTenantAccessType;
        return _x;
    }

    @Property(name="deviceDetail")
    @JsonIgnore
    public Optional<DeviceDetail> getDeviceDetail() {
        return Optional.ofNullable(deviceDetail);
    }

    public SignIn withDeviceDetail(DeviceDetail deviceDetail) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("deviceDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.deviceDetail = deviceDetail;
        return _x;
    }

    @Property(name="federatedCredentialId")
    @JsonIgnore
    public Optional<String> getFederatedCredentialId() {
        return Optional.ofNullable(federatedCredentialId);
    }

    public SignIn withFederatedCredentialId(String federatedCredentialId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("federatedCredentialId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.federatedCredentialId = federatedCredentialId;
        return _x;
    }

    @Property(name="flaggedForReview")
    @JsonIgnore
    public Optional<Boolean> getFlaggedForReview() {
        return Optional.ofNullable(flaggedForReview);
    }

    public SignIn withFlaggedForReview(Boolean flaggedForReview) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("flaggedForReview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.flaggedForReview = flaggedForReview;
        return _x;
    }

    @Property(name="homeTenantId")
    @JsonIgnore
    public Optional<String> getHomeTenantId() {
        return Optional.ofNullable(homeTenantId);
    }

    public SignIn withHomeTenantId(String homeTenantId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("homeTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.homeTenantId = homeTenantId;
        return _x;
    }

    @Property(name="homeTenantName")
    @JsonIgnore
    public Optional<String> getHomeTenantName() {
        return Optional.ofNullable(homeTenantName);
    }

    public SignIn withHomeTenantName(String homeTenantName) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("homeTenantName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.homeTenantName = homeTenantName;
        return _x;
    }

    @Property(name="incomingTokenType")
    @JsonIgnore
    public Optional<IncomingTokenType> getIncomingTokenType() {
        return Optional.ofNullable(incomingTokenType);
    }

    public SignIn withIncomingTokenType(IncomingTokenType incomingTokenType) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("incomingTokenType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.incomingTokenType = incomingTokenType;
        return _x;
    }

    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    public SignIn withIpAddress(String ipAddress) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("ipAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.ipAddress = ipAddress;
        return _x;
    }

    @Property(name="ipAddressFromResourceProvider")
    @JsonIgnore
    public Optional<String> getIpAddressFromResourceProvider() {
        return Optional.ofNullable(ipAddressFromResourceProvider);
    }

    public SignIn withIpAddressFromResourceProvider(String ipAddressFromResourceProvider) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("ipAddressFromResourceProvider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.ipAddressFromResourceProvider = ipAddressFromResourceProvider;
        return _x;
    }

    @Property(name="isInteractive")
    @JsonIgnore
    public Optional<Boolean> getIsInteractive() {
        return Optional.ofNullable(isInteractive);
    }

    public SignIn withIsInteractive(Boolean isInteractive) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("isInteractive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.isInteractive = isInteractive;
        return _x;
    }

    @Property(name="isTenantRestricted")
    @JsonIgnore
    public Optional<Boolean> getIsTenantRestricted() {
        return Optional.ofNullable(isTenantRestricted);
    }

    public SignIn withIsTenantRestricted(Boolean isTenantRestricted) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("isTenantRestricted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.isTenantRestricted = isTenantRestricted;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<SignInLocation> getLocation() {
        return Optional.ofNullable(location);
    }

    public SignIn withLocation(SignInLocation location) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.location = location;
        return _x;
    }

    @Property(name="mfaDetail")
    @JsonIgnore
    public Optional<MfaDetail> getMfaDetail() {
        return Optional.ofNullable(mfaDetail);
    }

    public SignIn withMfaDetail(MfaDetail mfaDetail) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("mfaDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.mfaDetail = mfaDetail;
        return _x;
    }

    @Property(name="networkLocationDetails")
    @JsonIgnore
    public CollectionPage<NetworkLocationDetail> getNetworkLocationDetails() {
        return new CollectionPage<NetworkLocationDetail>(contextPath, NetworkLocationDetail.class, this.networkLocationDetails, Optional.ofNullable(networkLocationDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SignIn withNetworkLocationDetails(List<NetworkLocationDetail> networkLocationDetails) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("networkLocationDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.networkLocationDetails = networkLocationDetails;
        return _x;
    }

    @Property(name="networkLocationDetails")
    @JsonIgnore
    public CollectionPage<NetworkLocationDetail> getNetworkLocationDetails(HttpRequestOptions options) {
        return new CollectionPage<NetworkLocationDetail>(contextPath, NetworkLocationDetail.class, this.networkLocationDetails, Optional.ofNullable(networkLocationDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="originalRequestId")
    @JsonIgnore
    public Optional<String> getOriginalRequestId() {
        return Optional.ofNullable(originalRequestId);
    }

    public SignIn withOriginalRequestId(String originalRequestId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("originalRequestId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.originalRequestId = originalRequestId;
        return _x;
    }

    @Property(name="privateLinkDetails")
    @JsonIgnore
    public Optional<PrivateLinkDetails> getPrivateLinkDetails() {
        return Optional.ofNullable(privateLinkDetails);
    }

    public SignIn withPrivateLinkDetails(PrivateLinkDetails privateLinkDetails) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("privateLinkDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.privateLinkDetails = privateLinkDetails;
        return _x;
    }

    @Property(name="processingTimeInMilliseconds")
    @JsonIgnore
    public Optional<Integer> getProcessingTimeInMilliseconds() {
        return Optional.ofNullable(processingTimeInMilliseconds);
    }

    public SignIn withProcessingTimeInMilliseconds(Integer processingTimeInMilliseconds) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("processingTimeInMilliseconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.processingTimeInMilliseconds = processingTimeInMilliseconds;
        return _x;
    }

    @Property(name="resourceDisplayName")
    @JsonIgnore
    public Optional<String> getResourceDisplayName() {
        return Optional.ofNullable(resourceDisplayName);
    }

    public SignIn withResourceDisplayName(String resourceDisplayName) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("resourceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.resourceDisplayName = resourceDisplayName;
        return _x;
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public SignIn withResourceId(String resourceId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("resourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="resourceServicePrincipalId")
    @JsonIgnore
    public Optional<String> getResourceServicePrincipalId() {
        return Optional.ofNullable(resourceServicePrincipalId);
    }

    public SignIn withResourceServicePrincipalId(String resourceServicePrincipalId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("resourceServicePrincipalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.resourceServicePrincipalId = resourceServicePrincipalId;
        return _x;
    }

    @Property(name="resourceTenantId")
    @JsonIgnore
    public Optional<String> getResourceTenantId() {
        return Optional.ofNullable(resourceTenantId);
    }

    public SignIn withResourceTenantId(String resourceTenantId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("resourceTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.resourceTenantId = resourceTenantId;
        return _x;
    }

    @Property(name="riskDetail")
    @JsonIgnore
    public Optional<RiskDetail> getRiskDetail() {
        return Optional.ofNullable(riskDetail);
    }

    public SignIn withRiskDetail(RiskDetail riskDetail) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("riskDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.riskDetail = riskDetail;
        return _x;
    }

    @Property(name="riskEventTypes_v2")
    @JsonIgnore
    public CollectionPage<String> getRiskEventTypes_v2() {
        return new CollectionPage<String>(contextPath, String.class, this.riskEventTypes_v2, Optional.ofNullable(riskEventTypes_v2NextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SignIn withRiskEventTypes_v2(List<String> riskEventTypes_v2) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("riskEventTypes_v2");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.riskEventTypes_v2 = riskEventTypes_v2;
        return _x;
    }

    @Property(name="riskEventTypes_v2")
    @JsonIgnore
    public CollectionPage<String> getRiskEventTypes_v2(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.riskEventTypes_v2, Optional.ofNullable(riskEventTypes_v2NextLink), Collections.emptyList(), options);
    }

    @Property(name="riskLevelAggregated")
    @JsonIgnore
    public Optional<RiskLevel> getRiskLevelAggregated() {
        return Optional.ofNullable(riskLevelAggregated);
    }

    public SignIn withRiskLevelAggregated(RiskLevel riskLevelAggregated) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("riskLevelAggregated");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.riskLevelAggregated = riskLevelAggregated;
        return _x;
    }

    @Property(name="riskLevelDuringSignIn")
    @JsonIgnore
    public Optional<RiskLevel> getRiskLevelDuringSignIn() {
        return Optional.ofNullable(riskLevelDuringSignIn);
    }

    public SignIn withRiskLevelDuringSignIn(RiskLevel riskLevelDuringSignIn) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("riskLevelDuringSignIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.riskLevelDuringSignIn = riskLevelDuringSignIn;
        return _x;
    }

    @Property(name="riskState")
    @JsonIgnore
    public Optional<RiskState> getRiskState() {
        return Optional.ofNullable(riskState);
    }

    public SignIn withRiskState(RiskState riskState) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("riskState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.riskState = riskState;
        return _x;
    }

    @Property(name="servicePrincipalCredentialKeyId")
    @JsonIgnore
    public Optional<String> getServicePrincipalCredentialKeyId() {
        return Optional.ofNullable(servicePrincipalCredentialKeyId);
    }

    public SignIn withServicePrincipalCredentialKeyId(String servicePrincipalCredentialKeyId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("servicePrincipalCredentialKeyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.servicePrincipalCredentialKeyId = servicePrincipalCredentialKeyId;
        return _x;
    }

    @Property(name="servicePrincipalCredentialThumbprint")
    @JsonIgnore
    public Optional<String> getServicePrincipalCredentialThumbprint() {
        return Optional.ofNullable(servicePrincipalCredentialThumbprint);
    }

    public SignIn withServicePrincipalCredentialThumbprint(String servicePrincipalCredentialThumbprint) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("servicePrincipalCredentialThumbprint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.servicePrincipalCredentialThumbprint = servicePrincipalCredentialThumbprint;
        return _x;
    }

    @Property(name="servicePrincipalId")
    @JsonIgnore
    public Optional<String> getServicePrincipalId() {
        return Optional.ofNullable(servicePrincipalId);
    }

    public SignIn withServicePrincipalId(String servicePrincipalId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("servicePrincipalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.servicePrincipalId = servicePrincipalId;
        return _x;
    }

    @Property(name="servicePrincipalName")
    @JsonIgnore
    public Optional<String> getServicePrincipalName() {
        return Optional.ofNullable(servicePrincipalName);
    }

    public SignIn withServicePrincipalName(String servicePrincipalName) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("servicePrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.servicePrincipalName = servicePrincipalName;
        return _x;
    }

    @Property(name="sessionLifetimePolicies")
    @JsonIgnore
    public CollectionPage<SessionLifetimePolicy> getSessionLifetimePolicies() {
        return new CollectionPage<SessionLifetimePolicy>(contextPath, SessionLifetimePolicy.class, this.sessionLifetimePolicies, Optional.ofNullable(sessionLifetimePoliciesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SignIn withSessionLifetimePolicies(List<SessionLifetimePolicy> sessionLifetimePolicies) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("sessionLifetimePolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.sessionLifetimePolicies = sessionLifetimePolicies;
        return _x;
    }

    @Property(name="sessionLifetimePolicies")
    @JsonIgnore
    public CollectionPage<SessionLifetimePolicy> getSessionLifetimePolicies(HttpRequestOptions options) {
        return new CollectionPage<SessionLifetimePolicy>(contextPath, SessionLifetimePolicy.class, this.sessionLifetimePolicies, Optional.ofNullable(sessionLifetimePoliciesNextLink), Collections.emptyList(), options);
    }

    @Property(name="signInEventTypes")
    @JsonIgnore
    public CollectionPage<String> getSignInEventTypes() {
        return new CollectionPage<String>(contextPath, String.class, this.signInEventTypes, Optional.ofNullable(signInEventTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SignIn withSignInEventTypes(List<String> signInEventTypes) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("signInEventTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.signInEventTypes = signInEventTypes;
        return _x;
    }

    @Property(name="signInEventTypes")
    @JsonIgnore
    public CollectionPage<String> getSignInEventTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.signInEventTypes, Optional.ofNullable(signInEventTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="signInIdentifier")
    @JsonIgnore
    public Optional<String> getSignInIdentifier() {
        return Optional.ofNullable(signInIdentifier);
    }

    public SignIn withSignInIdentifier(String signInIdentifier) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("signInIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.signInIdentifier = signInIdentifier;
        return _x;
    }

    @Property(name="signInIdentifierType")
    @JsonIgnore
    public Optional<SignInIdentifierType> getSignInIdentifierType() {
        return Optional.ofNullable(signInIdentifierType);
    }

    public SignIn withSignInIdentifierType(SignInIdentifierType signInIdentifierType) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("signInIdentifierType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.signInIdentifierType = signInIdentifierType;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<SignInStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public SignIn withStatus(SignInStatus status) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.status = status;
        return _x;
    }

    @Property(name="tokenIssuerName")
    @JsonIgnore
    public Optional<String> getTokenIssuerName() {
        return Optional.ofNullable(tokenIssuerName);
    }

    public SignIn withTokenIssuerName(String tokenIssuerName) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("tokenIssuerName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.tokenIssuerName = tokenIssuerName;
        return _x;
    }

    @Property(name="tokenIssuerType")
    @JsonIgnore
    public Optional<TokenIssuerType> getTokenIssuerType() {
        return Optional.ofNullable(tokenIssuerType);
    }

    public SignIn withTokenIssuerType(TokenIssuerType tokenIssuerType) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("tokenIssuerType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.tokenIssuerType = tokenIssuerType;
        return _x;
    }

    @Property(name="uniqueTokenIdentifier")
    @JsonIgnore
    public Optional<String> getUniqueTokenIdentifier() {
        return Optional.ofNullable(uniqueTokenIdentifier);
    }

    public SignIn withUniqueTokenIdentifier(String uniqueTokenIdentifier) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("uniqueTokenIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.uniqueTokenIdentifier = uniqueTokenIdentifier;
        return _x;
    }

    @Property(name="userAgent")
    @JsonIgnore
    public Optional<String> getUserAgent() {
        return Optional.ofNullable(userAgent);
    }

    public SignIn withUserAgent(String userAgent) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("userAgent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.userAgent = userAgent;
        return _x;
    }

    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    public SignIn withUserDisplayName(String userDisplayName) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("userDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public SignIn withUserId(String userId) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.userId = userId;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public SignIn withUserPrincipalName(String userPrincipalName) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="userType")
    @JsonIgnore
    public Optional<SignInUserType> getUserType() {
        return Optional.ofNullable(userType);
    }

    public SignIn withUserType(SignInUserType userType) {
        SignIn _x = _copy();
        _x.changedFields = changedFields.add("userType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signIn");
        _x.userType = userType;
        return _x;
    }

    public SignIn withUnmappedField(String name, Object value) {
        SignIn _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SignIn patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SignIn _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SignIn put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SignIn _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SignIn _copy() {
        SignIn _x = new SignIn();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appDisplayName = appDisplayName;
        _x.appId = appId;
        _x.appliedConditionalAccessPolicies = appliedConditionalAccessPolicies;
        _x.authenticationContextClassReferences = authenticationContextClassReferences;
        _x.authenticationDetails = authenticationDetails;
        _x.authenticationMethodsUsed = authenticationMethodsUsed;
        _x.authenticationProcessingDetails = authenticationProcessingDetails;
        _x.authenticationProtocol = authenticationProtocol;
        _x.authenticationRequirement = authenticationRequirement;
        _x.authenticationRequirementPolicies = authenticationRequirementPolicies;
        _x.autonomousSystemNumber = autonomousSystemNumber;
        _x.azureResourceId = azureResourceId;
        _x.clientAppUsed = clientAppUsed;
        _x.conditionalAccessStatus = conditionalAccessStatus;
        _x.correlationId = correlationId;
        _x.createdDateTime = createdDateTime;
        _x.crossTenantAccessType = crossTenantAccessType;
        _x.deviceDetail = deviceDetail;
        _x.federatedCredentialId = federatedCredentialId;
        _x.flaggedForReview = flaggedForReview;
        _x.homeTenantId = homeTenantId;
        _x.homeTenantName = homeTenantName;
        _x.incomingTokenType = incomingTokenType;
        _x.ipAddress = ipAddress;
        _x.ipAddressFromResourceProvider = ipAddressFromResourceProvider;
        _x.isInteractive = isInteractive;
        _x.isTenantRestricted = isTenantRestricted;
        _x.location = location;
        _x.mfaDetail = mfaDetail;
        _x.networkLocationDetails = networkLocationDetails;
        _x.originalRequestId = originalRequestId;
        _x.privateLinkDetails = privateLinkDetails;
        _x.processingTimeInMilliseconds = processingTimeInMilliseconds;
        _x.resourceDisplayName = resourceDisplayName;
        _x.resourceId = resourceId;
        _x.resourceServicePrincipalId = resourceServicePrincipalId;
        _x.resourceTenantId = resourceTenantId;
        _x.riskDetail = riskDetail;
        _x.riskEventTypes_v2 = riskEventTypes_v2;
        _x.riskLevelAggregated = riskLevelAggregated;
        _x.riskLevelDuringSignIn = riskLevelDuringSignIn;
        _x.riskState = riskState;
        _x.servicePrincipalCredentialKeyId = servicePrincipalCredentialKeyId;
        _x.servicePrincipalCredentialThumbprint = servicePrincipalCredentialThumbprint;
        _x.servicePrincipalId = servicePrincipalId;
        _x.servicePrincipalName = servicePrincipalName;
        _x.sessionLifetimePolicies = sessionLifetimePolicies;
        _x.signInEventTypes = signInEventTypes;
        _x.signInIdentifier = signInIdentifier;
        _x.signInIdentifierType = signInIdentifierType;
        _x.status = status;
        _x.tokenIssuerName = tokenIssuerName;
        _x.tokenIssuerType = tokenIssuerType;
        _x.uniqueTokenIdentifier = uniqueTokenIdentifier;
        _x.userAgent = userAgent;
        _x.userDisplayName = userDisplayName;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        _x.userType = userType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SignIn[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("appliedConditionalAccessPolicies=");
        b.append(this.appliedConditionalAccessPolicies);
        b.append(", ");
        b.append("authenticationContextClassReferences=");
        b.append(this.authenticationContextClassReferences);
        b.append(", ");
        b.append("authenticationDetails=");
        b.append(this.authenticationDetails);
        b.append(", ");
        b.append("authenticationMethodsUsed=");
        b.append(this.authenticationMethodsUsed);
        b.append(", ");
        b.append("authenticationProcessingDetails=");
        b.append(this.authenticationProcessingDetails);
        b.append(", ");
        b.append("authenticationProtocol=");
        b.append(this.authenticationProtocol);
        b.append(", ");
        b.append("authenticationRequirement=");
        b.append(this.authenticationRequirement);
        b.append(", ");
        b.append("authenticationRequirementPolicies=");
        b.append(this.authenticationRequirementPolicies);
        b.append(", ");
        b.append("autonomousSystemNumber=");
        b.append(this.autonomousSystemNumber);
        b.append(", ");
        b.append("azureResourceId=");
        b.append(this.azureResourceId);
        b.append(", ");
        b.append("clientAppUsed=");
        b.append(this.clientAppUsed);
        b.append(", ");
        b.append("conditionalAccessStatus=");
        b.append(this.conditionalAccessStatus);
        b.append(", ");
        b.append("correlationId=");
        b.append(this.correlationId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("crossTenantAccessType=");
        b.append(this.crossTenantAccessType);
        b.append(", ");
        b.append("deviceDetail=");
        b.append(this.deviceDetail);
        b.append(", ");
        b.append("federatedCredentialId=");
        b.append(this.federatedCredentialId);
        b.append(", ");
        b.append("flaggedForReview=");
        b.append(this.flaggedForReview);
        b.append(", ");
        b.append("homeTenantId=");
        b.append(this.homeTenantId);
        b.append(", ");
        b.append("homeTenantName=");
        b.append(this.homeTenantName);
        b.append(", ");
        b.append("incomingTokenType=");
        b.append(this.incomingTokenType);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("ipAddressFromResourceProvider=");
        b.append(this.ipAddressFromResourceProvider);
        b.append(", ");
        b.append("isInteractive=");
        b.append(this.isInteractive);
        b.append(", ");
        b.append("isTenantRestricted=");
        b.append(this.isTenantRestricted);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("mfaDetail=");
        b.append(this.mfaDetail);
        b.append(", ");
        b.append("networkLocationDetails=");
        b.append(this.networkLocationDetails);
        b.append(", ");
        b.append("originalRequestId=");
        b.append(this.originalRequestId);
        b.append(", ");
        b.append("privateLinkDetails=");
        b.append(this.privateLinkDetails);
        b.append(", ");
        b.append("processingTimeInMilliseconds=");
        b.append(this.processingTimeInMilliseconds);
        b.append(", ");
        b.append("resourceDisplayName=");
        b.append(this.resourceDisplayName);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("resourceServicePrincipalId=");
        b.append(this.resourceServicePrincipalId);
        b.append(", ");
        b.append("resourceTenantId=");
        b.append(this.resourceTenantId);
        b.append(", ");
        b.append("riskDetail=");
        b.append(this.riskDetail);
        b.append(", ");
        b.append("riskEventTypes_v2=");
        b.append(this.riskEventTypes_v2);
        b.append(", ");
        b.append("riskLevelAggregated=");
        b.append(this.riskLevelAggregated);
        b.append(", ");
        b.append("riskLevelDuringSignIn=");
        b.append(this.riskLevelDuringSignIn);
        b.append(", ");
        b.append("riskState=");
        b.append(this.riskState);
        b.append(", ");
        b.append("servicePrincipalCredentialKeyId=");
        b.append(this.servicePrincipalCredentialKeyId);
        b.append(", ");
        b.append("servicePrincipalCredentialThumbprint=");
        b.append(this.servicePrincipalCredentialThumbprint);
        b.append(", ");
        b.append("servicePrincipalId=");
        b.append(this.servicePrincipalId);
        b.append(", ");
        b.append("servicePrincipalName=");
        b.append(this.servicePrincipalName);
        b.append(", ");
        b.append("sessionLifetimePolicies=");
        b.append(this.sessionLifetimePolicies);
        b.append(", ");
        b.append("signInEventTypes=");
        b.append(this.signInEventTypes);
        b.append(", ");
        b.append("signInIdentifier=");
        b.append(this.signInIdentifier);
        b.append(", ");
        b.append("signInIdentifierType=");
        b.append(this.signInIdentifierType);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("tokenIssuerName=");
        b.append(this.tokenIssuerName);
        b.append(", ");
        b.append("tokenIssuerType=");
        b.append(this.tokenIssuerType);
        b.append(", ");
        b.append("uniqueTokenIdentifier=");
        b.append(this.uniqueTokenIdentifier);
        b.append(", ");
        b.append("userAgent=");
        b.append(this.userAgent);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("userType=");
        b.append(this.userType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
