package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.SharedPCAccountManagerPolicy;
import odata.msgraph.client.beta.enums.Enablement;
import odata.msgraph.client.beta.enums.SharedPCAllowedAccountType;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the sharedPCConfiguration resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountManagerPolicy", 
    "allowedAccounts", 
    "allowLocalStorage", 
    "disableAccountManager", 
    "disableEduPolicies", 
    "disablePowerPolicies", 
    "disableSignInOnResume", 
    "enabled", 
    "fastFirstSignIn", 
    "idleTimeBeforeSleepInSeconds", 
    "kioskAppDisplayName", 
    "kioskAppUserModelId", 
    "localStorage", 
    "maintenanceStartTime", 
    "setAccountManager", 
    "setEduPolicies", 
    "setPowerPolicies", 
    "signInOnResume"})
@JsonInclude(Include.NON_NULL)
public class SharedPCConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharedPCConfiguration";
    }

    @JsonProperty("accountManagerPolicy")
    protected SharedPCAccountManagerPolicy accountManagerPolicy;

    @JsonProperty("allowedAccounts")
    protected SharedPCAllowedAccountType allowedAccounts;

    @JsonProperty("allowLocalStorage")
    protected Boolean allowLocalStorage;

    @JsonProperty("disableAccountManager")
    protected Boolean disableAccountManager;

    @JsonProperty("disableEduPolicies")
    protected Boolean disableEduPolicies;

    @JsonProperty("disablePowerPolicies")
    protected Boolean disablePowerPolicies;

    @JsonProperty("disableSignInOnResume")
    protected Boolean disableSignInOnResume;

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("fastFirstSignIn")
    protected Enablement fastFirstSignIn;

    @JsonProperty("idleTimeBeforeSleepInSeconds")
    protected Integer idleTimeBeforeSleepInSeconds;

    @JsonProperty("kioskAppDisplayName")
    protected String kioskAppDisplayName;

    @JsonProperty("kioskAppUserModelId")
    protected String kioskAppUserModelId;

    @JsonProperty("localStorage")
    protected Enablement localStorage;

    @JsonProperty("maintenanceStartTime")
    protected LocalTime maintenanceStartTime;

    @JsonProperty("setAccountManager")
    protected Enablement setAccountManager;

    @JsonProperty("setEduPolicies")
    protected Enablement setEduPolicies;

    @JsonProperty("setPowerPolicies")
    protected Enablement setPowerPolicies;

    @JsonProperty("signInOnResume")
    protected Enablement signInOnResume;

    protected SharedPCConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSharedPCConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private SharedPCAccountManagerPolicy accountManagerPolicy;
        private SharedPCAllowedAccountType allowedAccounts;
        private Boolean allowLocalStorage;
        private Boolean disableAccountManager;
        private Boolean disableEduPolicies;
        private Boolean disablePowerPolicies;
        private Boolean disableSignInOnResume;
        private Boolean enabled;
        private Enablement fastFirstSignIn;
        private Integer idleTimeBeforeSleepInSeconds;
        private String kioskAppDisplayName;
        private String kioskAppUserModelId;
        private Enablement localStorage;
        private LocalTime maintenanceStartTime;
        private Enablement setAccountManager;
        private Enablement setEduPolicies;
        private Enablement setPowerPolicies;
        private Enablement signInOnResume;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Specifies how accounts are managed on a shared PC. Only applies when
         * disableAccountManager is false.”</i>
         * 
         * @param accountManagerPolicy
         *            value of {@code accountManagerPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountManagerPolicy(SharedPCAccountManagerPolicy accountManagerPolicy) {
            this.accountManagerPolicy = accountManagerPolicy;
            this.changedFields = changedFields.add("accountManagerPolicy");
            return this;
        }

        /**
         * <i>“Indicates which type of accounts are allowed to use on a shared PC.”</i>
         * 
         * @param allowedAccounts
         *            value of {@code allowedAccounts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAccounts(SharedPCAllowedAccountType allowedAccounts) {
            this.allowedAccounts = allowedAccounts;
            this.changedFields = changedFields.add("allowedAccounts");
            return this;
        }

        /**
         * <i>“Specifies whether local storage is allowed on a shared PC.”</i>
         * 
         * @param allowLocalStorage
         *            value of {@code allowLocalStorage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowLocalStorage(Boolean allowLocalStorage) {
            this.allowLocalStorage = allowLocalStorage;
            this.changedFields = changedFields.add("allowLocalStorage");
            return this;
        }

        /**
         * <i>“Disables the account manager for shared PC mode.”</i>
         * 
         * @param disableAccountManager
         *            value of {@code disableAccountManager} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableAccountManager(Boolean disableAccountManager) {
            this.disableAccountManager = disableAccountManager;
            this.changedFields = changedFields.add("disableAccountManager");
            return this;
        }

        /**
         * <i>“Specifies whether the default shared PC education environment policies should be
         * disabled. For Windows 10 RS2 and later, this policy will be applied without
         * setting Enabled to true.”</i>
         * 
         * @param disableEduPolicies
         *            value of {@code disableEduPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableEduPolicies(Boolean disableEduPolicies) {
            this.disableEduPolicies = disableEduPolicies;
            this.changedFields = changedFields.add("disableEduPolicies");
            return this;
        }

        /**
         * <i>“Specifies whether the default shared PC power policies should be disabled.”</i>
         * 
         * @param disablePowerPolicies
         *            value of {@code disablePowerPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disablePowerPolicies(Boolean disablePowerPolicies) {
            this.disablePowerPolicies = disablePowerPolicies;
            this.changedFields = changedFields.add("disablePowerPolicies");
            return this;
        }

        /**
         * <i>“Disables the requirement to sign in whenever the device wakes up from sleep mode
         * .”</i>
         * 
         * @param disableSignInOnResume
         *            value of {@code disableSignInOnResume} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableSignInOnResume(Boolean disableSignInOnResume) {
            this.disableSignInOnResume = disableSignInOnResume;
            this.changedFields = changedFields.add("disableSignInOnResume");
            return this;
        }

        /**
         * <i>“Enables shared PC mode and applies the shared pc policies.”</i>
         * 
         * @param enabled
         *            value of {@code enabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        /**
         * <i>“Specifies whether to auto connect new non-admin Azure AD accounts to pre-
         * configured candidate local accounts”</i>
         * 
         * @param fastFirstSignIn
         *            value of {@code fastFirstSignIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fastFirstSignIn(Enablement fastFirstSignIn) {
            this.fastFirstSignIn = fastFirstSignIn;
            this.changedFields = changedFields.add("fastFirstSignIn");
            return this;
        }

        /**
         * <i>“Specifies the time in seconds that a device must sit idle before the PC goes to
         * sleep. Setting this value to 0 prevents the sleep timeout from occurring.”</i>
         * 
         * @param idleTimeBeforeSleepInSeconds
         *            value of {@code idleTimeBeforeSleepInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder idleTimeBeforeSleepInSeconds(Integer idleTimeBeforeSleepInSeconds) {
            this.idleTimeBeforeSleepInSeconds = idleTimeBeforeSleepInSeconds;
            this.changedFields = changedFields.add("idleTimeBeforeSleepInSeconds");
            return this;
        }

        /**
         * <i>“Specifies the display text for the account shown on the sign-in screen which
         * launches the app specified by SetKioskAppUserModelId. Only applies when
         * KioskAppUserModelId is set.”</i>
         * 
         * @param kioskAppDisplayName
         *            value of {@code kioskAppDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskAppDisplayName(String kioskAppDisplayName) {
            this.kioskAppDisplayName = kioskAppDisplayName;
            this.changedFields = changedFields.add("kioskAppDisplayName");
            return this;
        }

        /**
         * <i>“Specifies the application user model ID of the app to use with assigned access.”</i>
         * 
         * @param kioskAppUserModelId
         *            value of {@code kioskAppUserModelId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskAppUserModelId(String kioskAppUserModelId) {
            this.kioskAppUserModelId = kioskAppUserModelId;
            this.changedFields = changedFields.add("kioskAppUserModelId");
            return this;
        }

        /**
         * <i>“Specifies whether local storage is allowed on a shared PC.”</i>
         * 
         * @param localStorage
         *            value of {@code localStorage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localStorage(Enablement localStorage) {
            this.localStorage = localStorage;
            this.changedFields = changedFields.add("localStorage");
            return this;
        }

        /**
         * <i>“Specifies the daily start time of maintenance hour.”</i>
         * 
         * @param maintenanceStartTime
         *            value of {@code maintenanceStartTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maintenanceStartTime(LocalTime maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
            this.changedFields = changedFields.add("maintenanceStartTime");
            return this;
        }

        /**
         * <i>“Disables the account manager for shared PC mode.”</i>
         * 
         * @param setAccountManager
         *            value of {@code setAccountManager} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder setAccountManager(Enablement setAccountManager) {
            this.setAccountManager = setAccountManager;
            this.changedFields = changedFields.add("setAccountManager");
            return this;
        }

        /**
         * <i>“Specifies whether the default shared PC education environment policies should be
         * enabled/disabled/not configured. For Windows 10 RS2 and later, this policy will
         * be applied without setting Enabled to true.”</i>
         * 
         * @param setEduPolicies
         *            value of {@code setEduPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder setEduPolicies(Enablement setEduPolicies) {
            this.setEduPolicies = setEduPolicies;
            this.changedFields = changedFields.add("setEduPolicies");
            return this;
        }

        /**
         * <i>“Specifies whether the default shared PC power policies should be enabled/
         * disabled.”</i>
         * 
         * @param setPowerPolicies
         *            value of {@code setPowerPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder setPowerPolicies(Enablement setPowerPolicies) {
            this.setPowerPolicies = setPowerPolicies;
            this.changedFields = changedFields.add("setPowerPolicies");
            return this;
        }

        /**
         * <i>“Specifies the requirement to sign in whenever the device wakes up from sleep
         * mode.”</i>
         * 
         * @param signInOnResume
         *            value of {@code signInOnResume} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder signInOnResume(Enablement signInOnResume) {
            this.signInOnResume = signInOnResume;
            this.changedFields = changedFields.add("signInOnResume");
            return this;
        }

        public SharedPCConfiguration build() {
            SharedPCConfiguration _x = new SharedPCConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sharedPCConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.accountManagerPolicy = accountManagerPolicy;
            _x.allowedAccounts = allowedAccounts;
            _x.allowLocalStorage = allowLocalStorage;
            _x.disableAccountManager = disableAccountManager;
            _x.disableEduPolicies = disableEduPolicies;
            _x.disablePowerPolicies = disablePowerPolicies;
            _x.disableSignInOnResume = disableSignInOnResume;
            _x.enabled = enabled;
            _x.fastFirstSignIn = fastFirstSignIn;
            _x.idleTimeBeforeSleepInSeconds = idleTimeBeforeSleepInSeconds;
            _x.kioskAppDisplayName = kioskAppDisplayName;
            _x.kioskAppUserModelId = kioskAppUserModelId;
            _x.localStorage = localStorage;
            _x.maintenanceStartTime = maintenanceStartTime;
            _x.setAccountManager = setAccountManager;
            _x.setEduPolicies = setEduPolicies;
            _x.setPowerPolicies = setPowerPolicies;
            _x.signInOnResume = signInOnResume;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Specifies how accounts are managed on a shared PC. Only applies when
     * disableAccountManager is false.”</i>
     * 
     * @return property accountManagerPolicy
     */
    @Property(name="accountManagerPolicy")
    @JsonIgnore
    public Optional<SharedPCAccountManagerPolicy> getAccountManagerPolicy() {
        return Optional.ofNullable(accountManagerPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * accountManagerPolicy} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies how accounts are managed on a shared PC. Only applies when
     * disableAccountManager is false.”</i>
     * 
     * @param accountManagerPolicy
     *            new value of {@code accountManagerPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountManagerPolicy} field changed
     */
    public SharedPCConfiguration withAccountManagerPolicy(SharedPCAccountManagerPolicy accountManagerPolicy) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("accountManagerPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.accountManagerPolicy = accountManagerPolicy;
        return _x;
    }

    /**
     * <i>“Indicates which type of accounts are allowed to use on a shared PC.”</i>
     * 
     * @return property allowedAccounts
     */
    @Property(name="allowedAccounts")
    @JsonIgnore
    public Optional<SharedPCAllowedAccountType> getAllowedAccounts() {
        return Optional.ofNullable(allowedAccounts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code allowedAccounts}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates which type of accounts are allowed to use on a shared PC.”</i>
     * 
     * @param allowedAccounts
     *            new value of {@code allowedAccounts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowedAccounts} field changed
     */
    public SharedPCConfiguration withAllowedAccounts(SharedPCAllowedAccountType allowedAccounts) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowedAccounts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.allowedAccounts = allowedAccounts;
        return _x;
    }

    /**
     * <i>“Specifies whether local storage is allowed on a shared PC.”</i>
     * 
     * @return property allowLocalStorage
     */
    @Property(name="allowLocalStorage")
    @JsonIgnore
    public Optional<Boolean> getAllowLocalStorage() {
        return Optional.ofNullable(allowLocalStorage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code allowLocalStorage
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies whether local storage is allowed on a shared PC.”</i>
     * 
     * @param allowLocalStorage
     *            new value of {@code allowLocalStorage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowLocalStorage} field changed
     */
    public SharedPCConfiguration withAllowLocalStorage(Boolean allowLocalStorage) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowLocalStorage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.allowLocalStorage = allowLocalStorage;
        return _x;
    }

    /**
     * <i>“Disables the account manager for shared PC mode.”</i>
     * 
     * @return property disableAccountManager
     */
    @Property(name="disableAccountManager")
    @JsonIgnore
    public Optional<Boolean> getDisableAccountManager() {
        return Optional.ofNullable(disableAccountManager);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableAccountManager} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Disables the account manager for shared PC mode.”</i>
     * 
     * @param disableAccountManager
     *            new value of {@code disableAccountManager} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableAccountManager} field changed
     */
    public SharedPCConfiguration withDisableAccountManager(Boolean disableAccountManager) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("disableAccountManager");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.disableAccountManager = disableAccountManager;
        return _x;
    }

    /**
     * <i>“Specifies whether the default shared PC education environment policies should be
     * disabled. For Windows 10 RS2 and later, this policy will be applied without
     * setting Enabled to true.”</i>
     * 
     * @return property disableEduPolicies
     */
    @Property(name="disableEduPolicies")
    @JsonIgnore
    public Optional<Boolean> getDisableEduPolicies() {
        return Optional.ofNullable(disableEduPolicies);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableEduPolicies} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies whether the default shared PC education environment policies should be
     * disabled. For Windows 10 RS2 and later, this policy will be applied without
     * setting Enabled to true.”</i>
     * 
     * @param disableEduPolicies
     *            new value of {@code disableEduPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableEduPolicies} field changed
     */
    public SharedPCConfiguration withDisableEduPolicies(Boolean disableEduPolicies) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("disableEduPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.disableEduPolicies = disableEduPolicies;
        return _x;
    }

    /**
     * <i>“Specifies whether the default shared PC power policies should be disabled.”</i>
     * 
     * @return property disablePowerPolicies
     */
    @Property(name="disablePowerPolicies")
    @JsonIgnore
    public Optional<Boolean> getDisablePowerPolicies() {
        return Optional.ofNullable(disablePowerPolicies);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disablePowerPolicies} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies whether the default shared PC power policies should be disabled.”</i>
     * 
     * @param disablePowerPolicies
     *            new value of {@code disablePowerPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disablePowerPolicies} field changed
     */
    public SharedPCConfiguration withDisablePowerPolicies(Boolean disablePowerPolicies) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("disablePowerPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.disablePowerPolicies = disablePowerPolicies;
        return _x;
    }

    /**
     * <i>“Disables the requirement to sign in whenever the device wakes up from sleep mode
     * .”</i>
     * 
     * @return property disableSignInOnResume
     */
    @Property(name="disableSignInOnResume")
    @JsonIgnore
    public Optional<Boolean> getDisableSignInOnResume() {
        return Optional.ofNullable(disableSignInOnResume);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableSignInOnResume} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Disables the requirement to sign in whenever the device wakes up from sleep mode
     * .”</i>
     * 
     * @param disableSignInOnResume
     *            new value of {@code disableSignInOnResume} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableSignInOnResume} field changed
     */
    public SharedPCConfiguration withDisableSignInOnResume(Boolean disableSignInOnResume) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("disableSignInOnResume");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.disableSignInOnResume = disableSignInOnResume;
        return _x;
    }

    /**
     * <i>“Enables shared PC mode and applies the shared pc policies.”</i>
     * 
     * @return property enabled
     */
    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enabled} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Enables shared PC mode and applies the shared pc policies.”</i>
     * 
     * @param enabled
     *            new value of {@code enabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enabled} field changed
     */
    public SharedPCConfiguration withEnabled(Boolean enabled) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.enabled = enabled;
        return _x;
    }

    /**
     * <i>“Specifies whether to auto connect new non-admin Azure AD accounts to pre-
     * configured candidate local accounts”</i>
     * 
     * @return property fastFirstSignIn
     */
    @Property(name="fastFirstSignIn")
    @JsonIgnore
    public Optional<Enablement> getFastFirstSignIn() {
        return Optional.ofNullable(fastFirstSignIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fastFirstSignIn}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies whether to auto connect new non-admin Azure AD accounts to pre-
     * configured candidate local accounts”</i>
     * 
     * @param fastFirstSignIn
     *            new value of {@code fastFirstSignIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fastFirstSignIn} field changed
     */
    public SharedPCConfiguration withFastFirstSignIn(Enablement fastFirstSignIn) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("fastFirstSignIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.fastFirstSignIn = fastFirstSignIn;
        return _x;
    }

    /**
     * <i>“Specifies the time in seconds that a device must sit idle before the PC goes to
     * sleep. Setting this value to 0 prevents the sleep timeout from occurring.”</i>
     * 
     * @return property idleTimeBeforeSleepInSeconds
     */
    @Property(name="idleTimeBeforeSleepInSeconds")
    @JsonIgnore
    public Optional<Integer> getIdleTimeBeforeSleepInSeconds() {
        return Optional.ofNullable(idleTimeBeforeSleepInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * idleTimeBeforeSleepInSeconds} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies the time in seconds that a device must sit idle before the PC goes to
     * sleep. Setting this value to 0 prevents the sleep timeout from occurring.”</i>
     * 
     * @param idleTimeBeforeSleepInSeconds
     *            new value of {@code idleTimeBeforeSleepInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code idleTimeBeforeSleepInSeconds} field changed
     */
    public SharedPCConfiguration withIdleTimeBeforeSleepInSeconds(Integer idleTimeBeforeSleepInSeconds) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("idleTimeBeforeSleepInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.idleTimeBeforeSleepInSeconds = idleTimeBeforeSleepInSeconds;
        return _x;
    }

    /**
     * <i>“Specifies the display text for the account shown on the sign-in screen which
     * launches the app specified by SetKioskAppUserModelId. Only applies when
     * KioskAppUserModelId is set.”</i>
     * 
     * @return property kioskAppDisplayName
     */
    @Property(name="kioskAppDisplayName")
    @JsonIgnore
    public Optional<String> getKioskAppDisplayName() {
        return Optional.ofNullable(kioskAppDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskAppDisplayName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies the display text for the account shown on the sign-in screen which
     * launches the app specified by SetKioskAppUserModelId. Only applies when
     * KioskAppUserModelId is set.”</i>
     * 
     * @param kioskAppDisplayName
     *            new value of {@code kioskAppDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskAppDisplayName} field changed
     */
    public SharedPCConfiguration withKioskAppDisplayName(String kioskAppDisplayName) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskAppDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.kioskAppDisplayName = kioskAppDisplayName;
        return _x;
    }

    /**
     * <i>“Specifies the application user model ID of the app to use with assigned access.”</i>
     * 
     * @return property kioskAppUserModelId
     */
    @Property(name="kioskAppUserModelId")
    @JsonIgnore
    public Optional<String> getKioskAppUserModelId() {
        return Optional.ofNullable(kioskAppUserModelId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskAppUserModelId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies the application user model ID of the app to use with assigned access.”</i>
     * 
     * @param kioskAppUserModelId
     *            new value of {@code kioskAppUserModelId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskAppUserModelId} field changed
     */
    public SharedPCConfiguration withKioskAppUserModelId(String kioskAppUserModelId) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskAppUserModelId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.kioskAppUserModelId = kioskAppUserModelId;
        return _x;
    }

    /**
     * <i>“Specifies whether local storage is allowed on a shared PC.”</i>
     * 
     * @return property localStorage
     */
    @Property(name="localStorage")
    @JsonIgnore
    public Optional<Enablement> getLocalStorage() {
        return Optional.ofNullable(localStorage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code localStorage}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies whether local storage is allowed on a shared PC.”</i>
     * 
     * @param localStorage
     *            new value of {@code localStorage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localStorage} field changed
     */
    public SharedPCConfiguration withLocalStorage(Enablement localStorage) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localStorage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.localStorage = localStorage;
        return _x;
    }

    /**
     * <i>“Specifies the daily start time of maintenance hour.”</i>
     * 
     * @return property maintenanceStartTime
     */
    @Property(name="maintenanceStartTime")
    @JsonIgnore
    public Optional<LocalTime> getMaintenanceStartTime() {
        return Optional.ofNullable(maintenanceStartTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maintenanceStartTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies the daily start time of maintenance hour.”</i>
     * 
     * @param maintenanceStartTime
     *            new value of {@code maintenanceStartTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maintenanceStartTime} field changed
     */
    public SharedPCConfiguration withMaintenanceStartTime(LocalTime maintenanceStartTime) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("maintenanceStartTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.maintenanceStartTime = maintenanceStartTime;
        return _x;
    }

    /**
     * <i>“Disables the account manager for shared PC mode.”</i>
     * 
     * @return property setAccountManager
     */
    @Property(name="setAccountManager")
    @JsonIgnore
    public Optional<Enablement> getSetAccountManager() {
        return Optional.ofNullable(setAccountManager);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code setAccountManager
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Disables the account manager for shared PC mode.”</i>
     * 
     * @param setAccountManager
     *            new value of {@code setAccountManager} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code setAccountManager} field changed
     */
    public SharedPCConfiguration withSetAccountManager(Enablement setAccountManager) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("setAccountManager");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.setAccountManager = setAccountManager;
        return _x;
    }

    /**
     * <i>“Specifies whether the default shared PC education environment policies should be
     * enabled/disabled/not configured. For Windows 10 RS2 and later, this policy will
     * be applied without setting Enabled to true.”</i>
     * 
     * @return property setEduPolicies
     */
    @Property(name="setEduPolicies")
    @JsonIgnore
    public Optional<Enablement> getSetEduPolicies() {
        return Optional.ofNullable(setEduPolicies);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code setEduPolicies}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies whether the default shared PC education environment policies should be
     * enabled/disabled/not configured. For Windows 10 RS2 and later, this policy will
     * be applied without setting Enabled to true.”</i>
     * 
     * @param setEduPolicies
     *            new value of {@code setEduPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code setEduPolicies} field changed
     */
    public SharedPCConfiguration withSetEduPolicies(Enablement setEduPolicies) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("setEduPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.setEduPolicies = setEduPolicies;
        return _x;
    }

    /**
     * <i>“Specifies whether the default shared PC power policies should be enabled/
     * disabled.”</i>
     * 
     * @return property setPowerPolicies
     */
    @Property(name="setPowerPolicies")
    @JsonIgnore
    public Optional<Enablement> getSetPowerPolicies() {
        return Optional.ofNullable(setPowerPolicies);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code setPowerPolicies}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies whether the default shared PC power policies should be enabled/
     * disabled.”</i>
     * 
     * @param setPowerPolicies
     *            new value of {@code setPowerPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code setPowerPolicies} field changed
     */
    public SharedPCConfiguration withSetPowerPolicies(Enablement setPowerPolicies) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("setPowerPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.setPowerPolicies = setPowerPolicies;
        return _x;
    }

    /**
     * <i>“Specifies the requirement to sign in whenever the device wakes up from sleep
     * mode.”</i>
     * 
     * @return property signInOnResume
     */
    @Property(name="signInOnResume")
    @JsonIgnore
    public Optional<Enablement> getSignInOnResume() {
        return Optional.ofNullable(signInOnResume);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code signInOnResume}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies the requirement to sign in whenever the device wakes up from sleep
     * mode.”</i>
     * 
     * @param signInOnResume
     *            new value of {@code signInOnResume} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code signInOnResume} field changed
     */
    public SharedPCConfiguration withSignInOnResume(Enablement signInOnResume) {
        SharedPCConfiguration _x = _copy();
        _x.changedFields = changedFields.add("signInOnResume");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCConfiguration");
        _x.signInOnResume = signInOnResume;
        return _x;
    }

    public SharedPCConfiguration withUnmappedField(String name, Object value) {
        SharedPCConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharedPCConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SharedPCConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharedPCConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SharedPCConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SharedPCConfiguration _copy() {
        SharedPCConfiguration _x = new SharedPCConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.accountManagerPolicy = accountManagerPolicy;
        _x.allowedAccounts = allowedAccounts;
        _x.allowLocalStorage = allowLocalStorage;
        _x.disableAccountManager = disableAccountManager;
        _x.disableEduPolicies = disableEduPolicies;
        _x.disablePowerPolicies = disablePowerPolicies;
        _x.disableSignInOnResume = disableSignInOnResume;
        _x.enabled = enabled;
        _x.fastFirstSignIn = fastFirstSignIn;
        _x.idleTimeBeforeSleepInSeconds = idleTimeBeforeSleepInSeconds;
        _x.kioskAppDisplayName = kioskAppDisplayName;
        _x.kioskAppUserModelId = kioskAppUserModelId;
        _x.localStorage = localStorage;
        _x.maintenanceStartTime = maintenanceStartTime;
        _x.setAccountManager = setAccountManager;
        _x.setEduPolicies = setEduPolicies;
        _x.setPowerPolicies = setPowerPolicies;
        _x.signInOnResume = signInOnResume;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharedPCConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("accountManagerPolicy=");
        b.append(this.accountManagerPolicy);
        b.append(", ");
        b.append("allowedAccounts=");
        b.append(this.allowedAccounts);
        b.append(", ");
        b.append("allowLocalStorage=");
        b.append(this.allowLocalStorage);
        b.append(", ");
        b.append("disableAccountManager=");
        b.append(this.disableAccountManager);
        b.append(", ");
        b.append("disableEduPolicies=");
        b.append(this.disableEduPolicies);
        b.append(", ");
        b.append("disablePowerPolicies=");
        b.append(this.disablePowerPolicies);
        b.append(", ");
        b.append("disableSignInOnResume=");
        b.append(this.disableSignInOnResume);
        b.append(", ");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("fastFirstSignIn=");
        b.append(this.fastFirstSignIn);
        b.append(", ");
        b.append("idleTimeBeforeSleepInSeconds=");
        b.append(this.idleTimeBeforeSleepInSeconds);
        b.append(", ");
        b.append("kioskAppDisplayName=");
        b.append(this.kioskAppDisplayName);
        b.append(", ");
        b.append("kioskAppUserModelId=");
        b.append(this.kioskAppUserModelId);
        b.append(", ");
        b.append("localStorage=");
        b.append(this.localStorage);
        b.append(", ");
        b.append("maintenanceStartTime=");
        b.append(this.maintenanceStartTime);
        b.append(", ");
        b.append("setAccountManager=");
        b.append(this.setAccountManager);
        b.append(", ");
        b.append("setEduPolicies=");
        b.append(this.setEduPolicies);
        b.append(", ");
        b.append("setPowerPolicies=");
        b.append(this.setPowerPolicies);
        b.append(", ");
        b.append("signInOnResume=");
        b.append(this.signInOnResume);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
