package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ResourceReference;
import odata.msgraph.client.beta.complex.ResourceVisualization;
import odata.msgraph.client.beta.complex.SharingDetail;
import odata.msgraph.client.beta.entity.request.EntityRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "lastShared", 
    "resourceReference", 
    "resourceVisualization", 
    "sharingHistory"})
@JsonInclude(Include.NON_NULL)
public class SharedInsight extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharedInsight";
    }

    @JsonProperty("lastShared")
    protected SharingDetail lastShared;

    @JsonProperty("resourceReference")
    protected ResourceReference resourceReference;

    @JsonProperty("resourceVisualization")
    protected ResourceVisualization resourceVisualization;

    @JsonProperty("sharingHistory")
    protected List<SharingDetail> sharingHistory;

    @JsonProperty("sharingHistory@nextLink")
    protected String sharingHistoryNextLink;

    protected SharedInsight() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSharedInsight() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private SharingDetail lastShared;
        private ResourceReference resourceReference;
        private ResourceVisualization resourceVisualization;
        private List<SharingDetail> sharingHistory;
        private String sharingHistoryNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastShared(SharingDetail lastShared) {
            this.lastShared = lastShared;
            this.changedFields = changedFields.add("lastShared");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param resourceReference
         *            value of {@code resourceReference} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceReference(ResourceReference resourceReference) {
            this.resourceReference = resourceReference;
            this.changedFields = changedFields.add("resourceReference");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param resourceVisualization
         *            value of {@code resourceVisualization} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceVisualization(ResourceVisualization resourceVisualization) {
            this.resourceVisualization = resourceVisualization;
            this.changedFields = changedFields.add("resourceVisualization");
            return this;
        }

        public Builder sharingHistory(List<SharingDetail> sharingHistory) {
            this.sharingHistory = sharingHistory;
            this.changedFields = changedFields.add("sharingHistory");
            return this;
        }

        public Builder sharingHistory(SharingDetail... sharingHistory) {
            return sharingHistory(Arrays.asList(sharingHistory));
        }

        public Builder sharingHistoryNextLink(String sharingHistoryNextLink) {
            this.sharingHistoryNextLink = sharingHistoryNextLink;
            this.changedFields = changedFields.add("sharingHistory");
            return this;
        }

        public SharedInsight build() {
            SharedInsight _x = new SharedInsight();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sharedInsight";
            _x.id = id;
            _x.lastShared = lastShared;
            _x.resourceReference = resourceReference;
            _x.resourceVisualization = resourceVisualization;
            _x.sharingHistory = sharingHistory;
            _x.sharingHistoryNextLink = sharingHistoryNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="lastShared")
    @JsonIgnore
    public Optional<SharingDetail> getLastShared() {
        return Optional.ofNullable(lastShared);
    }

    public SharedInsight withLastShared(SharingDetail lastShared) {
        SharedInsight _x = _copy();
        _x.changedFields = changedFields.add("lastShared");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedInsight");
        _x.lastShared = lastShared;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property resourceReference
     */
    @Property(name="resourceReference")
    @JsonIgnore
    public Optional<ResourceReference> getResourceReference() {
        return Optional.ofNullable(resourceReference);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code resourceReference
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param resourceReference
     *            new value of {@code resourceReference} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceReference} field changed
     */
    public SharedInsight withResourceReference(ResourceReference resourceReference) {
        SharedInsight _x = _copy();
        _x.changedFields = changedFields.add("resourceReference");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedInsight");
        _x.resourceReference = resourceReference;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property resourceVisualization
     */
    @Property(name="resourceVisualization")
    @JsonIgnore
    public Optional<ResourceVisualization> getResourceVisualization() {
        return Optional.ofNullable(resourceVisualization);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * resourceVisualization} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param resourceVisualization
     *            new value of {@code resourceVisualization} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceVisualization} field changed
     */
    public SharedInsight withResourceVisualization(ResourceVisualization resourceVisualization) {
        SharedInsight _x = _copy();
        _x.changedFields = changedFields.add("resourceVisualization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedInsight");
        _x.resourceVisualization = resourceVisualization;
        return _x;
    }

    @Property(name="sharingHistory")
    @JsonIgnore
    public CollectionPage<SharingDetail> getSharingHistory() {
        return new CollectionPage<SharingDetail>(contextPath, SharingDetail.class, this.sharingHistory, Optional.ofNullable(sharingHistoryNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SharedInsight withSharingHistory(List<SharingDetail> sharingHistory) {
        SharedInsight _x = _copy();
        _x.changedFields = changedFields.add("sharingHistory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedInsight");
        _x.sharingHistory = sharingHistory;
        return _x;
    }

    @Property(name="sharingHistory")
    @JsonIgnore
    public CollectionPage<SharingDetail> getSharingHistory(HttpRequestOptions options) {
        return new CollectionPage<SharingDetail>(contextPath, SharingDetail.class, this.sharingHistory, Optional.ofNullable(sharingHistoryNextLink), Collections.emptyList(), options);
    }

    public SharedInsight withUnmappedField(String name, Object value) {
        SharedInsight _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="lastSharedMethod")
    @JsonIgnore
    public EntityRequest getLastSharedMethod() {
        return new EntityRequest(contextPath.addSegment("lastSharedMethod"), RequestHelper.getValue(unmappedFields, "lastSharedMethod"));
    }

    @NavigationProperty(name="resource")
    @JsonIgnore
    public EntityRequest getResource() {
        return new EntityRequest(contextPath.addSegment("resource"), RequestHelper.getValue(unmappedFields, "resource"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharedInsight patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SharedInsight _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharedInsight put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SharedInsight _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SharedInsight _copy() {
        SharedInsight _x = new SharedInsight();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.lastShared = lastShared;
        _x.resourceReference = resourceReference;
        _x.resourceVisualization = resourceVisualization;
        _x.sharingHistory = sharingHistory;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharedInsight[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastShared=");
        b.append(this.lastShared);
        b.append(", ");
        b.append("resourceReference=");
        b.append(this.resourceReference);
        b.append(", ");
        b.append("resourceVisualization=");
        b.append(this.resourceVisualization);
        b.append(", ");
        b.append("sharingHistory=");
        b.append(this.sharingHistory);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
