package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
 * <p>
 * Referenceable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "expiryTime", 
    "invitationDomain", 
    "invitationStatus"})
@JsonInclude(Include.NON_NULL)
public class SharedEmailDomainInvitation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharedEmailDomainInvitation";
    }

    @JsonProperty("expiryTime")
    protected OffsetDateTime expiryTime;

    @JsonProperty("invitationDomain")
    protected String invitationDomain;

    @JsonProperty("invitationStatus")
    protected String invitationStatus;

    protected SharedEmailDomainInvitation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSharedEmailDomainInvitation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime expiryTime;
        private String invitationDomain;
        private String invitationStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder expiryTime(OffsetDateTime expiryTime) {
            this.expiryTime = expiryTime;
            this.changedFields = changedFields.add("expiryTime");
            return this;
        }

        public Builder invitationDomain(String invitationDomain) {
            this.invitationDomain = invitationDomain;
            this.changedFields = changedFields.add("invitationDomain");
            return this;
        }

        public Builder invitationStatus(String invitationStatus) {
            this.invitationStatus = invitationStatus;
            this.changedFields = changedFields.add("invitationStatus");
            return this;
        }

        public SharedEmailDomainInvitation build() {
            SharedEmailDomainInvitation _x = new SharedEmailDomainInvitation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sharedEmailDomainInvitation";
            _x.id = id;
            _x.expiryTime = expiryTime;
            _x.invitationDomain = invitationDomain;
            _x.invitationStatus = invitationStatus;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="expiryTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpiryTime() {
        return Optional.ofNullable(expiryTime);
    }

    public SharedEmailDomainInvitation withExpiryTime(OffsetDateTime expiryTime) {
        SharedEmailDomainInvitation _x = _copy();
        _x.changedFields = changedFields.add("expiryTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedEmailDomainInvitation");
        _x.expiryTime = expiryTime;
        return _x;
    }

    @Property(name="invitationDomain")
    @JsonIgnore
    public Optional<String> getInvitationDomain() {
        return Optional.ofNullable(invitationDomain);
    }

    public SharedEmailDomainInvitation withInvitationDomain(String invitationDomain) {
        SharedEmailDomainInvitation _x = _copy();
        _x.changedFields = changedFields.add("invitationDomain");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedEmailDomainInvitation");
        _x.invitationDomain = invitationDomain;
        return _x;
    }

    @Property(name="invitationStatus")
    @JsonIgnore
    public Optional<String> getInvitationStatus() {
        return Optional.ofNullable(invitationStatus);
    }

    public SharedEmailDomainInvitation withInvitationStatus(String invitationStatus) {
        SharedEmailDomainInvitation _x = _copy();
        _x.changedFields = changedFields.add("invitationStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedEmailDomainInvitation");
        _x.invitationStatus = invitationStatus;
        return _x;
    }

    public SharedEmailDomainInvitation withUnmappedField(String name, Object value) {
        SharedEmailDomainInvitation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharedEmailDomainInvitation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SharedEmailDomainInvitation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharedEmailDomainInvitation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SharedEmailDomainInvitation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SharedEmailDomainInvitation _copy() {
        SharedEmailDomainInvitation _x = new SharedEmailDomainInvitation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.expiryTime = expiryTime;
        _x.invitationDomain = invitationDomain;
        _x.invitationStatus = invitationStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharedEmailDomainInvitation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("expiryTime=");
        b.append(this.expiryTime);
        b.append(", ");
        b.append("invitationDomain=");
        b.append(this.invitationDomain);
        b.append(", ");
        b.append("invitationStatus=");
        b.append(this.invitationStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
